FUNCTION week
* Syntax: WEEK ( <xpD> )
* Return: week of the year
* Note..: when no parameter is passed, current date is used
*
PARAMETER this_date

PRIVATE this_year,newyear,last_year,next_year,next_newyear
PRIVATE day_newyear,day_next_ny,day_of_year,this_week

*  this_year      =  character
*  newyear        =  date     
*  next_newyear   =  date     
*  day_newyear    =  numeric  
*  day_next_ny    =  numeric  
*  day_of_year    =  numeric  
*  this_week      =  character

IF TYPE("this_date") # "D"
    this_date = DATE()
ELSE
  IF EMPTY(this_date)
    RETURN "    "
  ENDIF
ENDIF

**********************************************
this_yearN   = YEAR(this_date)

this_year    = STR(this_yearN   , 4)
last_year    = STR(this_yearN -1, 4)
next_year    = STR(this_yearN +1, 4)

newyear      = STOD("&this_year.0101")
next_newyear = STOD("&next_year.0101")

day_newyear  = PDOW(newyear)
day_next_ny  = PDOW(next_newyear)

day_of_year  = this_date - newyear
**********************************************

DO CASE

  CASE day_of_year < 8 - day_newyear
    IF day_newyear > 4
        
        newyear     = STOD("&last_year.0101")
        day_newyear = PDOW(newyear)
        day_of_year = this_date - newyear
        
        IF day_newyear > 4
          day_of_year = day_of_year - (8-day_newyear)
        ELSE
          day_of_year = day_of_year + day_newyear - 1
        ENDIF
        this_week = last_year + STRZERO(INT(day_of_year/7) + 1,2)
    ELSE
        this_week = this_year + "01"
    ENDIF

  CASE ((next_newyear- this_date) < day_next_ny) .AND. day_next_ny < 5
    this_week = next_year + "01"

  OTHERWISE

    IF day_newyear > 4
        day_of_year = day_of_year - (8-day_newyear)
    ELSE
        day_of_year = day_of_year + day_newyear - 1
    ENDIF
    this_week = this_year + STRZERO(INT(day_of_year/7) + 1,2)

ENDCASE
RETURN RIGHT(this_week,4)


FUNCTION PDOW
* Syntax: PDOW( <xpD> )
* Return: day of week starts on monday
* Note..: DOW() starts on sunday
*
PARAMETERS this_date
PRIVATE cl_dag
cl_dag = DOW(this_date)-1
RETURN IF(cl_dag = 0, 7,cl_dag)

