/*********
*
* STRIP.C

*   Author : Jean-Pierre van Melis
* Compiled : with Microsoft C 5.1
*   Object : can only be used in conjunction with Clipper summer '87

*  Syntax: STRIP( <expC> [, <expN> ])
*  Return: All non-alphanumeric characters are removed, and spaces
*          are added to keep the initial length (for indexing purposes).
*          and all characters are made uppercase to gain speed
*          (otherwise you have to use the UPPER() function to do this).
*          The length of the returned string is of the same as the
*          original, unless you pass a second numeric parameter that's
*          smaller
*
*          As an addition, I also implemented foreign language support
*          all extended characters are replaced by there ASCII-counterpart.
*
*                            replacement : U
*                          replacement : A
*
*
*          INPUT                  RETURN
*          ---------------------- ----------------------------------
*           "van der Plas"        "VANDERPLAS  "
*           "garon"              "GARCON"
*           "tte"                "TETE"
*
* With '#define UPPERCASING FALSE'
*
*          INPUT                  RETURN
*          ---------------------- ----------------------------------
*           "van der Plas"        "vanderPlas  "
*           "garon"              "garcon"
*           "tte"                "tete"
*
* With '#define UPPERCASING FALSE' and "#define NOSPACE FALSE"
*
*          INPUT                  RETURN
*          ---------------------- ----------------------------------
*           "van der Plas"        "van der Plas"
*           "garon"              "garcon"
*           "tte"                "tete"
*
*
*        mNAAM = "v/d Broek BV      "
*        USE namen
*        INDEX ON STRIP(naam) TO naam
*        SEEK TRIM(STRIP(mNAAM))
*        IF FOUND()
*           ? naam
*        ENDIF
*
*
*     output: "v/d Broek B.V.    "
*********/

#include "jpm.h"

#define UPPERCASING TRUE
#define NOSPACE     TRUE

#if (UPPERCASING)
static byte convert[38] =
{ 'C','U','E','A','A','A','A','C','E','E','E','I','I','I','A','A','E',NULLC,NULLC
 ,'O','O','O','U','U','Y','O','U',NULLC,NULLC,NULLC,NULLC,NULLC,'A','I','O','U'
 ,'N','N'};
#else
static byte convert[38] =
{ 'C','u','e','a','a','a','a','c','e','e','e','i','i','i','A','A','E',NULLC,NULLC
 ,'o','o','o','u','u',NULLC,'O','U',NULLC,NULLC,NULLC,NULLC,NULLC,'a','i','o','u'
 ,'n','N'};
#endif

/*
                                                            
                                                             
       
*/

CLIPPER strip()

{

   byte *par;                                   /* pointer to input */
   byte *retstr;                                /* pointer to output */

   int parleng;                                 /* length of parameter */
   int leng;                                    /* length of return */

   quant n1;                                    /* offset input */
   quant n2;                                    /* offset output */

   Boolean error;

   error = TRUE;

   if(ISCHAR(1))
   {
      par    = _parc(1);                        /* receive pointer from clipper */
      parleng= _parclen(1);

      if (PCOUNT == 2 && ISNUM(2))
         leng = _parni(2);
      else
         leng = parleng;         

      retstr = _exmgrab(leng+1);                /* Allocate memory */

      if(retstr)                                /* Enough memory available */
      {
         error = FALSE;                         /* No errors */
         n2    = 0;                             /* point to first character */

         for(n1=0;n2<leng && n1<parleng; n1++) /* parse input till end of input*/
         {
            if(islower(par[n1]))                /* character is lowercase */
#if (UPPERCASING)
              retstr[n2++] = (par[n1] + ('A'-'a'));/* convert to uppercase */
#else
              retstr[n2++] = par[n1];           /* copy from input */
#endif
#if (NOSPACE)
            else if(isdigit(par[n1]) || isupper(par[n1]))
              retstr[n2++] = par[n1];           /* copy from input */
#else
            else if(isdigit(par[n1]) || isupper(par[n1]) || par[n1]=SPACEC)
              retstr[n2++] = par[n1];           /* copy from input */
#endif
            if((par[n1] >127) && (par[n1] < 166))
               if( convert[par[n1]-128])
                  retstr[n2++] = convert[par[n1]-128];

         }
         while(n2 < leng)                       /* fill rest with spaces */
            retstr[n2++] = SPACEC;

         retstr[n2] = NULLC;                    /* terminate with null */
      }
   }
   if(error)
      _retc(NULLS);                             /* return null string */
   else
   {
      _retclen(retstr, leng);                   /* return string with length */
      _exmback(retstr, leng+1);                 /* deallocate memory */
   }
   return;
}
