#include "jpm.h"


/**********************************************************************
   Syntax : AADD( <expA1>, <expA2> [ , <expA3>] )
   Return : 

***********************************************************************/

CLIPPER aadd()
{
   if (ISARRAY(1) && ISARRAY(2))
   {
      quant   i;
      quant   alength;
      quant   array_to_store = 1;

      alength = min(ALENGTH(1),ALENGTH(2));

      if (ISARRAY(3))
      {
         alength        = min(alength,ALENGTH(3));
         array_to_store = 3;
      }

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC && _parinfa(2, i) == NUMERIC)
            _stornd( (_parnd(1,i) + _parnd(2,i) ), array_to_store, i);
      }
      _retl(TRUE);
   }
   else
      _retl(FALSE);

   return;
}

/**********************************************************************
   Syntax : ADIS( <expA1>, <expA2> [ , <expA3>] )
   Return : 

***********************************************************************/

CLIPPER adis()
{
   if (ISARRAY(1) && ISARRAY(2))
   {
      quant   i;
      quant   alength;
      quant   array_to_store = 1;

      alength = min(ALENGTH(1),ALENGTH(2));

      if (ISARRAY(3))
      {
         alength        = min(alength,ALENGTH(3));
         array_to_store = 3;
      }

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC && _parinfa(2, i) == NUMERIC)
            _stornd( (_parnd(1,i) - _parnd(2,i) ), array_to_store, i);
      }
      _retl(TRUE);
   }
   else
      _retl(FALSE);

   return;
}

/**********************************************************************
   Syntax : AMUL( <expA1>, <expA2> [ , <expA3>] )
   Return : 

***********************************************************************/

CLIPPER amul()
{
   if (ISARRAY(1) && ISARRAY(2))
   {
      quant   i;
      quant   alength;
      quant   array_to_store = 1;

      alength = min(ALENGTH(1),ALENGTH(2));

      if (ISARRAY(3))
      {
         alength        = min(alength,ALENGTH(3));
         array_to_store = 3;
      }

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC && _parinfa(2, i) == NUMERIC)
            _stornd( (_parnd(1,i) * _parnd(2,i) ), array_to_store, i);
      }
      _retl(TRUE);
   }
   else
      _retl(FALSE);

   return;
}


/**********************************************************************
   Syntax : ADIV( <expA1>, <expA2> [ , <expA3>] )
   Return : 

***********************************************************************/

CLIPPER adiv()
{
   if (ISARRAY(1) && ISARRAY(2))
   {
      quant   i;
      quant   alength;
      quant   array_to_store = 1;

      alength = min(ALENGTH(1),ALENGTH(2));

      if (ISARRAY(3))
      {
         alength        = min(alength,ALENGTH(3));
         array_to_store = 3;
      }

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC && _parinfa(2, i) == NUMERIC)
            if (_parnd(2,i) == 0)
               _stornd(0.00, array_to_store, i);
            else
               _stornd( (_parnd(1,i) / _parnd(2,i) ), array_to_store, i);
      }
      _retl(TRUE);
   }
   else
      _retl(FALSE);

   return;
}
