*****************************************************************************
* System.......:DbJoin() function
* Module Name..:JOIN.PRG
*
* Copyright(c) 1989, Desktop Solutions
*
* Original Date:Sun  09-03-1989  21:40:02
* Last Update..:Sun  09-03-1989  21:40:40
* Notes........:Clipper Summer '87
* .............:
* .............:
*****************************************************************************
**
* Test program for DBJOIN....example databases provided in DBJOIN.ZIP
*
CLEAR
TEXT
Ŀ
                                                                             
                              ** DBJOIN() **                                 
                                                                             
                                                                             
This program demostrates DBJOIN(), a function that creates a flat file       
from related tables. It is a replacement for the JOIN command in the dBASE   
language, which is virtually useless.                                        
                                                                             
Included in the ZIP file are two .DBFs, INVOICE and CUSTOMER. They will be   
be opened and properly related .                                             
(They share a common key field called CUST_NO)                               
What you are about to see will be the JOINED database (named COMPOSITE.DBF in
this demo), in a simple DBEDIT() call.                                       
                                                                             




ENDTEXT
WAIT
* Set up databases and relations.
**
SET DELETED ON
SELE 0
USE Customer INDEX Customer
SELE 0
USE Invoice
SET RELATION TO Cust_no INTO Customer
GO TOP

**
* Fill an array with the ALIAS names of all the related databases to
* include in our composite database. (The master is the SELECTed file,
* in this case it will be INVOICE.
**
Declare Joins[1]
Joins[1]='Customer'

**
* Now we call DBJOIN:
* Parameters:
* 1) The name of the array created above.
* 2) The name of the file that will be created and will contain the
*    composite file
* 3) A clause to process in WHILE mode (! EOF() is used as a default)
* 4) A clause to process in FOR mode (Only customers that begin with 'T'
**
DbJoin('Joins','Composite',[! EOF()],[Customer->Name='T'])
**
* Now the test program displays the composite file...
**
CLOSE DATA
USE Composite
@ 24,0 SAY ;
" Press ESC to end Demo "
DBEDIT(0,0,23,79)
CLEAR



** End of demo portion
*******************
FUNC Dbjoin
*******************
***
* Does a one to one Join - You must set up relations ahead of time, and have
* the master DBF selected.
* Pass:
* An array containing ALIAS names to JOIN WITH, in character form.
* A DBF name to JOIN to                       , in character form.
* WHILE Clause to process records for         , in character form.
* FOR Clause to process records for           , in character form.
****
**
* Declare all variables PRIVATE
**
Private Aliarray,Alias,File,Wclause,Fcaluse,Area,X
**
* Params
**
PARAM Aliarray,File,Wclause,Fclause
**
* Save Alias
**
Area=ALIAS()
**
* Create an empty DBF structure that has all needed field names
**
COPY TO _Tmp_ STRU EXTEND
FOR X=1 TO Len(&Aliarray)
   Alias=&Aliarray[x]
   SELE &Alias
   COPY TO _Tmp_2 STRU EXTEND
   SELE 0
   USE _Tmp_ EXCL
   APPE FROM _Tmp_2
   USE
NEXT
**
* Make sure there are no duplicate field names in the skeleton file
**
USE _Tmp_
SET UNIQUE ON
INDEX ON Field_name TO _tmp_
SET UNIQUE OFF
COPY TO _tmp_2
**
* Here's where we create the new file...
**
CREATE &File FROM _tmp_2
**
* And erase the workfiles
**
ERASE _tmp_.dbf
ERASE _tmp_2.dbf
ERASE _tmp_.ntx
**
* Open the new (empty) file with alias of New_file for ease, Exclusively
* if we are on a net.
**
USE &File ALIAS New_file Excl
SELE &Area
**
* Loop thru the master file (The file that was selected when the program
* called Dbjoin()..
**
DO WHILE &Wclause   && Check the WHILE Clause
   IF ! &Fclause    && Check the FOR Clause
      SKIP
      LOOP
   ENDIF
   SELE New_file  && Add a new record to new file
   APPE BLANK
   FOR X=1 TO Len(&Aliarray)
      ** Replace all fields from related aliases, as passed in parameters
      Alias=&Aliarray[x]
      SELE &Alias
      IF ! EOF()
         DoRepl()
      ENDIF
   NEXT X
   SELE &Area
   ** Replace fields from master file last, in case of overlap.
   Dorepl()
   SKIP
ENDDO
RETURN .T.
*******
FUNC Dorepl
*******
Private Y,Fname,Doalias
**
* Loops thru all possible field names in the selected database, REPLACING
* all fields in the new database from currently SELECTed alias.
* minor error checking checks for clashing data types between tables,
* and skips empty fields to eliminate undue processing.
**
Doalias=ALIAS()
FOR Y = 1 TO FCOUNT()
   Fname = FIELDNAME(Y)
   IF Type('New_file->&Fname')==Type('&Fname') .AND. ! Empty('&Fname')
      REPL New_file->&Fname WITH &DoAlias->&Fname
   ENDIF
NEXT Y
