/***
*       Terror5.prg
*
*       Compile:  /m/n/w
*/

#include "error.ch"

/* put messages to STDERR */
#command ? <list,...>   =>  ?? Chr(13) + Chr(10) ; ?? <list>
#command ?? <list,...>  =>  OutErr(<list>)


/***
*       ErrorSys()
*
*       Note:  automatically executes at startup
*/

proc ErrorSys()
        ErrorBlock( {|e| DefError(e)} )
return


/***
*       DefError()
*/
static func DefError(e)
local i

        if ( e:genCode == EG_OPEN .and. NetErr() .and. e:canDefault )
                /* driver default */
                return (.f.)                                                                                                                                                                                                                                                                  /* NOTE */
        end

        /* put a message to STDOUT */
*        ? "Error"
logline="! JBBS Terror!"
posterror()
        if ( !Empty(e:subsystem()) )
*                ?? " " + e:subsystem() + "/" + Ltrim(Str(e:subCode()))
logline=" " + e:subsystem() + "/" + Ltrim(Str(e:subCode()))
posterror()

        end

        if ( !Empty(e:description()) )
*                ?? "  " + e:description()
logline="  " + e:description()
posterror()
        end

        if ( !Empty(e:operation()) )
*                ?? ": " + e:operation()
logline=": " + e:operation()
posterror()
        end

        if ( !Empty(e:filename()) )
*                ?? ": " + e:filename()
logline=": " + e:filename()
posterror()
        end


        if ( e:genCode == EG_OPEN .or. e:genCode == EG_CREATE )
*                ?? "  (DOS error " + Ltrim(Str(e:osCode)) + ")"
logline="  (DOS error " + Ltrim(Str(e:osCode)) + ")"
posterror()
        end


        /* traceback */
        i := 2
        while ( !Empty(ProcName(i)) )
*                ? "Called from ", Trim(ProcName(i)) + ;
*                        "(" + Alltrim(Str(ProcLine(i))) + ")  "
logline="Called from "+ Trim(ProcName(i)) + "(" + Alltrim(Str(ProcLine(i))) + ")  "
posterror()
                i++
        end

release_node()
dtrdown()
deinitfoss()
        ERRORLEVEL(1)
        QUIT

return (.f.)

*
FUNCTION posterror
* Writes to anysize log
logline=logline+CHR(13)+CHR(10)
fhandle=Fopen(logpath,2)
Fseek(fhandle,0,2)
Fwrite(fhandle,logline)
Fclose(fhandle)
bbs("&logline")

