
 ; Function: ISPRINTER
 ; Purpose : To return the printer status for one of the lpt devices.
 ; Syntax  : ISPRINTER( ExpN ) where ExpN = LPT port to check
 ;------------------------------------------------------------------

 CLfunc log ISPRINTER <int lpt_no>
 CLcode
    mov di, false       ; Initialise return value to false.
    cmp PCOUNT, 1       ; Verify parameter count.

    jne isprt0
    cmp lpt_no, 2       ; Verify printer number (0-2) and
    jg  isprt0          ; return if out of bounds.

    MPUSH   ax, dx      ; Save registers.

    mov dx, lpt_no      ; Store printer to get status from.
    mov ah, 2           ; Store service number.
    int 17h             ; Call printer status interrupt.

    mov di, false       ; Initilize return to false.
    cmp ah, 90h         ; If printer not selected or not ready
    jne isprt1          ; return.
    mov di, true        ; Set return value to true.

 isprt1:
    MPOP    ax, dx      ; Restore registers.

 isprt0:
    CLret   di          ; Return from Isprinter.

    END


