***********************************************************************
*-*
*-*      Program: DEMOCUR.PRG
*-*
*-*      IsCursor() Function DEMO program
*-*      Author: John Scott Prinke
*-*              1976 Monday Drive
*-*              Elgin, IL  60123
*-*              (312)-888-3210
*-*              Source BFH594
*-*
*-*      Entered into the Public Domain.
*-*      No warranty expressed or implied.  Use at your own risk.
*-*
*-*      MAKEDEMO.BAT will compile and link CURDEMO
*-*
*-*      Technical comments in ISCURSOR.ASM
*-*
*-*      Document for your Clipper S'87 manual by:
*-*          TYPE ISCURSOR.DOC >PRN
*-*          for Epson or compatible printers
*-*
***********************************************************************

public mdate, mname, ison
mdate = date()
mname = SPACE(25)
ison = "Y"

DO WHILE .T.
   setinpuc()
   CLEAR SCREEN
   instru()

   @ 2,20 SAY trim(mname)
   @ 3,20 SAY "IsCursor() Function Demo"
   IF ison = "Y"
     @ 5,20 SAY "IsCursor Function ENABLED in F10 function"
   ELSE
     @ 5,20 SAY "IsCursor Function DISABLED in F10 function"
   ENDIF
   @ 3,70 SAY DTOC(mdate)
   SET CURSOR OFF
   @ 8,2 SAY "The cursor is set OFF"
   INKEY(0)
   DO CASE
     CASE LASTKEY() = -9
        whatever()
     CASE  LASTKEY() = 27
        EXIT
     OTHERWISE
   ENDCASE


   IF IsCursor()
      @ 8,40 SAY "Function says ON"
   ELSE
      @ 8,40 SAY "Function says OFF"
   ENDIF
   INKEY(0)
   DO CASE
     CASE LASTKEY() = -9
        whatever()
     CASE  LASTKEY() = 27
        EXIT
     OTHERWISE
   ENDCASE

   SET CURSOR ON
   @ 10,2 SAY "The cursor is set ON"

   INKEY(0)
   DO CASE
     CASE LASTKEY() = -9
        whatever()
     CASE  LASTKEY() = 27
        EXIT
     OTHERWISE
   ENDCASE


   IF IsCursor()
      @ 10,40 SAY "Function says ON"
   ELSE
      @ 10,40 SAY "Function says OFF"
   ENDIF
   INKEY(0)
   DO CASE
     CASE LASTKEY() = -9
        whatever()
     CASE  LASTKEY() = 27
        EXIT
     OTHERWISE
   ENDCASE
ENDDO
CLEAR SCREEN
IF .NOT. iscursor()
  giveback = "Y"
  @ 2,1 SAY "D:\CLIPPER>"
  inkey(3)
  clear type
  tone(277,2)
  @ 4,5 SAY "How do you like the prompt without the cursor ???"
  inkey(1)
  clear type
  @ 10,07 SAY "You have exited the program with the CURSOR OFF. (I can tell now)."
  @ 11,07 SAY "If you are going to DEBUG to check memory at 0000:0460, GREAT!"
  @ 12,07 SAY "If you're planning on doing anything else, the cursor is real handy."
  @ 15,07 SAY "Do you want me to give it back to you (Y/N) ?  " GET giveback picture "@!" valid (giveback $ "YN")
  clear type
  read
  IF giveback = "Y"
    set cursor on
  ENDIF
  CLEAR SCREEN
ENDIF
QUIT

****************** FUNCTIONS *************************************


FUNCTION setinpuc
IF ISCOLOR()
   SET COLOR TO GR+/B,W+/GR,N,,W+/N
   * Yellow on blue   white on brown   unselected is white on black
ELSE
   *     {Monochrome}
   SET COLOR TO W/N,N/W,N,,N/W,,u/W
ENDIF
RETURN "T"


FUNCTION instru
IF ISCOLOR()
   SET COLOR TO W+/R,W+/R,N
   * white on red
ELSE
   SET COLOR TO N/W,W/N,N
ENDIF
@ 23, 02 SAY "     Esc - Exit         Enter - Continue      F10 - Whatever Function      "
IF ison = "Y"
   @ 24, 02 SAY " Whatever gets the data with the cursor on and returns the cursor properly "
ELSE
   SETINPUC()
   @ 24, 02 SAY " Whatever gets the data with the cursor on and always returns the cursor ON"
ENDIF
setinpuc()
RETURN "T"


FUNCTION WHATEVER
  *-* Get the cursor status on entry
  cur_stat = IsCursor()
  save screen to mscr

  *-* WHATEVER function code
       @ 14-1, 0 clear
       * black shadow behind square
       SET COLOR TO N/N,N/N,N
       @ 14-1, 15-2 clear TO 19, 20
       @ 14-1, 15-2 clear TO 14, 65
       IF ISCOLOR()
         SET COLOR TO N/W,W+/GR,N,,W+/N
         * Black on white  white on yellow
       ELSE
         *    {Monochrome}
         SET COLOR TO W/N,N/W,N
       ENDIF
       * Black on white  white on yellow
       @ 14, 15 clear TO 19+1,65+1
       set cursor on
       @ 14, 20 SAY " WHATEVER FUNCTION"
       @ 16, 20 SAY "Date : " GET mdate
       @ 17, 20 SAY "Name : " GET mname
       @ 18, 20 SAY "IsCursor ON (Y/N) :" GET ison picture "@!" valid (ison $ "YN")
       read
       IF ison = "N"
         set cursor off
         @ 19, 20 SAY "Try F10 after the cursor is set off"
         inkey(0)
         set cursor on
       ENDIF
       SETINPUC()
       restore screen from mscr
       IF ison = "Y"
         @ 5,20 SAY "IsCursor Function ENABLED in F10 function"
         INSTRU()
       ELSE
         @ 5,20 SAY "IsCursor Function DISABLED in F10 function"
         INSTRU()
       ENDIF


  *-* Reset the cursor status on exit
  IF .NOT. cur_stat .and. ison = "Y"       && ".and. ison..." only for demo
     SET CURSOR OFF
  ENDIF

RETURN "T"

*-* EOF: DEMOCUR.PRG
