/***
*
*  ISDIGIT()
*
*  Copyright: 1990-1991 Jean Paquin
*    Created: 91/14/11
*    Revised: 91/10/17
*    Purpose: Returns .T. if character located at nPosition in cString
*             is a digit (0..9).
*
*     Syntax: ISDIGIT(cString,nPosition)
*
*      Notes: 1. If cString is NOT supplied, ISDIGIT() returns .F.
*
*             2. If nPosition is NOT supplied, ISDIGIT() will test
*                the first character in cString.
*
*             3. If nPosition is lower than 1 or greater than length
*                of cString, ISDIGIT() returns .F.
*
*  Compiling: CL /c /AL /Zl /Od /FPa /Gs ISDIGIT.C
*
*             /c     compile only, do not automatically invoke the linker
*             /AL    use the large model
*             /Zl    do not place the names of the default librairies
*                    in the object file
*             /Od    defeats optimization so that function will work
*                    properly when linking with Blinker and WarpLink
*             /FPa   do not generate floating point calls
*             /Gs    do not generate stack probes
*
***/

#include "nandef.h"
#include "extend.h"

CLIPPER isdigit()
{
    byte result = FALSE;   // default: NOT a digit
   quant position;

   if (ISCHAR(1) && (quant)_parclen(1) > 0) {

      if (ISNUM(2)) {

         position = (quant)_parnl(2) - 1;

         if (position >= 0 && position < (quant)_parclen(1))
            result = (*(_parc(1) + position) >= '0' && *(_parc(1) + position) <= '9');

      }

      else

      {
         result = (*(_parc(1)) >= '0' && *(_parc(1)) <= '9');
      }

   }

   _retl(result);

}
