/***
*
*  ISALPHA()
*
*  Copyright: 1990-1991 Jean Paquin
*    Created: 91/14/11
*    Revised: 91/10/17
*    Purpose: Returns .T. if character located at nPosition in cString
*             is an alphabetic character including foreign accents.
*
*     Syntax: ISALPHA(cString,nPosition)
*
*      Notes: 1. If cString is NOT supplied, ISALPHA() returns .F.
*
*             2. If nPosition is NOT supplied, ISALPHA() will test
*                the first character in cString.
*
*             3. If nPosition is lower than 1 or greater than length
*                of cString, ISALPHA() returns .F.
*
*  Compiling: CL /c /AL /Zl /Od /FPa /Gs ISALPHA.C
*
*             /c     compile only, do not automatically invoke the linker
*             /AL    use the large model
*             /Zl    do not place the names of the default librairies
*                    in the object file
*             /Od    defeats optimization so that function will work
*                    properly when linking with Blinker and WarpLink
*             /FPa   do not generate floating point calls
*             /Gs    do not generate stack probes
*
***/

#include "nandef.h"
#include "extend.h"

#define ISALPHABETIC(c)  ((c) >= 'a' && (c) <= 'z' || (c) >= 'A' && (c) <= 'Z')
#define ISFOREIGN(c)     (CHR_IN((c),"",33))

CLIPPER isalpha()
{
    byte result = FALSE;   // default: NOT an alphabetic character
   quant position;

   if (ISCHAR(1) && (quant)_parclen(1) > 0) {

      if (ISNUM(2)) {

         position = (quant)_parnl(2) - 1;

         if (position >= 0 && position < (quant)_parclen(1))
            result = (ISALPHA(*(_parc(1) + position)) || ISFOREIGN(*(_parc(1) + position)));

      }

      else

      {
         result = (ISALPHA(*(_parc(1))) || ISFOREIGN(*(_parc(1))));
      }

   }

   _retl(result);

}
