/***
*
*  ISUPPER()
*
*  Copyright: 1990-1991 Jean Paquin
*    Created: 91/14/11
*    Revised: 91/10/17
*    Purpose: Returns .T. if character located at nPosition in cString
*             is an UPPERCASE character including foreign accents.
*
*     Syntax: ISUPPER(cString,nPosition)
*
*      Notes: 1. If cString is NOT supplied, ISUPPER() returns .F.
*
*             2. If nPosition is NOT supplied, ISUPPER() will test
*                the first character in cString.
*
*             3. If nPosition is lower than 1 or greater than length
*                of cString, ISUPPER() returns .F.
*
*             4. If the character at nPosition in cString is NOT an
*                alphabetic character or a foreign accent, ISUPPER()
*                returns .F.
*
*  Compiling: CL /c /AL /Zl /Od /FPa /Gs ISUPPER.C
*
*             /c     compile only, do not automatically invoke the linker
*             /AL    use the large model
*             /Zl    do not place the names of the default librairies
*                    in the object file
*             /Od    defeats optimization so that function will work
*                    properly when linking with Blinker and WarpLink
*             /FPa   do not generate floating point calls
*             /Gs    do not generate stack probes
*
***/

#include "nandef.h"
#include "extend.h"

#define ISUPPERALPHA(c)  ((c) >= 'A' && (c) <= 'Z')
#define ISUPPERACCENT(c) (CHR_IN((c),"",7))

CLIPPER isupper()
{
    byte result = FALSE;   // default: NOT an uppercase character
   quant position;

   if (ISCHAR(1) && (quant)_parclen(1) > 0) {

      if (ISNUM(2)) {

         position = (quant)_parnl(2) - 1;

         if (position >= 0 && position < (quant)_parclen(1))
            result = (ISUPPERALPHA(*(_parc(1) + position)) || ISUPPERACCENT(*(_parc(1) + position)));

      }

      else

      {
         result = (ISUPPERALPHA(*(_parc(1))) || ISUPPERACCENT(*(_parc(1))));
      }

   }

   _retl(result);

}
