/*

                                                                
  Funktion FileCopy                                             
                                                                
  Autor Klaus Mick                                              
  Datum  27.9.1993                                              
  Mgliche Rckgabewerte:                                       
  RETVAL= -1   Soure - und Targetdatei konnten                  
               nicht geffnet werden.                           
          -2   Sourcedatei = Targetdatei Copy onto itself!!!    
          -3   Nicht gengend Speicherkapazitt auf dem         
               Targetlaufwerk                                   
          -4   Kopierfehler                                     
          -5   Lesefehler in Quelldatei                         
          -6   Schreibfehler in Zieldatei                       
          -7   Abbruch des berschreibmodus durch Anwender      
          +1   Filecopy = OK"                                   
                                                                

 Compile   /n/m/l/a/w    Clipper 5.01

*/
#include "wincolor.ch"

static ___old_col  :=""
static ___ico_sav  :="" 
static cLowColor   :="n+/w"
static cHighColor  :="w+/w"

function winfilecopy(source,target,displayit)
local offset     :=0
local offset2    :=0
local bytesize   :=4096
local targetsize :=0
local iii        :=0
local handle     :=0
local handle2    :=0
local copy2buffer:=""
local transfered :=0
local written    :=0
local retval     :=0
local lTargetExist := .f.

copy2buffer      := space(bytesize)
___old_col := setcolor()

/*
Ŀ
 Source und Targetnamen vergleichen 

*/
if ltrim(source) = ltrim(target)
  retval := -2
  setcolor(___old_col)
  return retval
endif
/*
Ŀ
 Dateien ffnen  

*/
  handle :=fopen(ltrim(source),2)         // Datei im Modus Lesen/Schreiben ffnen
  handle2:=fopen(ltrim(target),0)         // Testen ob Datei schon angelegt 
  if handle < 0 
     retval := -1
     setcolor(___old_col)
     return retval
  elseif handle >= 0 .and. handle2 < 0
     // Quelle ist vorhanden aber Zieldatei noch nicht 
     handle2:=fcreate(ltrim(target),0)
  endif
/*
Ŀ
 Dateigre von Source ermitteln 

*/
offset := fseek(handle,0,2)
/*
Ŀ
 Prfen ob die Zieldatei schon existiert 

*/
if file(ltrim(target))
   targetsize:=fseek(handle2,0,2)
   /*
     Sonderfall der Dateigre = 0 abfangen
   */
   *if targetsize = 0
   * lTargetExist := .t.
   *endif
else
  targetsize := 0
endif
if targetsize > 0 .or. lTargetExist = .t.
  if windialog(1,10,{"Datei existiert schon auf dem",;
                      "Ziellaufwerk.",;
                      "Datei berschreiben ?",""},"FILECOPY") = 1
   fclose(handle2)                     // Handle auf geffnete schlieen
   ferase(ltrim(target))               // und Datei mit LowLevel lschen
   handle2:=fcreate(ltrim(target),0)   // Anschlieend mit fcreate neu erffnen.
  else
   retval := -7
   setcolor(___old_col)
   fclose(handle)
   fclose(handle2)
   return retval
  endif
endif
/*
Ŀ
 Ermittlung des Datentrgerspeicherplatzes 
 abzglich des Speicherplatzes beim ber-  
 schreibmodus                              

*/
if at(":",ltrim(target)) = 0
  if diskspace() <= offset
     retval := -3
     setcolor(___old_col)
     fclose(handle)
     fclose(handle2)
     return retval
  endif
else
  target := ltrim(target)
  if diskspace(asc(upper(substr(target,1,1)))-64) <= offset
     retval := -3
     setcolor(___old_col)
     fclose(handle)
     fclose(handle2)
     return retval
  endif
endif
fseek(handle2,0,0)
/*
Ŀ
 Anzahl der zu kopierende Blcke ermitteln 

*/

do case 
  case (offset / 4096 ) >= 1
     bytesize := 4096
  case (offset / 2048 ) >= 1
     bytesize := 2048
  case (offset / 1024 ) >= 1
     bytesize := 1024
  case (offset / 512 ) >= 1
     bytesize := 512
  otherwise
     bytesize := 256
endcase

offset2  := int(offset/bytesize) // Anzahl Blcke ermitteln
fseek(handle,0,0)            // Satzzeiger auf Dateianfang setzen
/*
Ŀ
 Schleife fr Filecopy mit % Anzeige       
 oder                                      
 Fastcopy mit Blocksize 4096 ohne Anzeige  

*/
___ico_sav := savescreen(10,25,10+8,25+29)
setcolor(cLowColor)
@ 10,25 clear to 10+8,25+29
if offset2 >= 1 .and. displayit = .t.
   for iii := 1 to offset2
      winF2prozent(10,25,offset2,iii,1,1,source)
      transfered := fread(handle,@copy2buffer,bytesize)
      if transfered = 0
        retval := -5
        setcolor(___old_col)
        restscreen(10,25,10+8,25+29,___ico_sav)
        fclose(handle)
        fclose(handle2)
        return retval
      else
        written:=fwrite(handle2,copy2buffer,transfered)
        if written <> transfered
           retval = -6
           setcolor(___old_col)
           restscreen(10,25,10+8,25+29,___ico_sav)
           fclose(handle)
           fclose(handle2)
           return retval
        endif
      endif
   next
   offset2    :=fseek(handle,0,1)                           // aktuelle Position
   transfered :=fread(handle,@copy2buffer,(offset-offset2)) // Restmenge Bytes lesen
   written    :=fwrite(handle2,copy2buffer,transfered)
   if written <> transfered
     retval   := -4
     setcolor(___old_col)
     restscreen(10,25,10+8,25+29,___ico_sav)
     fclose(handle)
     fclose(handle2)
     return retval
   endif
else
  copy2buffer := space(4096)
  do while .t.                                             //repeat
     transfered:=fread(handle,@copy2buffer,4096)
     written   :=fwrite(handle2,copy2buffer,transfered)
     if transfered = 0
        exit
     endif
  enddo                                                    //until (transfered = 0)
endif
fclose(handle)                                             // Datei schlieen
if ferror() <> 0
  winanzeige("Quelldatei # LOW-LEVEL FEHLERCODE   NO.: "+alltrim(str(ferror())),maxrow()-20,2)
endif
fclose(handle2)                                            // Datei schlieen
if ferror() <> 0
  winanzeige("Zieldatei # LOW-LEVEL FEHLERCODE NO.: "+alltrim(str(ferror())),maxrow()-20,2)
endif
retval := 1
setcolor(___old_col)
restscreen(10,25,10+8,25+29,___ico_sav)
return retval


static function winf2prozent(line,leftcol,loopend,loopact,looptop,delaytime,source) 
local z___i,retval,ni_iii,headline
retval := .t.
z___i := 0
ni_iii := 0
headline := "KOPIE % FERTIG"

/*
 Ŀ
    berprfung der Parameter kann hier entfallen da diese Funktion nur   
    intern verwendet wird.                                                
 
*/

if line >= (maxrow()-6) .or. valtype(line) = NIL       // berprfung des Zeilenbergabeparameters
  line := maxrow()-7
endif
if leftcol+30 >=79 .or. valtype(line) = NIL   // berprfung des Spaltenparameters
  leftcol := 12
endif

z___i=INT((loopact*100)/loopend)
if looptop = loopact
  @ line,leftcol clear to line+8,leftcol+29
  winWindow(line,leftcol,line+8,leftcol+29,"bg+/r",headline,.f.) 
  setcolor(strtran(cLowColor,"+/","/"))
  @ line+2,leftcol+2 say"    20   40   60   80   100" 
  @ line+3,leftcol+2 say"  " 
  winRahmen(line+4,leftcol+1,line+6,leftcol+27,.f.)
  @ line+7,leftcol+3 say center("Kopiere: "+alltrim(path_ex(source)),25)
endif
If loopact<loopend
   setcolor(cHighColor)      //"g+/w")
   @ line+5,leftcol+2   say REPLICATE("",((z___i/4)+1))
else
  setcolor(___old_col)
ENDIF
for ni_iii = 1 to delaytime
next
RETURN (RETVAL)



/*
Ŀ
                                                      
 Funktion winWindow(x,y,w,z,[Farbe],[Text])           
 Zeichnet eine Windowsbox mit farblich markierten     
 Kopfteil.                                            
                                                      
 Autor    Klaus Mick                                  
 Datum    5.10.92                                     

*/

static function winWindow(x,y,w,z,cfarbe,ctext,lType)
/*Ŀ
 x,y,w,z  = Bildschirmkoordinaten  
*/
local  cOldColor    := setcolor()
local  lOldCursor   := setcursor()
local  RetVal       := NIL
local  nParameters  := pcount()
local  cKopffarbe   := "w+/b"
local  cTiteltext   := "BOX"
local  lRahmentyp   := .t.          // default mit Doppeltrahmen
local  cHilfsfarbe  := ""

do case
  case nParameters < 4
    return (RetVal)
  case nParameters >= 5
    iif(valtype(cfarbe) == "C",cKopffarbe := cfarbe,NIL)
endcase

lRahmentyp := iif(Valtype(lType) == "L",lType,.t.)
cTitelText := iif(Valtype(cText) == "C",cText,"BOX")

/*
Ŀ
 erster Rahmen  

*/
setcolor(cLowColor)
@ x+1,y to w-1,y      //   
@ w,y SAY ""
setcolor(cHighColor)
@ x+1,z to w-1,z      //   
@ w,z SAY ""
@ w,y+1 to w,z-1      //   

if lRahmentyp
/*
Ŀ
 zweiter Rahmen      

*/
setcolor(cHighColor)
@ x+1,y+1 to w-1,y+1  //  
@ w-1,y+1 SAY ""
setcolor(cLowColor)
@ x+1,z-1 to w-1,z-1  //  
@ w-1,z-1 SAY ""
@ w-1,y+2 to w-1,z-2
endif
/*
Ŀ
 Kopfseiten       

*/

cHilfsfarbe := alltrim(substr(cKopffarbe,at("/",cKopffarbe)+1,3))

cHilfsfarbe := strtran(cHilfsfarbe,"*","+")+"/"+alltrim(substr(cOldColor,at("/",cOldColor)+1,3))  

setcolor(cHilfsfarbe)
@ x,y SAY ""
@ x,z SAY ""

/*
Ŀ
 Kopfleiste     

*/
setcolor(cKopffarbe)
@ x,y+1,x,z-1 box("        ")
/*
Ŀ
 Kopftext    

*/
setcolor(cKopffarbe)
if len(cTiteltext) <=(z-3)-(y+3) 
  @ x,y+3 say center(cTiteltext,(z-3)-(y+3))
else
  @ x,y+3 say center(substr(cTiteltext,1,(z-3)-(y+3)),(z-3)-(y+3))
endif


setcolor(cOldColor)
setcursor(lOldcursor)
return (RetVal)


/*
Ŀ
Funktion winAnzeige() User-Info mit Delay Time fr Anzeige
Autor: Klaus Mick                                         

*/

static function winAnzeige(text1,zeile,delay)
local h           := ""
local old__col    := setcolor()
local txtlen      := 0
local nParameters := pcount()

if nParameters <2
  return NIL
endif

txtlen := len(text1)
h:=savescreen(zeile,(39-int(txtlen/2))-2,zeile+4,(39+int(txtlen/2))+2)
setcolor(cLowColor)
@ zeile,39-int(txtlen/2)-2 clear to zeile+4,39+int(txtlen/2)+2
winWindow(zeile,(39-int(txtlen/2)-2),zeile+4,(39+int(txtlen/2)+2),"w+/r","",.f.) 
setcolor("w+/r")
@ zeile,(39-int(txtlen/2)-1) say ""
@ zeile,37 say "INFO"
@ zeile,(39+int(txtlen/2)+1) say ""
setcolor (cLowColor)
@ zeile+2,39-int(txtlen/2) say center(text1,(txtlen-2))
if pcount()=3
  inkey(delay)
else
  inkey(5)
endif
restscreen(zeile,(39-int(txtlen/2))-2,zeile+4,(39+int(txtlen/2))+2,h)
setcolor(old__col)
return NIL



/*
Ŀ
 Funktion winDialog(nDiaTyp,nZeile,aText,cTitel) 
 Dialogelemente mit windowshnlicher Oberflche  
 Autor     :Klaus Mick                           
 Datum     :7.10.92                              

*/

#define WIN_ACHTUNG        1
#define WIN_FEHLER         2
#define WIN_ERROR          3
#define WIN_INFO           4

static Function winDialog(nDiaTyp,nZeile,aText,cTitel)
local nParameters    := pcount()
local cOldColor      := setcolor()
local lOldCursor     := setcursor()
local cOldScreen     := ""
local nX_Zeile       := 0
local nY_Spalte      := 0
local nRetVal        := 0
local nTaste         := 0
local cHeadline      := "DIALOGBOX"
local nCounter       := 0
local cPromptCol     := ""
local l5Parameter    := .f.

if nParameters < 3
  return NIL
endif

clear typeahead

iif(valtype(cTitel) == "C",cheadline := cTitel,"DIALOGBOX")
nX_Zeile  := nZeile
nY_Spalte := 15

if nDiaTyp = WIN_ACHTUNG
  cOldScreen:=savescreen(nX_Zeile-2,nY_Spalte,nX_Zeile+8,nY_Spalte+51)
  setcolor(cLowColor)     //"N/W,B+/W,,,N+/W"
  @ nX_Zeile-2,nY_Spalte clear to nX_Zeile+7,nY_Spalte+50
  winWindow(nX_Zeile-2,nY_Spalte,nX_Zeile+7,nY_Spalte+50,;
            "W+/B",cHeadline,.f.)
  setcolor("w+/B")
  @ nX_Zeile-2,nY_Spalte+2 say ""
  setcolor("gr+/r")
  @ nX_Zeile+0,nY_Spalte+1 say ""
  @ nX_Zeile+1,nY_Spalte+1 say "  "
  @ nX_Zeile+2,nY_Spalte+1 say "  "
  @ nX_Zeile+3,nY_Spalte+1 say ""
  @ nX_Zeile+4,nY_Spalte+1 say ""
  setcolor(cLowColor)   // N/W,B+/W,,,N+/W"
elseif nDiaTyp = WIN_FEHLER
  cOldScreen:=savescreen(nX_Zeile-2,nY_Spalte,nX_Zeile+8,nY_Spalte+51)
  setcolor(cLowColor)
  @ nX_Zeile-2,nY_Spalte clear to nX_Zeile+7,nY_Spalte+50
  winWindow(nX_Zeile-2,nY_Spalte,nX_Zeile+7,nY_Spalte+50,;
            "GR+/BG",cHeadline,.f.)
  setcolor("gr+/Bg")
  @ nX_Zeile-2,nY_Spalte+2 say ""
  setcolor("r/n")
  @ nX_Zeile+0,nY_Spalte+1 say ""
  @ nX_Zeile+1,nY_Spalte+1 say " "
  @ nX_Zeile+2,nY_Spalte+1 say "    "
  @ nX_Zeile+3,nY_Spalte+1 say "    "
  @ nX_Zeile+4,nY_Spalte+1 say " "
  setcolor("r/"+substr(cLowColor,at("/",cLowColor)+1,3))
  @ nX_Zeile+5,nY_Spalte+1 say ""
  setcolor(cLowColor)
elseif nDiaTyp = WIN_ERROR
  cOldScreen:=savescreen(nX_Zeile-2,nY_Spalte,nX_Zeile+8,nY_Spalte+51)
  setcolor(cLowColor)
  @ nX_Zeile-2,nY_Spalte clear to nX_Zeile+7,nY_Spalte+50
  winWindow(nX_Zeile-2,nY_Spalte,nX_Zeile+7,nY_Spalte+50,;
            "GR+/R",cHeadline,.f.)
  setcolor("gr+/r")
  @ nX_Zeile-2,nY_Spalte+2 say ""
  setcolor("gr+/r")
  @ nX_Zeile+0,nY_Spalte+1 say ""
  @ nX_Zeile+1,nY_Spalte+1 say "    "
  @ nX_Zeile+2,nY_Spalte+1 say "  STOP  "
  @ nX_Zeile+3,nY_Spalte+1 say "    "
  @ nX_Zeile+4,nY_Spalte+1 say ""
  setcolor(cLowColor)
elseif nDiaTyp = WIN_INFO
  cOldScreen:=savescreen(nX_Zeile-2,nY_Spalte,nX_Zeile+8,nY_Spalte+51)
  setcolor(cLowColor)
  @ nX_Zeile-2,nY_Spalte clear to nX_Zeile+7,nY_Spalte+50
  winWindow(nX_Zeile-2,nY_Spalte,nX_Zeile+7,nY_Spalte+50,;
            "W+/RB",cHeadline,.f.)
  setcolor("w+/rB")
  @ nX_Zeile-2,nY_Spalte+2 say ""
  setcolor("w+/gr")
  @ nX_Zeile+0,nY_Spalte+1 say ""
  @ nX_Zeile+1,nY_Spalte+1 say "      "
  @ nX_Zeile+2,nY_Spalte+1 say "     "
  @ nX_Zeile+3,nY_Spalte+1 say "    "
  @ nX_Zeile+4,nY_Spalte+1 say ""
  setcolor(cLowColor)
endif

setcolor(cLowColor)

for nCounter = 1 to len(aText)
  @ nX_Zeile-1+nCounter,nY_Spalte+10 say substr(aText[nCounter],1,40)
next

do while .t.     //nTaste = 0

if nDiaTyp = 1        // == WIN_ACHTUNG
  setcolor(oWINCOLOR[2])
  winRahmen(nX_Zeile+4,nY_Spalte+17,nX_Zeile+6,nY_Spalte+22,.f.)
  @ nX_Zeile+5,nY_Spalte+19 say "JA"
  @ nX_Zeile+5,nY_Spalte+19 prompt "J"

  winRahmen(nX_Zeile+4,nY_Spalte+26,nX_Zeile+6,nY_Spalte+31,.f.)
  @ nX_Zeile+5,nY_Spalte+27 say "NEIN"
  @ nX_Zeile+5,nY_Spalte+27 prompt "N"
  @ nX_Zeile-2,nY_Spalte+2 prompt ""

  menu to nTaste
  do case
  case nTaste = 1
      winRahmen(nX_Zeile+4,nY_Spalte+17,nX_Zeile+6,nY_Spalte+22,.t.)
      @ nX_Zeile+5,nY_Spalte+19 say "JA"
      inkey(.3)
      winRahmen(nX_Zeile+4,nY_Spalte+17,nX_Zeile+6,nY_Spalte+22,.f.)
      @ nX_Zeile+5,nY_Spalte+19 say "JA"
      inkey(.2)
      nRetVal:=1
      exit
  case nTaste = 2
      winRahmen(nX_Zeile+4,nY_Spalte+26,nX_Zeile+6,nY_Spalte+31,.t.)
      @ nX_Zeile+5,nY_Spalte+27 say "NEIN"
      inkey(.3)
      winRahmen(nX_Zeile+4,nY_Spalte+26,nX_Zeile+6,nY_Spalte+31,.f.)
      @ nX_Zeile+5,nY_Spalte+27 say "NEIN"
      inkey(.2)
      nRetVal:=2
      exit
  case nTaste = 3
      nRetVal:= 0
      exit
  otherwise
      loop
  endcase
elseif nDiaTyp >= 2
     *setcolor(cLowColor+","+cHighColor)
   if nDiaTyp = WIN_FEHLER
     setcolor(oWINCOLOR[2])
   elseif nDiaTyp = WIN_ERROR
     setcolor(oWINCOLOR[2])
   elseif nDiaTyp = WIN_INFO
     setcolor(oWINCOLOR[2])
   endif
   winRahmen(nX_Zeile+4,nY_Spalte+20,nX_Zeile+6,nY_Spalte+29,.f.)
   @ nX_Zeile+5,nY_Spalte+24 say "OK"
   @ nX_Zeile+5,nY_Spalte+24 prompt "O"
   @ nX_Zeile-2,nY_Spalte+2 prompt ""
   menu to nTaste
   do case
    case nTaste = 1
      winRahmen(nX_Zeile+4,nY_Spalte+20,nX_Zeile+6,nY_Spalte+29,.t.)
      @ nX_Zeile+5,nY_Spalte+24 say "OK"
      inkey(.3)
      winRahmen(nX_Zeile+4,nY_Spalte+20,nX_Zeile+6,nY_Spalte+29,.f.)
      @ nX_Zeile+5,nY_Spalte+24 say "OK"
      inkey(.2)
      nRetVal:=1
      exit
    case nTaste = 2
      nRetVal:= 0
      exit
    otherwise
      nRetval:=0
  endcase
endif

enddo
setcolor(cOldColor)
restscreen(nX_Zeile-2,nY_Spalte,nX_Zeile+8,nY_Spalte+51,cOldScreen)
return nRetVal


/*
Ŀ
                                                      
 Funktion winRahmen(x,y,w,z,lTyp)                     
 Zeichnet einen Rahmen in Windowsmanier entweder als  
 Sunken Frame oder Raised Frame                       
                                                      
 Autor    Klaus Mick                                  
 Datum    5.10.92                                     
 Update   4.12.92                                     

*/



static function winRahmen(x,y,w,z,lType)
/*Ŀ
 x,y,w,z  = Bildschirmkoordinaten  
 lTyp     = .t. Abgesenkter Rahmen 
          = .f. Erhabener Rahmen   
*/

local  cOldColor    := setcolor()
local  lOldCursor   := setcursor()
local  RetVal       := NIL
local  i            := 0


if pcount() < 5
   return (RetVal)
endif


iif(lType==.t.,setcolor(cLowColor),setcolor(cHighColor))
@ x,y SAY ""
for i := y+1 to z-1
 @ x,i say ""
next
for i := x+1 to w-1
 @ i,y say ""
next
@ w,y SAY ""
iif(lType==.t.,setcolor(cHighColor),setcolor(cLowColor))
@ x,z SAY ""
for i := x+1 to w-1
 @ i,z say ""
next
@ w,z SAY ""
for i := y+1 to z-1
 @ w,i say ""
next
setcolor(cOldColor)
setcursor(lOldcursor)
return (RetVal)


/*

  Function PATH_EX()                                      
  Entfernt aus einem Dateistring den Laufwerksbuchstaben  
  und die Pfadangabe.                                     
                                                          
  In Kombination mit EXT_EX() kann ein Dateiname isoliert 
  werden.                                                 

*/

static function path_ex(maske)
local chDatei:=""
if at("\",maske)<>0
  chDatei:=substr(maske,rat("\",maske)+1,len(maske))
else
if at(":",maske)<>0
  chDatei:=substr(maske,rat(":",maske)+1,len(maske)) 
  else
     chDatei:=maske
  endif
endif
return(chDatei)

/*

                                         
CENTER()                                 
TEXT T IN LNGE L ZENTRIEREN (C,N)       
PARAMETER TEXT,LNGE des Gesamtstrings   
                                         

*/

static FUNCTION CENTER(PTEXT,PLEN)
Local H,RET
H=INT((PLEN-LEN(PTEXT))/2)
RET=SPACE(H)+PTEXT+SPACE(PLEN-H-LEN(PTEXT))
RETURN(RET)
