*:*********************************************************************
*:
*: Procedure file: INTEGRIT.PRG
*:
*:         Author: John Wiseman
*:      Copyright (c) 1990, John Wiseman
*:  Last modified: 03/22/90     16:00
*:
*:  Procs & Fncts: INDEX_INTEG()
*:
*:      Documented 03/18/90 at 14:02                SNAP!  version 4.01
*:*********************************************************************
*!*********************************************************************
*!
*!       Function: INDEX_INTEG()
*!
*!      Called by: INVUPDATE      (procedure in POS.PRG)
*!
*!*********************************************************************

*Use this function to return the logical integrity flag for current index file.
*before calling the procedure activate a database with or without an index file.
*use the following to call the routine:  if index_integ(Num)  where num is
*the depth of checking that will be done. Thus pass 10 for a quick check
*or more for a better check.  If there is no index header or any of the checks
*fails a true or error condition will be returned.  Your calling routine would
*do an index on key command to fix it.  Do not use reindex command.  Since you
*can call the function even without a index started your calling routine can
*handle a bad index, bad index header, or no index started.
*
*  Modifications: used Doug Winters suggestion that at first bad find we just
*                 exit since we need not look further. 3-22-90


FUNCTION index_integ      && test integrity of currently assigned index
PRIVATE ERROR, key_exp, KEY, depth
parameter depth           && how deep you want to test integrity passed in

if depth>reccount()       && make sure we don't access more than # records
 depth=reccount()
endif

set console off           && prevents goto record number from display
ERROR=.F.                 && assume there will not be any error
key_exp=Indexkey(1)       && store the key expression for this index

if len(trim(key_exp))=0   && no key expression so either no index attached
  set console on          && or the header was junk!
  return .t.              && return true cause there should have been index
endif


FOR I=1 TO RECCOUNT() STEP INT(RECCOUNT()/depth)  && depth will calculate step #
  GOTO I                  && step your way through database records
  KEY=&key_exp            && now expand the key macro & get the actual rec key
  
  FIND &key
  
  IF EOF()                && if index is ok then we should not be at end of file
    ERROR=.T.             && if at any time we don't find key set error true
    exit                  && no sense in looking further lets get out-a-here
  ENDIF
NEXT

set console on
RETURN ERROR                && return the resulting error to be used for testing
*: EOF: INTEGRIT.PRG
