/*

                  ###                                   ######
                   #     #    #  ######          #####  #     #
                   #     ##   #  #               #    # #     #
                   #     # #  #  #####           #    # ######
                   #     #  # #  #               #    # #     #
                   #     #   ##  #               #    # #     #
                  ###    #    #  #      #######  #####  ######


	Inf_dB takes any Informix database file and converts it to a form
	compatible with dBASE III's APPEND command. The syntax is :

	Inf_dB <Informix Data Base> <Database File Name> <Outfile File>

	It will NOT let you specify a file that already exists as the
	output file and it does complete error checking on the command
	line arguments.

	Inf_dB converts all field types except for COMPOSITE fields, which
	it simply treats as if they did not exeist after issuing a warning.
	It will also truncate any character fields that are longer than 254
	characters, as 254 is the maximum that dBASE III can handle. It 
	also converts MONEY fields to floats with 2 decimal places, as dBASE
	III does not support money fields.

	DATE, EDATE, and YDATE are all converted to the form 19YYMMDD. This
	form is compatible with dBASE III date fields unless a date in
	another century is needed, in which case Informix itself couldn't
	handle it.

	The only limitation is that Inf_dB will not work on a file with more
	than 1000 fields because of memory limitations. If will issue an
	error message if an attempt is made to do this.

 Programmer : Rob Gabbard
	      CSS Central Region
	      FTS 684-3616

       Date : 04/01/86

	Compile : scc -w -o Inf_dB Inf_dB.c -ldb -lcisam -lm

*/

#include <stdio.h>
#include <isam.h>
#undef DOUBLESIZE	/* To avoid error calls resulting from multiple */
#undef FLOATSIZE	/* defines from isam.h and dbio.h */
#include <dbio.h>

#define SUCCESS 0	/* For return condition from ALL routines */

struct fieldtype	/* Array of structures to hold field info */
{
	char name[51];
	int offset;
	short type;
	short len;
	short perms;
}fields[1000];

char buf[2049]; 	/* Buffer for dbfind */

void separate();

void separate(fp,num)

/*	This procedure separates the field contents from the buffer read
	in by dbfind, determines its type and outputs it to the output
	file in the form compatible with dBASE III */

	FILE *fp;
	short num;	/* number of fields in file */

{
	int j, k, newlen, intfield;
	double doubfield;
	long longfield;
	float floatfield;
	short mdy[3];

	for(j=0;j<num;j++)
	{
		switch(fields[j].type)
		{
			case CHARTYPE:	/* Character field */
				k = fields[j].offset + fields[j].len - 1;
				while(buf[k] == ' ' && k >= fields[j].offset)
					k--;
				newlen = k - fields[j].offset + 1;
				if(newlen > 254)
					newlen = 254;
				if(newlen == 0)
					fprintf(fp,"\042\042");
				else
					fprintf(fp,"\042%.*s\042",newlen,&buf[fields[j].offset]);
				break;
			case INTTYPE:	/* Integer field */
				intfield = ldint(&buf[fields[j].offset]);
				fprintf(fp,"%d",intfield);
				break;
			case SERIALTYPE:	/* Serial field */
			case LONGTYPE:		/* Long field */
				longfield = ldlong(&buf[fields[j].offset]);
				fprintf(fp,"%ld",longfield);
				break;
			case MONEYTYPE:		/* Money field */
				doubfield = lddbl(&buf[fields[j].offset]);
				fprintf(fp,"%.2f",doubfield/100);
				break;
			case DOUBLETYPE:	/* Double field */
				doubfield = lddbl(&buf[fields[j].offset]);
				fprintf(fp,"%f",doubfield);
				break;
			case FLOATTYPE:	/* Float field */
				floatfield = ldfloat(&buf[fields[j].offset]);
				fprintf(fp,"%f",floatfield);
				break;
			case DATETYPE: 	/* Date field */
			case EDATETYPE:	/* Edate field */
			case YDATETYPE:	/* Ydate field */
				longfield = ldlong(&buf[fields[j].offset]);
				if(longfield != 0)
				{
					rjulmdy(longfield,mdy,YDATETYPE);
					fprintf(fp,"19%02d%02d%02d",mdy[0],mdy[1],mdy[2]);
				}
				break;
			case COMPOSTYPE:	/* Composite field, ignored */
				break;
			default:
				break;
		}
		if(j != num-1 && fields[j].type != COMPOSTYPE)
			fprintf(fp,",");	/* Field delimiter */
	}
	fprintf(fp,"\n");	/* Record delimiter */
}

main(argc,argv)

	int argc;
	char *argv[];

{
	FILE *fstat, *fopen(), *fclose();
	short numfields, recsize, perms;
	int x, i, len, dbstat, offset = 0;
	char *fnames[1000];

/* Test arguments, attempt to open database and establish output file */

	if (argc != 4)
		exit(printf("Usage : Inf_dB <Inf db name> <db file name> <dB III dest file>\n"));

	if((dbstat = dbselect(DBOPEN,argv[1])) != SUCCESS)
		exit(printf("Inf_dB : Error #%d opening database\n",dbstat));

	if((dbstat = dbselect(FILEOPEN,argv[2])) != SUCCESS)
		exit(printf("Inf_dB : Error #%d opening database file\n",dbstat));

	if(fopen(argv[3],"r") != NULL)
		exit(printf("Inf_dB : Destination file already exists\n"));

	if((dbstat = dbfile(argv[2],&numfields,&recsize,&perms)) != SUCCESS)
		exit(printf("Inf_dB : Error %d retrieving file stats\n",dbstat));

	if(numfields > 1000)	/* Too many fields */
		exit(printf("Inf_dB : Number of fields in %s exceeds limit\n",argv[2]));

	if((fstat = fopen(argv[3],"w")) == NULL)  /* Can't open output file */
		exit(printf("Inf_dB : Error opening %s\n",argv[3]));
	
	for(i=0;i<numfields;i++)	/* Read field info */
	{
		if((dbstat = dbnfield(i,argv[2],fields[i].name,&fields[i].type,&fields[i].len,&fields[i].perms)) != SUCCESS)
			exit(printf("Inf_dB : Error %d retrieving field stats\n",dbstat));
		fnames[i] = fields[i].name;
		fields[i].offset = offset;	/* Set offsets in buffer */
		if(fields[i].type != COMPOSTYPE)
		{
			if(fields[i].len > 254)	/* Field too long */
				printf("Inf_dB : warning : Character field %s will be truncated to 254 characters\n",fields[i].name);
			offset += fields[i].len;
		}
		else
		/* Composite field warning issued */
			printf("Inf_dB : warning : Composite field %s will not be included in output file\n",fields[i].name);
	}

	if((dbstat = dbsetfileview(argv[2],fnames,numfields)) != SUCCESS)
		exit(printf("Inf_dB : Error %d setting file view\n",dbstat));
	
	if((dbstat = dbfind(argv[2],FIRST,(char *)0,&len,buf) != SUCCESS))
		exit(printf("Inf_dB : Error #%d searching for first record\n",dbstat));

	while(dbstat == 0)	/* Step through records */
	{
		separate(fstat,numfields);
		dbstat = dbfind(argv[2],NEXT,(char *)0,&len,buf);
	}

	if(dbstat != 6011)
		exit(printf("Error #%d searching database\n",dbstat));
	else	/* Close database and output file */
	{
		fclose(fstat);
		dbselect(FILECLOSE,argv[2]);
		dbselect(DBCLOSE,argv[1]);
	}

}
                          FTS 684-3616

       Date : 04/01/86

	Compile : scc -w -o Inf_dB Inf_dB.c -ldb -lcisam -lm

*/

#include <stdio.h>
#include <isam.h>
#undef DOUBLESIZE	/* To avoid error calls resulting from multiple */
#undef FLOATSIZE	/* defines from isam.h and dbio.h */
#include <dbio.h>

#define SUCCESS 0	/* For return condition from ALL routines */

struct fieldtype	/* Array 