* ͸
*  Program:       Info.prg                                               
*  Date Created:  Wed  03-16-1994                                        
*  Author:        Clifford Wiebe                                         
*  Note:          Copyright (c) 1994 Clifford Wiebe                      
*                 CI$: 71726,1642                                        
*                 19026 - 117A AVE                                       
*                 Pitt Meadows, BC, Canada, V3Y 1Y3                      
*                 Voice: (604) 465-3000                                  
*                                                                        
* Ĵ
*  Purpose:       Runtime Debugging / System Snapshot                    
* Ĵ
*                                                                        
* If you would like to see a stand-alone demo, compile with              
* CLIPPPER INFO /N /W /DTEST                                             
* and link with your favourite linker.                                   
*                                                                        
* Somewhere in your startup code, set a hotkey to Info(), I use          
* ALT-F10. You can then press this hotkey in any wait state to see a     
* snapshot of your system. Info does change tag orders, current alias,   
* but IT DOES RESTORE THEM. The Heart library mentioned in the code is   
* my own udf library. To include the code specific to a 3rd party lib,   
* uncomment the #define for that lib. Efforts have been made to use the  
* vanilla Clipper functions instead of specific third-party function     
* calls. For example, I couldn't find a function to return the total     
* number of open tags/indexes, so I wrote a small function to do it. This
* function is available in the Six Driver, sx_indexcount() and           
* sx_keycount(). The replacement function is TotalTags().                
*                                                                        
* Ĵ
* Before you jump all over me, I know initializing the aMessage to 500   
* and not doing any bounds checking is the lazy way out, but hey, why    
* don't *you* write the local error checking routine to bump up the array
* size and recover from the error!                                       
*                                                                        
*                                                                        
* The first time you run Info, it primes some static variables with      
* memory(x) values. The next time you invoke info, it compares these     
* values to current to report memory differences.                        
*                                                                        
* Feel free to use Info and include it with your applications, but you   
* are not allowed to charge for it, or re-sell it.                       
*                                                                        
*                                                                        
* ͵
*  Revision History                                                      
*  Date            Author           Notes                                
*                                                                        
*  03-31-1994      cw               Replaced the original array browser  
*                                   with code from the Heart library.    
*                                                                        
*                                                                        
*                                                                        
* ;

#include "inkey.ch"
#include "set.ch"

// uncomment out the defines for the modules you have
//  ͻ
//         If you are not using the Heart library,          
//         (Heart.LIB is my internal function library)      
//       ****   MAKE SURE HEART IS NOT DEFINED  ****        
//  ͼ

// Uncomment out any lines below for the 3rd-party libraries you are
// using. The function references are not extensive, I'm sure you can
// come up with some information you need, but isn't included.

//#define SIX15                  // SixDriver
//#define NETLIB2                // Pinnacle's Publishing Netlib 5.2x
//#define IDL2                   // IDC's IDL(2) Lib (not referenced)
//#define NOVLIB                 // Novlib ( version 2.1 used )
//#define NANFOR                 // Nanforum real-time library
//#define NANFORX                // Nanforum extended mode
//#define BLINKER2               // Blinker 2.x
//#define BLINKER3               // Blinker 3.x
//#define FUNCKY15               // Funcky version 1.5
//#define HEART                  // My internal function library

#ifdef HEART
   #include "version.ch"      // include file for all version define's
   #include "tbwin.ch"        // required for array browsing
   #include "commands.ch"     // the usual default command etc.
#endif

#ifdef NOVLIB
   #include "novlib.ch"
#endif

#ifndef HEART
   #include "fileio.ch"       // needed for handavail() function
   #include "box.ch"          // include box drawing for the array browse

   // following preprocessor stuff is used for the array browser

   #define  TBWIN_TBARRAY           01
   #define  TBWIN_AR_ROW_POS        02
   #define  TBWIN_AR_COL_POS        03
   #define  TBWIN_GOFIRST           04
   #define  TBWIN_GOLAST            05
   #define  TBWIN_GOLEFT            06
   #define  TBWIN_GORIGHT           07
   #define  TBWIN_EXIT_REQUESTED    08
   #define  TBWIN_FREEZE_TEXT       09


   #xtranslate :arRowPos      =>    :cargo\[TBWIN_AR_ROW_POS]
   #xtranslate :arColPos      =>    :cargo\[TBWIN_AR_COL_POS]
   #xtranslate :gofirst       =>    :cargo\[TBWIN_GOFIRST]
   #xtranslate :golast        =>    :cargo\[TBWIN_GOLAST]
   #xtranslate :goleft        =>    :cargo\[TBWIN_GOLEFT]
   #xtranslate :goright       =>    :cargo\[TBWIN_GORIGHT]
   #xtranslate :tbarray       =>    :cargo\[TBWIN_TBARRAY]
   #xtranslate :exitrequested =>    :cargo\[TBWIN_EXIT_REQUESTED]
   #xtranslate :freezetext    =>    :cargo\[TBWIN_FREEZE_TEXT]

#endif



#ifdef BLINKER3
   #include "blinker.ch"
#endif

#ifdef SIX15
   #include "machsix.ch"
#endif

static nSub                      // subscript into current message slot
static aMessage                  // this is where everything is stored.


#ifndef HEART

   // we don't have heart.lib, duplicate some of the translates
   // found in cast.ch

   #xtranslate getkey(<x>)    => inkey(<x>)
   #xtranslate lstrim(<n>)    => ltrim(str(n))
   #xtranslate IsChar(<x>)    => (valtype(<x>) == 'C')
   #xtranslate IsNum(<x>)     => (valtype(<x>) == 'N')
   #xtranslate IsDate(<x>)    => (valtype(<x>) == 'D')
   #xtranslate IsArray(<x>)   => (valtype(<x>) == 'A')
   #xtranslate IsBool(<x>)    => (valtype(<x>) == 'L')
   #xtranslate IsNil(<x>)     => (valtype(<x>) == 'U')
   #xtranslate IsMemo(<x>)    => (valtype(<x>) == 'M')
   #xtranslate IsObject(<x>)  => (valtype(<x>) == 'O')
   #xtranslate IsBlock(<x>)   => (valtype(<x>) == 'B')

   #xtranslate Num2Logical ( <nValue> )   => iif(<nValue> == 0,.F.,.T.)
   #xtranslate Logical2Char( <lValue> )   => iif(<lValue>,".T.",".F.")
   #xtranslate Logical2Num ( <lValue> )   => iif(<lValue>,1,0)
   #xtranslate Num2Char    ( <nValue> )   => ltrim(str(<nValue>))
   #xtranslate Char2Block  ( <cValue> )   => &(<cValue>)

#endif

#define INFO_ARRAY_SIZE                 500


#ifdef TEST
function main()
   ? 'Starting Info'
   info()
   quit
return ( nil )
#endif

function Info()
   Local nMsg
   local n
   local n1, cMsgLine := savescreen(maxrow(),0,maxrow(),maxcol() )
   local oTb, nHotKey := lastkey()

   // save memory settings to track memory leakage
   static nStmemTot,       ;        // Total memory
          nStMemChar,      ;        // Memory avail to characters
          nStMemVir                 // Total virtual memory


   setkey(nHotKey,nil)              // NOT re-entrant

   nSub     := 1
   aMessage := array(INFO_ARRAY_SIZE)

   aMessage := afill(aMessage,'')
   CallStack()                // Load CallStack Info
   LoadConfig()               // Load System Configuration
   LoadSetInfo()              // Load Selected Clipper SETtings
   LoadNetInfo()              // Load Network Information
   #ifdef HEART
      LoadPaths()                // Load directory/path info
   #endif
   LoadMemory()               // Load Memory Information
   if nStMemTot != nil        // Load Memory Leakage information
      LoadLeakage(nStMemTot,nStMemChar, nStMemVir)
   endif
   #ifdef BLINKER3
      LoadBlink3()            // Load Blinker 3.x information
   #endif
   #ifdef BLINKER2
      LoadBlink2()            // Load Blinker 2.x information
   #endif
   LoadDBStat()               // Load Database Status
   CleanUp()                  // Clean up array, get ready to browse

   #ifdef HEART
      oTb := artbwinNew(0,1,maxrow() - 2,78,aMessage,'[ System Information ]')
*     oTb:freezetext := 10 // freeze first 10 chars, just to show it can be done
      oTb:title  := '[ System Information Snapshot ]'
      oTb:getcolumn(1):width := 80
      ClockOff()
      :oTb:browse()
      :oTb:tbkill()
      ClockOn()
   #else
      ArTbrowse(1,1,maxrow() - 2,78,aMessage,'[ System Information ]')
   #endif
   setkey(nHotkey, {|| info() })
   restscreen(maxrow(),0,maxrow(),maxcol(),cMsgLine)

   // if statics are nil, save memory values for comparison
   // later to detect memory leakage
   if nStMemTot == nil
      nStMemTot   := memory(0)
      nStMemChar  := memory(1)
      nStMemVir   := memory(3)
   endif

return ( NIL )



static function CallStack( )
   Local n := 0

   aMessage[nSub++] := padc('[ CallStack ]',79,'')

   while !(procname(n) == '')
      aMessage[nSub++] := procname(n)+ '(' + lstrim(procline(n)) + ')'
      n++
   enddo
return ( nil )

static function LoadConfig( )
   aMessage[nSub++] := padc('[ Version and Default ]',79,'')
   aMessage[nSub++] := '           RDD Driver Name: '+dbsetdriver()
   aMessage[nSub++] := '   Default Index Extension: '+ordbagext()
   #ifdef SIX15
      aMessage[nSub++] := '   Primary Index Extension: '+ rddinfo(dbsetdriver())[4]
      aMessage[nSub++] := ' Secondary Index Extension: '+ rddinfo(dbsetdriver())[5]
      aMessage[nSub++] := '        Memofile Extension: '+ rddinfo(dbsetdriver())[6]
      aMessage[nSub++] := '            sixcdx Version: '+ sx_version(3)
      aMessage[nSub++] := '           MachSix Version: '+ m6_version(3)
   #endif
   aMessage[nSub++] := '           Clipper Version: '+ version()
   #ifdef NOVLIB
      aMessage[nSub++] := '            NovLib Version: '+ NovLibVer()
   #endif
   aMessage[nSub++] := '           Blinker Version: '+ transform(BliVerNum()/100,'99.99')
   #ifdef FUNCKY15
      aMessage[nSub++] := '                  CPU Type: '+ str(cputype())
   #endif
   #ifdef NANFOR
      aMessage[nSub++] := '                  CPU Type: '+ 'NA'
   #endif
   #ifdef FUNCKY15
      aMessage[nSub++] := '    Math Coprocessor Found: '+ iif(ndptype()>0,'Yes','No')
   #endif
//   #ifdef NANFORX
//        aMessage[nSub++] := '               DOS Version: '+ ft_dosver()
//   #endif
   aMessage[nSub++] := '          Free Diskspace(): '+               ;
               transform(diskspace(),'9,999,999,999')
   aMessage[nSub++] := '             Color Setting: '+setcolor()
   aMessage[nSub++] := '           CLIPPER setting: '+GetEnv('CLIPPER')
   aMessage[nSub++] := '              TEMP setting: '+GetEnv('TEMP')
   aMessage[nSub++] := '               TMP setting: '+GetEnv('TMP')
   aMessage[nSub++] := '         Available Handles: '+str(HandAvail(),5)
   #ifdef NANFOR
      // don't use the ft_handcnt function with Blinker 3.x
//    #ifndef BLINKER3
//         aMessage[nSub++] := ' CONFIG.SYS DOS Handles: '+ str(Ft_HandCnt(),5)
      aMessage[nSub++] := '             Default Drive: '+ Ft_default()
//    #endif
   #endif

return ( nil )
static function LoadSetInfo()
   local n
   aMessage[nSub++] := padc('[ Clipper SETtings ]',79,'')
   aMessage[nSub++] := '       Exact: ' +iif(set(_SET_EXACT),'On ','Off') + ;
                       '                 Fixed: ' +iif(set(_SET_FIXED),'On ','Off')
   aMessage[nSub++] := '    Decimals: ' +str(set(_SET_DECIMALS),3) + ;
                       '           Date Format: ' + set(_SET_DATEFORMAT)
   aMessage[nSub++] := '   Exclusive: ' +iif(set(_SET_EXCLUSIVE),'On ','Off')+;
                       '              SoftSeek: ' +iif(set(_SET_SOFTSEEK),'On ','Off')
   aMessage[nSub++] := '      Unique: ' +iif(set(_SET_UNIQUE),'On ','Off')+;
                       '                  Wrap: ' +iif(set(_SET_WRAP),'On ','Off')
   aMessage[nSub++] := '      Cancel: ' +iif(set(_SET_CANCEL),'On ','Off')+;
                       '               Deleted: ' +iif(set(_SET_DELETED),'On ','Off')
   aMessage[nSub++] := '   Read Exit: ' +iif(set(_SET_EXIT),'On ','Off')+;
                       '             Intensity: ' +iif(set(_SET_INTENSITY),'On ','Off')
   aMessage[nSub++] := '        Path: ' +set(_SET_PATH)
   aMessage[nSub++] := '     Default: ' +set(_SET_DEFAULT)

return ( nil )

static function LoadNetInfo()
   local n
   aMessage[nSub++] := padc('[ Network Information ]',79,'')
   #ifdef NETLIB52
      aMessage[nSub++] := '          Netware Login ID: ' +n_whoami()
      aMessage[nSub++] := '                 Full Name: ' +n_fullname()
      aMessage[nSub++] := '    Logical Station Number: ' +str(n_stanum(),5)
      aMessage[nSub++] := '      Max Handles from Net: ' +str(n_handles(),5)
      aMessage[nSub++] := '         Available Handles: ' +str(n_handles() - n_handles(-1),5)
   #endif
   #ifdef NOVLIB
      aMessage[nSub++] := '          Netware Login ID: ' +Any2Char(LoginName())
      aMessage[nSub++] := '                 Full Name: ' +LoginName()
      aMessage[nSub++] := '    Logical Station Number: ' +str(ConnNo(),5)
      aMessage[nSub++] := '     Shell Revision Number: ' +ShellVer()
      for n := 1 to 4
         if CapQueue( n ) > 0
            aMessage[nSub++] := '   LPT'+ltrim(str(n))+           ;
                          ': Captured to Queue: '+                ;
                          padr(QueueName(CapQueue(n)),15) +       ;
                          iif( iscap(n),' Active',' Inactive ')
         endif
      next
   #endif
   #ifdef NANFOR
      aMessage[nSub++] := '          Netware Login ID: ' +ft_nwuid()
      aMessage[nSub++] := '    Logical Station Number: ' +str(ft_nwlstat(),5)
   #endif
return ( nil )

static function LoadDbStat()
   local nArea, nSaveArea, cAlias, n

   aMessage[nSub++] := padc('[ Database Status ]',79,'')
   aMessage[nSub++] := 'Current Work Area: '+str(select(),3 )
   aMessage[nSub++] := '    Current Alias: ' + alias()
   nArea := 1
   nSaveArea := select( alias() )
   DO WHILE nArea < 256
      IF LEN(ALIAS(nArea)) <> 0
         select( nArea )
         aMessage[nSub++] := padc('[ Database: '+alias()+' ]',79,'')
         aMessage[nSub++] := padl('Area:',16) +                      ;
                             str(nArea,2) + ' ' + space(5) +         ;
                           + '    Curr/Total: '+                     ;
                        transform( recno(),"999,999")+ "/"  +        ;
                        ltrim(transform( lastrec(),"999,999"))

         aMessage[nSub++] := padl('Record Size: ',16) +              ;
                              transform( recsize(),'9,999') +        ;
                             '      Header Size: '+                  ;
                             transform( header(),'9,999') +          ;
                             ' File Size: '+                         ;
                             transform( (recsize() * lastrec()) +    ;
                                         header() + 1,'99,999,999')
         if len( dbrlocklist() ) > 0
            aMessage[nSub++] := transform(len(dbrlocklist()),'999') + ;
                           ' LOCK(s) ACTIVE.    Record Numbers: '
            for n := 1 to len( dbrlocklist() )
               aMessage[nSub-1] += transform(dbrlocklist()[n],'9,999,999')
            next
         endif
         aMessage[nSub++] :=  padl('Bagname: ',16)+                  ;
                              padr(ordbagname(),12) +                ;
                             'Total Tags: '+str(TotalTags())

         aMessage[nSub++] := padl('Current Tag: ',16)+               ;
                              str(ordnumber() ) +                    ;
                             '    Tag Name: ' + ordname( ordnumber() )
         aMessage[nSub++] := padl("Deleted: ",16)+iif(deleted(),"Y","N")
         if !empty( dbfilter() )
            aMessage[nSub++] := ' Active Filter: '+dbfilter()
         else
            aMessage[nSub++] := ' Active Filter: *No Active Filter*'
         endif
         #ifdef SIX15
            SixFilterInfo()
            SixScopeInfo()
         #endif
         LoadIndex( )
      ENDIF
      nArea++
   ENDDO
   Select ( nSaveArea )       // restore original area
return ( nil )

#ifdef SIX15
static function SixFilterInfo()
   local nHandle, aFiltInfo
   local aOptimize := {' Not Optimizable',' Partially Optimized',' Fully Optimized'}

   nHandle := m6_GetAreaFilter()
   if nHandle > 0
      aFiltInfo := m6_filtInfo( nHandle )
      aMessage[nSub++] := 'Six Driver Filter Info'
      aMessage[nSub++] := '     Filter Expression: ' + aFiltInfo[INFO_EXPR]
      aMessage[nSub++] := 'Non-Indexed Expression: ' + aFiltInfo[INFO_NONEXPR]
      aMessage[nSub++] := '    Optimization Level: ' +               ;
                           ltrim(str(aFiltInfo[INFO_OPTLVL])) +      ;
                           aOptimize[ aFiltInfo[INFO_OPTLVL]+1 ]
   endif
return ( nil )

static function SixScopeInfo()
   local x

   x := sx_setscope(0)
   if !empty( x )
      aMessage[nSub++] := '   Scope Top: '+ any2char( x )
   endif
   x := sx_setscope(1)
   if !empty( x )
      aMessage[nSub++] := 'Scope Bottom: '+ any2char( x )
   endif
return ( nil )
#endif

static function TotalTags()
   local nBagCount := 0, n := 1
   local nSaveOrder := ordnumber()
   local cOrdSavTag

   ordsetfocus( 1 )

   if !empty( ordsetfocus() )
      // at least one tag active
      nBagCount++
      do while .T.
         // who came up with this ordsetfocus name anyway!
         cOrdSavTag := ordsetfocus(++n )
         if cOrdSavTag == ordsetfocus()
            exit
         endif
         nBagCount++
      enddo
   endif
   ordsetfocus( nSaveOrder )
return ( nBagCount )

static function LoadIndex()
   local nTagCount := TotalTags()
   local n

   aMessage[nSub++] := padc('[ Index Status for '+alias()+' ]',79,'')

   for n := 1 to nTagCount
      aMessage[nSub++] := "Tag "+str(n,2)+"    Name: "+padr(ordname( n ),12)
      aMessage[nSub++] := "          Expr: "+ordkey(n)
      aMessage[nSub++] := "         Value: "+any2char(&(ordkey(n)))

      if !empty( ordfor( n ) )
         aMessage[nSub++] := "    Tag Filter: "+ordfor(n)
      else
         aMessage[nSub++] := "    Tag Filter: NONE"
      endif
      #ifdef SIX15
         LoadSixInfo( n )
      #endif
      aMessage[nSub++] := ''
   next

return ( nil )

#ifdef SIX15
static function LoadSixInfo( n )
   local aTagInfo := {}

   aTagInfo := sx_taginfo()
   if len( aTagInfo ) >= n
      aMessage[nSub++] := "        Unique: "+iif(aTaginfo[n,4],'Y','N')
      aMessage[nSub++] := "       Descend: "+iif(aTaginfo[n,5],'Y','N')
      aMessage[nSub++] := "  Roll You Own: "+iif(aTaginfo[n,5],'Y','N')
   endif
return ( nSub )
#endif

#ifdef HEART
static function LoadPaths()
   // These are standard paths that are available to all systems
   // using Heart.lib

   aMessage[nSub++] := padc('[ Program Paths ]',79,'')
   aMessage[nSub++] := '    Main Defined Data Path: '+DataPath()
   aMessage[nSub++] := '       Defined Report Path: '+ReportPath()
   aMessage[nSub++] := '       Defined Import Path: '+ImportPath()
   aMessage[nSub++] := '       Defined Export Path: '+ExportPath()
return ( nil )
#endif

static function LoadMemory()

   aMessage[nSub++] := padc('[ Memory Status ]',79,'')
   aMessage[nSub++] := '   Mem(0)=Total Char Space  Mem(1)  =Largest Avail Block'
   aMessage[nSub++] := '   Mem(2)=Avail to DOS      Mem(3)  =Total VMM'
   aMessage[nSub++] := '   Mem(4)=Avail EMS to VMM  Mem(101)=Fixed Heap Size(?)'
   aMessage[nSub++] := ''
#ifdef FUNCKY15
   aMessage[nSub++] := '    Installed Conv. Memory: '+ str(dosmem(),5)+'k'
   aMessage[nSub++] := '      Installed EMS Memory: '+ iif(isems(),str(expmem(),5)+'k','    0k')
   aMessage[nSub++] := '      Installed XMS Memory: '+ str(extmem(),5)+'k'
#endif
#ifdef NANFORX
   aMessage[nSub++] := '    Installed Conv. Memory: '+ str(ft_sysmem(),5)+'k'
   aMessage[nSub++] := '      Installed EMS Memory: '+ 'NA'
#endif

   aMessage[nSub++] := '        Memory(0): '+str(memory(0),7)+ 'k'+ space(3) + ;
                    '   Memory(1): '+str(memory(1),7)+ 'k'
   aMessage[nSub++] := '        Memory(3): '+str(memory(3),7)+ 'k'+ space(3) + ;
                    '   Memory(2): '+str(memory(2),7)+ 'k'
   aMessage[nSub++] := '        Memory(4): '+str(memory(4),7)+ 'k'+ space(3) + ;
                    ' Memory(101): '+str(memory(101),7)+'k'

   aMessage[nSub++] := 'Total (0,1,2,3,4): '+      ;
      transform(memory(0)+memory(1)+memory(2)+memory(3)+memory(4),'999,999')+'k'

return ( nil )

static function LoadLeakage(nStMemTot,nStMemChar, nStMemVir)
   aMessage[nSub++] := padc('[ Memory Leakage ]',79,'')
   aMessage[nSub++] := '      Lost Total Memory(0): '+str(nstMemTot - memory(0),7)+ 'k'
   aMessage[nSub++] := '  Lost Character Memory(1): '+str(nStMemChar - memory(1),7)+ 'k'
   aMessage[nSub++] := '    Lost Virtual Memory(3): '+str(nStMemVir - memory(3),7)+ 'k'
return ( nil )


#ifdef BLINKER3
static function LoadBlink3()
   local n
   aMessage[nSub++] := ''
   aMessage[nSub++] := padc('[ Blinker Extended Mode Information ]',79,'')

   n := BliMgrsts(BliMachineMode)
   if n < 0
      n := n + 1
   endif
   aMessage[nSub++] := '                Running In: '+{'Real','Protected'}[n+1]+' mode'
   n := BliMgrSts(BliCacheLoc) + 1
   aMessage[nSub++] := '  Overlay Cache Located In: '+{'*NO CACHE*','EMS Memory','XMS Memory'}[n]
   n := BliMgrSts(BliHostMode) + 1
   aMessage[nSub++] := '      DOS Extender Host is: '+{'*NO HOST*','DPMI','VCPI','XMS'}[n]
   n := BliMgrSts(BliRealMemAvail)
   aMessage[nSub++] := '     Real Memory Available: '+transform(int(n / 1024),'99,999,999k')
   n := BliMgrSts(BliVirMemAvail)
   aMessage[nSub++] := '  Virtual Memory Available: '+ transform(int(n / 1024),'99,999,999k')
   n := BliMgrSts(BliOverlaySize)
   aMessage[nSub++] := 'Overlay Pool Operating Sze: '+ transform(int(n / 1024),'99,999,999k')
   aMessage[nSub++] := '               SET BLINKER= '+getenv('BLINKER')

return ( nil )
#endif

#ifdef BLINKER2
static function LoadBlink2()
   aMessage[nSub++] := ''
   aMessage[nSub++] := padc('[ Blinker 2.10 Real Mode Information ]',79,'')
   aMessage[nSub++] := ' Overlay Pool Current Size: '+ transform(BliOvlSiz(),'999,999')
   aMessage[nSub++] := '     Total Loaded Overlays: '+ transform(BliTotLod(),'999')
   aMessage[nSub++] := '     Total Active Overlays: '+ transform(BliTotAct(),'999')
#endif
return ( nil )

static function CleanUp()
   aMessage[nSub++] := '*end of informaton*'
   aMessage[nSub] := replicate('',79)
   // Resize the array to strip off the nil elements
   aMessage := asize(aMessage,nSub)
   keyboard chr( 0 )            // clear keyboard
return ( nil )

#ifndef HEART

function HandAvail()
   // return the number of handles available
   local n, aHandles := {}

   do while .T.
      n := fopen('NUL',FO_READWRITE)   // open the nul device
      if ferror() != 0                 // until error occurs
         exit
      endif
      aadd( aHandles,n )               // we'll need to close them
   enddo
   // close all the nul open handles
   aeval( aHandles,{|x| fclose( x ) } )
return ( len( aHandles ) )

function ArTbrowse(nTop,nLeft,nBottom, nRight, aTable, cTitle )
   local oTb, oTbc, n, cScreen
   local nKey, cColor

   cScreen              := savescreen(0,0,maxrow(),maxcol() )
   cColor               := setcolor("W+/B")

   // start by creating a standard tbwin object
   oTb                  := TBrowseNew(nTop,nLeft,nBottom, nRight )
   oTb:cargo            := array(20)
   oTb:tbarray          := aTable
   oTb:ExitRequested    := .F.
   oTb:freezetext       := 0        // don't freeze any left columns

   oTb:arRowPos         := 1        // row pointer for array
   oTb:arColPos         := 1        // column pointer for array
   oTb:gotopblock       := {|| oTb:arRowPos := 1 }
   oTb:gobottomblock    := {|| oTb:arRowPos := len( oTb:tbarray ) }
   oTb:skipblock        := {|nSkip| aTbSkip(nSkip,aTable,oTb) }
   oTb:gofirst          := {|| oTb:arRowPos := 1 }
   oTb:golast           := {|| oTb:arRowPos := len( oTb:tbarray ) }
   // 1-D array, allow for panning the text
   oTb:goleft           := ;
         {|| iif(oTb:arColPos > 1,oTb:arColPos--,nil),                  ;
               oTb:refreshall()}
   oTb:goright          := ;
         {|| iif(oTb:arColPos < len( oTb:tbarray ),oTb:arColPos++,nil), ;
               oTb:refreshall()}

   oTbc                 := tbcolumnNew(,                                ;
        {||left(oTb:tbarray[oTb:arRowPos],oTb:freezetext) +             ;
         substr(oTB:tbarray[oTb:arRowPos],oTb:freezetext + oTb:arColPos) } )

   oTb:addcolumn( oTbc )

   dispbox(oTb:nTop-1,oTb:nLeft-1,oTb:nBottom+1,oTb:nRight+1,B_DOUBLE+" ")

   @ oTb:nTop-1,3 say cTitle

   do while !oTb:ExitRequested
      do while (nKey := inkey()) == 0 .and. !oTb:stabilize()
      enddo
      if nkey == 0
         nkey := inkey(0)
      endif

      do case
         case nKey == K_ESC
            oTb:ExitRequested := .T.
         case nKey == K_DOWN        ;  oTb:down()
         case nKey == K_UP          ;  oTb:up()
         case nKey == K_PGUP        ;  oTb:pageup()
         case nKey == K_PGDN        ;  oTb:pagedown()
         case nKey == K_PGUP        ;  oTb:pageup()
         case nKey == K_CTRL_PGUP   ;  oTb:gotop()
         case nKey == K_CTRL_PGDN   ;  oTb:gobottom()
         case nKey == K_RIGHT       ;  eval( oTb:goright )
         case nKey == K_LEFT        ;  eval( oTb:goleft )
      endcase
   enddo

   restscreen(0,0,maxrow(),maxcol(),cScreen)
   setcolor(cColor)
return ( nil )

static function aTBSkip(nSkip,aTable, oTb )
   local nTemp := oTb:arRowPos

   if oTb:arRowPos + nSkip > len(oTb:tbarray)
      oTb:arRowPos  := len( oTb:tbarray )
   elseif oTb:arRowPos + nSkip < 1
      oTb:arRowPos  := 1
   else
      oTb:arRowPos += nSkip
   endif
return ( oTb:arRowPos - nTemp )

static function Any2Char( value )
      Local rvalue
      do case
         case value == nil
            rValue := 'nil'
         case ischar(value)
            rValue := value
         case isnum(value)
            rValue := Num2Char(Value)
         case isdate(value)
            rvalue := dtoc(value)
         case isBool(value)
            rvalue := Logical2Char( value )
         case isMemo(value)
            rvalue := MemoRead ( Value )
         case isObject(value)
            rvalue := '*Object*'
         case isBlock(value)
            rvalue := '*Block*'
         case IsArray(value)
            rvalue := Array2Char(value)
         case IsNil(value)
            rvalue := 'NIL'
      endcase
   return (rvalue)

static function Array2Char( aValue )
   local c := '{'
   aeval(aValue,{|a| c += "" + Any2Char(a) + "," })
   c += '}'
return ( c )

#endif
