clear screen
set scoreboard off

* Database is opened in an area, pass in the area

Select A
USE ITEMS
xind = Indx_sel(8,12,3)
IF !EMPTY(xind)
   INDEX ON &xind TO items1
ENDIF

* pass the database name to be opened in next area

xind = Indx_sel(15,40,4,'items')
IF !EMPTY(xind)
   INDEX ON &xind TO items2
ENDIF

* pass the database name to be opened in next area, change color also

xind = Indx_sel(3,11,20,'items','BG+/B,W+/B')
IF !EMPTY(xind)
   INDEX ON &xind TO items3
ENDIF
CLEAR SCREEN
RETURN

*****************

FUNCTION Indx_sel
*
* Allows selection of fields from a database in order
*   Builds the index selection based on the order 
*    as a literal and returns it to the user
*
*  Format: INDX_SEL(n1, n2, n3, c1, c2)
*    where:  n1 = Top Row of Choice Window
*               Default = 4
*            n2 = Top Column of Choice Window
*               Default = 7
*            n3 = Number of rows in Choice Window
*                 will not be more than count of names in DB
*               Default = 6
*            c1 = a 1 character Select Area for database
*             or  a database name
*            c2 = Color selection for Choice window (in number format)
*               Default = White on Blue
*
   PARAMETER _T_row, _T_col, _Disp_row, _DB_name, _Indx_clr
   PRIVATE _clr_hold, _scr_hold, _nxt_fld

   _T_row =    IF ((TYPE('_T_row')    != 'N'), 4, _T_row)
   _T_col =    IF ((TYPE('_T_col')    != 'N'), 7, _T_col)
   _Disp_row = IF ((TYPE('_Disp_row') != 'N'), 6, _Disp_row)
   * If no database passed, then it was already selected
   _DB_name =  IF ((TYPE('_DB_name')  != 'C'), '', _DB_name)
   * Colors passed in, Default is White on Blue
   _Indx_clr = IF ((TYPE('_Indx_clr') != 'C'), 'W/B,GR+/B', _Indx_clr)

   * Testing for field selection on a database
   IF LEN(_DB_name) = 1
       SELECT &_DB_name                    && Use area pointer
   ELSEIF LEN(_DB_name) > 1
       USE &_DB_name                       && Use database
   ENDIF

   PRIVATE _Names[FCOUNT()], _Sort_ord[FCOUNT()], _Max_ord, _Indx_pool
   PRIVATE _iss, _ctr
   _Max_ord = 0                            && Maximum order # entered
   _Indx_pool = ''                        && List of index fields at end
   FOR i=1 TO FCOUNT()
      _Sort_ord[i]=0
   NEXT i

   * If more rows requested than names, shorten the rows
   IF _Disp_row > FCOUNT()
      _Disp_row = FCOUNT()
   ENDIF

   SAVE SCREEN TO _scr_hold
   _clr_hold = SETCOLOR()
   SET COLOR TO &_Indx_clr

   _B_row=_T_row + _Disp_row + 2          && Bottom row
   _B_col=_T_col+23                       && Bottom column
   @  _T_row,_T_col,_B_row,_B_col BOX '͸Գ '
   @  _T_row+1, _T_col+4 SAY "Field Name  Order"
   @  _B_row, _T_col+1   SAY ' '+CHR(17)+' pick, ESC ends '
   IF _Disp_row < FCOUNT()
      @ _B_row-1,_T_col+1 SAY CHR(25)     && Down Arrow at beginning
   ENDIF

   IF !EMPTY(AFIELDS(_Names))
      ACHOICE(_T_row+2,_T_col+3,_B_row-1,_T_col+12,_Names,'',"_Ord_func",1)
   ENDIF

   * Selections have been made, now develop the index literal
   FOR _ctr = 1 TO _Max_ord        && Look for each selected order #
      FOR _iss = 1 to FCOUNT()        && Look in each sort_ord entry
         IF _Sort_ord[_iss] = _ctr     && Entry matches an order pick
            _Nxt_fld = _Names[_iss]    && Place field in work area
*  Determine if field selected is numeric or date 
*   if so then convert to character
            IF TYPE('&_Nxt_fld') = 'N'      && Numeric
                _Nxt_fld = '(STR('+_Nxt_fld+'))'
            ENDIF
            IF TYPE('&_Nxt_fld') = 'D'      && Date
                _Nxt_fld = '(DTOC('+_Nxt_fld+'))'
            ENDIF
*  Do not index on Logical or Memo fields
            IF TYPE('&_Nxt_fld') # 'L' .AND.;
               TYPE('&_Nxt_fld') # 'M'
                 _Indx_pool = _Indx_pool + _Nxt_fld + '+'
                 _iss = FCOUNT() + 1       && Stop loop
            ENDIF
         ENDIF
      NEXT _iss
   NEXT _ctr                       && Next order #

   _Indx_pool = LEFT(_Indx_pool,LEN(_Indx_pool)-1)     && Remove last +
   RESTORE SCREEN FROM _scr_hold     && Restore underlying screen
   SET COLOR TO &_clr_hold           && Restore color

RETURN(_Indx_pool)                && Return the index list

*****************

FUNCTION _Ord_func
* Controls the ACHOICE screen, allows selection of the order
   PARAMETER _Of_mode, _Of_ele, _Of_scr
   PRIVATE _Of_action, _irw
   _Of_action = 2                  && Continue
   SET CURSOR OFF                  && do not display fill in
   FOR _irw = 1 TO _Disp_row          && screen row size
      @ _T_row+1+_irw, _T_col+18 SAY _Sort_ord[_irw+(_Of_ele-_Of_scr-1)] PICTURE '@Z 99'
   NEXT _irw
   SET CURSOR ON

   DO CASE

   CASE _Of_mode = 3
      IF LASTKEY()=13
         _Of_action =2     && make selection
   * Enter Key Pressed, User Selected a Field, Get an Order Numberr
         @ _T_row+2+_Of_scr, _T_col+18 GET _Sort_ord[_Of_ele] picture '99' valid _chk_ord(_Of_ele)
         READ
         @ _T_row+2+_Of_scr, _T_col+18 SAY _Sort_ord[_Of_ele] picture '@Z 99'   && Display entry
         _Max_ord = MAX(_Max_ord, _Sort_ord[_Of_ele])      && Keep max # entered
      ENDIF
      IF LASTKEY()=27  && ESC
         _Of_action = 0    && abort
      ENDIF

   CASE _Of_mode = 4
      _Of_action = 0       && abort
   ENDCASE

   * display arrows on side of frame
   IF _Of_ele > (_Of_scr+1)
      @ _T_row+2,_T_col+1 SAY CHR(24)     && Up Arrow
   ELSE
      @ _T_row+2,_T_col+1 SAY ' '         && Space
   ENDIF
*  IF _Of_ele-(_Of_scr) < FCOUNT()-_Disp_row
   IF _Of_ele-(_Of_scr) < FCOUNT()-_Disp_row+1
      @ _B_row-1,_T_col+1 SAY CHR(25)     && Down Arrow
   ELSE
      @ _B_row-1,_T_col+1 SAY ' '         && space
   ENDIF
RETURN(_Of_action)

*****************

FUNCTION _chk_ord      && Check for duplicate select number
* Used as a VALID from GET
   PARAMETER sel_pos      && selected position
   PRIVATE _ix
   * look for the same sort order number in the array, if so
   *   then tone and reject
   IF _Sort_ord[sel_pos] # 0                 && allow zero to stop select
      FOR _ix = 1 TO FCOUNT()                 && entire table
         IF _ix # sel_pos                     && do not check same value
            IF _Sort_ord[_ix] = _Sort_ord[sel_pos]   && match?
               TONE(164.8,3)                 && error sound
               RETURN(.F.)                   && VALID check fails
            ENDIF
         ENDIF
      NEXT _ix
   ENDIF
RETURN(.T.)
