*   FILE NAME: IND.PRG
*          BY:  Stephen D. Hilton
*        DATE: February 10, 1988
*        DESC: Program which demonstrates the use of Summer '87 
*              command SET ORDER TO
*  DATA FILES: INDTEST.DBF
*
*  Structure for database : indtest.dbf
*  Number of data records :         15
*  Date of last update    : 02-10-1988
*  Field  Field name  Type       Width    Dec
*  -----  ----------  ----       -----    ---
*      1  FIRSTNAME   Character     15
*      2  LASTNAME    Character     15
*      3  COMPANY     Character     30
*  ** Total **                      61
*
*
*  If you want to test this program and save some time by not
*  keying it in yourself.  Why don't you call the C.U.G.O.C.
*  Bulletin Board @ (714) 760-4402 and download file ORDER.ARC.
*  The arc file contains the source code and sample database
*  file.
*  
*        Ŀ
*               HOURS              LINE SETTINGS  
*        Ĵ
*           Mon-Fri   5pm-6am       2400 N 8 1    
*           Sat-Sun   24 hrs        1200 N 8 1    
*           Holidays  24 hrs         300 N 8 1    
*        
*  
*
USE INDTEST

SET COLOR TO 
CLEAR 

IF .NOT. FILE("FIRST.NTX")
   ? "Creating FIRSTNAME index file"
   INDEX ON firstname TO first
ENDIF 

IF .NOT. FILE("LAST.NTX")
   ? "Creating LASTNAME index file"
   INDEX ON lastname TO last
ENDIF 

IF .NOT. FILE("COMPANY.NTX")
   ? "Creating COMPANY index file"
   INDEX ON company TO company
ENDIF 

SET INDEX TO first,last,company

SET COLOR TO W/N
CLEAR 
@ 01,00 TO 03,79 DOUBLE
@ 05,00 TO 21,79 DOUBLE
@ 02,03 SAY "SET INDEX TEST PROGRAM"
@ 02,30 SAY "Select Index First, Last, Company, Natural, Quit"
SET COLOR TO N/W
@ 04,00 SAY SPACE(2)+"REC #"+SPACE(3)+"FIRSTNAME"+SPACE(9)+"LASTNAME"+;
   SPACE(10)+"COMPANY"+SPACE(27)
SET COLOR TO 

SET ORDER TO 0
DO DISPLAY

Level1 = 1
SET WRAP ON 
SET MESSAGE TO 24
DO WHILE .T.
   @ 23,00 CLEAR 
   @ 02,43 PROMPT "First" MESSAGE "SET ORDER TO 1"
   @ 02,50 PROMPT "Last" MESSAGE "SET ORDER TO 2"
   @ 02,56 PROMPT "Company" MESSAGE "SET ORDER TO 3"
   @ 02,65 PROMPT "Natural" MESSAGE "SET ORDER TO 0"
   @ 02,74 PROMPT "Quit" MESSAGE "Return To DOS "
   MENU TO Level1
   DO INDSUB WITH Level1
ENDDO 

PROCEDURE INDSUB
PARAMETERS choice

DO CASE 
CASE choice = 1
   SET ORDER TO 1
   DO DISPLAY
   GO TOP 
   DO MESSAGE WITH "FIRSTNAME"
   @ 06,10 GET FIRSTNAME
   READ 
   DO DISPLAY
CASE choice = 2
   SET ORDER TO 2
   DO DISPLAY
   GO TOP 
   DO MESSAGE WITH "LASTNAME"
   @ 06,28 GET LASTNAME
   READ 
   DO DISPLAY
CASE choice = 3
   SET ORDER TO 3
   DO DISPLAY
   GO TOP 
   DO MESSAGE WITH "COMPANY"
   @ 06,46 GET COMPANY
   READ 
   DO DISPLAY
CASE choice = 4
   SET ORDER TO 0
   DO DISPLAY
CASE choice = 5
   CLEAR SCREEN 
   QUIT 
ENDCASE 
RETURN 

PROCEDURE DISPLAY
GO TOP 
mrow = 6
DO WHILE mrow <= 20 .AND. ! EOF()
   @ mrow,02 SAY STR(RECNO(),5)
   @ mrow,10 SAY FIRSTNAME
   @ mrow,28 SAY LASTNAME
   @ mrow,46 SAY COMPANY
   IF EOF()
      EXIT 
   ELSE 
      SKIP 
      mrow = mrow+1
   ENDIF 
ENDDO 
RETURN 

PROCEDURE MESSAGE
PARAMETERS m_field
SET COLOR TO W/N*
@ 23,00 SAY ">>>>>>>"
@ 23,73 SAY "<<<<<<<"
SET COLOR TO 
MSG = "CHANGE this "+m_field+" and watch the file Re-Order"
CTR = (80-LEN(MSG))/2
@ 23,CTR SAY MSG
RETURN 

*EOF: IND.PRG    
