*     Main Module: IMPORTER.PRG
*     TJs Lab  4409 Beaumont Drive, Orlando, Florida  32808
*
SET ESCAPE ON
SET SCOREBOARD OFF
IF ISCOLOR()
   SET COLOR TO W+/B,N/W,R
ENDIF
DO WHILE .T.
   CLEAR
   @ 3,17 SAY  "DEMO - IMPORT TEXT WHILE IN MEMOEDIT() FUNCTION"
   @ 24,29 SAY "PRESS Esc TO EXIT"
   DBNAME=SPACE(50)            && Name of the database
   @ 13,0 CLEAR TO 15,79
   @ 13,0 TO 15,79
   @ 14,5 SAY "Enter NAME of DATABASE to EDIT: " GET DBNAME PICTURE "@S30"
   READ
   IF LASTKEY()=27             && Press Esc to EXIT/QUIT this Program
      CLEAR
      CLOSE DATABASES
      RETURN
   ENDIF
   IF !EMPTY(DBNAME) .AND. AT(".",DBNAME)=0  && If not empty and has no extension
      DBNAME=ALLTRIM(DBNAME)+".DBF"          && then attach  .DBF
   ENDIF
   DO CASE
      CASE FILE("&DBNAME")                   && If database exists, then open.
	   BROWSEIT(DBNAME)                  && UDF to set up for DBEDIT()
      CASE EMPTY("&DBNAME")                  && If nil is entered, then load all
	   RELEASE ARRTEMP                   && DBF files into an array,
	   DECLARE ARRTEMP[ADIR("*.DBF")]    && then present this array as an
	   ADIR("*.DBF",ARRTEMP)             && option box using ACHOICE()
	   @ 4,31 CLEAR TO 23,49
	   @ 4,31 TO 23,49
	   X = ACHOICE(5, 32, 22, 48, ARRTEMP, .T.)
	   IF X=0                            && If Esc was pressed
	      LOOP                           && then start over
	   ENDIF
	   BROWSEIT(ARRTEMP[X])
      OTHERWISE
	   @ 11,0 CLEAR TO 13,79
	   @ 11,0 TO 13,79
	   @ 12,2 SAY      "SORRY, BUT COULD NOT FIND "+DBNAME
	   TONE(4343,.8)
	   INKEY(2)
   ENDCASE
ENDDO

FUNCTION BROWSEIT    && UDF to set screen up, then browse a database with DBEDIT()
PARAMETER DBNAME
USE &DBNAME
RELEASE ARRTEMP                   && RELEASE in case used more that once
DECLARE ARRTEMP[FCOUNT()]         && DECLARE to the number of fields
AFIELDS(ARRTEMP)                  && Load field names into the array
@ 1,0 CLEAR TO 23,79              && Clear and make a box
@ 1,0 TO 23,79
@ 1,35 SAY      "[ BROWSE ]"
@ 24,0
@ 24,0 SAY " Esc(EXIT)   Ctrl N(ADD)   Ctrl U(DELETE) "
**      Use DBEDIT() to browse this database
DBEDIT(2, 1, 22, 78, ARRTEMP, "DBFUNCT", 0, 0, " ", "  ")
RETURN ""

FUNCTION DBFUNCT         && UDF - Used with DBEDIT()
PARAMETERS MODE,I
TEMPFIELD=ARRTEMP[I]
SET CURSOR ON
DO CASE
   CASE MODE<4           && No keys pressed, so return
	IF DELETED()     && Check to see if current file is marked for deletion
	   @ 0,70 SAY "*"
	ELSE
	   @ 0,70 SAY " "
	ENDIF
	RETURN(1)
   CASE LASTKEY()=21     && Press  Ctrl U  to delete a record
	DELETE
	RETURN(2)
   CASE LASTKEY()=14     && Press  Ctrl N  to add a record
	APPEND BLANK
	RETURN(2)
   CASE LASTKEY()=13 .AND. TYPE("&TEMPFIELD")="M"   && To edit a memofield
	SAVE SCREEN TO SCRN3
	@ 1,32 SAY "[ SIMPLE EDITOR ]"
	@ 24,0
	@ 24,0 SAY "Esc (ABORT)    Ctrl W (SAVE)   F4 (IMPORT TEXT)"
	**   The follow line of code utilizes the MEMOEDIT() function to create
	**   a simple editor. The user defined function is MEMO_UDF().
	REPLACE &TEMPFIELD WITH MEMOEDIT(&TEMPFIELD, 2, 1 , 22, 78,.T., "MEMO_UDF", 132, 3, 1, 0, 0, 0)
	RESTORE SCREEN FROM SCRN3
	RETURN(1)
	**    When you wish to edit any field, just press the enter key,
	**    make your change, then press enter again...
   CASE LASTKEY()=13     && Edit this field (not a memofield)
	@ ROW(), COL() GET &TEMPFIELD
	READ
	RETURN(1)
   CASE LASTKEY()=27     && Exit DBEDIT() and DBFUNCT()
	RETURN(0)
   OTHERWISE
	RETURN(2)
ENDCASE

FUNCTION MEMO_UDF        && UDF - Used with MEMOEDIT()
PARAMETERS MD,LN,CL      && Parameters are: Mode, Line Number, and Column
DO CASE
   CASE MD = 0           && A key was pressed, so print the current cursor row and column
	@ 24,65 SAY SUBSTR(LTRIM(STR(LN))+"/"+LTRIM(STR(CL))+SPACE(14),1,11)
   OTHERWISE
	X = LASTKEY()
	DO CASE                          &&Ŀ
	   CASE X = -3                   && Press  F4 to import a text file 
		SAVE SCREEN TO SCRN5     &&
		@ 13,5 CLEAR TO 15,70
		@ 13,5 TO 15,70
		NMIMPORT=SPACE(50)       && Name of the Text File
		@ 14,8 SAY "ENTER IMPORT TEXT FILE: " GET NMIMPORT PICTURE "@S20"
		READ
		IF LASTKEY()<>27
		   DO CASE
		      CASE FILE("&NMIMPORT")   && Check to see if the text file exists
			   IF SIZE_OK(NMIMPORT,LEN(&TEMPFIELD)) && Check its size
			      NTS=MEMOREAD("&NMIMPORT")         && Move text file into a memory variable
			      IF IS_TEXT(NTS)                   && Simple test to insure it is a text file
				 KEYBOARD NTS                   && Now KEYBOARD the string containing the text
			      ENDIF
			   ENDIF
		      CASE EMPTY(NMIMPORT)       && Give the User the option of selecting from
			   RELEASE ARRTEM        && the current directory....
			   DECLARE ARRTEM[ADIR("*.*")]
			   ADIR("*.*",ARRTEM)
			   @ 3,20 CLEAR TO 22,34
			   @ 3,20 TO 22,34
			   X=ACHOICE(4,21,21,33,ARRTEM)
			   IF X<>0 .AND. LASTKEY()<>27
			      NMIMPORT=ARRTEM[X]
			      IF SIZE_OK(NMIMPORT,LEN(&TEMPFIELD))
				 NTS=MEMOREAD("&NMIMPORT")
				 IF IS_TEXT(NTS)
				    KEYBOARD NTS
				 ENDIF
			      ENDIF
			   ENDIF
		      OTHERWISE
			   @ 10,5 CLEAR TO 12,70
			   @ 10,5 TO 12,70
			   @ 11,8 SAY "SORRY, BUT COULD NOT FIND FILE "+SUBSTR(NMIMPORT,1,30)
			   TONE(3434,1)
			   INKEY(2)
		   ENDCASE
		ENDIF
		RESTORE SCREEN FROM SCRN5
	ENDCASE
ENDCASE
@ 24,65 SAY SUBSTR(LTRIM(STR(LN))+"/"+LTRIM(STR(CL))+SPACE(14),1,11)
RETURN ""

FUNCTION SIZE_OK     && UDF - Is Len(memofield)+Size of Text File > 65535 ?
PARAMETERS FILENAME, SIZE
RELEASE ARRSIZE
DECLARE ARRSIZE[1]            && Use ADIR() to load the file size into an array
ADIR(FILENAME,"",ARRSIZE)     && with only one element
IF ARRSIZE[1] + SIZE > 65535  && Maximun Size Clipper can access
   @ 3,5 CLEAR TO 5,75
   @ 3,5 TO 5,60
   @ 4,8 SAY "Sorry, but file "+FILENAME+" is too large..."
   TONE(4343,2)
   INKEY(2)
   RETURN .F.
ELSE
   RETURN .T.   && New size will be less than 65535
ENDIF

FUNCTION IS_TEXT  && Simple test to insure you don't try to import a binary file
PARAMETER NTS
IF AT(CHR(27),NTS)>0 .OR. AT(CHR(152),NTS)>0 .OR. AT(CHR(1),NTS)>0
   @ 14,29 to 16,52
   @ 15,30 SAY " Opps, a BINARY file! "
   TONE(4343,3)
   INKEY(2)
   RETURN .F.
ELSE
   RETURN .T.
ENDIF

*** eof:  IMPORTER.PRG

