// ImpDBF
//
// Date   : 08/06/1993
// Author : ShaunB..
//
// Purpose: Import text files into databases
//
// Compile: CLIPPER impdbf /N/M/W/L
//
// Link   : YourFavoriteLinker FI impdbf LIB nanfor
//
// Note   : Requires NANFOR.LIB from CompuServe Clipper forum
//
// You may copy and modify this program freely - all I ask is that you
// distribute the program with my name as the original author (me!!).

#include "fileio.ch"

#define MAXOUTFILES 9

#define FDEFSIZE    6
#define INNAME      1
#define INTYPE      2
#define INSTART     3
#define INLEN       4
#define OUTDEF      5
#define DOINSERT    6

#define OUTDSIZE    3
#define OUTDTABLE   1
#define OUTDFIELD   2
#define OUTDSKIPB   3

static cInFile
static aOutFile
static aFlds
static lZapFile
static aSkips
static aRec
static cSkipFile

procedure main(cDefFile)
    local cLine, nProc, nSkip, nIns, nHndSkip, x

    clear screen

    ? "ImpDBF v1.0 (c) 1993 ShaunB.."
    ?

    if( empty(cDefFile) )
        ? "usage: IMPDBF definition_file_name"
        quit
    endif

    // Load the definitions
    loadDef(cDefFile)

    // Check our settings
    if( empty(cInFile) )
        tone(300,2)
        ? "No input file specified"
        return
    endif

    if( empty(aOutFile[1]) )
        tone(300,2)
        ? "No output file specified"
        return
    endif

    if( empty(aFlds) )
        tone(300,2)
        ? "No fields specified"
        return
    endif

    // Open all output files, zapping them if need be
    for x := 1 to len(aOutFile)
        if( !empty(aOutFile[x]) )
            dbUseArea(.t., "DBFNTX", aOutFile[x], "outf" + ltrim(str(x)), .f.)
            if( lZapFile )
                zap
            endif
        endif
    next x

    // Create a 'skipped records' file
    nHndSkip := fcreate(cSkipFile)
    fclose(nHndSkip)
    nHndSkip := fopen(cSkipFile, FO_WRITE)

    // Might have to die here
    if( nHndSkip == -1 )
        ? "Cannot open skip file"
        quit
    endif

    ? "Skipped records will be placed in", cSkipFile

    // Init counters
    nProc := 0
    nSkip := 0
    nIns  := 0

    // Open the input file
    ft_fuse(cInFile)

    do while( !ft_feof() )
        // Allow for aborting (pro-choice!)
        if( nextKey() != 0 .and. inkey(0) == 27 )
            tone(400,2)
            ? "User abort"
            ?
            exit
        endif

        // Grab line from the file
        cLine := ft_freadln()

        nProc++
        nIns := nProc - nSkip

        // Show status on the screen
        @ 5, 0 say "Lines  : " + ltrim(str(nProc))
        @ 6, 0 say "Skipped: " + ltrim(str(nSkip))
        @ 7, 0 say "Skipped: " + ltrim(str(nIns))

        // Split the text line into fields
        splitTextRec(cLine)

        // Should we skip this line
        if( !skipLine(cLine) )
            insertToDbf()                           // Plug the fields
        else
            fwrite(nHndSkip, cLine+chr(13)+chr(10)) // Log skipped record
            nSkip++                                 // Bump counter
        endif

        // Next line in input file
        ft_fskip()
    enddo
    ?

    // Close files
    ft_fuse()
    fclose(nHndSkip)
    close databases
return


// Load definition file
procedure loadDef(cDefName)
    local cLine, aFDef, bSkip, x, aTmp

    // Clear global vars
    cInFile  := ""
    aOutFile := array(MAXOUTFILES)
    lZapFile := .f.
    aFlds    := {}
    aSkips   := {}
    cSkipFile:= "SKIP.$$$"

    // Open definition file
    ft_fuse(cDefName)

    do while( !ft_feof() )
        // Grab a line
        cLine := alltrim(ft_freadln())

        // Ignore blank lines and those that start with a comment char '#'
        if( !empty(cLine) .and. left(cLine, 1) != "#" )

            // Get settings
            if( lower(left(cLine, 6)) == "input=" )
                cInFile := substr(cLine, 7)
            elseif( lower(left(cLine, 8)) == "output1=" )
                aOutFile[1] := substr(cLine, 9)
            elseif( lower(left(cLine, 8)) == "output2=" )
                aOutFile[2] := substr(cLine, 9)
            elseif( lower(left(cLine, 8)) == "output3=" )
                aOutFile[3] := substr(cLine, 9)
            elseif( lower(left(cLine, 8)) == "output4=" )
                aOutFile[4] := substr(cLine, 9)
            elseif( lower(left(cLine, 8)) == "output5=" )
                aOutFile[5] := substr(cLine, 9)
            elseif( lower(left(cLine, 8)) == "output6=" )
                aOutFile[6] := substr(cLine, 9)
            elseif( lower(left(cLine, 8)) == "output7=" )
                aOutFile[7] := substr(cLine, 9)
            elseif( lower(left(cLine, 8)) == "output8=" )
                aOutFile[8] := substr(cLine, 9)
            elseif( lower(left(cLine, 8)) == "output9=" )
                aOutFile[9] := substr(cLine, 9)
            elseif( lower(left(cLine, 5)) == "skip=" )
                bSkip := substr(cLine,6)
                bSkip := &bSkip
                aadd(aSkips, bSkip)
            elseif( lower(left(cLine, 10)) == "zapoutput=" )
                lZapFile := (left(alltrim(lower(substr(cLine, 11))),1) == "y")
            elseif( lower(left(cLine, 6)) == "field=" )
                // Meat of this thing - the field definition

                // Turn field def into an array
                aFDef := "{" + substr(cLine, 7) + "}"
                aFDef := &aFDef

                // Adjust size
                asize(aFDef, FDEFSIZE)

                // Assume that field is to be inserted if not otherwise
                // specified
                if( aFDef[DOINSERT] == nil )
                    aFDef[DOINSERT] := .T.
                endif

                // If a specific table and field has not been specified then
                // assume that output table is first table, output field
                // is the same name as input field and that field is to
                // be inserted
                if( aFDef[OUTDEF] == nil )
                    aFDef[OUTDEF] := { {1, aFDef[1], {|| .t.}} }
                endif

                // Fix output definitions - ie. put in missing eval blocks
                for x := 1 to len(aFDef[OUTDEF])
                    aTmp := aFDef[OUTDEF, x]

                    if( len(aTmp) < OUTDSIZE )
                        ASize(aTmp, OUTDSIZE)
                    endif

                    if( aTmp[OUTDSKIPB] == nil )
                        aTmp[OUTDSKIPB] := {|| .t.}
                    endif

                    aFDef[OUTDEF, x] := aTmp
                next x

                // Add the field definition to the array of fields
                aadd( aFlds, aFDef )
            endif
        endif
        ft_fskip()
    enddo

    // Close definition file
    ft_fuse()
return


// Split text line into component parts
procedure splitTextRec(cLine)
    local x, nPos

    aRec := {}
    for x := 1 to len(aFlds)
        aadd(aRec, substr(cLine, aFlds[x, INSTART], aFlds[x, INLEN]))
    next x
return


// Insert record into different tables
procedure insertToDbf()
    local nSel, nTbl, nFld, nPos, nIdx, cFld, aOutDef, cAls
    local aAppend, x

    // Remember where we are
    nSel := select()

    // Initialize array of 'appended' flags
    aAppend := array(MAXOUTFILES)
    for x := 1 to len(aAppend)
        aAppend[x] := .f.
    next x

    // Process each field
    for nFld := 1 to len(aFlds)
        // If we skip this field then loop around
        if( !aFlds[nFld, DOINSERT] )
            loop
        endif

        // Grab output definition
        aOutDef := aFlds[nFld, OUTDEF]

        // For all tables in output definition
        for nTbl := 1 to len(aOutDef)
            // Ask block for the field whether it should be inserted
            if( eval(aOutDef[nTbl, OUTDSKIPB], aRec[nFld]) )
                nIdx := aOutDef[nTbl, 1]           // Index of output table
                cFld := aOutDef[nTbl, 2]           // Target field in table
                cAls := "outf" + ltrim(str(nIdx))  // Alias name of table

                select(cAls)                     // Go to the table
                nPos := fieldPos(cFld)           // Grab field position in record

                if( nPos != 0 )                  // Valid field name ??
                    if( !aAppend[nIdx] )         // Have we appended a record yet
                        dbAppend()
                        aAppend[nIdx] := .t.
                    endif
                    fieldPut(nPos, aRec[nFld])   // Plonk in the field
                endif
            endif
        next nTbl
    next nFld
    select(nSel)
return


// Check whether we must skip this line
function skipLine(cLine)
    local x

    // Ask each block whether to skip the line
    for x := 1 to len(aSkips)
        if( eval(aSkips[x], cLine) )
            return .t.
        endif
    next x
return .f.


// Return position of a field name in 'aRec'
function fldPos(cName)
    local x

    for x := 1 to len(aFlds)
        if( upper(alltrim(aFlds[x, INNAME])) == upper(alltrim(cName)) )
            return x
        endif
    next x
return 0


// Return value of a field name in 'aRec'
function fldValue(cName)
    local nPos, xVal

    nPos := fldPos(cName)
    if( empty(nPos) )
        abortIt("Invalid field name specified")
    else
        xVal := aRec[nPos]
    endif
return xVal


// Abort here
procedure abortIt(cMsg)
    tone(500,2)
    ? "ABORTED:"
    ? cMsg
    ft_fuse()
    close databases
    QUIT
return
