// MODULE: IGRAPH.CH
// Intelligraph Clipper level constants
// (c) 1993 CyberSoft

/* Video mode constants */

#define M640x200x2        6
#define M720x348x2        7
#define M640x350x16      	16
#define M640x480x2       	17
#define M640x480x16      	18
#define M320x200x256     	19
#define M640x480x256    	257
#define M800x600x16     	258
#define M800x600x256    	259
#define M1024x768x16    	260
#define M1024x768x256   	261

/* common parameter constants */

/* Standard 16 colors */

#define BLACK             0
#define BLUE              1
#define GREEN             2
#define CYAN              3
#define RED               4
#define MAGENTA           5
#define BROWN             6
#define WHITE             7
#define GREY              8
#define GRAY              8
#define HIBLUE            9
#define HIGREEN          	10
#define HICYAN           	11
#define HIRED            	12
#define HIMAGENTA        	13
#define YELLOW           	14
#define HIWHITE          	15

/* common parameter constants */

// IGShow: nGType
#define IGBAR2D         	1
#define IGHBAR2D         	2
#define IGGANTT         	3
#define IGLINE          	4
#define IGAREA          	5
#define IGHLC           	6


/* Axis style defines */
#define AUTO					 		NIL
#define AS_GRID						1
#define AS_NOLABELS				2
#define AS_NOTICKS				4
#define AS_NORMAL					8
#define AS_REVERSE			 	16
#define AS_ORIGIN					0
#define AS_TOP						256
#define AS_LEFT						256
#define AS_RIGHT					512
#define AS_BOTTOM					512

/* Legend style defines */
#define LS_COLORTEXT			1

/* Line style defines */
#define LS_SOLID					0
#define LS_DASH						1
#define LS_DOT						2
#define LS_DASHDOT				3
#define LS_DASHDOTDOT			4

/* IGInfo defines */
#define INFO_XMIN					1
#define INFO_XMAX					2
#define INFO_YMIN        	3
#define INFO_YMAX       	4
#define INFO_XORG        	5
#define INFO_YORG        	6
#define INFO_XLEN        	7
#define INFO_YLEN        	8


/* graph specific styles */

// IGShow: nStyle: bar graph
#define IGBAR_STACK     	1
#define IGBAR_STACKPERCENT 2
#define IGBAR_NOSPACE		 	16
#define IGBAR_MONO    		32768

// IGShow: nStyle: line graph
#define IGLINE_SOLID     	16
#define IGLINE_SYMBOLS   	32
#define IGLINE_STICK     	64
#define IGLINE_PATTERN  	128
#define IGLINE_THICK    	256
#define IGLINE_MONO   		32768

// IGShow: nStyle: HLC graph
#define IGHLC_THICK     	16
#define IGHLC_NOBARS    	32
#define IGHLC_NOCLOSE   	64
#define IGHLC_NOOPEN			128
#define IGHLC_MONO      	32768

// IGShow: nStyle: gantt chart
#define IGGANTT_NOSPACE   16
#define IGGANTT_MONO    	32768

// IGShow: nStyle: area graph
#define IGAREA_PERCENT		1
#define IGAREA_ABSOLUTE		2
#define IGAREA_MONO      	32768

/* IGFontStyle: nUse */
#define FS_TITLE      		0
#define FS_XYTITLE     		1
#define FS_LABELS      		2
#define FS_LEGEND       	3
#define FS_SYMBOL       	4


