#include "igraph.ch"
#define NSTR(x) LTRIM(STR(x))

LOCAL aData, aPatterns, aColors, aSymbols
LOCAL aTests := { ;
  { "2D Bar Graph", IGBAR2D, { || BarData() }, ;
    { { "Mono",         IGBAR_MONO }, ;
			{ "No-space", 		IGBAR_NOSPACE }, ;
      { "Stacked",      IGBAR_STACK }, ;
      { "Stacked-%", 		IGBAR_STACKPERCENT } ;
    } ;
  }, ;
  { "Gantt Chart", IGGANTT, { || GanttData() }, ;
    { { "Mono",         IGGANTT_MONO }, ;
      { "No-space", 		IGGANTT_NOSPACE } ;
    } ;
  }, ;
  { "High-Low-Close Chart", IGHLC, { || HLCData() }, ;
    { { "Mono",         IGHLC_MONO }, ;
      { "No-close",     IGHLC_NOCLOSE }, ;
      { "No-bars",      IGHLC_NOBARS }, ;
      { "Thick",        IGHLC_THICK } ;
    } ;
  }, ;
  { "Line Graph", IGLINE, { || LineData() }, ;
    { { "Symbols",      IGLINE_SYMBOLS }, ;
      { "Mono",         IGLINE_MONO }, ;
      { "Solid",        IGLINE_SOLID }, ;
      { "Thick",        IGLINE_THICK }, ;
      { "Pattern",      IGLINE_PATTERN }, ;
      { "Stick",        IGLINE_STICK } ;
    } ;
  }, ;
  { "Area Graph", IGAREA, { || AreaData() }, ;
    { { "Mono",         IGAREA_MONO }, ;
      { "Absolute",     IGAREA_ABSOLUTE }, ;
      { "%",      			IGAREA_PERCENT } ;
    } ;
  } }
LOCAL i,j
LOCAL nGroups, nPoints
LOCAL nRange, nCenter
LOCAL nKey, nKeyMode
LOCAL nGMode
LOCAL nHandle
LOCAL cOptions, nType := 0, nOptions
LOCAL aGraphs := {}

AEVAL(aTests, { |a| AADD(aGraphs, a[1]) })

WHILE .T.

  nGMode := FindMode()

  IF nGMode == 0
    CLS
    QUIT
  END

  WHILE .T.

    nType := PopMenu(aGraphs,, nType)
    IF nType == 0
      EXIT
    END

    SetGMode(nGMode)
    SetHires(0)

    nKeyMode := 1

    WHILE nKeyMode != 0

      nHandle := IGNew()

			aData = EVAL(aTests[nType, 3])
			nGroups = LEN(aData)
			nPoints = LEN(aData[1])

      aPatterns := ARRAY(nGroups)
      aColors := ARRAY(nGroups)

      FOR i := 1 to nGroups
        aPatterns[i] := INT(RND(20))
        aColors[i] := INT(RND(256))
      NEXT i

      IGAmp(aData)
      IGColors(AColors)

      IGTitleG(aTests[nType, 1])

      cOptions := ""
      nOptions := 0
      FOR i := 1 to LEN(aTests[nType, 4])
        IF RND(5) > 4
          cOptions += " " + aTests[nType, 4, i, 1]
          nOptions += aTests[nType, 4, i, 2]
        END
      NEXT
      IGTitleX(cOptions)

      IGTitleY("IntelliGraph can wrap long axis labels automatically.")

      IF RND(2) > 1
        IGLegends({ "Frozen Fomeys", "Dobbin Dogs", "Bunny Burgers", ;
          "Feline Fritters", "Porcuswine Trotters", ;
          "Even legend labels can be almost any length" })
      ELSE
        IGLegends({})
      END
      IGLabels({ "January", "February", "March", "April", "May", "June" })

      clrscreen()
      IGShow(aTests[nType, 2], nOptions)

      // Handle keystrokes
      DO CASE
      CASE nKeyMode == 1
        nKey := INKEY(0)
        DO CASE
        CASE nKey == 13
          nKeyMode := 2
        CASE nKey == 27
          nKeyMode := 0
        END
      CASE nKeyMode == 2
        nKey := INKEY()
        DO CASE
        CASE nKey == 32
          nKeyMode := 1
        CASE nKey == 27
          nKeyMode := 0
        END
      END
      IGDelete(nHandle)
    END
    SetText()
  END
END


/***********************************************************************
 * Routines to store data appropriate to a graph type
 *
 */

FUNCTION BarData()
LOCAL nGroups := RND(6) + 1
LOCAL nPoints := RND(10) + 1
LOCAL aData[nGroups, nPoints]
LOCAL i, j

  FOR i := 1 TO nGroups
  	FOR j := 1 to nPoints
    	aData[i,j] := RND(100)
    NEXT
  NEXT

	RETURN aData


FUNCTION GanttData()
LOCAL nGroups := RND(6) + 2
LOCAL nPoints := RND(10) + 2
LOCAL aData[nGroups, nPoints]
LOCAL i, j

  FOR i := 1 TO nGroups
  	FOR j := 1 to nPoints
    	aData[i,j] := RND(100)
    NEXT
  NEXT

	RETURN aData


FUNCTION HLCData()
LOCAL nGroups := 4
LOCAL nPoints := RND(30) + 5
LOCAL aData[nGroups, nPoints]
LOCAL i
LOCAL nCurrent := RND(100) + 50

  FOR i := 1 to nPoints
		aData[4,i] := nCurrent
    aData[1,i] := nCurrent + RND(10)
    aData[2,i] := nCurrent - RND(10)
		nCurrent := RND(aData[1,i] - aData[2,i]) + aData[2,i]
		aData[3,i] := nCurrent
  NEXT

	RETURN aData


FUNCTION LineData()
LOCAL nGroups := RND(6) + 1
LOCAL nPoints := RND(30) + 5
LOCAL aData[nGroups, nPoints]
LOCAL i, j
LOCAL nRange := EXP(RND(40) - 20)
LOCAL nStart := RND(4 * nRange) - 2 * nRange

  FOR i := 1 TO nGroups
		aData[i,1] := nStart + RND(2 * nRange) - nRange
	NEXT

	FOR i := 1 to nGroups
  	FOR j := 2 to nPoints
    	aData[i,j] := aData[i,j-1] + RND(nRange) - nRange / 2
    NEXT
  NEXT

	RETURN aData


FUNCTION AreaData()
LOCAL nGroups := RND(6) + 1
LOCAL nPoints := RND(10) + 5
LOCAL aData[nGroups, nPoints]
LOCAL i, j

  FOR i := 1 TO nGroups
  	FOR j := 1 to nPoints
    	aData[i,j] := RND(100)
    NEXT
  NEXT

	RETURN aData


FUNCTION RND( nMax )
STATIC nSeed, m:=2147483647, a:=397204094
  IF(nSeed==nil, nSeed:=SECONDS(), )
RETURN (nMax*((nSeed:=MOD(nSeed*a, m))/m))
