#include "igraph.ch"

ANNOUNCE CheckModes

STATIC nMode := 0
STATIC aModes := ;
  { { M640x200x2,     "CGA      640x200x2"    }, ;
    { M720x348x2,     "Hercules 720x348x2"    }, ;
    { M640x350x16,    "EGA      640x350x16"   }, ;
    { M320x200x256,   "MCGA     320x200x256"  }, ;
    { M640x480x2,     "VGA      640x480x2"    }, ;
    { M640x480x16,    "VGA      640x480x16"   }, ;
    { M640x480x256,   "SVGA     640x480x256"  }, ;
    { M800x600x16,    "SVGA     800x600x16"   }, ;
    { M800x600x256,   "SVGA     800x600x256"  }, ;
    { M1024x768x16,   "SVGA     1024x768x16"  }, ;
    { M1024x768x256,  "SVGA     1024x768x256" } }

INIT PROCEDURE CheckModes()
LOCAL i
  FOR i := 1 to LEN(aModes)
    IF GetGMode(aModes[i, 1]) != 0
      AADD(aModes[i], .T.)
      nMode := i
    ELSE
      AADD(aModes[i], .F.)
    END
  END

FUNCTION FindMode()
LOCAL aModeName := {}, aModeValid := {}

  AEVAL(aModes, { |a| AADD(aModeName, a[2]), AADD(aModeValid, a[3]) })

  nMode := PopMenu(aModeName, aModeValid, nMode)

  IF nMode != 0
    RETURN (aModes[nMode, 1])
  END

  RETURN (0)

FUNCTION PopMenu(aChoices, aSelectable, nSelect)
LOCAL nHeight := LEN(aChoices), nWidth := 0, nTop, nLeft, nBottom, nRight
LOCAL cWindow, cOldColor

  IF nSelect == NIL
    nSelect := 0
  END

  cOldColor := SETCOLOR("W+/B, K/W, , , K+/B")

  AEVAL(aChoices, { |c| nWidth := MAX(nWidth, LEN(c)) })

  nHeight += 1
  nWidth += 1
  nTop := INT((MAXROW() - nHeight) / 2)
  nLeft := INT((MAXCOL() - nWidth) / 2)
  nBottom := nTop + nHeight
  nRight := nLeft + nWidth

  cWindow := SAVESCREEN(nTop, nLeft, nBottom, nRight)
  DISPBOX(nTop, nLeft, nBottom, nRight, 2, "W+/B")

  nSelect := ACHOICE(nTop+1, nLeft+1, nBottom-1, nRight-1, ;
    aChoices, aSelectable, , nSelect)
  SETCOLOR(cOldColor)

  RESTSCREEN(nTop, nLeft, nBottom, nRight, cWindow)

  RETURN (nSelect)





