#include "igraph.ch"
#define GROUPS 3
#define POINTS 5
LOCAL aData, aPatterns, aColors, aSymbols
LOCAL aExamples := { ;
  { "Example 1  Your first IntelliGraph", { || Example1() } }, ;
  { "Example 2  Multi-graph example",			{ || Example2() } }, ;
  { "Example 3  Graph components",        { || Example3() } }, ;
  { "Example 4  Graph variations",        { || Example4() } }, ;
  { "Example 5  Axis control",         		{ || Example5() } }, ;
  { "Catalog of graph styles",         		{ || Catalog() } }, ;
  { "Clipping example",         					{ || ClipExample() } } ;
}

LOCAL nGMode
LOCAL nType := 0
LOCAL aMenu := {}

AEVAL(aExamples, { |a| AADD(aMenu, a[1]) })

WHILE .T.

  nGMode := FindMode()

  IF nGMode == 0
    CLS
    QUIT
  END

  WHILE .T.

    nType := PopMenu(aMenu,, nType)
    IF nType == 0
      EXIT
    END

    SetGMode(nGMode)
    SetHires(0)
    SetRGBDAC(0, 255, 255, 255)
    SetRGBDAC(15, 0, 0, 0)

    EVAL( aExamples[nType, 2] )

    SetText()

  END
END

FUNCTION RND( nMax )
STATIC nSeed, m:=2147483647, a:=397204094
  IF(nSeed==nil, nSeed:=SECONDS(), )
RETURN (nMax*((nSeed:=MOD(nSeed*a, m))/m))


PROCEDURE Example1()
LOCAL nHandle
LOCAL aData := { { 27, 53, 37 }, { 44, 12, 69 } }

  nHandle := IGNew()
  IGAmp(aData)
  IGShow(IGBAR2D)

  INKEY(0)
  IGDelete(nHandle)

  RETURN

PROCEDURE Example2()
LOCAL nHandle1, nHandle2
LOCAL aData := { { 27, 53, 37 }, { 44, 12, 69 } }

  nHandle1 := IGNew()
  IGWindow(50, 50, 600, 950)
  IGAmp(aData)

  nHandle2 := IGNew()
  IGWindow(700, 50, 1300, 950)
  IGAmp(aData)

	IGSelect(nHandle1)
  IGShow(IGBAR2D)

  IGSelect(nHandle2)
  IGShow(IGHBAR2D)

  INKEY(0)
  IGDelete(nHandle1)
  IGDelete(nHandle2)

  RETURN

PROCEDURE Example3()
LOCAL nHandle
LOCAL aData := { { 27, 53, 37 }, { 44, 12, 69 } }
LOCAL aLabels := { "April", "May", "June" }
LOCAL aLegends := { "Red Widgets", "Blue Widgets" }

  nHandle := IGNew()

  IGAmp(aData)

  IGLabels(aLabels)
  IGLegends(aLegends)

  IGTitleG("Quarterly Report")
  IGTitleX("Month")
  IGTitleY("Units sold")

  IGShow(IGBAR2D)

  INKEY(0)
  IGDelete(nHandle)

  RETURN

PROCEDURE Example4()
LOCAL nHandle
LOCAL aData := { { 27, 53, 37 }, { 44, 12, 69 } }
LOCAL aLabels := { "April", "May", "June" }
LOCAL aLegends := { "Red Widgets", "Blue Widgets" }

  nHandle := IGNew()

  IGAmp(aData)

  IGLabels(aLabels)
  IGLegends(aLegends)

  IGTitleG("Quarterly Report")
  IGTitleX("Month")
  IGTitleY("Units sold")

  IGColors({RED, BLUE})
  IGPatterns({13, 14})

  IGShow(IGBAR2D)
  INKEY(0)
  IGDelete(nHandle)

  RETURN

PROCEDURE Example5()
LOCAL nHandle
LOCAL aData := { { 27, 53, 37 }, { 44, 12, 69 } }
LOCAL aLabels := { "April", "May", "June" }
LOCAL aLegends := { "Red Widgets", "Blue Widgets" }

  nHandle := IGNew()

  IGAmp(aData)

  IGLabels(aLabels)
  IGLegends(aLegends)

  IGTitleG("Quarterly Report")
  IGTitleX("Month")
  IGTitleY("Units sold")

  IGColors({RED, BLUE})
	IGPatterns({13, 14})

	IGXAxisStyle(AS_NOTICKS)
	IGYAxisStyle(AS_GRID)
	IGYAxisScale(0, 0, 100, AUTO)

  IGShow(IGBAR2D)

  INKEY(0)
  IGDelete(nHandle)

  RETURN

PROCEDURE Catalog()
LOCAL nHandle
LOCAL aData := { { 27, 53, 37 }, { 44, 12, 69 } }

  nHandle := IGNew()
  IGAmp(aData)
	IGWindow(100, 100, 1250, 900)

	ClrScreen()
  IGShow(IGBAR2D)
	INKEY(0)

	ClrScreen()
  IGShow(IGBAR2D, IGBAR_NOSPACE)
	INKEY(0)

	ClrScreen()
  IGShow(IGBAR2D, IGBAR_STACK)
	INKEY(0)

	ClrScreen()
  IGShow(IGBAR2D, IGBAR_STACKPERCENT)
	INKEY(0)

	ClrScreen()
  IGShow(IGHBAR2D)
	INKEY(0)

	ClrScreen()
  IGShow(IGHBAR2D, IGBAR_NOSPACE)
	INKEY(0)

	ClrScreen()
  IGShow(IGHBAR2D, IGBAR_STACK)
	INKEY(0)

	ClrScreen()
  IGShow(IGHBAR2D, IGBAR_STACKPERCENT)
	INKEY(0)

	ClrScreen()
  IGShow(IGLINE)
	INKEY(0)

	ClrScreen()
  IGShow(IGLINE, IGLINE_SYMBOLS)
	INKEY(0)

	ClrScreen()
  IGShow(IGLINE, IGLINE_SOLID)
	INKEY(0)

	ClrScreen()
  IGShow(IGLINE, IGLINE_THICK)
	INKEY(0)

	ClrScreen()
  IGShow(IGLINE, IGLINE_PATTERN)
	INKEY(0)

	ClrScreen()
  IGShow(IGLINE, IGLINE_STICK)
	INKEY(0)

	ClrScreen()
  IGShow(IGHLC)
	INKEY(0)

	ClrScreen()
  IGShow(IGHLC, IGHLC_NOCLOSE)
	INKEY(0)

	ClrScreen()
  IGShow(IGHLC, IGHLC_NOBARS)
	INKEY(0)

	ClrScreen()
  IGShow(IGHLC, IGHLC_THICK)
	INKEY(0)

	ClrScreen()
  IGShow(IGGANTT)
	INKEY(0)

	ClrScreen()
  IGShow(IGGANTT, IGGANTT_NOSPACE)
	INKEY(0)

	ClrScreen()
  IGShow(IGAREA)
	INKEY(0)

	ClrScreen()
  IGShow(IGAREA, IGAREA_ABSOLUTE)
	INKEY(0)

	ClrScreen()
  IGShow(IGAREA, IGAREA_PERCENT)
	INKEY(0)

  IGDelete(nHandle)

  RETURN


PROCEDURE ClipExample()
LOCAL nHandle
LOCAL aData := { { 27, 33, 44, 47, 42, 36, 47, 58, 64, 65 } }

  nHandle := IGNew()

  IGAmp(aData)

	IGXAxisStyle(AS_GRID)
	IGYAxisStyle(AS_GRID)
	IGYAxisScale(AUTO, 40, 60, AUTO)

  IGShow(IGLINE, IGLINE_THICK)

  INKEY(0)
  IGDelete(nHandle)

  RETURN



