* ..... Instant Error
* ..... Copyright (c) The Leylan Factor  1989
* .....
* ..... The Leylan Factor
* ..... 8033 Sunset Blvd., #737
* ..... Los Angeles, CA  90046
* ..... (213) 856-8743
* .....
* ..... distribute freely with this header intact
* .....
* ..... compile :  clipper ie -m
* .....
* .....    link :  plink86 fi ie, errorsys lib clipper extend
* ..... or
* .....    link :  link ie errorsys,,, clipper extend /NOE /SE:1024
* .....
* ..... NOTE : obtaining certain errors most notably the
* ..... "Miscellaneous Error", "RUN command" requires specific
* ..... environmental situations that can only be approximated
* ..... as they differ from machine to machine.  The "RUN command"
* ..... error should occur if you SET CLIPPER= R16 and probably will
* ..... not occur if you don't
* .....
* ..... error selections preceded with a "." (dot) indicate that there
* ..... is no method provided to produce the error, if you develop a
* ..... routine you should include the code and remove the dot.

* ..... set dos error code
Errorlevel(1)

* ..... declare constants
PUBLIC true, false, void, null
true  = .F.
false = !true
void  = ""
null  = 0

* .....  this "video" var is here so you can override the iscolor()
PUBLIC video
video = iscolor()

* ..... init environment
env_init()
* ..... init keys
key_init()
* ..... init define
def_init()
* ..... init menus
mnu_init()

* ..... clear screen
CLEAR

* ..... init stack
PUBLIC h_shue
h_shue = stak_init( 20, "C", LEN(Setcolor()))
* ..... set default color
stak_push(h_shue, Setcolor(box_hue(h_menu)))

* ..... say screen box
box_say(h_scrn)
* ..... say dialog box
box_say(h_bdia)
* ..... say menu box
box_say(h_menu)

* ..... say message
box_msg(h_bdia, "1Instant Error... the (error in an instant) development tool")

* ..... public shell
PUBLIC p_shell, p_shellx
p_shell  = 1
p_shellx = 1
* ..... do while this shell
DO WHILE (p_shell > 0)
   * ..... get menu
   l_key = menu_get(h_menu, "a_menu", h_menup)
   * ..... do case
   DO CASE
      * ..... case command = "Database Error"
   CASE l_key == 1
      pc1()
      * ..... case command = "Expression Error"
   CASE l_key == 2
      pc2()
      * ..... case command = "Miscellaneous Error"
   CASE l_key == 3
      pc3()
      * ..... case command = "Open Error"
   CASE l_key == 4
      pc4()
      * ..... case command = "Print Error"
   CASE l_key == 5
      pc5()
      * ..... case command = "Undefined Error"
   CASE l_key == 6
      pc6()
      * ..... case command = "Other Error"
   CASE l_key == 7
      pc7()
      * ..... case command = exit
   CASE l_key == k_exit
      exit_get()
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE (p_shell > 0)
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... exit screen
bye()
* ..... clear screen
CLEAR
* ..... reset environment
SET cursor ON
* ..... return
RETURN

* ..... "Database Error"
FUNCTION pc1
* ..... save screen
PRIVATE s_dat
s_dat = box_sav(h_subm)
* ..... say submenu box
box_say(h_subm)
* ..... set color
stak_push(h_shue, Setcolor(box_hue(h_subm)))
* ..... increment shell
p_shell = (p_shell + 1)
p_shellx = (p_shellx + 1)
* ..... do while this shell
DO WHILE (p_shell == p_shellx)
   * ..... get menu
   l_key = menu_get(h_subm, "a_sub1", h_sub1p)
   * ..... do case
   DO CASE
      * ..... case command = "Database required"
   CASE l_key == 1
      pc11()
      * ..... case command = "Lock required"
   CASE l_key == 2
      pc12()
      * ..... case command = "Exclusive required"
   CASE l_key == 3
      pc13()
      * ..... case command = "Field numeric overflow"
   CASE l_key == 4
      pc14()
      * ..... case command = "Index file corrupted"
   CASE l_key == 5
      pc15()
      * ..... case command = exit
   CASE l_key == k_exit
      * ..... decrement shell
      p_shell = (p_shell - 1)
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE (p_shell == p_shellx)
* ..... decrement shell
p_shellx = (p_shellx - 1)
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... restore screen
box_res(h_subm, s_dat)
* ..... return
RETURN void

* ..... "Database required"
FUNCTION pc11
* ..... beep
Tone(130.8, .5)
* ..... generate error
APPEND BLANK
* ..... return
RETURN void

* ..... "Lock required"
FUNCTION pc12
* ..... beep
Tone(130.8, .5)
* ..... init var
PRIVATE l_var1
l_var1 = "test"
* ..... open file
USE ie
* ..... generate error
REPLACE err1 WITH l_var1
* ..... close file
USE
* ..... return
RETURN void

* ..... "Exclusive required"
FUNCTION pc13
* ..... beep
Tone(130.8, .5)
* ..... open file
USE ie
* ..... generate error
PACK
* ..... close file
USE
* ..... return
RETURN void

* ..... "Field numeric overflow"
FUNCTION pc14
* ..... beep
Tone(130.8, .5)
* ..... init numeric var
PRIVATE l_var2
l_var2 = 999999999
* ..... open file
USE ie
* ..... lock record
RLOCK()
* ..... generate error
REPLACE err2 WITH l_var2
* ..... unlock record
UNLOCK
* ..... close file
USE
* ..... return
RETURN void

* ..... "Index file corrupted"
FUNCTION pc15
* ..... beep
Tone(130.8, .5)
* ..... return
RETURN void

* ..... "Expression Error"
FUNCTION pc2
* ..... save screen
PRIVATE s_dat
s_dat = box_sav(h_subm)
* ..... say submenu box
box_say(h_subm)
* ..... set color
stak_push(h_shue, Setcolor(box_hue(h_subm)))
* ..... increment shell
p_shell = (p_shell + 1)
p_shellx = (p_shellx + 1)
* ..... do while this shell
DO WHILE (p_shell == p_shellx)
   * ..... get menu
   l_key = menu_get(h_subm, "a_sub2", h_sub2p)
   * ..... do case
   DO CASE
      * ..... case command = "Type mismatch"
   CASE l_key == 1
      pc21()
      * ..... case command = "Subscript range"
   CASE l_key == 2
      pc22()
      * ..... case command = "Zero divide"
   CASE l_key == 3
      pc23()
      * ..... case command = "Expression error"
   CASE l_key == 4
      pc24()
      * ..... case command = exit
   CASE l_key == k_exit
      * ..... decrement shell
      p_shell = (p_shell - 1)
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE (p_shell == p_shellx)
* ..... decrement shell
p_shellx = (p_shellx - 1)
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... restore screen
box_res(h_subm, s_dat)
* ..... return
RETURN void

* ..... "Type mismatch"
FUNCTION pc21
* ..... beep
Tone(130.8, .5)
* ..... init var
PRIVATE l_var1
* ..... generate error
l_var1 = DTOC("01/01/89")
* ..... return
RETURN void

* ..... "Subscript range"
FUNCTION pc22
* ..... beep
Tone(130.8, .5)
* ..... init array
PRIVATE a_err[2]
* ..... generate error
? a_err[3]
* ..... return
RETURN void

* ..... "Zero divide"
FUNCTION pc23
* ..... beep
Tone(130.8, .5)
* ..... generate error
? (12 - (6 / 0))
* ..... return
RETURN void

* ..... "Expression error"
FUNCTION pc24
* ..... beep
Tone(130.8, .5)
* ..... init macro
PRIVATE l_mac
l_mac = 'a.1 = 1'
* ..... generate error
? &l_mac.
* ..... return
RETURN void

* ..... "Miscellaneous Error"
FUNCTION pc3
* ..... save screen
PRIVATE s_dat
s_dat = box_sav(h_subm)
* ..... say submenu box
box_say(h_subm)
* ..... set color
stak_push(h_shue, Setcolor(box_hue(h_subm)))
* ..... increment shell
p_shell = (p_shell + 1)
p_shellx = (p_shellx + 1)
* ..... do while this shell
DO WHILE (p_shell == p_shellx)
   * ..... get menu
   l_key = menu_get(h_subm, "a_sub3", h_sub3p)
   * ..... do case
   DO CASE
      * ..... case command = "Type mismatch"
   CASE l_key == 1
      pc31()
      * ..... case command = "RUN command"
   CASE l_key == 2
      pc32()
      * ..... case command = exit
   CASE l_key == k_exit
      * ..... decrement shell
      p_shell = (p_shell - 1)
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE (p_shell == p_shellx)
* ..... decrement shell
p_shellx = (p_shellx - 1)
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... restore screen
box_res(h_subm, s_dat)
* ..... return
RETURN void

* ..... "Type mismatch"
FUNCTION pc31
* ..... beep
Tone(130.8, .5)
* ..... open file
USE ie
* ..... lock record
RLOCK()
* ..... generate error
REPLACE err3 WITH "error"
* ..... unlock record
UNLOCK
* ..... close file
USE
* ..... return
RETURN void

* ..... "RUN command"
FUNCTION pc32
* ..... beep
Tone(130.8, .5)
* ..... init space
PRIVATE a_var[16], l_ele, l_mem
FOR l_ele = 1 TO 16
   l_mem = MEMORY(0)
   a_var[l_ele] = SPACE(IIF(l_mem > 32, 32000, l_mem * 1000))
NEXT l_ele = 1 to 16
* ..... generate error
RUN DIR
* ..... return
RETURN void

* ..... "Open Error"
FUNCTION pc4
* ..... save screen
PRIVATE s_dat
s_dat = box_sav(h_subm)
* ..... say submenu box
box_say(h_subm)
* ..... set color
stak_push(h_shue, Setcolor(box_hue(h_subm)))
* ..... increment shell
p_shell = (p_shell + 1)
p_shellx = (p_shellx + 1)
* ..... do while this shell
DO WHILE (p_shell == p_shellx)
   * ..... get menu
   l_key = menu_get(h_subm, "a_sub4", h_sub4p)
   * ..... do case
   DO CASE
      * ..... case command = "File not found"
   CASE l_key == 1
      pc41()
      * ..... case command = "Path not found"
   CASE l_key == 2
      pc42()
      * ..... case command = "Too many open files (no handles left)"
   CASE l_key == 3
      pc43()
      * ..... case command = "Invalid handle"
   CASE l_key == 4
      pc44()
      * ..... case command = "Insufficient memory"
   CASE l_key == 5
      pc45()
      * ..... case command = "Invalid drive was specified"
   CASE l_key == 6
      pc46()
      * ..... case command = "Attempt to remove the current directory"
   CASE l_key == 7
      pc47()
      * ..... case command = "Attempted write on write-protected disk"
   CASE l_key == 8
      pc48()
      * ..... case command = "Drive not ready"
   CASE l_key == 9
      pc49()
      * ..... case command = "File already exists"
   CASE l_key == 10
      pc4a()
      * ..... case command = exit
   CASE l_key == k_exit
      * ..... decrement shell
      p_shell = (p_shell - 1)
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE (p_shell == p_shellx)
* ..... decrement shell
p_shellx = (p_shellx - 1)
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... restore screen
box_res(h_subm, s_dat)
* ..... return
RETURN void

* ..... "File not found"
FUNCTION pc41
* ..... beep
Tone(130.8, .5)
* ..... generate error
CREATE test FROM ie0
* ..... return
RETURN void

* ..... "Path not found"
FUNCTION pc42
* ..... beep
Tone(130.8, .5)
* ..... generate error
USE \path\ie
* ..... return
RETURN void

* ..... "Too many open files (no handles left)"
FUNCTION pc43
* ..... beep
Tone(130.8, .5)
* ..... private
PRIVATE l_sel
* ..... generate error
FOR l_sel = 1 TO 20
   SELECT(0)
   USE ie
NEXT l_sel
* ..... return
RETURN void

* ..... "Invalid handle"
FUNCTION pc44
* ..... beep
Tone(130.8, .5)
* ..... generate error
* ..... return
RETURN void

* ..... "Insufficient memory"
FUNCTION pc45
* ..... beep
Tone(130.8, .5)
* ..... generate error
* ..... return
RETURN void

* ..... "Invalid drive was specified"
FUNCTION pc46
* ..... beep
Tone(130.8, .5)
* ..... generate error
curdir("K:")
* ..... return
RETURN void

* ..... "Attempt to remove the current directory"
FUNCTION pc47
* ..... beep
Tone(130.8, .5)
* ..... generate error
* ..... return
RETURN void

* ..... "Attempted write on write-protected disk"
FUNCTION pc48
* ..... beep
Tone(130.8, .5)
* ..... generate error
* ..... return
RETURN void

* ..... "Drive not ready"
FUNCTION pc49
* ..... beep
Tone(130.8, .5)
* ..... generate error
* ..... return
RETURN void

* ..... "File already exists"
FUNCTION pc4a
* ..... beep
Tone(130.8, .5)
* ..... generate error
* ..... return
RETURN void

* ..... "Print Error"
FUNCTION pc5
* ..... save screen
PRIVATE s_dat
s_dat = box_sav(h_subm)
* ..... say submenu box
box_say(h_subm)
* ..... set color
stak_push(h_shue, Setcolor(box_hue(h_subm)))
* ..... increment shell
p_shell = (p_shell + 1)
p_shellx = (p_shellx + 1)
* ..... do while this shell
DO WHILE (p_shell == p_shellx)
   * ..... get menu
   l_key = menu_get(h_subm, "a_sub5", h_sub5p)
   * ..... do case
   DO CASE
      * ..... case command = "Print error"
   CASE l_key == 1
      pc51()
      * ..... case command = exit
   CASE l_key == k_exit
      * ..... decrement shell
      p_shell = (p_shell - 1)
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE (p_shell == p_shellx)
* ..... decrement shell
p_shellx = (p_shellx - 1)
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... restore screen
box_res(h_subm, s_dat)
* ..... return
RETURN void

* ..... "Print error"
FUNCTION pc51
* ..... private
PRIVATE l_lerr, l_perr, l_nerr
l_lerr = .T.
l_perr = .F.
l_nerr = .T.
* ..... beep
Tone(130.8, .5)
* ..... set printer on
SET CONSOLE OFF
SET PRINTER ON
* ..... open file
USE ie
* ..... do while not eof and (no error)
DO WHILE !EOF() .AND. l_nerr
   * ..... begin error trap
   BEGIN SEQUENCE
      * ..... generate error
      ? err1, err2, err3, err4
      * ..... increment record
      SKIP +1
      * ..... end error trap
   END SEQUENCE
   * ..... if error
   IF l_perr
      * ..... error function
      l_nerr = pc51p("Test Report")
      * ..... endif error
   ENDIF l_perr
   * ..... enddo while not eof and (no error)
ENDDO while !eof() .and. l_nerr
* ..... close file
USE
* ..... set printer off
SET PRINTER OFF
SET CONSOLE ON
* ..... return
RETURN void

FUNCTION pc51p
* ..... parameters
PARAMETERS l_rept
* ..... set printer off
SET PRINTER OFF
* ..... reset printer error
l_perr = .F.
* ..... private
PRIVATE l_box, l_hue, l_proc
* ..... init box, color, message
l_box  = Savescreen(5, 15, 22, 65)

if video
  l_hue  = Setcolor("W+/RB,W+/W,,,W/RB")
else
  l_hue  = Setcolor("+W/N,W+/W,,,W/N")
endif video

l_proc = "printer"
* ..... draw box
@ 12, 15, 22, 65 BOX "Ŀ "
@ 12, 17 SAY " Warning "
@ 14, 18 SAY " Report :"
@ 16, 18 SAY "A printer error has occurred, please check  "
@ 17, 18 SAY "that the printer is online and select one of"
@ 18, 18 SAY "the following courses of action.            "
@ 12, 65 - (LEN(l_proc)+4) SAY " "+l_proc+" "
@ 14, 28 SAY l_rept
* ..... clear keyboard buffer
CLEAR TYPEAHEAD
* ..... private
PRIVATE l_return
l_return = 2
* ..... say prompts
@ 20, 27 PROMPT "Quit"
@ 20, 36 PROMPT "Retry"
@ 20, 46 PROMPT "Ignore"
* ..... get return
MENU TO l_return
l_return = IF(l_return == 0, 1, l_return)
* ..... reset color
Setcolor(l_hue)
* ..... reset screen
Restscreen(5, 15, 22, 65, l_box)
* ..... set printer on
SET PRINTER ON
* ..... return
RETURN (l_return = 2)

* ..... "Undefined Error"
FUNCTION pc6
* ..... save screen
PRIVATE s_dat
s_dat = box_sav(h_subm)
* ..... say submenu box
box_say(h_subm)
* ..... set color
stak_push(h_shue, Setcolor(box_hue(h_subm)))
* ..... increment shell
p_shell = (p_shell + 1)
p_shellx = (p_shellx + 1)
* ..... do while this shell
DO WHILE (p_shell == p_shellx)
   * ..... get menu
   l_key = menu_get(h_subm, "a_sub6", h_sub6p)
   * ..... do case
   DO CASE
      * ..... case command = "Undefined identifier"
   CASE l_key == 1
      pc61()
      * ..... case command = "Not an array"
   CASE l_key == 2
      pc62()
      * ..... case command = "Missing EXTERNAL"
   CASE l_key == 3
      pc63()
      * ..... case command = exit
   CASE l_key == k_exit
      * ..... decrement shell
      p_shell = (p_shell - 1)
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE (p_shell == p_shellx)
* ..... decrement shell
p_shellx = (p_shellx - 1)
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... restore screen
box_res(h_subm, s_dat)
* ..... return
RETURN void

* ..... "Undefined identifier"
FUNCTION pc61
* ..... beep
Tone(130.8, .5)
* ..... generate error
? l_errvar
* ..... return
RETURN void

* ..... "Not an array"
FUNCTION pc62
* ..... beep
Tone(130.8, .5)
* ..... init var
PRIVATE l_var
l_var = 1
* ..... generate error
? l_var[1]
* ..... return
RETURN void

* ..... "Missing EXTERNAL"
FUNCTION pc63
* ..... beep
Tone(130.8, .5)
* ..... init macro
PRIVATE l_mac
l_mac = 'err()'
* ..... generate error
? &l_mac.
* ..... return
RETURN void

* ..... "Other Error"
FUNCTION pc7
* ..... save screen
PRIVATE s_dat
s_dat = box_sav(h_subm)
* ..... say submenu box
box_say(h_subm)
* ..... set color
stak_push(h_shue, Setcolor(box_hue(h_subm)))
* ..... increment shell
p_shell = (p_shell + 1)
p_shellx = (p_shellx + 1)
* ..... do while this shell
DO WHILE (p_shell == p_shellx)
   * ..... get menu
   l_key = menu_get(h_subm, "a_sub7", h_sub7p)
   * ..... do case
   DO CASE
      * ..... case command = "Internal error"
   CASE l_key == 1
      pc71()
      * ..... case command = "Disk Full"
   CASE l_key == 2
      pc72()
      * ..... case command = "Multiple Error"
   CASE l_key == 3
      pc73()
      * ..... case command = "Out of Memory"
   CASE l_key == 4
      pc74()
      * ..... case command = "Not Enough Memory"
   CASE l_key == 5
      pc75()
      * ..... case command = exit
   CASE l_key == k_exit
      * ..... decrement shell
      p_shell = (p_shell - 1)
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE (p_shell == p_shellx)
* ..... decrement shell
p_shellx = (p_shellx - 1)
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... restore screen
box_res(h_subm, s_dat)
* ..... return
RETURN void

* ..... "Internal error"
FUNCTION pc71
* ..... beep
Tone(130.8, .5)
* ..... open file
USE ie EXCLUSIVE
* ..... create index
INDEX ON err1 TO ie1
* ..... close file
USE
* ..... corrupt index
PRIVATE l_fh
l_fh = Fopen("ie1.ntx", 2)
Fseek(l_fh, 1025, 0)
Fwrite(l_fh, "instant error")
Fclose(l_fh)
* ..... generate error
USE ie INDEX ie1
APPEND BLANK
APPEND BLANK
USE
* ..... return
RETURN void

* ..... "Disk Full"
FUNCTION pc72
* ..... beep
Tone(130.8, .5)
* ..... generate error
* ..... return
RETURN void

* ..... "Multiple Error"
FUNCTION pc73
* ..... beep
Tone(130.8, .5)
* ..... set up multiple error
PRIVATE multi_err
multi_err = .T.
* ..... generate error
? 1/0
* ..... return
RETURN void

* ..... "Out of Memory"
FUNCTION pc74
* ..... beep
Tone(130.8, .5)
* ..... init space
PRIVATE l_var1, l_var2, l_var3, l_var4
PRIVATE l_var5, l_var6, l_var7, l_var8
* ..... generate error
l_var1 = SPACE(64000)
l_var2 = SPACE(64000)
l_var3 = SPACE(64000)
l_var4 = SPACE(64000)
l_var5 = SPACE(64000)
l_var6 = SPACE(64000)
l_var7 = SPACE(64000)
l_var8 = SPACE(64000)
* ..... return
RETURN void

* ..... "Not Enough Memory"
FUNCTION pc75
* ..... beep
Tone(130.8, .5)
* ..... generate error
* ..... return
RETURN void


FUNCTION exit_get
* ..... private
PRIVATE s_dia
* ..... save dialog
s_dia = box_sav(h_bdia)
* ..... if 'EXIT THIS SYSTEM'
IF yn_get("1Exit The System ? ", "Yes", "Yes", "No")
   * ..... reset dos error code
   Errorlevel(0)
   * ..... reset shell
   p_shell = 0
   * ..... endif 'EXIT THIS SYSTEM'
ENDIF yn_get("1Exit The System ? ", "Y", "Yes", "No")
* ..... restore dialog
box_res(h_bdia, s_dia)
* ..... return
RETURN void


FUNCTION env_init
* ..... set environment
SET ALTERNATE  OFF
SET BELL       OFF
SET CARRY      OFF
SET CENTURY    OFF
SET COLOR      TO
SET CONFIRM    OFF
SET CONSOLE    ON
SET CURSOR     OFF
SET DATE       AMERICAN
SET DECIMALS   TO 2
SET DEFAULT    TO
SET DELETED    OFF
SET DELIMITERS OFF
SET DELIMITERS TO
SET DEVICE     TO SCREEN
SET ESCAPE     OFF
SET EXACT      ON
SET EXCLUSIVE  OFF
SET FILTER     TO
SET FIXED      OFF
SET FORMAT     TO
SET FUNC 1     TO
SET INTENSITY  ON
SET MARGIN     TO 0
SET MESSAGE    TO
SET PATH       TO
SET PRINT      OFF
SET PRINTER    TO
SET PROCEDURE  TO
SET SCOREBOARD OFF
SET SOFTSEEK   OFF
SET TYPEAHEAD  TO 64
SET UNIQUE     OFF
SET WRAP       ON
* ..... return
RETURN void


FUNCTION key_init
* ..... public
PUBLIC k_null, k_space, k_escape, k_bell
k_null    =   0
k_space   =  32
k_escape  =  27
k_bell    =   7
* ..... public
PUBLIC k_home, k_end, k_pgup, k_pgdn, k_up, k_down, k_left, k_right
k_home    =   1
k_end     =   6
k_pgup    =  18
k_pgdn    =   3
k_up      =   5
k_down    =  24
k_left    =  19
k_right   =   4
* ..... public
PUBLIC k_enter
k_enter   =  13
* ..... public
PUBLIC k_exit
* ..... define exit
k_exit    = k_escape
* ..... return
RETURN void


FUNCTION def_init
* ..... init achoice modes
PUBLIC c_aidle, c_afirst, c_alast, c_akeyx, c_anone
c_aidle  = 0
c_afirst = 1
c_alast  = 2
c_akeyx  = 3
c_anone  = 4
* ..... init achoice actions
PUBLIC c_astop, c_aitem, c_acont, c_anext
c_astop = 0
c_aitem = 1
c_acont = 2
c_anext = 3
* ..... return
RETURN void


FUNCTION mnu_init

* ..... init screen box
PUBLIC h_scrn
if video
  h_scrn = box_init(  0,  0, 24, 80, "B/B,,,,", 0)
else
  h_scrn = box_init(  0,  0, 24, 80, "W/W,,,,", 0)
endif video

* ..... init dialog box
PUBLIC h_bdia
if video
  h_bdia = box_init(  1,  2,  2, 75, "W+/W,GR+/BG,,,W+/W", 2)
else
  h_bdia = box_init(  1,  2,  2, 75, "W/N,W+/W,,,N+/N", 2)
endif video

* ..... init menu box
PUBLIC h_menu
if video
  h_menu = box_init(  6,  2, 16, 30, "W+/W,GR+/BG,,,W+/W", 2)
else
  h_menu = box_init(  6,  2, 16, 30, "W/N,W+/W,,,N+/N", 2)
endif video

* ..... init pointers
PUBLIC h_menup
h_menup = mptr_init(1, 1)

* ..... init menu
PUBLIC a_menu[7]
a_menu[1] = "Database Error"
a_menu[2] = "Expression Error"
a_menu[3] = "Miscellaneous Error"
a_menu[4] = "Open Error"
a_menu[5] = "Print Error"
a_menu[6] = "Undefined Error"
a_menu[7] = "Other Error"

* ..... init submenu box
PUBLIC h_subm
if video
  h_subm = box_init(  8, 12, 11, 30, "W+/BG,GR+/W,,,W+/BG", 2)
else
  h_subm = box_init(  8, 12, 11, 30, "N/W,W+/N,,,N+/N", 2)
endif video

* ..... init pointers
PUBLIC h_sub1p
h_sub1p = mptr_init(1, 1)
PUBLIC h_sub2p
h_sub2p = mptr_init(1, 1)
PUBLIC h_sub3p
h_sub3p = mptr_init(1, 1)
PUBLIC h_sub4p
h_sub4p = mptr_init(1, 1)
PUBLIC h_sub5p
h_sub5p = mptr_init(1, 1)
PUBLIC h_sub6p
h_sub6p = mptr_init(1, 1)
PUBLIC h_sub7p
h_sub7p = mptr_init(1, 1)

* ..... init sub-menu
PUBLIC a_sub1[5]
a_sub1[1] = "Database required"
a_sub1[2] = "Lock required"
a_sub1[3] = "Exclusive required"
a_sub1[4] = "Field numeric overflow"
a_sub1[5] = ":Index file corrupted"

* ..... init sub-menu
PUBLIC a_sub2[4]
a_sub2[1] = "Type mismatch"
a_sub2[2] = "Subscript range"
a_sub2[3] = "Zero divide"
a_sub2[4] = "Expression error"

* ..... init sub-menu
PUBLIC a_sub3[2]
a_sub3[1] = "Type mismatch"
a_sub3[2] = "RUN command"

* ..... init sub-menu
PUBLIC a_sub4[10]
a_sub4[1]  = "File not found"
a_sub4[2]  = "Path not found"
a_sub4[3]  = "Too many open files"
a_sub4[4]  = ":Invalid handle"
a_sub4[5]  = ":Insufficient memory"
a_sub4[6]  = ":Invalid drive specified"
a_sub4[7]  = ":Remove current directory"
a_sub4[8]  = ":Write-protected disk"
a_sub4[9]  = ":Drive not ready"
a_sub4[10] = ":File already exists"

* ..... init sub-menu
PUBLIC a_sub5[1]
a_sub5[1] = "Print error"

* ..... init sub-menu
PUBLIC a_sub6[3]
a_sub6[1] = "Undefined identifier"
a_sub6[2] = "Not an array"
a_sub6[3] = "Missing EXTERNAL"

* ..... init sub-menu
PUBLIC a_sub7[5]
a_sub7[1] = "Internal error"
a_sub7[2] = ":Disk Full"
a_sub7[3] = "Multiple Error"
a_sub7[4] = "Out of Memory"
a_sub7[5] = ":Not Enough Memory"
* ..... return
RETURN void


FUNCTION yn_get
* ..... parameters
PARAMETERS l_ymsg, l_def, l_msgy, l_msgn
* ..... private
PRIVATE l_row, l_col, l_yn
* ..... set color
stak_push(h_shue, Setcolor(box_hue(h_bdia)))
* ..... init coordinates
l_row = box_row(h_bdia)+1
l_col = box_col(h_bdia)+LEN(TRIM(l_ymsg))
* ..... say 'MESSAGE'
box_msg(h_bdia, l_ymsg)
* ..... cast yes/no
l_yn = IIF(l_def == l_msgy, 1, 2)
* ..... say prompts
@ l_row, l_col+4  PROMPT l_msgy
@ l_row, l_col+10 PROMPT l_msgn
* ..... get yes/no
MENU TO l_yn
* ..... clear 'MESSAGE'
box_msg(h_bdia, "")
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... return
RETURN (l_yn == 1)


FUNCTION menu_get
* ..... parameters
PARAMETERS l_menu, a_menut, h_menup
* ..... private
PRIVATE l_row, l_col, l_len, l_wid, l_key
* ..... init row, col, len, wid
l_row = box_row(l_menu)
l_col = box_col(l_menu)
l_len = l_row+box_len(l_menu)
l_wid = l_col+box_wid(l_menu)
* ..... increment shell
p_shell = p_shell+1
p_shellx = p_shellx+1
* ..... do while this shell
DO WHILE p_shell = p_shellx
   * ..... get menu
   l_key = Achoice(l_row+1, l_col+3, l_len-1, l_wid-3, &a_menut., .T., "menu_getv", mptr_ret(h_menup,1), mptr_ret(h_menup,2))
   * ..... do case
   DO CASE
      * ..... case Exit
   CASE l_key == 0
      IF (LASTKEY() == k_escape)
         * ..... assign lastkey
         l_key = LASTKEY()
         * ..... decrement shell
         p_shell = p_shell-1
      ENDIF (lastkey() == k_escape)
      * ..... case "command"
   CASE l_key > 0
      * ..... decrement shell
      p_shell = p_shell-1
      * ..... endcase
   ENDCASE
   * ..... enddo while this shell
ENDDO WHILE p_shell = p_shellx
* ..... decrement shell
p_shellx = p_shellx-1
* ..... return
RETURN l_key

* ..... function menu verify
FUNCTION menu_getv
* ..... parameters
PARAMETERS l_mode, l_ele, l_off
* ..... private
PRIVATE l_key, l_max
* ..... init max entry
l_max = LEN(&a_menut.)
* ..... save current position
mptr_sav(h_menup, 1, l_ele, l_off)
* ..... do case
DO CASE
   * ..... case "idle"
CASE l_mode == c_aidle
   l_ret  = c_acont
   * ..... case "exception"
CASE l_mode == c_akeyx
   * ..... init lastkey
   l_key = LASTKEY()
   * ..... DO CASE
   DO CASE
      * ..... CASE "escape"
   CASE l_key == k_escape
      l_ret = c_astop
      * ..... CASE "home"
   CASE l_key == k_home
      IF mptr_ret(h_menup, 1) == 1
         CLEAR TYPEAHEAD
         Tone(100, 2)
      ELSE
         mptr_sav(h_menup, 1, 1)
      ENDIF mptr_ret(h_menup, 1) == 1
      l_ret = c_astop
      * ..... CASE "end"
   CASE l_key == k_end
      IF mptr_ret(h_menup, 1) == l_max
         CLEAR TYPEAHEAD
         Tone(100, 2)
      ELSE
         mptr_sav(h_menup, 1, l_max)
      ENDIF mptr_ret(h_menup, 1) == l_max
      l_ret = c_astop
      * ..... CASE "up"
   CASE l_key == k_up
      IF mptr_ret(h_menup, 1) == 1
         CLEAR TYPEAHEAD
         Tone(100, 2)
      ELSE
         mptr_sav(h_menup, 1, mptr_ret(h_menup, 1) -1)
      ENDIF mptr_ret(h_menup, 1) == 1
      l_ret = c_acont
      * ..... CASE "down"
   CASE l_key == k_down
      IF mptr_ret(h_menup, 1) == l_max
         CLEAR TYPEAHEAD
         Tone(100, 2)
      ELSE
         mptr_sav(h_menup, 1, mptr_ret(h_menup, 1) +1)
      ENDIF mptr_ret(h_menup, 1) == l_max
      l_ret = c_acont
      * ..... CASE "left"
   CASE l_key == k_left
      CLEAR TYPEAHEAD
      Tone(100, 2)
      l_ret = c_acont
      * ..... CASE "right"
   CASE l_key == k_right
      CLEAR TYPEAHEAD
      Tone(100, 2)
      l_ret = c_acont
      * ..... CASE "enter"
   CASE l_key == k_enter
      l_ret = c_aitem
      * ..... otherwise
   OTHERWISE
      l_ret = c_acont
      * ..... ENDCASE
   ENDCASE
   * ..... otherwise
OTHERWISE
   CLEAR TYPEAHEAD
   Tone(100, 2)
   l_ret = c_acont
   * ..... endcase
ENDCASE
* ..... return
RETURN l_ret


FUNCTION mptr_init
* ..... parameters
PARAMETERS l_data1, l_data2
* ..... if not initialized
IF ('U' $ TYPE("p_ptrxxxxx"))
   * ..... public
   PUBLIC p_ptrxxxxx
   p_ptrxxxxx = 1
   * ..... else
ELSE
   * ..... increment var
   p_ptrxxxxx = p_ptrxxxxx+1
   * ..... endif not initialized
ENDIF ('U' $ TYPE("p_ptrxxxxx"))
* ..... private
PRIVATE l_handle
* ..... init pointer array
l_handle = "a_pt"+zero_pad(p_ptrxxxxx, 5)
PUBLIC &l_handle.[2]
* ..... init pointer elements
&l_handle.[1] = l_data1
&l_handle.[2] = l_data2
* ..... return
RETURN l_handle

FUNCTION mptr_sav
* ..... parameters
PARAMETERS l_handle, l_ele, l_data1, l_data2
* ..... save data
&l_handle.[l_ele] = l_data1
* ..... if initialized
IF !("U" $ TYPE("l_data2"))
   &l_handle.[l_ele+1] = l_data2
   * ..... endif initialized
ENDIF !("U" $ TYPE("l_data2"))
* ..... return
RETURN void

FUNCTION mptr_ret
* ..... parameters
PARAMETERS l_handle, l_ele
* ..... return
RETURN &l_handle.[l_ele]

FUNCTION mptr_zap
* ..... parameters
PARAMETERS l_handle
* ..... release array
RELEASE &l_handle.
* ..... return
RETURN void


FUNCTION stak_init
* ..... parameters
PARAMETERS l_depth, l_type, l_len
* ..... if not initialized
IF ('U' $ TYPE("p_stkxxxxx"))
   * ..... public
   PUBLIC p_stkxxxxx
   p_stkxxxxx = 1
   * ..... else
ELSE
   * ..... increment var
   p_stkxxxxx = p_stkxxxxx+1
   * ..... endif not initialized
ENDIF ('U' $ TYPE("p_stkxxxxx"))
* ..... private
PRIVATE l_handle, l_cnt, l_data
* ..... init stack array
l_handle = "a_st"+zero_pad(p_stkxxxxx, 5)
* ..... public
PUBLIC &l_handle.[l_depth]
* ..... init data
DO CASE
CASE TYPE("l_type") == "C"
   l_data = SPACE(l_len)
CASE TYPE("l_type") == "N"
   l_data = 0
CASE TYPE("l_type") == "D"
   l_data = CTOD(SPACE(8))
CASE TYPE("l_type") == "L"
   l_data = .F.
ENDCASE
* ..... init stack elements
Afill(&l_handle. , l_data)
* ..... public
PUBLIC &l_handle.p
&l_handle.p = 0
* ..... return
RETURN l_handle

FUNCTION stak_push
* ..... parameters
PARAMETERS l_handle, l_data
* ..... increment stack pointer
&l_handle.p = &l_handle.p + 1
* ..... save data
&l_handle.[&l_handle.p] = l_data
* ..... return
RETURN &l_handle.p

FUNCTION stak_pop
* ..... parameters
PARAMETERS l_handle
* ..... private
PRIVATE l_data
* ..... save data
l_data = &l_handle.[&l_handle.p]
* ..... decrement stack pointer
&l_handle.p = &l_handle.p - 1
* ..... return
RETURN l_data

FUNCTION stak_zap
* ..... parameters
PARAMETERS l_handle
* ..... release array
RELEASE &l_handle.
RELEASE &l_handle.p
* ..... return
RETURN void


FUNCTION box_init
* ..... parameters
PARAMETERS l_row, l_col, l_len, l_wid, l_hue, l_sha
* ..... if not initialized
IF ('U' $ TYPE("p_boxxxxxx"))
   * ..... public
   PUBLIC p_boxxxxxx
   p_boxxxxxx = 1
   * ..... else
ELSE
   * ..... increment var
   p_boxxxxxx = p_boxxxxxx+1
   * ..... endif not initialized
ENDIF ('U' $ TYPE("p_boxxxxxx"))
* ..... private
PRIVATE l_handle
* ..... init box array
l_handle = "a_bx"+zero_pad(p_boxxxxxx, 5)
* ..... public
PUBLIC &l_handle.[6]
* ..... init box elements
&l_handle.[1] = l_row
&l_handle.[2] = l_col
&l_handle.[3] = l_len
&l_handle.[4] = l_wid
&l_handle.[5] = l_hue
&l_handle.[6] = l_sha
* ..... return
RETURN l_handle

FUNCTION box_row
* ..... parameters
PARAMETERS l_handle
* ..... return
RETURN &l_handle.[1]

FUNCTION box_col
* ..... parameters
PARAMETERS l_handle
* ..... return
RETURN &l_handle.[2]

FUNCTION box_len
* ..... parameters
PARAMETERS l_handle
* ..... return
RETURN &l_handle.[3]

FUNCTION box_wid
* ..... parameters
PARAMETERS l_handle
* ..... return
RETURN &l_handle.[4]

FUNCTION box_hue
* ..... parameters
PARAMETERS l_handle
* ..... return
RETURN &l_handle.[5]

FUNCTION box_sha
* ..... parameters
PARAMETERS l_handle
* ..... return
RETURN &l_handle.[6]

FUNCTION box_zap
* ..... parameters
PARAMETERS l_handle
* ..... release array
RELEASE &l_handle.
* ..... return
RETURN void

FUNCTION box_say
* ..... parameters
PARAMETERS l_handle
* ..... private
PRIVATE l_row, l_col, l_len, l_wid
* ..... init coordinates
l_row = box_row(l_handle)
l_col = box_col(l_handle)
l_len = l_row + box_len(l_handle)
l_wid = box_wid(l_handle)
* ..... if shadow
IF box_sha(l_handle) > 0
   * ..... set color
   stak_push(h_shue, Setcolor("N/N"))
   * ..... say shadow
   scroll(l_row+1, l_col+l_wid, l_len, l_col+l_wid, 0)
   scroll(l_len+1, l_col+1, l_len+1, l_col+l_wid, 0)
   * ..... reset color
   Setcolor(stak_pop(h_shue))
   * ..... endif shadow
ENDIF box_sha(l_handle) > 0
* ..... convert box strings
l_gtop = box_top("         ",l_wid)
l_gmid = box_mid("         ",l_wid)
l_gbot = box_end("         ",l_wid)
* ..... set color
stak_push(h_shue, Setcolor(box_hue(l_handle)))
* ..... say top
@ l_row, l_col SAY l_gtop
* ..... for middle
FOR l_cnt = l_row+1 TO l_len-1 STEP 1
   * ..... say middle
   @ l_cnt, l_col SAY l_gmid
   * ..... next middle
NEXT l_cnt
* ..... say bottom
@ l_len, l_col SAY l_gbot
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... return
RETURN void

FUNCTION box_msg
* ..... parameters
PARAMETERS l_handle, l_msg
* ..... private
PRIVATE l_beep
* ..... set color
stak_push(h_shue, Setcolor(box_hue(l_handle)))
* ..... assemble message
l_msg = SUBS(l_msg+SPACE(box_wid(l_handle)), 1, box_wid(l_handle)-2-box_col(l_handle))
* ..... say message
@ box_row(l_handle)+1, box_col(l_handle)+2 SAY SUBS(l_msg, 2)
* ..... get beep
l_beep = VAL(SUBS(l_msg, 1, 1))
* ..... do case
DO CASE
   * ..... case beep = 1
CASE l_beep == 1
   * ..... beep
   Tone(2000, 1)
   * ..... case beep = 1
CASE l_beep == 2
   * ..... beep
   Tone(100, 2)
   * ..... endcase
ENDCASE
* ..... reset color
Setcolor(stak_pop(h_shue))
* ..... return
RETURN void

FUNCTION box_sav
* ..... parameters
PARAMETERS l_handle
* ..... private
PRIVATE l_row, l_col, l_len, l_wid
* ..... init coordinates
l_row = box_row(l_handle)
l_col = box_row(l_handle)+box_len(l_handle)
l_len = box_col(l_handle)
l_wid = box_col(l_handle)+box_wid(l_handle)
* ..... do case
DO CASE
   * ..... case shadow 1
CASE box_sha(l_handle) == 1
   l_row = l_row-1
   l_wid = l_wid+1
   * ..... case shadow 2
CASE box_sha(l_handle) == 2
   l_col = l_col+1
   l_wid = l_wid+1
   * ..... case shadow 3
CASE box_sha(l_handle) == 3
   l_col = l_col+1
   l_len = l_len-1
   * ..... case shadow 4
CASE box_sha(l_handle) == 4
   l_row = l_row-1
   l_len = l_len-1
   * ..... endcase
ENDCASE
* ..... return
RETURN Savescreen(l_row, l_len, l_col, l_wid)

FUNCTION box_res
* ..... parameters
PARAMETERS l_handle, l_scrn
* ..... private
PRIVATE l_row, l_col, l_len, l_wid
* ..... init coordinates
l_row = box_row(l_handle)
l_col = box_row(l_handle)+box_len(l_handle)
l_len = box_col(l_handle)
l_wid = box_col(l_handle)+box_wid(l_handle)
* ..... do case
DO CASE
   * ..... case shadow 1
CASE box_sha(l_handle) == 1
   l_row = l_row-1
   l_wid = l_wid+1
   * ..... case shadow 2
CASE box_sha(l_handle) == 2
   l_col = l_col+1
   l_wid = l_wid+1
   * ..... case shadow 3
CASE box_sha(l_handle) == 3
   l_col = l_col+1
   l_len = l_len-1
   * ..... case shadow 4
CASE box_sha(l_handle) == 4
   l_row = l_row-1
   l_len = l_len-1
   * ..... endcase
ENDCASE
* ..... return
RETURN Restscreen(l_row, l_len, l_col, l_wid, l_scrn)

FUNCTION box_top
* ..... parameters
PARAMETERS l_fram, l_wid
* ..... return
RETURN(SUBS(l_fram,1,1)+REPL(SUBS(l_fram,2,1),l_wid-2)+SUBS(l_fram,3,1))

FUNCTION box_mid
* ..... parameters
PARAMETERS l_fram, l_wid
* ..... return
RETURN(SUBS(l_fram,8,1)+REPL(SUBS(l_fram,9,1),l_wid-2)+SUBS(l_fram,4,1))

FUNCTION box_end
* ..... parameters
PARAMETERS l_fram, l_wid
* ..... return
RETURN(SUBS(l_fram,7,1)+REPL(SUBS(l_fram,6,1),l_wid-2)+SUBS(l_fram,5,1))


FUNCTION zero_pad
* ..... parameters
PARAMETERS l_num, l_len
* ..... return
RETURN(SUBS(STR(l_num+(10 ^ l_len), l_len+1), 2, l_len))


FUNCTION bye
* ..... private
PRIVATE l_cnt, scrn_tl, scrn_tr, scrn_br, scrn_bl
* ..... for row
FOR l_cnt = 1 TO 12 STEP 1
   * ..... save screens
   scrn_tl = bye_save(1)
   scrn_tr = bye_save(2)
   scrn_br = bye_save(3)
   scrn_bl = bye_save(4)
   * ..... if first time
   IF l_cnt == 1
     * ..... blank screen
      scroll( 0,  0, 24, 79, 0)
   * ..... endif first time
   ENDIF l_cnt == 1
   * ..... restore screens
   bye_rest(1, scrn_tl)
   bye_rest(2, scrn_tr)
   bye_rest(3, scrn_br)
   bye_rest(4, scrn_bl)
   * ..... next row
NEXT l_cnt = 1 to 12 step 1
* ..... return
RETURN void

FUNCTION bye_save
PARAMETERS l_quad
DO CASE
CASE l_quad == 1
  RETURN Savescreen( 0,  0, 11, 36)
CASE l_quad == 2
  RETURN Savescreen( 0, 44, 11, 79)
CASE l_quad == 3
  RETURN Savescreen(13,  0, 24, 36)
CASE l_quad == 4
  RETURN Savescreen(13, 44, 24, 79)
ENDCASE
* ..... return
RETURN void

FUNCTION bye_rest
PARAMETERS l_quad, l_scrn
DO CASE
CASE l_quad == 1
  Restscreen( 1,  4, 12, 40, l_scrn)
CASE l_quad == 2
  Restscreen( 1, 40, 12, 75, l_scrn)
CASE l_quad == 3
  Restscreen(12,  4, 23, 40, l_scrn)
CASE l_quad == 4
  Restscreen(12, 40, 23, 75, l_scrn)
ENDCASE
* ..... return
RETURN void

