* ..... Errorsys, the Clipper Error System
* .....
* ..... modified by :
* .....
* ..... The Leylan Factor
* ..... 8033 Sunset Blvd., #737
* ..... Los Angeles, CA  90046
* ..... (213) 856-8743

* ..... db_error(name, line, info)
FUNCTION db_error
PARAMETERS name, line, info
PRIVATE l_err

SET DEVICE TO SCREEN

l_err = error_msg("db_error", m->name, m->line, m->info)

DO CASE
   * ..... case quit
CASE l_err == 1
   SET cursor ON
   Setcolor("w/n")
   @ 23, 0 CLEAR
   QUIT
   * ..... case retry
CASE l_err == 2
   RETURN .T.
   * ..... case ignore
CASE l_err == 3
   BREAK
ENDCASE

RETURN .F.


* ..... expr_error(name, line, info, model, _1, _2, _3)
FUNCTION expr_error
PARAMETERS name, line, info, model, _1, _2, _3
PRIVATE l_err

_1 = IF( "U"$TYPE("_1"), "<none>" , _1)
_2 = IF( "U"$TYPE("_2"), "<none>" , _2)
_3 = IF( "U"$TYPE("_3"), "<none>" , _3)

SET DEVICE TO SCREEN

l_err = error_msg("expr_error", m->name, m->line, m->info, m->model, m->_1, m->_2, m->_3)

DO CASE
   * ..... case quit
CASE l_err == 1
   SET cursor ON
   Setcolor("w/n")
   @ 23, 0 CLEAR
   QUIT
   * ..... case retry
CASE l_err == 2
   BREAK
   * ..... case ignore
CASE l_err == 3
   BREAK
ENDCASE

RETURN .F.


*  ..... misc_error(name, line, info, model)
FUNCTION misc_error
PARAMETERS name, line, info, model
PRIVATE l_err

SET DEVICE TO SCREEN

l_err = error_msg("misc_error", m->name, m->line, m->info, m->model)

DO CASE
   * ..... case quit
CASE l_err == 1
   SET cursor ON
   Setcolor("w/n")
   @ 23, 0 CLEAR
   QUIT
   * ..... case retry
CASE l_err == 2
   RETURN .T.
   * ..... case ignore
CASE l_err == 3
   BREAK
ENDCASE

RETURN .F.


* ..... open_error(name, line, info, model, _1)
FUNCTION open_error
PARAMETERS name, line, info, model, _1
PRIVATE l_err

IF Neterr() .AND. model == "USE"
   RETURN .F.
END

_1 = IF( "U"$TYPE("_1"), "<none>" , _1)

SET DEVICE TO SCREEN

l_err = error_msg("open_error", m->name, m->line, m->info, m->model, m->_1)

DO CASE
   * ..... case quit
CASE l_err == 1
   SET cursor ON
   Setcolor("w/n")
   @ 23, 0 CLEAR
   QUIT
   * ..... case retry
CASE l_err == 2
   RETURN .T.
   * ..... case ignore
CASE l_err == 3
   RETURN .F.
ENDCASE

RETURN .T.


* ..... print_error(name, line)
FUNCTION print_error
PARAMETERS name, line
PRIVATE l_err

IF !("U"$TYPE("l_lerr"))
   IF l_lerr
      l_perr = .T.
      BREAK
   ENDIF l_lerr
ENDIF !("U"$type("l_lerr"))

SET DEVICE TO SCREEN

l_err = error_msg("print_error", m->name, m->line)

DO CASE
   * ..... case quit
CASE l_err == 1
   SET cursor ON
   Setcolor("w/n")
   @ 23, 0 CLEAR
   QUIT
   * ..... case retry
CASE l_err == 2
   RETURN .T.
   * ..... case ignore
CASE l_err == 3
   BREAK
ENDCASE

RETURN .T.


* ..... undef_error(name, line, info, model, _1)
FUNCTION undef_error
PARAMETERS name, line, info, model, _1
PRIVATE l_err

_1 = IF( "U"$TYPE("_1"), "<none>" , _1)

SET DEVICE TO SCREEN

l_err = error_msg("undef_error", m->name, m->line, m->info, m->model, m->_1)

DO CASE
   * ..... case quit
CASE l_err == 1
   SET cursor ON
   Setcolor("w/n")
   @ 23, 0 CLEAR
   QUIT
   * ..... case retry
CASE l_err == 2
   RETURN .T.
   * ..... case ignore
CASE l_err == 3
   BREAK
ENDCASE

RETURN .F.


* ..... error_msg(name, line)

FUNCTION error_msg
PARAMETERS l_proc, l_name, l_line, l_info, l_model, l_1, l_2, l_3

l_info  = IF("U"$TYPE("l_info"), "<none>", l_info)
l_model = IF( "U"$TYPE("l_model"), "<none>", l_model)
l_1 = IF( "U"$TYPE("l_1"), "<none>" , l_1)
l_2 = IF( "U"$TYPE("l_2"), "<none>" , l_2)
l_3 = IF( "U"$TYPE("l_3"), "<none>" , l_3)

PRIVATE a_err[88]
a_err[ 1] = "Invalid function number"
a_err[ 2] = "File not found"
a_err[ 3] = "Path not found"
a_err[ 4] = "Too many open files (no handles left)"
a_err[ 5] = "Access denied"
a_err[ 6] = "Invalid handle"
a_err[ 7] = "Memory control blocks destroyed"
a_err[ 8] = "Insufficient memory"
a_err[ 9] = "Invalid memory block address"
a_err[10] = "Invalid environment"
a_err[11] = "Invalid format"
a_err[12] = "Invalid access code"
a_err[13] = "Invalid data"
a_err[14] = "Reserved"
a_err[15] = "Invalid drive was specified"
a_err[16] = "Attempt to remove the current directory"
a_err[17] = "Not same device"
a_err[18] = "No more files"
a_err[19] = "Attempted write on write-protected disk"
a_err[20] = "Unknown unit"
a_err[21] = "Drive not ready"
a_err[22] = "Unknown command"
a_err[23] = "Data error (CRC)"
a_err[24] = "Bad request structure length"
a_err[25] = "Seek error"
a_err[26] = "Unknown media type"
a_err[27] = "Sector not found"
a_err[28] = "Printer out of paper"
a_err[29] = "Write fault"
a_err[30] = "Read fault"
a_err[31] = "General failure"
a_err[32] = "Sharing violation"
a_err[33] = "Lock violation"
a_err[34] = "Invalid disk change"
a_err[35] = "FCB unavailable"
a_err[36] = "Sharing buffer overflow"
a_err[37] = "Reserved"
a_err[38] = "Reserved"
a_err[39] = "Reserved"
a_err[40] = "Reserved"
a_err[41] = "Reserved"
a_err[42] = "Reserved"
a_err[43] = "Reserved"
a_err[44] = "Reserved"
a_err[45] = "Reserved"
a_err[46] = "Reserved"
a_err[47] = "Reserved"
a_err[48] = "Reserved"
a_err[49] = "Reserved"
a_err[50] = "Network request not supported"
a_err[51] = "Remote computer not listening"
a_err[52] = "Duplicate name on network"
a_err[53] = "Network name not found"
a_err[54] = "Network busy"
a_err[55] = "Network device no longer exists"
a_err[56] = "Network BIOS command limit exceeded"
a_err[57] = "Network adapter hardware error"
a_err[58] = "Incorrect response from network"
a_err[59] = "Unexpected network error"
a_err[60] = "Incompatible remote adapter"
a_err[61] = "Print queue full"
a_err[62] = "Not enough space for print file"
a_err[63] = "Print file deleted (not enough space)"
a_err[64] = "Network name deleted"
a_err[65] = "Access denied"
a_err[66] = "Network device type incorrect"
a_err[67] = "Network name not found"
a_err[68] = "Network name limit exceeded"
a_err[69] = "Network BIOS session limit exceeded"
a_err[70] = "Temporarily paused"
a_err[71] = "Network request not accepted"
a_err[72] = "Print or disk redirection paused"
a_err[73] = "Reserved"
a_err[74] = "Reserved"
a_err[75] = "Reserved"
a_err[76] = "Reserved"
a_err[77] = "Reserved"
a_err[78] = "Reserved"
a_err[79] = "Reserved"
a_err[80] = "File already exists"
a_err[81] = "Reserved"
a_err[82] = "Cannot make directory entry"
a_err[83] = "Fail on INT 24H"
a_err[84] = "Too many redirections"
a_err[85] = "Duplicate redirection"
a_err[86] = "Invalid password"
a_err[87] = "Invalid parameter"
a_err[88] = "Network device fault"

PRIVATE l_box, l_hue, l_color
l_box = Savescreen(5, 15, 22, 65)

video = IF( "U"$TYPE("video"), iscolor() , video)

if video
  l_hue = Setcolor("W+/R,W+/W,,,W/R")
else
  l_hue = Setcolor("+W/N,W+/W,,,W/N")
endif video

@  5, 15, 22, 65 BOX "Ŀ "

@  5, 17 SAY " Warning "
@  7, 18 SAY "Process :"
@  8, 18 SAY "   Line :"
@  9, 18 SAY "   Info :"
@ 10, 18 SAY "  Model :"
@ 11, 18 SAY " Parm 1 :"
@ 12, 18 SAY " Parm 2 :"
@ 13, 18 SAY " Parm 3 :"
@ 14, 18 SAY "Message :"
@ 16, 18 SAY "An error has occurred, please write down the"
@ 17, 18 SAY "information provided and select one of the  "
@ 18, 18 SAY "following courses of action.                "

@  5, 65 - (LEN(l_proc)+4) SAY " "+l_proc+" "
@  7, 28 SAY l_name
@  8, 28 SAY l_line
@  9, 28 SAY l_info
@ 10, 28 SAY l_model
@ 11, 28 SAY l_1
@ 12, 28 SAY l_2
@ 13, 28 SAY l_3

PRIVATE l_dos
l_dos = Doserror()
@ 14, 28 SAY IF(l_dos == 0, "<unspecified>", LEFT(a_err[l_dos], 30))

* ..... these two lines are here for demo purposes of multiple errors only
PRIVATE l_multi
l_multi = IF( "U"$TYPE("multi_err"), "" , 1/0)
* ..... and should be removed before using this with any applications

CLEAR TYPEAHEAD

PRIVATE l_return
l_return = 1

@ 20, 27 PROMPT "Quit"
@ 20, 36 PROMPT "Retry"
@ 20, 46 PROMPT "Ignore"
MENU TO l_return

l_return = IF(l_return == 0, 1, l_return)

Setcolor(l_hue)
Restscreen(5, 15, 22, 65, l_box)

RETURN l_return

