*****************************************************************************
*
*  idx.prg
*
*  This program demonstrates the indexer() fuction
*
*  Written by Will Cattell
*
*

private settalkon    && If true will force the indexer() function to
*                    &&    display the record number while indexing
*                    && The private statement implisitly creates memory
*                    &&    variables as logical whose value is false


store .t.   to settalkon  && Display the record number while indexing
select 0
use file0001
index on file0001->lastname;
         + file0001->firstname;
         + indexer(23,01);
      to lastname

store .f.   to settalkon  && Do not display the record number any more

select file0001
goto top

do while .not. eof()
   list next 20 file0001->lastname, file0001->firstname
   wait
enddo



function indexer
*
*  Displays the record number while indexing
*
*  This function should be embedded into the index expression.
*
*  To activate the record number display:
*     set settalkon to true
*
*  Otherwise set settalkon to false
*
*  WARNING: Whenever you embed this function in an index
*  it is executed everytime the index is referenced.
*  
*  Index files are accessed whenever they are referenced in the USE
*     SET INDEX, INDEX ON or SET ORDER TO commands and your application
*     performs file IO ( SEEKs, SKIPs GOTOs);
*  therefore,  settalkon MUST be defined as a logical memory variable BEFORE
*     you use an index file that contains the INDEXER() function.
*  
*
   parameters  df_row,;    && The row to display the recno()
               df_col      && The column to display the recno()

   if settalkon            && The value is set outside of the function
      @ df_row,df_col   say "Record: "
      @ df_row,col()    say recno()
   endif

return ""                  && Since you must return something
*                          &&    return a null value.
*****************************************************************************

