**************************************************************
**  PRTSC.PRG - FUNCTIONS TO CONTROL PRINT SCREEN ON/OFF
**            - REQUIRES IDL LIBRARY for CLIPPER S87 & 5.0
**
**  Author:     Milton F. Shaw Jr.
**  Date:       06/11/91
**  Support BBS:  Auto Exec BBS - (508) 833-0508
**  
**  How does it work:
**
**      The function to TURN OFF Print Screen tells the system
**      that the printer is BUSY.  Thus you won't get lockups
**      if a printer is not attached, not ready or any other
**      printer error.  This is safer than attacking the actual
**      print screen interrupt.
**
**      I use three functions, PRT_SCROFF(), PRT_SRCON() & PRT_SCRST()
**
**      PRT_SCROFF() - TURNS OFF PRINT SCREEN, returns logical
**      PRT_SCRON()  - ENABLES PRINT SCREEN, returns logical
**      PRT_SCRST()  - RETURN STATUS, .T. = ON, .F. = OFF
**
**  All three functions have been tested with S87 and V5.01 with no
**  known/found problem. It is advisable to restore print screen to
**  to ON prior to exiting your program.
**  
**  Any questions reqarding these functions should be directed to
**  AUTO EXEC BBS, (508) 833-0508. Leave MAIL to either the SYSOP or
**  to MILT SHAW.  There is no fee required to register and have
**  access at this time, 9 Nodes, 2.3 Gigabytes with literally 
**  thousands of CLIPPER, dBASE/FoxBase, 'C', BASIC, PASCAL programs
**  source, shareware, etc.
**
**  If you have any functions designed around a library, in ASM, 'C' 
**  or just a good clipper UDF you'd like to share.  Upload it to
**  Auto Exec BBS.


FUNCTION PRT_SCROFF
      POKEW("0050","0000",1)
RETURN(IIF(PEEKW("0050","0000")=1,.T.,.F.))

FUNCTION PRT_SCRON
      POKEW("0050","0000",0)
RETURN(IIF(PEEKW("0050","0000")=0,.T.,.F.))

FUNCTION PRT_SCRST
RETURN(IIF(PEEKW("0050","0000")=0,.T.,.F.))
