* Program:  HPLJLib.PRG
* Author.:  John Kaster
* Date...:  3/24/1987
* Notes..:  This source code is provided for Clipper(tm) as is, and I assume
*           no responsibility for any use you may put it to.  I used the
*           Hewlett-Packard Technical Reference Manual for my source code.
*
*           If you have any problems, comments, or suggestions, please let
*           me know.  I can be contacted on the EXEC-PC in Milwaukee,
*           Wisconsin, at 414-964-5160, or Acumen, in Springfield, Virginia,
*           at 703-321-7441.
*
*           Functions contained herein
*           HPCopies    ::= # of Copies
*           HPCour10    ::= Resident font, Courier 10 fixed pitch
*           HPDHori     ::= Decipoint horizontal movement
*           HPDPos      ::= Decipoint position
*           HPDVert     ::= Decipoint horizontal movement
*           HPDotOff    ::= Dot offset
*           HPDotX      ::= Dot offset X
*           HPDotY      ::= Dot offset Y
*           HPEmac      ::= Execute macro
*           HPFontCont  ::= Font control
*           HPFontID    ::= Font identification
*           HPFormFeed  ::= Form feed
*           HPHMI       ::= Horizontal motion index
*           HPHalfLF    ::= Half line feed
*           HPHori      ::= Horizontal movement
*           HPLPI       ::= Lines per inch
*           HPLand      ::= Landscape mode
*           HPLeftM     ::= Left margin
*           HPMacID     ::= Macro identification
*           HPPerm      ::= Make font permanent
*           HPPop       ::= Retrieve cursor position
*           HPPort      ::= Portrait mode
*           HPPos       ::= Position in rows and columns
*           HPPush      ::= Save current cursor position
*           HPReset     ::= Reset the printer
*           HPRightM    ::= Right Margin
*           HPShiftIn   ::= Shift in to secondary font
*           HPShiftOut  ::= Shift out of secondary font
*           HPSymbol    ::= Select a symbol set
*           HPTemp      ::= Make font temporary
*           HPTest      ::= Test the printer
*           HPUnder     ::= Underline on or off
*           HPVMI       ::= Vertical motion index
*           HPVert      ::= Vertical movement in lines (rows)
*           HPWrap      ::= Word wrap on or off
*

FUNCTION HPCopies
* Syntax:  HPCopies ( <ExpN> )
* Notes.:  Sets # of copies to print
PARAMETER Copies
RETURN ( chr(27)+'&l'+alltrim(str(Copies))+'X' )

FUNCTION HPCour10
* Syntax:  HPCour10 ()
* Notes.:  Sets resident courier 10 pitch fixed spacing
RETURN ( chr(27)+'(s3T'+chr(27)+'(s10h(s10V'+chr(27)+'(s0P' )

FUNCTION HPSymbol
* Syntax:  HPSymbol ()
* Notes.:  Selects the passed symbol set for the primary font if one
*          parameter is passed.  Otherwise, sets it for secondary.
*          Pass  Selects Symbol Set
*          ====  ==================
*          R8    Roman-8
*          K8    Kana-8
*          M8    Math-8
*          A8    Ansi-8
*          US    USASCII
*          LD    Line Draw
*          MS    Math Symbols
*          LG    US Legal
*          RX    Roman Extension
*          DM    ISO Denmark/Norway
*          UK    ISO United/Kingdom
*          FR    ISO France
*          GE    ISO Germany
*          IT    ISO Italy
*          SF    ISO Sweden/Finland
*          SP    ISO Spain

PARAMETER SymSet,Font
IF PCOUNT()<1
  RETURN ( '' )
ENDIF
IF PCOUNT()<2
  Font='('
ENDIF
SymSet=UPPER(SymSet)
DO CASE
CASE SymSet='R8'
  SymSet='8U'
CASE SymSet='K8'
  SymSet='8K'
CASE SymSet='M8'
  SymSet='8M'
CASE SymSet='A8'
  SymSet='9U'
CASE SymSet='US'
  SymSet='0U'
CASE SymSet='LD'
  SymSet='0B'
CASE SymSet='MS'
  SymSet='0A'
CASE SymSet='LG'
  SymSet='1U'
CASE SymSet='RX'
  SymSet='0E'
CASE SymSet='DM'
  SymSet='0D'
CASE SymSet='UK'
  SymSet='1E'
CASE SymSet='FR'
  SymSet='0F'
CASE SymSet='GE'
  SymSet='0G'
CASE SymSet='IT'
  SymSet='0T'
CASE SymSet='SF'
  SymSet='0S'
CASE SymSet='SP'
  SymSet='1S'
ENDC
IF PCOUNT()<2
  Font='('
ENDIF
IF Font#'('.AND.Font#')'
  DO CASE
  CASE TYPE('Font')='N'
    Font=IF(Font=2,')','(')
  CASE UPPER(Font) $ 'SP'
    Font=IF(Font='S',')','(')
  CASE UPPER(Font) $ '12'
    Font=IF(Font='2',')','(')
  OTHE
    Font='('
  ENDC
ENDIF
RETURN ( chr(27)+Font+SymSet )

FUNCTION HPFontID
* Syntax:  HPFontID ( <ExpN> )
* Notes.:  Selects specified font
PARAMETER FontID
RETURN ( chr(27)+'*c'+alltrim(str(FontID))+'D' )

FUNCTION HPFontCont
* Syntax:  HPFontCont ( <ExpN> )
* Notes.:  Performs specified action on fonts
*          Code  Action
*            
*          0     Delete all fonts (temporary and permanent)
*          1     Delete all temporary fonts
*          2     Delete font (last font ID specified)
*          3     Delete character code (last char and font ID specified)
*          4     Make font temporary (last font ID)
*          5     Make font permanent (last font ID)
*          6     Copy/Assign current font (last font ID)
*            This information is from p. 3-5 of the Laser Jet Technical
*            Reference Manual
PARAMETER FontCont
RETURN ( chr(27)+'*c'+alltrim(str(FontCont))+'F' )

FUNCTION HPPerm
* Syntax:  HPPerm ( <ExpN> )
* Notes.:  Makes specified font permanent
PARAMETER Perm
RETURN ( HPFontID(Perm)+HPFontCont(5) )

FUNCTION HPTemp
* Syntax:  HPTemp ( <ExpN> )
* Notes.:  Makes specified font temporary
PARAMETER Temp
RETURN ( HPFontID(Temp)+HPFontCont(4) )

FUNCTION HPWrap
* Syntax:  HPWrap ( <ExpL> )
* Notes.:  .T. turns wrap around on, .F. turns it off
PARAMETER Wrap
IF Wrap
  RETURN ( chr(27)+'&s0C' )
ELSE
  RETURN ( chr(27)+'&s1C' )
ENDIF

FUNCTION HPUnder
* Syntax:  HPUNDER( ExpL )
* Notes.:  ExpL - .T. for underline on, .F. for underline off
*          Turns HP Laserjet Auto-underline on or off
PARAMETER SetOn
PRIV SO
SO=IIF(SetOn,'D','@')
RETURN ( chr(27)+'&d'+SO )

FUNCTION HPLAND
* Syntax:  HPLand()
* Notes.:  Sets HP Landscape mode
RETURN ( chr(27)+'&l1O')

FUNCTION HPPort
* Syntax:  HPPort()
* Notes.:  Sets HP Portrait mode
RETURN ( chr(27)+'&l0O')

FUNCTION HPDOTOFF
* Syntax:  HPDotOff ( <ExpN1> [, <ExpN2>] )
* Notes.:  Sets the HP dot offsets in 300s of inch
PARAMETER OX,OY
IF Pcount()<2
  RETURN ( "" )
ELSE
  * Both X and Y dot offsets
  RETURN ( HPDotX(OX)+HPDotY(OY) )
ENDIF

FUNCTION HPDOTX
* Syntax:  HPDotX ( <ExpN> )
* Notes.:  Sets the HP dot offset in 300s of inch
PARAMETER X
IF TYPE('X')='C'
  RETURN ( chr(27)+'*p'+alltrim(X)+'X' )
ENDIF
RETURN ( chr(27)+'*p'+alltrim(str(X))+'X' )

FUNCTION HPDOTY
* Syntax:  HPDotY ( <ExpN> )
* Notes.:  Sets the HP dot offset in 300s of inch
PARAMETER Y
IF TYPE('Y')='C'
  RETURN ( chr(27)+'*p'+alltrim(Y)+'Y' )
ENDIF
RETURN ( chr(27)+'*p'+alltrim(str(Y))+'Y' )

FUNCTION HPMACID
* Syntax:  HPMacID( <ExpN> )
* Notes.:  Identify a previously downloaded macro
PARAMETER MacNo
RETURN ( chr(27)+'&f'+alltrim(str(MacNo))+'Y' )

FUNCTION HPEMAC
* Syntax:  HPEmac( <ExpN> )
* Notes.:  Execute a specified macro number
PARAMETER MacNo
RETURN ( HPMacId(MacNo)+chr(27)+'&f2X' )

FUNCTION HPPUSH
* Syntax:  HPPush()
* Notes.:  Pushes current cursor position onto the stack
RETURN ( chr(27)+'&f0S' )

FUNCTION HPPOP
* Syntax:  HPPop()
* Notes.:  Pops last pushed cursor position off the stack
RETURN ( chr(27)+'&f1S' )

FUNCTION HPHMI
* Syntax:  HPHMI( <ExpN> )
* Notes.:  Sets Horizontal motion index in 120ths of an inch
PARAMETER HMI
IF PCOUNT()<1
  RETURN ( '' )
ELSE
 RETURN ( chr(27)+'&k'+alltrim(str(HMI))+'H' )
ENDIF

FUNCTION HPVMI
* Syntax:  HPVMI( <ExpN> )
* Notes.:  Sets Vertical motion index in 48ths of an inch
PARAMETER VMI
IF PCOUNT()<1
  RETURN ( '' )
ELSE
 RETURN ( chr(27)+'&l'+alltrim(str(VMI))+'C' )
ENDIF

FUNCTION HPLPI
* Syntax:  HPLPI( <ExpN> )
* Notes.:  Sets Lines per inch.  Valid LPI: 1,2,3,4,6,8,12,16,24
PARAMETER LPI
IF PCOUNT()<1
  RETURN ( '' )
ELSE
 RETURN ( chr(27)+'&l'+alltrim(str(LPI))+'D' )
ENDIF

FUNCTION HPRESET
* Syntax:  HPReset()
* Notes.:  Resets the laser printer to defaults
RETURN ( chr(27)+'E' )

FUNCTION HPTest
* Syntax:  HPTest()
* Notes.:  Runs the self-test on the printer
RETURN ( chr(27)+'z' )

FUNCTION HPHori
* Syntax:  HPHori( <Column Value> )
* Notes.:  Positions the cursor horizontally by columns.  Without a +/-,
*          position is absolute.  With a +/-, position is relative to
*          current position.
PARAMETER Hori
IF PCOUNT()<1
  RETURN ( '' )
ENDIF
IF TYPE('Hori')='C'
  RETURN ( chr(27)+'&a'+alltrim(Hori)+'C' )
ENDIF
RETURN ( chr(27)+'&a'+alltrim(str(Hori))+'C' )

FUNCTION HPVert
* Syntax:  HPVert( <Row Value> )
* Notes.:  Positions the cursor vertically by rows.  Without a +/-, position
*          absolute.  With a +/-, position is relative to current position.
PARAMETER Vert
IF PCOUNT()<1
  RETURN ( '' )
ENDIF
IF TYPE('Vert')='C'
  RETURN ( chr(27)+'&a'+alltrim(Vert)+'R' )
ENDIF
RETURN ( chr(27)+'&a'+alltrim(str(Vert))+'R' )

FUNCTION HPPos
* Syntax:  HPPos( X [, Y] )
* Notes.:  Positions the cursor at X,Y in columns and rows.  Use +/- in
*          values for relative
PARAMETER X,Y
IF PCOUNT()<2
  RETURN ( '' )
ENDIF
RETURN ( HPHori(X)+HPVert(Y) )

FUNCTION HPDHori
* Syntax:  HPDHori( <Hori> )
* Notes.:  Positions the cursor horizontally by 720ths of an inch. Without
*          a +/-, position is absolute.  With a +/-, position is relative to
*          current position.
PARAMETER Hori
IF PCOUNT()<1
  RETURN ( '' )
ENDIF
IF TYPE('Hori')='C'
  RETURN ( chr(27)+'&a'+alltrim(Hori)+'H' )
ENDIF
RETURN ( chr(27)+'&a'+alltrim(str(Hori))+'H' )

FUNCTION HPDVert
* Syntax:  HPVert( <Vert> )
* Notes.:  Positions the cursor vertically by 720ths of an inch.  Without a
*          +/-, position is absolute.  With a +/-, position is relative to
*          current position.
PARAMETER Vert
IF PCOUNT()<1
  RETURN ( '' )
ENDIF
IF TYPE('Vert')='C'
  RETURN ( chr(27)+'&a'+alltrim(Vert)+'V' )
ENDIF
RETURN ( chr(27)+'&a'+alltrim(str(Vert))+'V' )

FUNCTION HPDPos
* Syntax:  HPPos( X [, Y] )
* Notes.:  Positions the cursor at X,Y in 1/720ths of an inch.  Precision is
*          up to 2 decimals
PARAMETER X,Y
IF PCOUNT()<2
  RETURN ( '' )
ENDIF
RETURN ( HPDHori(X)+HPDVert(Y) )

FUNCTION HPHalfLF
* Syntax:  HPHalfLF()
* Notes.:  Performs a half line feed on the printer
RETURN ( chr(27)+'=' )

FUNCTION HPLeftM
* Syntax:  HPLeftM ( <Left Margin> )
* Notes.:  Sets the left margin in
PARAMETER LeftM
RETURN ( chr(27)+'&a'+alltrim(str(LeftM))+'L' )

FUNCTION HPRightM
* Syntax:  HPRightM ( <Right Margin> )
* Notes.:  Sets the left margin in
PARAMETER RightM
RETURN ( chr(27)+'&a'+alltrim(str(RightM))+'M' )

FUNCTION HPShiftIn
* Syntax:  HPShiftIn()
* Notes.:  Shifts in to secondary font - Ctrl-O
RETURN ( chr(15) )

FUNCTION HPShiftOut
* Syntax:  HPShiftOut()
* Notes.:  Shifts out of secondary font - Ctrl-N
RETURN ( chr(14) )

FUNCTION HPFormFeed
* Syntax:  HPFormFeed()
* Notes.:  Ejects the page
RETURN ( chr(12) )
