/* -------------------------------------------------------------------------

  Copy Right,  April 1992              Donated to Public Domain
  Auther: Jamal Assaf
  --------------------------------------------------------------------------
  Purpose  : Activate Hot Keys from  @ GET
  Advantage: - Hot keys activated are 'local' to current get.
             - No need to modify getsys.prg.
             - You don't have to worry about activating and deactivating
               the hot key.
             - More important is makes your life easier!

  Compile with: /n/m
                      ****** Have Fun *******


  Example: (Hey, this is just an example)

     FUNCTION GetCust()
          LOCAL getlist := {}, cCustCode := SPACE(10)

          @ 5,10 SAY "Enter Customer Code (F5-Lookup): " GET cCustCode ;
                 HOTKEY K_F5, {|| LookupCust(@cCustCode, @cTitle)}
          @ 6,2  SAY "Title : " GET cTitle
          READ
     RETURN NIL

     FUNCTION LookupCust(cCode, cTitle)

           SEEK cCode
           IF FOUND()
              cTitle := CUSTOMER->CUST_TITLE
           ENDIF
     RETURN NIL



     Please note  that the HOTKEY parameters are seperated by
          a comma, and the procedure or function called is a code block.
          Remember that the new #xcommand works in conjuction with
          similar processor commands found in STD.CH like @ SAY...GET....
          If there is a better way to do this, please share your ideas.

----------------------------------------------------------------------- */

 // Example Begins:

 #include "inkey.ch"
 #include "hotget.ch"

 FUNCTION TestHotGet()
   LOCAL getlist := {}, cName := SPACE(15), cAddress := SPACE(20), ;
         cHelp := "F1 Pressed...It is working"
   CLS
   SETCOLOR("W+/B")
   @ 15,10 SAY "Press ESCAPE to exit" COLOR "GR+/R"
   DO WHILE LASTKEY() != K_ESC
      @ 10,10 SAY "Enter Name (F1-ShowHelp)   : " GET cName ;
                   HOTKEY K_F1, { || ShowHelp(cHelp) }

      @ 12,10 SAY "Enter Address (F5-Test it) : " GET cAddress ;
                   HOTKEY K_F5, { || ShowHelp("F5 was pressed") }
      READ
   ENDDO

 RETURN NIL

 FUNCTION ShowHelp(cHelp)

    @ 22,0 say PADR(cHelp + "   " + "Press any key to continue...",75) COLOR "G/N"
    INKEY(0)
    @ 22,0 SAY PADR(" ",75)  COLOR "G/N"      // clear line

 RETURN NIL

 // Example Ends


//************************************************************************

 // This code is required for the HOTKEY to work properly.

FUNCTION HotKeySet(oGet, nKeyVal, bKeyBlock)
   SetKey( nKeyVal, bKeyBlock )
   GetReader(oGet)
   SetKey( nKeyVal, NIL)
RETURN NIL

