#include "extend.h"

/***********************************************************************
* Function   :  fillarr()
*
* Written By :  Richard Horwitz
*
* Copyright  :  Fieldston Consulting Group, Inc. 1990
*
* Description:  Fills an array with an incremented value.
*   This function takes 3 parameters, the array to fill, the
*   starting value, and the increment value.
*
* Also demonstrates the use of parameter information macros,
* accessing parameters, and storing values to passed parameters.
***************************************************************/
CLIPPER fillarr()
{
int arraylen;              /* declared size of array */
int startval;              /* starting value */
int incrval;               /* increment value */
int _counter;              /* loop counter */

/* do paramter and type checking */
if((PCOUNT != 3) || (! ISARRAY(1)) || (! ISNUM(2)) || (! ISNUM(3)))
   return;

arraylen = ALENGTH(1);     /* get the length of the array */
startval = _parni(2);      /* get the starting value */
incrval  = _parni(3);      /* get the increment value */

/* loop around for each array element storing the values */
for(_counter = 1; _counter <= arraylen ; _counter++)

    /* store the incremented value to array element counter */
    _storni(startval+=incrval,1 ,_counter);

return;
}
