#include "extend.h"

void revfunc(char *, char *, int);	/* func that does the reverse */

/**********************************************************************
* Function   :  reverse()
*
* Written By :  Richard Horwitz
*
* Copyright  :  Fieldston Consulting Group, Inc. 1990
*
* Clipper Syntax  :  reverse(<string>)
*
*	Where: 
*		<string> 		- the string to reverse
*
*
* Description:  This function is called from Clipper, and acts as an
*    intermediate function to revfunc(), the C function that actually
*    does the reversing of the string.  It takes one parameter, the 
*    string to reverse, and returns a copy of that string reversed. 
*    If no parameters are passed, or are of the wrong data type, a 
*    null is returned.
***********************************************************************/
CLIPPER reverse()
{
char *_instring;			/* pointer to the passed string */
char *_outstring;		/* pointer for return string */
int _size;			/* size of passed string */

/* do parameter and type checking */
if((PCOUNT < 1) || (! ISCHAR(1)))
		{
		_retc("");		/* wrong or no params, so return null */
		return;			/* back to Clipper */
		}

_size = _parclen(1);				/* get size of passed string */
_instring = _parc(1);				/* set pointer to passed string */
_outstring = _exmgrab(_size+1);		/* allocate memory for return string */

	/* if the allocate was successful, call the actual reversing function */
	if(_outstring)
		{
		revfunc(_instring,_outstring, _size);
		_retc(_outstring);			/* return the result to Clipper */
		_exmback(_outstring, _size+1);		/* free the allocated memory */
		}
		else
		_ret();					/* return a NIL to Clipper */

	return;					/* back to Clipper */
}


/**********************************************************************
* Function   :  revfunc()
*
* Written By :  Richard Horwitz
*
* Copyright  :  Fieldston Consulting Group, Inc. 1990
*
* Description:  This function does the actual reversing of the string.
*    What we are doing is copying, character by character, from the
*    end of the string to reverse, into the front of the result string.
***********************************************************************/
void revfunc(__instring, __outstring, __size)

char *__instring;			/* pointer to string to reverse */
char *__outstring;			/* pointer to space for result */
int  __size;				/* size of string passed from clipper */
{
	int  _k;				/* loop counter */
	int  _inpos;			/* position in string to reverse */
	int  _outpos;			/* position in result string */

	_inpos  = __size - 1;		/* point to last char of string to reverse */
	_outpos = 0;			/* point to first char of result string */

	/* do the actual reversing of the string */
	for(_k=0; _k < __size; _k++)
			__outstring[_outpos++] = __instring[_inpos--];

	__outstring[__size] = 0x00;	/* make sure last char is null */
	
}


