#include "extend.h"

void xorit(char *, char *, char *, int);   /* func that does the XOR */

/**********************************************************************
* Function   :  encrypt()
*
* Written By :  Richard Horwitz
*
* Copyright  :  Fieldston Consulting Group, Inc. 1990
*
* Description:  This function is called from Clipper, and acts as an
*    intermediate function to xorit(), the C function that actually
*    does the XORing (encryption/decryption) of the string. It takes
*    two parameters, the string to encrypt/decrypt, and the key to use
*    for the encrypting/decrypting.  It returns a copy of the
*    encrypted/decrypted string to Clipper.
*    If no parameters are passed, or are of the wrong data type, a 
*    null is returned.
* 
* Note: I say encrypt/decrypt because when you take an encrypted string
*    and re-encrypt it with the same key, it decrypts the string.
*    Also we *must* use _retclen() since the encrypted string might 
*    have embedded NULLs.
* 
***********************************************************************/
CLIPPER encrypt()
{

   char *instr;         /* pointer to the passed string to encrypt/decrypt*/
   char *keystr;        /* pointer to the passed key string */
   char *outstr;        /* pointer for return string */
                                       
   int _size=0;         /* size of passed string minus null terminator */

   /* do parameter and type checking */
   if((PCOUNT < 2) || (!ISCHAR(1)) || (!ISCHAR(2)))
      {
      _ret();                 /* wrong or no params, so return null */
      return;                 /* back to Clipper */
      }

   _size = _parclen(1);       /* get size of passed string to encrypt/decrypt */
   instr =  _parc(1);         /* set pointer to that string */
   keystr =  _parc(2);        /* set pointer to key string */

   outstr = _xalloc(_size+1);  /* allocate memory for return string */

   /* if the allocate was successful, call the actual XORing function */
   if(outstr)                    
      xorit(instr, keystr, outstr, _size);

   _retclen(outstr,_size);     /* return the result to Clipper */
   _xfree(outstr);             /* free the allocated memory */
}



/**********************************************************************
* Function   :  xorit()
*               
* Written By :  Richard Horwitz
*
* Copyright  :  Fieldston Consulting Group, Inc. 1990
*
* Description:  This function does the actual XORing (encryption/decryption)
*    of the string.  What we are doing is XORing, character by character,
*    the string to (encrypt/decrypt), with the key string, placing the
*    resulting value into dest. 
***********************************************************************/
void xorit(inptr, key, dest, size)
char *inptr;              /* pointer to string to de/encrypt */
char *key;                /* pointer to key string */
char *dest;               /* pointer to buffer to hold result */
int size;                 /* size of input string */
{
char *keyptr;             /* pointer to key */
int  _k=0;                /* loop counter */


    /* loop around xoring each char in input string */
    while(*inptr)          
      {

       /* set pointer to key string */
       keyptr = key;

       /* loop around for each char in key, or until end of input string */
       while((*keyptr) && (_k < size))
          dest[_k++] = (*keyptr++ ^ *inptr++);     /* do the xor */

       }

      /* make sure last byte is NULL */
      dest[size] = 0x00;   
}



