* HOL.PRG
*****************************************************************************
*                                                                           *
*  Author    : Brian Gallagher                                              *
*  Date      : 11/30/88                                                     *
*  Comment   : Adds seven days to the DATE passed, adjusting the end date   *
*              if it falls on a holiday or weekend                          *
*                                                                           *
*****************************************************************************
*
FUNCTION holiday
PARAM date

date = date + 7

dateok = .F.
DO WHILE .NOT. dateok
   
   DO CASE
   CASE DOW(date) = 7
      date = date + 2
   CASE DOW(date) = 1
      date = date + 1
   OTHERWISE
      date = date
   ENDCASE 
   
   m_month=MONTH(date)
   m_year=YEAR(date)
   m_1st=CTOD(STR(m_month,2)+'/01/'+STR(m_year,4))
   
   DO CASE
   CASE m_month = 1
      IF DAY(date) < 3
         newysday=CTOD('01/01/'+STR(m_year,4))
         DO CASE
         CASE DOW(newysday) = 1
            newy = 2
            IF newy = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         CASE DOW(newysday) > 1
            newy = 1
            IF newy = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         ENDCASE 
      ELSE
         DO CASE
         CASE DOW(m_1st) < 3
            mlk  = 17 - DOW(m_1st)
            IF mlk = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         CASE DOW(m_1st) > 2
            mlk  = 24 - DOW(m_1st)
            IF mlk = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         ENDCASE 
      ENDIF 
   CASE m_month = 2
      IF DAY(date) < 14
         lincday=CTOD('02/12/'+STR(m_year,4))
         DO CASE
         CASE DOW(lincday) = 1
            linc = 13
            IF linc = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         CASE DOW(lincday) > 1
            linc = 12
            IF linc = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         ENDCASE 
      ELSE
         DO CASE
         CASE DOW(m_1st) < 3
            washb = 17 - DOW(m_1st)
            IF washb = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         CASE DOW(m_1st) > 2
            washb = 24 - DOW(m_1st)
            IF washb = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         ENDCASE 
      ENDIF 
   CASE m_month = 5
      memod = 31 - DOW(m_1st)
      IF memod = DAY(date)
         date = date + 1
         LOOP
      ENDIF 
   CASE m_month = 7
      IF DAY(date) <= 5
         DO CASE
         CASE DOW(date) = 1
            fourth = 5
            IF fourth = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         CASE DOW(date) > 1
            fourth = 4
            IF fourth = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         ENDCASE 
      ENDIF 
   CASE m_month = 9
      DO CASE
      CASE DOW(m_1st) < 3
         labor = 3 - DOW(m_1st)
         IF labor = DAY(date)
            date = date + 1
            LOOP
         ENDIF 
      CASE DOW(m_1st) > 2
         labor = 10 - DOW(m_1st)
         IF labor = DAY(date)
            date = date + 1
            LOOP
         ENDIF 
      ENDCASE 
   CASE m_month = 10
      DO CASE
      CASE DOW(m_1st) < 3
         colom = 10 - DOW(m_1st)
         IF colom = DAY(date)
            date = date + 1
            LOOP
         ENDIF 
      CASE DOW(m_1st) > 2
         colom = 17 - DOW(m_1st)
         IF colom = DAY(date)
            date = date + 1
            LOOP
         ENDIF 
      ENDCASE 
   CASE m_month = 11
      DO CASE
      CASE DAY(date) < 9 .AND. MOD(m_year,2) = 0
         DO CASE
         CASE DOW(m_1st) < 3
            elec   = 4 - DOW(m_1st)
            IF elec = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         CASE DOW(m_1st) > 2
            elec   = 11 - DOW(m_1st)
            IF elec = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         ENDCASE 
      CASE DAY(date) > 10 .AND. DAY(date) < 20
         vetsday=CTOD('11/11/'+STR(m_year,4))
         DO CASE
         CASE DOW(vetsday) = 1
            vets = 12
            IF vets = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         CASE DOW(vetsday) > 1
            vets = 11
            IF vets = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         ENDCASE 
      CASE DAY(date) > 20
         DO CASE
         CASE DOW(m_1st) < 6
            thanks = 27 - DOW(m_1st)
            IF thanks = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         CASE DOW(m_1st) > 5
            thanks = 34 - DOW(m_1st)
            IF thanks = DAY(date)
               date = date + 1
               LOOP
            ENDIF 
         ENDCASE 
      ENDCASE 
   CASE m_month = 12
      xmasday=CTOD('12/25/'+STR(m_year,4))
      DO CASE
      CASE DOW(xmasday) = 1
         xmas = 26
         IF xmas = DAY(date)
            date = date + 1
            LOOP
         ENDIF 
      CASE DOW(xmasday) > 1
         xmas = 25
         IF xmas = DAY(date)
            date = date + 1
            LOOP
         ENDIF 
      ENDCASE 
   ENDCASE 
   
   dateok = .T.
   LOOP
ENDDO
RETURN (date)
