/*
 HOTMENU.PRG
 Enhancement for PROMPT and MENU which allows hot keys to be displayed in
 a different color and to be something other than the first letter.

 This program requires the include file HOTMENU.CH, which redefines
 PROMPT and MENU TO.

 CHOICES is a 2-dimensional array of menu prompts.  Each element is a
 sub-array containing 4 elements: 1) row, 2) column, 3) prompt text,
 4) position of hot key in text (if hot key is the first letter, this
 can be omitted).
*/

/*
   NOTE: Hotmenu.prg has since been modified to accept an ALT key combo
   of the highlighted letter.
*/

#include "inkey.ch"
#include "hotmenu.ch"

STATIC choices:={}

func main

 choice := 1

 cls

 setcolor( "w+/bg" )

 @ 0, 0, 25, 79 box ""

 setcolor( "n/bg, gr+/r,,,w+/b" )

 @0, 0 say space( 80 )

 while lastkey() <> 27

    @ 0,05 prompt "Rey" hotkey 1
    @ 0,10 prompt "Mike" hotkey 4
    @ 0,16 prompt "Scott" hotkey 1

    menu to choice

 end // while


quit

    return nil

* The PROMPT command is redefined to call this function.
function make_prmpt (row,col,text,hpos)
  aadd( choices, { row, col, text, iif( hpos == nil, 1, hpos ) } )
return nil

* The MENU TO command is redefined to call this function.
function hot_menu (curr)
local l := len( choices ), width := 0, n, k, a, prev, choice
local col_prompt := setcolor(), old_cursor, col_high, col_hotkey, key_block

/* Parse the SETCOLOR string ( if it has only one color, there will be no
   highlight color for the menu bars!).  First chop off the leftmost part
   (standard color) to get the highlight color.  Then see if there are still
   any commas; if so, set the hotkey color to the rightmost portion. */

a           := at( ",", col_prompt )
col_high    := substr( col_prompt, a+1 )
a           := at( ",", col_high )
col_hotkey  := iif( a == 0, col_prompt,;
                           substr( col_prompt, rat( ",", col_prompt ) + 1 ) )

/* Determine if it is a vertical or horizontal menu by checking if the first
   two choices are in the same row.  If it is vertical, pad the choices to
   the same length; don't pad if horizontal because it looks lousy. */
if choices[ 1, 1 ] <> choices[ 2, 1 ]

  for n := 1 to l
    width := max( width, len( choices[ n, 3 ] ) )
  next

  for n := 1 to l
    choices[ n, 3 ] := padr( choices[ n, 3 ], width )
  next

endif

for n := 1 to l
  @ choices[ n, 1 ], choices[ n, 2 ] say choices[ n, 3 ] color col_prompt
  @ choices[ n, 1 ], choices[ n, 2 ] + choices[ n, 4 ] - 1 ;
    say substr( choices[ n, 3 ], choices[ n, 4 ], 1 ) color col_hotkey
next

if curr == nil
  curr := 1
endif

prev       := curr
old_cursor := setcursor(0)
do while .t.

  @ choices[ prev, 1 ], choices[ prev, 2 ] say choices[ prev, 3 ] color col_prompt
  @ choices[ prev, 1 ], choices[ prev, 2] + choices[ prev, 4 ] - 1 ;
    say substr( choices[ prev, 3 ], choices[ prev, 4 ], 1 ) color col_hotkey
  @ choices[ curr, 1 ], choices[ curr, 2 ] say choices[ curr, 3 ] color col_high
  k := inkey(0)

  do case
     case k == K_ESC
       curr := 0
       exit

     case k == K_ENTER
       exit

     case k == K_UP .or. k == K_LEFT
       prev := curr
       curr := iif( curr == 1, l, curr - 1 )

     case k == K_DOWN .or. k == K_RIGHT
       prev := curr
       curr := iif( curr == l, 1, curr + 1 )

     case k == K_HOME .or. k == K_PGUP
       prev := curr
       curr := 1

     case k == K_END .or. k == K_PGDN
       prev := curr
       curr := l

     case ( k >= 32 .and. k <= 127 ) .or. ChkAltKey( @k )
       a    := ascan( choices, {|c| upper( substr( c[3], c[4], 1 ) ) == upper( chr( k ) ) } )
       if a > 0
         prev := curr
         curr := a

         /* even though the menu is being exited at this point, highlight the choice
            anyway.  if a submenu is displayed, this avoids the confusion which would
            occur if the first menu appeared to have the wrong choice highlighted. */

         @ choices[ prev, 1 ], choices[prev,2] say choices[ prev, 3 ] color col_prompt
         @ choices[ prev, 1 ], choices[ prev, 2 ] + choices[ prev, 4 ] - 1 say ;
          substr( choices[ prev, 3 ], choices[ prev, 4 ], 1 ) color col_hotkey
         @ choices[ curr, 1 ], choices[ curr, 2 ] say choices[ curr, 3 ] color col_high

         exit

       endif

     case ( key_block := setkey( k ) ) != nil   // support for set key
       eval( key_block, procname(1), procline(), readvar() )

  endcase

enddo

asize( choices, 0 )

setcursor( old_cursor )

return curr

// This part allows the function to check for an ALT key combination on
// the highlighted letter...
function ChkAltKey( nKey )
local bBlock, nVal
local aAltKeys := { { K_ALT_A, "A" }, ;
		    { K_ALT_B, "B" }, ;
		    { K_ALT_C, "C" }, ;
		    { K_ALT_D, "D" }, ;
		    { K_ALT_E, "E" }, ;
		    { K_ALT_F, "F" }, ;
		    { K_ALT_G, "G" }, ;
		    { K_ALT_H, "H" }, ;
		    { K_ALT_I, "I" }, ;
		    { K_ALT_J, "J" }, ;
		    { K_ALT_K, "K" }, ;
		    { K_ALT_L, "L" }, ;
		    { K_ALT_M, "M" }, ;
		    { K_ALT_N, "N" }, ;
		    { K_ALT_O, "O" }, ;
		    { K_ALT_P, "P" }, ;
		    { K_ALT_Q, "Q" }, ;
		    { K_ALT_R, "R" }, ;
		    { K_ALT_S, "S" }, ;
		    { K_ALT_T, "T" }, ;
		    { K_ALT_U, "U" }, ;
		    { K_ALT_V, "V" }, ;
		    { K_ALT_W, "W" }, ;
		    { K_ALT_X, "X" }, ;
		    { K_ALT_Y, "Y" }, ;
		    { K_ALT_Z, "Z" }    }

nVal   := ascan( aAltKeys, { | x | x[ 1 ] == nKey } )
bBlock := { || nKey := asc( aAltKeys[ nVal, 2 ] ), .t. }

return iif( nVal > 0, eval( bBlock ), .f. )
