/*
 HOTMENU.PRG
 Enhancement for PROMPT and MENU which allows hot keys to be displayed in
 a different color and to be something other than the first letter.

 This program requires the include file HOTMENU.CH, which redefines
 PROMPT and MENU TO.

 CHOICES is a 2-dimensional array of menu prompts.  Each element is a
 sub-array containing 4 elements: 1) row, 2) column, 3) prompt text,
 4) position of hot key in text (if hot key is the first letter, this
 can be omitted).
*/

#include "inkey.ch"

STATIC choices:={}

* The PROMPT command is redefined to call this function.
FUNCTION MAKE_PRMPT (row,col,text,hpos)
  aadd(choices,{row,col,text,iif(hpos=nil,1,hpos)})
RETURN nil

* The MENU TO command is redefined to call this function.
FUNCTION HOT_MENU (curr)
LOCAL l:=len(choices), width:=0, n, k, a, prev, choice, ;
 col_prompt:=setcolor(), old_cursor, col_high, col_hotkey, key_block
/* Parse the SETCOLOR string (if it has only one color, there will be no
   highlight color for the menu bars!).  First chop off the leftmost part
   (standard color) to get the highlight color.  Then see if there are still
   any commas; if so, set the hotkey color to the rightmost portion. */
a:=at(",",col_prompt)
col_high:=substr(col_prompt,a+1)
a:=at(",",col_high)
col_hotkey:=iif(a=0,col_prompt,substr(col_prompt,rat(",",col_prompt)+1))
/* Determine if it is a vertical or horizontal menu by checking if the first
   two choices are in the same row.  If it is vertical, pad the choices to
   the same length; don't pad if horizontal because it looks lousy. */
IF choices[1,1]<>choices[2,1]
  FOR n=1 TO l
    width:=max(width,len(choices[n,3]))
  NEXT
  FOR n=1 TO l
    choices[n,3]:=padr(choices[n,3],width)
  NEXT
ENDIF
FOR n=1 TO l
  @ choices[n,1],choices[n,2] SAY choices[n,3] COLOR col_prompt
  @ choices[n,1],choices[n,2]+choices[n,4]-1 ;
   SAY substr(choices[n,3],choices[n,4],1) COLOR col_hotkey
NEXT
IF curr=nil
  curr:=1
ENDIF
prev:=curr
old_cursor:=setcursor(0)
DO WHILE .T.
  @ choices[prev,1],choices[prev,2] SAY choices[prev,3] COLOR col_prompt
  @ choices[prev,1],choices[prev,2]+choices[prev,4]-1 ;
   SAY substr(choices[prev,3],choices[prev,4],1) COLOR col_hotkey
  @ choices[curr,1],choices[curr,2] SAY choices[curr,3] COLOR col_high
  k:=inkey(0)
  DO CASE
  CASE k=K_ESC
    curr:=0
    EXIT
  CASE k=K_ENTER
    EXIT
  CASE k=K_UP .OR. k=K_LEFT
    prev:=curr
    curr:=iif(curr=1,l,curr-1)
  CASE k=K_DOWN .OR. k=K_RIGHT
    prev:=curr
    curr:=iif(curr=l,1,curr+1)
  CASE k=K_HOME .OR. k=K_PGUP
    prev:=curr
    curr:=1
  CASE k=K_END .OR. k=K_PGDN
    prev:=curr
    curr:=l
  CASE k>=32 .and. k<=127
    a:=ascan(choices,{|c| upper(substr(c[3],c[4],1))=upper(chr(k))})
    IF a>0
      prev:=curr
      curr:=a
/* Even though the menu is being EXITed at this point, highlight the choice
   anyway.  If a submenu is displayed, this avoids the confusion which would
   occur if the first menu appeared to have the wrong choice highlighted. */
      @ choices[prev,1],choices[prev,2] SAY choices[prev,3] COLOR col_prompt
      @ choices[prev,1],choices[prev,2]+choices[prev,4]-1 SAY ;
       substr(choices[prev,3],choices[prev,4],1) COLOR col_hotkey
      @ choices[curr,1],choices[curr,2] SAY choices[curr,3] COLOR col_high
      EXIT
    ENDIF
  CASE (key_block:=setkey(k)) != nil   // support for SET KEY
    eval(key_block,procname(1),procline(),readvar())
  OTHERWISE
  ENDCASE
ENDDO
asize(choices,0)
setcursor(old_cursor)
RETURN curr
