*  HKTEST01.PRG:  routines to test Howard Kapustein's Library Ver. 0.10
*
*  Copyright (c) 1987        05-01-87
*
*
*    This is just a short program to test HKLIB01.LIB.
*    To test the library, compile this program and add the
*    library file when linking.
*
*    NOTE: some of the functions may seem to execute slowly.
*    This is because the CENTER() function is used repetitively.
*    I used the CENTER() function for output to make the results
*    easier to read. If you wish a truer test of speed, just change
*    the CENTER(...) to a column number.
*
*
CLEAR
SET COLOR TO BG+/N,GR+/N,N
SET DELIMITERS OFF
char = SPACE(20)
@ 1, CENTER("Howard Kapustein's Library Version 0.10") SAY "Howard Kapustein's Library Version 0.10"
@ 2, CENTER("---------------------------------------") SAY "---------------------------------------"
@ 5, 25 SAY "Library Functions:"
@ 7, 30 SAY "1. CENTER( <expC> )"
@ 8, 30 SAY "2. DOL_STR( <expN> )"
@ 9, 30 SAY "3. MOD( <expN>,<expN> )"
@ 10, 30 SAY "4. ISSTATE( <expC> )"
@ 11, 30 SAY "5. STABBR( <expC>,<expL> )"
@ 12, 30 SAY "6. STFULL( <expC> )"
@ 13, 30 SAY "9. Quit"
DO WHILE .T.
    SET COLOR TO BG+/N,GR+/N
    choice = " "
    SET CONFIRM OFF
    @ 15, 35 SAY "Which: " GET choice VALID choice $ "1234569"
    READ
    SET COLOR TO BG+/N,
    SET CONFIRM ON
    DO CASE
       CASE choice = "1"
           mc = SPACE(55)
           @ 17, 0 SAY "Enter string to center: " GET mc
           READ
           SET COLOR TO B+/W
           @ 20, CENTER(LTRIM(TRIM(mc))) SAY LTRIM(TRIM(mc))
       CASE choice = "2"
           mn = 0.0000
           @ 17, 20 SAY "Enter number to convert: " GET mn
           READ
           @ 20, CENTER(LTRIM(STR(mn))+" = "+DOL_STR(mn)) SAY LTRIM(STR(mn))+" = "+DOL_STR(mn)
       CASE choice = "3"
           ma = 0.0
           mb = 0.0
           @ 17, 24 SAY "A / B:   A = " GET ma
           @ 18, 33 SAY "B = " GET mb
           READ
           @ 20, 30 SAY "MOD(A,B) = "+LTRIM(STR(MOD(ma,mb)))
       CASE choice = "4"
           mi = SPACE(2)
           @ 17, 20 SAY "Enter abbreviation: " GET mi
           READ
           ml = ISSTATE(mi)
           @ 20, 30 SAY "Is "+mi+" a state abbreviation?   "
           SET COLOR TO GR+/N
           @ 20, 58 SAY ml
       CASE choice = "5"
           mn = SPACE(30)
           ml = .F.
           @ 17, 20 SAY "Enter name to check: " GET mn
           @ 18, 20 SAY "Case sensitive? " GET ml
           READ
           SET COLOR TO B+/W
           ct = CENTER("State abbreviation of "+LTRIM(TRIM(mn))+" = "+STABBR(LTRIM(TRIM(mn)),ml))
           @ 20, ct SAY "State abbreviation of "+LTRIM(TRIM(mn))+" = "+STABBR(LTRIM(TRIM(mn)),ml)
       CASE choice = "6"
           ma = SPACE(2)
           @ 17, 20 SAY "Enter abbreviation to check: " GET ma
           READ
           SET COLOR TO B+/W
           @ 20, CENTER(ma+" = "+STFULL(ma)) SAY ma+" = "+STFULL(ma)
       CASE choice = "9"
           QUIT
    ENDCASE
    SET COLOR TO BG+/N
    @ 24, CENTER("Press any key to continue") SAY "Press any key to continue"
    i = INKEY(0)
    @ 16, 0 CLEAR
ENDDO