        PAGE    60,132
        TITLE   HANDLES - Handle Table Expansion for Clipper

;  Function HANDLES replaces the DOS handle table for the calling process
;  with a handle table of length HTABLEN.  (Maximum HTABLEN is 255)
;
;  Requirements:  DOS 3.x.  The number of file handles available after calling
;                 this function in MIN(HTABLEN, N), where N is the value in
;                 the statement "FILES=N" in the DOS CONFIG.SYS file.
;
;  See the file HANDLES.DOC for additional documentation.


        PUBLIC  HANDLES,HAND_AD
        EXTRN   __RETNI:FAR

HTABLEN EQU     250                     ; HANDLE TABLE LENGTH

DOS     EQU     21H                     ; DOS FUNTION CALL INTERRUPT

_PROG   SEGMENT 'CODE'
        ASSUME  CS:_PROG
  
PSP     STRUC                           ; DESCRIPTION OF USED PORTION OF PSP            
        DB      18H DUP(?)
HPSP    DB      20 DUP(?)               ; DOS SUPPLIED HANDLE TABLE
        DB      6 DUP(?)
HTABSIZ DW      ?                       ; LENGTH OF HANDLE TABLE (DEFAULT 20)
HTABPTR DD      ?                       ; POINTER TO HANDLE TABLE 
PSP     ENDS                            ;  DEFAULT IS (PSP_SEG : HPSP)


HAND_AD PROC    FAR                     ; CALLED ALSO BY HANDPROC ROUTINES        
                                        ;   WHICH ARE ASSEMBLED SEPARATELY
        MOV     AH,62H                  ; GET PSP ADDRESS
        INT     DOS                     ; SEGMENT ADDRESS RETURNED IN BX
        MOV     DS,BX                
        MOV     CX,DS:HTABSIZ           ; CX IS HANDLE TABLE SIZE
        LDS     SI,DS:HTABPTR           ; DS:SI IS POINTER TO HANDLE TABLE
        RET

HAND_AD ENDP


HANDLES PROC    FAR                     ; REPLACE THE CURRENT HANDLE TABLE
                                        ;  WITH HTAB
        PUSH    BP
        PUSH    DS
        PUSH    ES
        PUSH    SI
        PUSH    DI

        MOV     AH,30H                  ; GET DOS VERSION NUMBER
        INT     DOS                     ; AL MAJOR, AH MINOR VERSION NO
        CMP     AL,3                    ; MUST HAVE AT LEAST DOS 3.0
        JL      BADVER

        CALL    HAND_AD                 ; RETURN DS:SI PTR TO HANDLE TABLE
                                        ; BX IS PSP SEG AND CX IS TABLE LENGTH
        CMP     CX,HTABLEN
        JGE     HANDRET                 ; RETURN CX IF NO EXPANSION

        MOV     ES,BX                   ; ES IS PSP SEG
        MOV     AX,CS
        MOV     DI,OFFSET HTAB

        MOV     WORD PTR ES:HTABPTR,DI  ; UPDATE HTABPTR AND HTABSIZ IN PSP
        MOV     WORD PTR ES:HTABPTR+2,AX
        MOV     WORD PTR ES:HTABSIZ,HTABLEN

        MOV     ES,AX                   ; ES,DI IS PTR TO HTAB
        CLD                             ; MOVE CX BYTES FROM OLD HANDLE TABLE
        REP     MOVSB                   ; TO NEW HANDLE TABLE
        MOV     CX,HTABLEN
HANDRET:
        POP     DI
        POP     SI
        POP     ES
        POP     DS
        POP     BP
        PUSH    CX                      ; RETURN HTABLEN OR 0 IF NOT DOS 3.X
        CALL    __RETNI
        ADD     SP,2
        RET

BADVER:
        XOR     AX,AX                   ; RETURN ZERO IF NOT DOS 3.X
        JMP     HANDRET

HANDLES ENDP

HTAB    DB      HTABLEN DUP(0FFH)       ; NOT ACCESSED BY CLIPPER MODULES

_PROG   ENDS
        END

