; Program ...: Handles.ASM
; Author ....: Ken Getz and Leonard Zerman
; Date ......: December 1, 1986
;
; .BIN file to be loaded from within dBASE III PLUS or the Developer's
; Release, to print out the number of available file handles for debugging
; purposes.  Uses service 44H of INT 21H to return status of first 20 file
; handles.  The interrupt returns a 6 if the file was unavailable (currently
; not in use); so, all occurrences of unavailable files are counted and
; returned to the user.
; (Note:  This simple program assumes the line FILES=20 is in CONFIG.SYS.)
;
CODE  SEGMENT BYTE PUBLIC 'CODE'

CR  EQU 13
LF  EQU 10

write1  MACRO char    ; Macro to write a single character.
  PUSH  AX
  PUSH  DX
  MOV DL,char
  MOV AH,2
  INT 21h
  POP DX
  POP AX
  ENDM

HANDLES PROC  FAR
  ASSUME  CS:code,DS:code

START:  JMP ENTRY
MSG DB  CR,LF,'Files currently available: $'
ENTRY:
  PUSH  CX    ; Save environment.
  PUSH  DI
  PUSH  DX
  PUSH  BX
  PUSH  AX
  PUSH  DS
  PUSH  CS    ; Make CS and DS have the same value.
  POP DS
  XOR DI,DI   ; Zero out DI.
  MOV CX,19
LOOPER:
  MOV AH,44h    ; IOCTL service.
  XOR AL,AL   ; Zero out AL.
  MOV BX,CX   ; BX := file handle to check.
  INT 21h   ; Call DOS.
  CMP AL,06   ; Check for "error" -- file not available.
  JNE NO_ERROR  ; If no error, jump over increment.
  INC DI    ; Add one to counter.
NO_ERROR: 
  LOOP  LOOPER    ; Loop back to use all possible file handles.
  MOV DX,OFFSET MSG ; Get message to print out.
  MOV AH,9    ; Print message service.
  INT 21h   ; Call DOS.
  MOV AX,DI   ; AX := binary number to convert to decimal.
  CALL  DEC   ; Convert to decimal and print.
  WRITE1  CR    ; Write carriage return.
  WRITE1  LF    ; Write linefeed.
EXIT: 
  POP DS    ; Restore all registers.
  POP AX
  POP BX
  POP DX
  POP DI
  POP CX
  RET
HANDLES ENDP

; Recursive procedure to convert a binary number stored in AX to decimal
; and print it.
; 
;   by Robert Doolittle
;
DEC PROC  NEAR
  MOV CX,-10
DEC3: PUSH  DI
  MOV DI,-1
DEC1: INC DI
  ADD AX,CX
  JB  DEC1
  SUB AX,CX
  XCHG  AX,DI
  OR  AX,AX
  JZ  DEC2
  CALL  DEC3
DEC2: ADD DI,30h
  MOV DX,DI
  MOV AH,2
  INT 21h
  POP DI
  RET
DEC ENDP

CODE  ENDS
  END START
