/*
  Ŀ
 ݳ                                                                         
 ݳ   Function: m_aprompt()                                                 
 ݳ   Purpose : Display prompts with mouse and embedded attribute support   
 ݳ   Usage   : m_aprompt( lExcept, nStart, aRows, aCols, aPrompts, nColor,;
 ݳ                       [aMessages, nMessageLine, sLetterChoice ,;        
 ݳ                        aHotkeys, aHotSpots, oBrowse                     
 ݳ   Program : FUNCky                                                      
 ݳ   Author  : Copyright (C) 1990, dLESKO INC. All Rights reserved.        
 ݳ   Modified: Dale Williams 2/24/91                                          
 ݳ   Modified: Gary S. Jorgenson, R.N. 08/13/91                            
 ݳ   Switches: /m/n/w                                                      
 ݳ                                                                         
 ݳ   Comments: This source code may be freely used and distributed         
 ݳ             provided that the affixed copyright notice is not removed.  
 ݳ                                                                         
 ݳ             Prompts and messages can have embedded attributes in        
 ݳ             them. See the demo program aprompts.prg for an example      
 ݳ                                                                         
  
 

   GSJ:modification
   
   The aPrompts parameter can now be a two dimensional array. Each element
   of aPrompts can either be a menu prompt or a sub-array. The sub-array
   must have element[1] as the prompt and element[2] as a code block to
   evaluate when selected. If the element is only a prompt, the function
   returns the option selected. If the element contains a prompt AND a code
   block, the block is evaluated upon selection and the function continues.
    end:GSJ

   I added a ninth parameter, _LetChoice, that is a string of all valid
   activation letters for prompts.  Using the imbedded atributtes, you can
   highlight the letter that will activate the prompt. With the keyboard, you
   just press the letter highlighted letter.  


   GSJ:modification
   
   The 10th paramater is an optional array of hotkeys. It must be
   a 2 dimensional array. Each sub-array needs 2 elements: The hot key and
   a code block to evaluate when pressed. This a key is pressed other than
   a valid prompt selection, this array is scanned for the key. If found, the
   associated code block is evaluated and execution continues.

   The 11th parameter is an optional array of hotspots. It must be
   a 2 dimensional array. Each sub-array has 5 elements: The 1st 4 elements
   are top, left, bottom, right coordinates of the screen. The 5th element is
   a code block to evaluate when the mouse cursor is within the specified
   region on a mouse click.

   The 12th parameter is an optional Tbrowse object. If passed, the object
   is stabilized and subsequent keystrokes manipulate the object as well as
   the prompts.
    end:GSJ

   Example:

   the prompts arrays.
   LOCAL caMainRows := {4,4,4,4,4}
   LOCAL caMainCols := {0,12,20,28,38}
   LOCAL caMainMenu := { {'^cM^naintenance', {||maint()}  } ,;
                         {'^cR^neviews'    , {||review()} } ,;
                         {'r^cE^nports'      {||report()} } ,;
                         {'^cU^ntilities'  , {||util()}   } ,;
                        '^cQ^nuit'}      

   LOCAL caHotKeys  := { { -3, {||funcF4()} }  ,;
                         { -4, {||funcF5()} }  }


   LOCAL caHotSpots := {{0,0,0,0,{||nstuff(27)}}}   // Top left corner
                                                    // of screen to quit

   LOCAL caMainMess := {'Add, Delete, Modify, or View a Database',;
                        'Work with Criteria Reviews',;
                        'Select Report to Produce',;
                        'Routines for System Upkeep',;
                        'Return to DOS'}


   LOCAL oBrowse := TBROWSEDB( 7,12,19,67 )    // Create a Browse Object
   LOCAL column  := TBCOLUMNNEW( , FIELDBLOCK( "DESC" ) )
   oBrowse:colorspec := "W+/B, W+/BG"
   oBrowse:addColumn( column )

   A few lines of code later...

   CsrOff()
   nLevel := M_APrompt(FALSE, Len(caMainMenu), caMainRows, caMainCols,;
                       caMainMenu,, caMainMess, MaxRow(), 'mreuq', caHotKeys,;
                       caHotSpots, oBrowse )
   CsrOn()

   Notice the 9th parameter in m_aprompt, 'mreuq'.  These correspond with
   the highlighted letters for each element in the caMainMenu array.

   The other minor change I made to this routine is that prompt messages are
   now displayed starting in the left-most column instead of centering the
   message.

*/


*  *

#include "Inkey.ch"

FUNCTION m_aprompt( _except, _start, _prow, _pcol, _prompts, _color, _pmessage,;
                    _pmessline, _LetChoice, _hotkeys, _hotspots, oBrowse)

LOCAL   _retflag := .F., _pkey := 0, _temp := 0, _pcol2 := {}, _button1 := .F.
LOCAL   lcol := lastcol()+1, _phigh, _plength, _plast, _pactive, _pfore, _x, b

_pfore := _color                         // Setup the default values
colorset(@_pfore, @_phigh)

_plength := len(_prompts)                // Declare the initialize parameters

IF( _start < 0 )             // Check that the active element is within range
	_pactive := 1
ELSEIF( _start > _plength )
	_pactive := _plength
ELSE
 _pactive := _start
ENDIF

_plast := _pactive

_phigh := _phigh+256   // Extend the _phigh attribute to tell anyone using the
                       // highlight color to ignore the embedded attributes

_pcol2 := Array(_plength)     // This array will hold the ending column number
                              // of each of the prompts so that we can check
                              // see if the mouse cursor is over an element


m_csroff()     // Shut the cursor off whenever you are printing to the screen

// Print out the initial prompts and fill the array _pcol2[]

FOR _x = 1 to _plength

  * GSJ:modification
  * Use IFARRAY to check current element of _prompts
  * for an array containing a code block to execute.
  * If found, display elememt 1, otherwise, display
  * the contents of the element.
  * end:GSJ

  aprint(_prow[_x],_pcol[_x],IFARRAY(_prompts[_x]), _pfore)
  _pcol2[_x] := aprintlen(IFARRAY(_prompts[_x]))+ _pcol[_x] -1

NEXT

// Highlight the active one
aprint(_prow[_pactive], _pcol[_pactive], IFARRAY(_prompts[_pactive]) , _phigh)

// If there are messages, then display the active message
IF( _pmessage != NIL )
  aprint(_pmessline, 0, "", _pfore, lcol)
  aprint(_pmessline, 0, _pmessage[_pactive], _pfore )
ENDIF

m_csron()            // Turn the mouse cursor back on

#define IS_TBROWSE VALTYPE( oBrowse ) = "O"

DO WHILE (.T.)       // Loop inside a loop makes it easy to display elements

  DO WHILE (.T.)

    IF IS_TBROWSE                            // If TBROWSE object was passed
      m_csroff()                             // Mouse cursor off
      WHILE ( !oBrowse:Stabilize() )         // stabilize it
        _pkey := INKEY()
        IF !EMPTY( _pkey );  EXIT;  ENDIF    // Exit on keypress
      END
      m_csron()                              // Mouse cursor on
    ENDIF
    DO WHILE (.T.)    // Cycle until a keystroke/mousepress occurs

      _pkey := inkey()
      IF( (_button1 := _isbutton(1)) );  EXIT;  ENDIF

      // For Debugging, show mouse cursor position when both buttons are pressed
      IF ( _isbutton(3) )
        _temp := savevideo(23,1,23,10)
        WHILE ( _isbutton(3) )
          print( 23,1, PADL(m_row(),4)+PADL(m_col(),4) )
        END
        restvideo(23,1,23,10,_temp)
      END

      IF( _pkey != 0 )
        b := setkey(_pkey)
        IF( b != NIL )
          EVAL(b, procname(2), procline(2))
          loop
        ELSE
          EXIT
        ENDIF
      ENDIF

    ENDDO   // Cycle

    _plast := _pactive


*  *
*   Process Mouse Activity                                                     *
*  *

    IF( _button1 )     // Check mouse presses
      _temp := m_aregion(_prow, _pcol, _prow, _pcol2)   // Over a Prompt?

      IF (_temp > 0)

         WHILE (_isbutton(1) )  // Let them scamper around with the mouse

           IF( _temp > 0)
              _pactive := _temp
           ENDIF

           IF (_plast != _pactive)      // Highlight new prompt if moved
             m_csroff()
             aprint(_prow[_plast], _pcol[_plast],;
                    IFARRAY(_prompts[_plast]), _pfore)
             aprint(_prow[_pactive], _pcol[_pactive],;
                    IFARRAY(_prompts[_pactive]), _phigh)

             * If there are messages, then display the active one
             IF ( _pmessage != NIL )
                aprint(_pmessline, 0, "", _pfore, lcol)
                aprint(_pmessline, 0, _pmessage[_pactive], _pfore)
             ENDIF
             m_csron()
             _plast := _pactive
           END
           _temp := m_aregion(_prow, _pcol, _prow, _pcol2)
         END

         * Check to see if they're still over the same when released
         IF ( _temp == m_aregion(_prow, _pcol, _prow, _pcol2 ))

           IF( _temp > 0 )
             _pactive := _temp
             _retflag := .T.
             EXIT
           ENDIF

         ENDIF

      ELSE    // Mouse cursor was not over a Prompt

         * Check if mouse cursor is in a hot spot
         * 
         IF _HotSpots != NIL
           b := ASCAN( _HotSpots, {|x|m_region(x[1],x[2],x[3],x[4])} )

           IF b > 0 .and. VALTYPE(_HotSpots[b,5]) = "B" .and. !_isbutton(1)
             EVAL(_HotSpots[b,5])
           ENDIF

         ENDIF

         * If exceptions are processed and they click
         * outside the prompt areas, then return
         * with -1
         IF ((_except) .and. (! _retflag) .and. _button1)
           return(-1)
         ELSE
           LOOP
         ENDIF

      ENDIF

    ENDIF


*  *
*   Process Keyboard Activity                                                     *
*  *

    /* If keyboard is used, check if letter pressed is valid for a prompt.
       If valid, AT() number is stored to the active prompt var. and
       marks return flag var. as true.
       If not valid, move into case statement. */

    IF ( _LetChoice != NIL ) .and. !Empty(AT(Chr(LastKey()), _LetChoice))

      _pactive := AT(Chr(LastKey()), _LetChoice)
      _retflag := .T.
      EXIT

    ELSE

      IF( _hotkeys != NIL )       // See if keypress was a hotkey
        b := ASCAN( _hotkeys, {|x| x[1] == _pkey} )
        IF b > 0 .and. VALTYPE(_hotkeys[b,2]) = "B"
          EVAL( _hotkeys[b,2] )
          EXIT
        END
      END


      DO CASE

        CASE ( _pkey == K_ESC )
           return(0)

        CASE ( _pkey == K_UP )
          IF IS_TBROWSE
            oBrowse:up()
          ELSE
            _pactive := IIF(_pactive == 1, _plength, _pactive-1 )
            IF Left(IFARRAY(_prompts[_pactive]), 1) = ''
               --_pactive
            ENDIF
          END
          EXIT

        CASE ( _pkey == K_LEFT )
           _pactive := IIF(_pactive == 1, _plength, _pactive-1 )
           IF Left(IFARRAY(_prompts[_pactive]), 1) = ''
              --_pactive
           ENDIF
           EXIT

        CASE ( _pkey == K_CTRL_LEFT ) .AND. IS_TBROWSE
           oBrowse:left()
           EXIT

        CASE ( _pkey == K_CTRL_RIGHT ) .AND. IS_TBROWSE
           oBrowse:right()
           EXIT

        CASE ( _pkey == K_DOWN )
          IF IS_TBROWSE
            oBrowse:down()
          ELSE
            _pactive := IIF(_pactive == _plength, 1, _pactive+1 )
            IF Left(IFARRAY(_prompts[_pactive]), 1) = ''
               ++_pactive
            ENDIF
          END
          EXIT

        CASE ( _pkey == K_RIGHT )
          _pactive := IIF(_pactive == _plength, 1, _pactive+1 )
          IF Left(IFARRAY(_prompts[_pactive]), 1) = ''
             ++_pactive
          ENDIF
          EXIT

        CASE (_pkey == K_HOME )
           _pactive := 1
           IF IS_TBROWSE;  oBrowse:gotop(); oBrowse:panhome();  END
           EXIT

        CASE (_pkey == K_END )
             _pactive := _plength
             IF IS_TBROWSE;  oBrowse:gobottom(); oBrowse:panhome();  END
             EXIT

        // If they press a normal key, and no letter choice array is sent,
        // search for it within the array
        // Take leading embedded attributes into account
        CASE (_pkey < 128 .and. _pkey > 32 .AND. _LetChoice == NIL)

             _temp := ASCAN( _prompts,;
                   {|x| UPPER(CHR(_pkey)) == ;
                   LEFT(LTRIM(UPPER(IFARRAY(x))),1)})

             IF (_temp > 0 )
               _pactive := _temp
               _retflag := .T.
               EXIT
             ENDIF

        CASE (_pkey == K_PGDN )
          IF IS_TBROWSE
            oBrowse:pagedown()
          ELSE
            _retflag := .T.
          ENDIF
          EXIT

        CASE (_pkey == K_PGUP )
          IF IS_TBROWSE
            oBrowse:pageup()
          ELSE
            _retflag := .T.
          ENDIF
          EXIT

        CASE (_pkey == K_ENTER )
          _retflag := .T.
          EXIT

      ENDCASE
    ENDIF

  ENDDO

    * If the active element has been moved, then repaint the
    * appropriate elements to display the new active element

    IF (_plast != _pactive)
       m_csroff()
       aprint(_prow[_plast], _pcol[_plast], IFARRAY(_prompts[_plast]), _pfore)
       aprint(_prow[_pactive], _pcol[_pactive],;
              IFARRAY(_prompts[_pactive]), _phigh)

       * If there are messages, then display the active one
       IF ( _pmessage != NIL )
           aprint(_pmessline, 0, "", _pfore, lcol)
           aprint(_pmessline, 0, _pmessage[_pactive], _pfore )
       endif
       m_csron()
    ENDIF

    * If there are exceptions, then return when they press
    * left arrow, use -2 to signify left arrow pressed
    IF (_except .and. _pkey == 19)
            return(-2)
    ENDIF

    * If there are exceptions, then return when they press
    * right arrow, use -3 to signify right arrow pressed
    IF (_except .and. _pkey == 4)
            return(-3)
    ENDIF

    * If the return flag is set, that means we have to return
    * the active element to the caller
    IF ( _retflag )

       * GSJ:modification
       * If a code block was passed, evaluate it then continue.
       * If no code block passed, return the option number selected
       * 
       IF ( VALTYPE( _prompts[_pactive]   ) = "A" )  .and. ;
          ( VALTYPE( _prompts[_pactive,2] ) = "B" )
          EVAL( _prompts[_pactive,2] )
          _retflag := .F.
       ELSE
          return ( _pactive )
       ENDIF

    ENDIF
ENDDO

RETURN NIL

/*
  Ŀ
 ݳ                                                                         
 ݳ   Function: colorset()                                                  
 ݳ   Purpose : return default fore/background colors in passed params      
 ݳ   Usage   : colorset(@nForeGround, @nBackGround) -> @nColor, @nColor    
 ݳ                                                                         
 ݳ   Program : FUNCky                                                      
 ݳ   Author  : Copyright (C) 1990, dLESKO INC. All Rights reserved.        
 ݳ   Switches: /m/n/w                                                      
 ݳ                                                                         
 ݳ   Comments: This source code may be freely used and distributed         
 ݳ             provided that the affixed copyright notice is not removed.  
 ݳ                                                                         
 ݳ             Used by the MAX* functions and mouse functions              
 ݳ                                                                         
  
 
*/
 
FUNCTION colorset( ForeGround, BackGround)

        IF ( ForeGround == NIL) 
                ForeGround := standard()
                BackGround := enhanced()
        ELSEIF( ForeGround < 0) 
                ForeGround := standard()
                BackGround := enhanced()
        ELSE
                BackGround := roloc( ForeGround)
        ENDIF

return NIL

* GSJ:modification
* Function returns 1st element if param is array, otherwise return the param
FUNCTION IFARRAY( obj )
RETURN IF( VALTYPE( obj ) = "A", obj[1], obj )
