FUNCTION gst_calc
* Purpose:  Pop a calculator on the screen which accepts a GST-included 
*           price and returns a GST-out price and the GST. I needed this
*           because my application had separate tracking of item cost and
*           GST, but with the GST phase-in chaos happening, some invoices
*           or expenses may have a GST included price. This function allows
*           the operator to break that down into Item/GST components.

* Returns:  Nothing. Optionally stuff the results into the keyboard buffer.

* Written by Brian Loesgen for use with Clipper Summer 87
*         Dec 29/90 (2 days prior to GST implementation)

* For any comments, I can be reached at:
*
*                 Voice      (416) 480-0620
*                 Fax        (416) 483-5717
*                 CompuServe     74326,1174
*                 Rose Media  BBS (Toronto)

* Released into the public domain to help all those that need to
* contend with the GST. No warranties or claims are made, use at
* own risk, etc....

* This is written in S87 because that's what the app is in which I
* needed this for. If I did it in 5.0, it would have looked *much*
* different (at the time this was written, and released, Clipper 5.0
* still had some birth pains which precluded use for the particular
* application I needed the calculator for)

* Third party libraries used:
*
* FUNCTION N_SAVEGETS / N_RESTGETS         ... from GET-IT
*        Saves/restores any currently active gets, meaning this
*        calculator can be used from within a READ, which is the whole
*        intent: User gets to a field where they need to enter a GST
*        excluded price, but all they have is GST in, they pop up the calc
*        and work it out, then continue with the read.
*
* FUNCTION NEWCOLOR                        ... from ProClip
*        No big deal if you don't have this, just comment out the lines
*        and everything will work fine, except that the pop-up box will
*        not have a shadow.

* Suggested usage: Set a hot key to call this. With Get-it, you can hot-key
*    the calculator up in the midst of a READ. I use:
*
*         SET KEY 300 TO gst_calc
*
*  .. which pops it up on Alt-Z, a particularly convenient keystroke
*     combination.

* Note: The paste function assumes that the GST field is the
*       GET immediately after the current one.


PRIVATE gc_top, gc_left, gc_bottom, gc_right, gc_color, gc_done
PRIVATE gc_getlist, gc_screen, with_gst

gc_top    = MIN(row()+1,16)
gc_left   = MIN(col(),39)
gc_bottom = gc_top + 8
gc_right  = gc_left + 41
gc_color = SETCOLOR()
gc_done = .F.
gc_getlist = N_SAVEGETS()
SET COLOR TO n/bg, n/w

gc_screen = savescreen(gc_top, gc_left, gc_bottom+1, gc_right+1)
@gc_top, gc_left clea to gc_bottom, gc_right
@gc_top, gc_left to gc_bottom, gc_right
newcolor(gc_top, gc_right+1, gc_bottom+1, gc_right+1, "w/n+")
newcolor(gc_bottom+1, gc_left+1, gc_bottom+1, gc_right+1, "w/n+")
@gc_top+7, gc_left+2 say "  or enter a number and press <Return>"

with_gst = 0
do while ! gc_done
   @gc_top+1, gc_left+2 say "Price including GST: " GET with_gst PICT "999,999.99"
   READ
   IF LASTKEY() <> 27
      @gc_top+3, gc_left+2 say "Price without GST: "
      @gc_top+3, gc_left+25 say with_gst*100/107 PICT "99,999.99"
      @gc_top+4, gc_left+2 say "GST: "
      @gc_top+4, gc_left+25 say with_gst*7/107 PICT "99,999.99"
      @gc_top+6, gc_left+2 say "Press <esc> to quit, P to paste,"
      INKEY(0)
   ENDIF
   IF LASTKEY() = 27
         gc_done = .t.
   ELSEIF UPPER(CHR(LASTKEY())) = "P"
      keyboard ltrim(str(with_gst*100/107,12,2))+ltrim(str(with_gst*7/107,12,2))
      gc_done = .t.
   ENDIF
ENDDO
SETCOLOR(gc_color)
RESTSCREEN(gc_top, gc_left, gc_bottom+1, gc_right+1, gc_screen)
N_RESTGETS(gc_getlist)
RETURN .F.


