***************************************************
* Filename: Graph_it.prg
* Author  : Roger J. Donnay 
* Date    : June 23, 1987
*
* Notes   : This is a general purpose, menu-driven, bar-graphing 
*           program for use with dBaseIII or Clipper data files.
*
* GRAPH_IT is a free software program designed for use by dBaseIII
* and/or Clipper software developers.
*
* All users are granted a limited license to use GRAPH_IT in any 
* form for their own use or for integration into a larger system.
* All users may copy GRAPH_IT for the use of others subject to 
* the following conditions:
*
*   GRAPH_IT must be copied in unmodified form, complete with
*   this license information.
*
*   The full GRAPH-IT documentation must be included with the
*   copy.
*
*   No fee, charge or other compensation may be accepted or
*   requested by any licensee.
*
* Software developers may use, modify, and distribute GRAPH_IT
* only as a an integrated portion of a larger software system.
*
* Operators of electronic bulletin board systems (Sysops) may post
* GRAPH_IT for downloading by their users only as long as the 
* above conditions are met.
*
* Donnay Software systems makes no warranty of any kind, express
* or implied, including without limitation, any warranties of 
* merchantability and/or fitness for a particular purpose. Donnay
* Software Systems shall not be liable for damages, whether
* direct, indirect, special or consequential arising from a 
* failure of this program to operate in the manner desired by the
* user.  Donnay Software Systems shall not be liable for any damage
* to data or property which may be caused directly or indirectly
* by use of the program.
*
* We welcome your comments and hope you find GRAPH_IT to be a useful
* graphing utility for your applications.
*
* Address any inquiries or comments to:
*
* Roger J. Donnay
* Donnay Software Systems
* 6151 Jasonwood Dr.
* Huntington Beach, CA 92648
* (714) 841-6260
*
* See the USERS MANUAL section at the end of this file.
*
* Check to see that you have the complete, unaltered source.  This file
* is    265  lines,  11884  characters
***********************************************

SET PROC TO graph_pr
DO grphmenu
RETURN


**********************************
*
*  graph_it.prg  USERS MANUAL
*
*                    I N T R O D U C T I O N
* 
*  GRAPH_IT.PRG and GRAPH_PR.PRG are the complete source files for a 
*  general purpose bar-graphing system that draws database information 
*  on the screen in vertical or horizontal bars.
*
*  Graph_it runs under dBaseIII or can be compiled with any version
*  of Clipper.  Graph_it can be used as a complete menu-driven
*  system, or a portion of Graph_it can be called from your clipper
*  or dBaseIII programs.
*
*  Graph_it will draw up to 4 bars on the screen for each data record
*  in a file, increment the file, and continue until the screen is full.
*
*  FILES REQUIRED
*
*  The standalone, menu-driven system requires the following files:
*
*  GRAPH_IT.PRG  -  Calling program and documentation
*  GRAPH_PR.PRG  -  Procedure file with all graphing procedures/functions
*  GRAPH_IT.DBF  -  Data file for keeping your parameter tables
*  GRAPH_IT.FRM  -  Form file for printing parameter data
*
*  If you are calling only the "grphdraw" procedure, there are no data 
*  files required other that the data file you intend to graph.
*
*  GRAPH_IT.DBF is a parameter file which is maintained by the procedure
*  GRPHMENU.   GRAPH_IT.DBF has the following structure:
*               
*  Field  Field Name   Type   Width  Dec      Description
*  -----  ------------ -----  -----  ----   -------------------------------
*    1    GRPH_NMBR     C       4           Graph Number
*    2    TITLE         C      40           Graph Title
*    3    FILE_NAME     C       8           Name of Data file to use
*    4    INDX_NAME     C       8           Name of Index file to use
*    5    FILT_DESC     C      55           Filter to use (expression)
*    6    BARDESC_1     C      14           Description of Bar 1
*    7    BARDESC_2     C      14           Description of Bar 2
*    8    BARDESC_3     C      14           Description of Bar 3
*    9    BARDESC_4     C      14           Description of Bar 4
*   10    BAREXPR_1     C      45           Expression for Bar 1
*   11    BAREXPR_2     C      45           Expression for Bar 2
*   12    BAREXPR_3     C      45           Expression for Bar 3
*   13    BAREXPR_4     C      45           Expression for Bar 4
*   14    PDESC_1       C      14           Description of parameter
*   15    PARA_1        C      45           Expression for parameter
*   16    GTYPE         C       1           Type of graph to draw
*   17    BAR_INCR      N       7           Bar incremental value
*   18    P_SPACE       N       2           Spacing between parameters 
* 
*
*                       O P E R A T I O N
*
*  DRAWING GRAPHS FROM THE GRAPH MENU
*
*  To run Graph It from dBaseIII, just type DO GRAPH_IT.  A menu will
*  come up on the screen which will open the GRAPH_IT.DBF file and
*  provide you with selections for adding, editing or viewing parameters
*  required for graphing data files.  You can call the graph menu from
*  your own programs by entering the following commands:
*         
*           SET PROC TO graph_pr
*           DO grphmenu
*
*  CAUTION: When calling the Graph It menu, the work areas I and J
*           are used for the GRAPH_IT.DBF file and data file(s).
*           If you have open files in these areas they will be closed
*           when returning from the Graph It menu.
*
*  The graph parameters determine which data file and/or index file you
*  will be graphing.  After you have entered your parameters and selected
*  the graph you want to draw, just press key <J> and the graph will be
*  drawn on the screen.  After a full screen of data is displayed, you will
*  be prompted with a message to Quit, Continue, Goto a specific record,
*  or draw a numeric chart.  If you select quit, you will be returned to 
*  your menu and the current record in the data file will be one (1) record 
*  past the last record graphed.  If you select Continue, another screen 
*  of data will be graphed from the data file.  If you choose to Goto a
*  specific record, you will be asked the record number to start, and 
*  another screen will be graphed starting at the new record.  If you 
*  choose to draw a numeric chart, the screen will clear and a chart of
*  actual numeric data will be drawn on the screen corresponding to the
*  bar graph just previously drawn.   If you want to do a printout of both
*  the bar graph and numeric data, first draw the bar graph, print the 
*  screen, then draw the numeric graph and print the screen again for a
*  nice presentation of graphic and numeric data on the same printout.
*
*
*  DRAWING GRAPHS FROM OTHER PROGRAMS (Method 1)
*
*  You can draw a graph from within your own programs by first setting
*  up the variables that the graph program needs then calling the graph
*  drawing procedure by entering the command DO GRPHDRAW.  See the 
*  notes in the GRPHDRAW procedure for the parameters that must be set up
*  prior to calling the procedure.  You must first be sure that the
*  data you are graphing is a numeric expression, that the file containing
*  the numeric data is selected in the current workspace, and the record
*  pointer is on the record you want to start graphing from.
*
*  Example:  Let's assume you have a data file with numeric information
*            for the past 10 years pertaining to sales, expenses, and
*            profits.
*
*            The data file is named SALES.DBF and is consists of four
*            fields:  YEAR, MONTH, SALES, EXPENSES.
*
*            To plot both style graphs showing Sales and Profit for each
*            month of the year 1985, you would write the following
*            program:
*
*            SET PROC TO graph_pr
*            USE sales
*            SET FILTER TO year='1985'
*            GOTO TOP &&Start at first month of 1985
*            STOR 'Sales' TO mbardesc_1
*            STOR 'Profit' TO mbardesc_2
*            STOR 'SALES' TO mbarexpr_1
*            STOR 'SALES-EXPENSES' TO mbarexpr_2 && an expression for "profit"
*            STOR ' ' TO mbardesc_3,mbardesc_4,mbarexpr_3,mbarexpr_4
*            STOR '1985 Sales vs Profits Summary' TO mtitle
*            STOR 'Month' TO mpdesc_1
*            STOR 'MONTH' TO mpara_1
*            STOR 100000 TO mbar_incr
*            STOR 'V' TO gtype
*            STOR 5 TO mp_space
*            DO grphdraw  && Draw Vertical Bar Graph
*            GOTO TOP
*            STOR 'H' TO gtype
*            STOR 1 TO mp_space
*            DO grphdraw  && Draw Horizontal Bar Graph
*            RETURN
*
*  DRAWING GRAPHS FROM OTHER PROGRAMS (Method 2)
*
*  A simpler method for calling a graph is available, however it
*  requires that the graph parameters have been previously entered
*  into the GRAPH_IT.DBF data file.  This can be done by running
*  the program GRAPH_IT.PRG (DO GRAPH_IT) or by editing the GRAPH_IT.DBF
*  data file with dBaseiii utilities.  You can then graph your data
*  by the procedure GRPHDRW:
*
*            DO grphdrw WITH <Parameter 1> <Parameter 2>
*
*  where Parameter 1 is a string with the number of the graph you
*  want to draw (this string should equal the GRPH_NMBR field in the
*  GRAPH_IT.DBF file) and Parameter 2 is a logical .t. if the data file
*  to graph is already open and in the current workspace, or a logical
*  .f. if the data file to graph is defined by the FILE_NAME field in
*  the GRAPH_IT.DBF file).
*
*  Example 1 :  You have a data file named EXPENSES.DBF and you wish to graph
*               some numeric data for the year 1984.  The parameters to
*               graph have already been established in a record in the 
*               GRAPH_IT.DBF file with a Graph number of 'EXP1'. 
*               The file contains expense information for several years,
*               but you want to graph only 1984.  If Parameter 2 is a
*               logical .t., any filter information in the GRAPH_IT.DBF
*               parameter file will be ignored and the graph will start
*               at the current record.
*
*               USE expenses
*               SET FILTER TO year='1984'
*               GOTO TOP
*               DO grphdrw WITH 'EXP1',.T.
*
*  Example 2:   You want to graph all the information in the file
*               EXPENSES.DBF in accordance with any filter or index file
*               already named by the 'EXP1' graph in the GRAPH_IT.DBF
*               file.
*
*               DO grphdrw WITH 'EXP1',.F.
*
*
*  Graph It will draw consecutive records in the data file, therefore
*  if you want to exclude records, use a SET FILTER statement after
*  USEing the file.  The expressions used to calculate the drawn bars must
*  be valid dBaseIII expressions which include valid data fields and/or
*  other numeric information.   
*
*
******************************************
*
* BUGS IN EARLIER VERSIONS OF GRAPH_IT
*
* In versions date on or before 6-21-87, it was found that when running
* under Rev. 1.0 of dBaseiii a PROCEDURE FILE ALREADY OPEN error was
* encountered because the calling program and procedures were in the same
* file.  This revision is distributed in two files to prevent this
* occurence.
*
* Some procedures have new names due to the improved features over
* earlier versions.  Check the names of the procedures before using
* this version if you have been using an earlier version.
*
********************************
* end of file
