*.............................................................................
*
*   Program Name: GLLIBR.CH        Created By: Global Technologies Corporation
*   Date Created: 06/05/90           Language: Clipper 5.0
*   Time Created: 11:27:44             Author: Bill French                               
*
*   The Graphics Language - Copyright (c) 1990,1991 - Bits Per Second Ltd.
*            In Association With Global Technologies Corporation
*
*.............................................................................
#define     Void                    NIL          // function return default
#define     PointsPerLine           41.666       // points per line in the dGE screen
#define     PointsPerColumn         17.088       // points per column in the dGE screen
#define     IconShadowOffsetD       .2           // down shift offset for icon shadowing
#define     IconShadowOffsetR       .5           // right shift offset for icon shadowing

#define     PieLabelOffSet          3            // default pie chart label offset (chrs)
#define     PieChartRadius          8            // default chart radius (rows)
#define     BarChartWidth           60           // default bar chart width (chrs)
#define     BarChartHeight          20           // default bar chart height (rows)
#define     BarXLabels              0            // set the x labels to horizontal(1=vertical)

#define     MaxScreens              20           // maximum number of screen handles
#define     MaxHandles              70           // maximum number of object handles
#define     NullString              ""
#define     NullInteger             00

#define     NoSuchLabel             01           // error number for label not found
#define     NoHandlesLeft           02           // error number for no unused handles left
#define     NoMemoryLeft            03           // error number for no video memory left 
#define     NoMouseDriver           04           // error number for no mouse driver
#define     NoSuchHandle            05           // error number for no handle
#define     NoLabelsLeft            06           // error number for no more labels

#define     ShadowOn                .T.          // various preprocessor assignments
#define     ShadowOff               .F.
#define     FlashOn                 .T.
#define     FlashOff                .F.
#define     InactiveObject          .F.
#define     ActiveObject            .T.

#define     IconButtonObject        01           // various object numbers
#define     TextButtonObject        02
#define     EventRegionObject       03
#define     BoxButtonObject         04

#define     UpperLeftBevelColor     "w+/"
#define     LowerRightBevelColor    "n+/"
#define     BevelSurfaceColor       "b/"
#define     BevelFrameColor         "w+/"

#define     TRUE                    .T.          // various std constants
#define     FALSE                   .F.


// SET GRAPHICS --------------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command switches the screen mode from text to graphics via the dGE
// high resolution function.  This command must be executed before any other
// graphics commands are encountered.  Once you leave the graphics mode via
// the command SET GRAPHICS OFF, you must re-establish the environment once
// again.  The button GET array and the screen will be erased.  See the 
// Technical Reference section for more details about the button GET list 
// array.
// 
// Syntax:
// SET GRAPHICS [ON] [OFF]
//
// Arguments:
// <ON> change to graphical mode.
// <OFF> change to text mode.
//    
// Example:
// SET GRAPHICS ON                           // switch from text to graphics
//    
//          Purpose: Initialize and establish graphics mode
//  Mapped Function: __SetGraphics() contained in GLLIBR.PRG.
//    dGE functions: sethires(),settext()
//    Other GL UDFs: None.
// System variables: _handles_[],_eshadow_,_icnfile_,_dgepath_,_icnwidt_
//                   _icnheig_
// System constants: MaxHandles
//
// See Also:
// 
#command    SET GRAPHICS ;                       // Completed 12-24-90
                  [<gon: ON>] ;
                  [OFF] ;
               => __SetGraphics(<.gon.>)


// SET VIDEO TO --------------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command selects the desired graphics mode and operates slightly
// different when using the memory-resident drivers.  It only supports 
// EGA and VGA.
// 
// Syntax:
// SET VIDEO TO [EGA] [VGA]
//
// Arguments:
// <video> is the graphics video mode, either EGA or VGA.  The graphics
//   language does not support any other video modes.
//
// Example:
// SET VIDEO TO VGA                          // establish vga support mode
//    
//          Purpose: Change the default video mode
//  Mapped Function: __SetVideo() contained in GLLIBR.PRG.
//    dGE functions: setvideo()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET VIDEO TO ;                       // Completed 12-24-90
                  <video> ;
               => __SetVideo(<"video">)


// SET DGE RESOURCES TO ------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command enables your applications to find dGE supporting files such
// as character sets, icon files, and super font files in directories other
// than the current one.  The search hierarhy is based first on a specified
// SET DGE RESOURCES command. If a RESOURCES command has not been issued, the 
// search for resource files continues with a look at the DOS environment for
// a DGE environment variable.  Lacking an environmnt variable, the current 
// directory is assumed to be the location of all resource files.  Note that 
// like other Grahics Language commands, SET DGE RESOURCES must be used after 
// SET GRAPHICS ON has been issued.
// 
// Syntax:
// SET DGE RESOURCES TO <reourcepath>
//
// Arguments:
// <resourcepath> must include a valid path and optionally preceeded by a 
//   disk drive letter.  Complex expressions are supported.
//    
// Example:
// SET DGE RESOURCES TO C:\DGE               // establish resources path
//    
//          Purpose: Set the path to dGE resources
//  Mapped Function: __SetResources() contained in GLLIBR.PRG.
//    dGE functions: None.
//    Other GL UDFs: None.
// System variables: _dgepath_
// System constants: None.
//
// See Also:
// 
#command    SET DGE RESOURCES TO ;               // Completed 12-24-90
                  <resourcepath> ;
               => __SetResources(<"resourcepath">)


// SET PALETTE BACKGROUND ----------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command allows you to change the background color of the graphics 
// screen in dGE.  The color is specified in normal Clipper syntax.
// 
// Syntax:
// SET PALETTE BACKGROUND TO [BRIGHT] <color>
//
// Arguments:
// <BRIGHT> will set the specified color to a bright status.
// <color> is a standard Clipper color code.
//    
// Example:
// SET PALETTE BACKGROUND TO BRIGHT BLUE  // establish bright blue bkgrnd
//    
//          Purpose: Set the graphics background color
//  Mapped Function: __SetPalette() contained in GLLIBR.PRG.
//    dGE functions: setpal()
//    Other GL UDFs: __WordToColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET PALETTE BACKGROUND TO ;          // Completed 12-24-90
                  [[<bri: BRIGHT>] <color>] ;
               => __SetPalette(<"color">,if(<.bri.>,"BRIGHT ",""))

// CLEAR GRAPHICS SCREEN -----------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command clears the screen while in graphics mode.  It performs 
// the same function in graphics mode as CLEAR SCREEN does in text mode.                  
//
// Syntax:
// CLEAR GRAPHICS SCREEN
//
// Arguments:
// None.
//    
// Example:
// CLEAR GRAPHICS SCREEN                     // clear the graphics screen
//    
//          Purpose: Clear the graphics screen
//  Mapped Function: __ClearGScreen() contained in GLLIBR.PRG.
//    dGE functions: clrscreen()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    CLEAR GRAPHICS SCREEN ;              // Completed 12-24-90
               => __ClearGScreen()


// CLEAR GRAPHICS WINDOW -----------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command clears a specific area of the screen.
// 
// Syntax:
// CLEAR GRAPHICS WINDOW FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>
//
// Arguments:
// <Pos1_a> is the upper left row screen coordinate from 0 to 24.
// <Pos1_b> is the upper left column screen coordinate from 0 to 79.
// <Pos2_a> is the lower right row screen coordinate from 0 to 24.
// <Pos2_b> is the lower right column screen coordinate from 0 to 79.
// [BEVEL] will clear an area that contains a beveled box which has
//   dimensions slightly larger than the originally specified frame.
//    
// Example:
// CLEAR GRAPHICS WINDOW FROM 10,10 TO 20,20 // clear a 10 by 10 window   
//    
//          Purpose: Clear a window area
//  Mapped Function: __ClearGWindow() contained in GLLIBR.PRG.
//    dGE functions: clrwin()
//    Other GL UDFs: __XDge(),__YDge()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    CLEAR GRAPHICS WINDOW FROM ;         // Completed 12-24-90
                  <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>;
                  [<bev: BEVEL>] ;
               => __ClearGWindow(<Pos1_a>,<Pos1_b>,<Pos2_a>,<Pos2_b>,<.bev.>)


// RESET GRAPHICS ARRAY ------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command resets the dGE internal graphingn in preparation for new data
// to be charted.
//
// Syntax:
// RESET GRAPHICS ARRAY
//
// Arguments:
// None.
//    
// Example:
// RESET GRAPHICS ARRAY
//
//          Purpose: Clear the dGE graphics array
//  Mapped Function: __ResetGArray() contained in GLLIBR.PRG.
//    dGE functions: datareset()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    RESET GRAPHICS ARRAY ;               // Complete 12-26-90
               => __ResetGArray()


// SCALE GRAPHICS ARRAY ------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command adjusts the data currently stored in the dGE internal 
// charting so that charts can be presented in a meaningful way.
//
// Syntax:
// SCALE GRAPHICS ARRAY TO <percent> 
//
// Arguments:
// <percent> is the percentage to scale the data stored in the internal dGE 
// charting array.
//    
// Example:
// SCALE GRAPHICS ARRAY TO 70
//
//          Purpose: Scale the dGE graphics array
//  Mapped Function: __ScaleGArray() contained in GLLIBR.PRG.
//    dGE functions: datapc()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SCALE GRAPHICS ARRAY TO ;            // Complete 12-26-90
                  <percent> ;
               => __ScaleGArray(<percent>)


// SET DRAWING AREA -----------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command will establish a window that will prohibit any drawing to
// occur outside.  It is a simple way to confine the display of graphical
// objects.
//
// Syntax:
// SET DRAWING AREA
//    [FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>]
//
// Arguments:
// <Pos1_a> is the upper left row screen coordinate of the box.
// <Pos1_b> is the upper left column screen coordinate of the box.
// <Pos2_a> is the lower right row screen coordinate of the box.
// <Pos2_b> is the lower right column screen coordinate of the box.
//
// Example:
// SET DRAWING AREA FROM <Pos1_a>,<Pos1_b> ; // define a drawing area
//    TO <Pos2_a>,<Pos2_b>
//    
//          Purpose: Restrict drawing to a window area
//  Mapped Function: __SetDrawArea() contained in GLLIBR.PRG.
//    dGE functions: clipwin()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET DRAWING AREA ;                  // Completed 12-28-90
                  [FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>];
               => __SetDrawArea(<Pos1_a>,<Pos1_b>,<Pos2_a>,<Pos2_b>)


// SAVE GRAPHICS SCREEN -------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command will save a specific portion of the graphics screen in
// similar fashion to Clipper's SAVE and RESTORE SCREEN commands.  There
// are certain limitations to dGE's ability to save and restore screen
// regions so read carefully about SNAPCOPY() before using this feature.
// The maximum number of screen saves that are possible is limited by
// default to 20, however, this can be changed by modifying the pre-
// processor constant MaxScreens in this file.
//
// Syntax:
// SAVE GRAPHICS SCREEN <label> FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>
//
// Arguments:
// <label> is a name tag that identifies the screen for later recall.
// <Pos1_a> is the upper left row screen coordinate of the box.
// <Pos1_b> is the upper left column screen coordinate of the box.
// <Pos2_a> is the lower right row screen coordinate of the box.
// <Pos2_b> is the lower right column screen coordinate of the box.
//
// Example:
// SAVE GRAPHICS SCREEN "scr_one" ;          // save screen ONE
//    FROM <Pos1_a>,<Pos1_b> ;
//    TO <Pos2_a>,<Pos2_b>
//    
//          Purpose: Save an area of the graphics screen
//  Mapped Function: __SaveGScreen() contained in GLLIBR.PRG.
//    dGE functions: snapcopy()
//    Other GL UDFs: None.
// System variables: _screens_[]
// System constants: MaxScreens
//
// See Also:
// RESTORE GRAPHICS SCREEN
// 
#command    SAVE GRAPHICS SCREEN <label> ;      // Completed 12-28-90
                  FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>;
               => __SaveGScreen(<label>,<Pos1_a>,<Pos1_b>,<Pos2_a>,<Pos2_b>)


// RESTORE GRAPHICS SCREEN ----------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command restores previously saved areas of the graphics screen that
// were captured with the SAVE GRAPHICS SCREEN command.  To restore an area,
// you must specify the label that the area was originally saved under.
//
// Syntax:
// RESTORE GRAPHICS SCREEN <label>
//
// Arguments:
// <label> is a name tag that the screen was originally saved under.
//
// Example:
// RESTORE GRAPHICS SCREEN "scr_one" ;       // restore screen "scr_one"
//    
//          Purpose: Restore a previously saved area of the graphics screen
//  Mapped Function: __RestGScreen() contained in GLLIBR.PRG.
//    dGE functions: snappaste()
//    Other GL UDFs: None.
// System variables: _screens_[]
// System constants: MaxScreens
//
// See Also:
// SAVE GRAPHICS SCREEN
// 
#command    RESTORE GRAPHICS SCREEN <label>;     // Completed 12-28-90
               => __RestGScreen(<label>)


// SHADE AREA AT -------------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command will fill the area surrounding the row/column position out 
// to the boundaries.  It uses dGE's shade() function and therefore requires 
// that a graphical boundary exist.
//
// Syntax:
// SHADE ARE AT <Pos1>,<Pos2>
//
// Arguments:
// <Pos1> is the row screen coordinate inside the area to be shaded.
// <Pos2> is the column screen coordinate inside the area to be shaded.
// <pattern> is the dGE pattern number from 0 to 20.
//    
// Example:
// SHADE ARE AT 10,20
//
//          Purpose: Draw a shaded area
//  Mapped Function: __ShadeArea() contained in GLLIBR.PRG.
//    dGE functions: None.
//    Other GL UDFs: __XdGE(),__YdGE(),__DgeColor()
// System constants: None.
//
// See Also:
// 
#command    SHADE AREA AT ;                      // Complete 12-26-90
                  <Pos1>,<Pos2> ;
                  [PATTERN <pattern>] ;
               => __ShadeArea(<Pos1>,<Pos2>,<pattern>)


// DRAW BOX FROM -------------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command will draw a box from the specified upper left coordinates
// to the specified lower right coordinates using a single line.  
// Optionally, the box can be filled with a specified dGE pattern from 0 to
// 20.  Unless a pattern is specified, the box will be clear.
//
// Syntax:
// DRAW BOX FROM <Pos1_a>,Pos1_b> TO <Pos2_a>,<Pos2_b> ;
//    [PATTERN <pattern>] 
//    [BEVEL] 
//
// Arguments:
// <Pos1_a> is the upper left row screen coordinate of the box.
// <Pos1_b> is the upper left column screen coordinate of the box.
// <Pos2_a> is the lower right row screen coordinate of the box.
// <Pos2_b> is the lower right column screen coordinate of the box.
// <pattern> is the dGE pattern number for the interior of the box.
// [BEVEL] will cause the box to have three dimensional characteristics
//   as though it was a raised button.
//    
// Example:
// DRAW BOX FROM 05,02 TO 20,77 PATTERN 7    // draw a pattern filled box
//
//          Purpose: Draw a box
//  Mapped Function: __DrawFrame() contained in GLLIBR.PRG.
//    dGE functions: boxfill()
//    Other GL UDFs: __XdGE(),__YdGE(),__XdGE_(),__YdGE_(),__DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW BOX FROM ;                      // Complete 12-26-90
                  <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b> ;
                  [PATTERN <pattern>] ;
                  [<bev: BEVEL>] ;
               => __DrawFrame(<Pos1_a>,<Pos1_b>,<Pos2_a>,<Pos2_b>,<pattern>,<.bev.>)


// DRAW CIRCLE AT ------------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command will draw a circle at the specified row/column coordinates
// with a radius of <Pos2> characters.  The circle will be drawn with a 
// solid line.
//
// Syntax:
// DRAW CIRCLE AT <Pos1>,<Pos2> RADIUS <radius> 

// Arguments:
// <Pos1> is the center point row screen coordinate from 0 to 24.
// <Pos2> is the center point column screen coordinate from 0 to 79.
// <radius> is the radius in <Pos2> coordinates from the center point.
//    
// Example:
// DRAW CIRCLE AT 12,40 RADIUS 4
//
//          Purpose: Draw a circle
//  Mapped Function: __DrawCircle() contained in GLLIBR.PRG.
//    dGE functions: drawcircle()
//    Other GL UDFs: __XdGE(),__YdGE(),__XdGE_(),__DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW CIRCLE AT ;                     // Complete 12-26-90
               <Pos1>,<Pos2> RADIUS <radius> ;
               => __DrawCircle(<Pos1>,<Pos2>,<radius>)


// DRAW LINE FROM ------------------------------------------------------------
// TecGuide-> {Language Ref::Graphical Commands::UDC}
// 
// Description:
// This command will draw a solid line from Pos1__a,Pos1_b to Pos2_a,Pos2_b.
// Optionally, the BROKEN clause will draw a dotted line.
//
// Syntax:
// DRAW LINE FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b> [<BROKEN>] 
//
// Arguments:
// <Pos1_a> is the starting row screen coordinate of the line.
// <Pos1_b> is the starting column screen coordinate of the line.
// <Pos2_a> is the ending row screen coordinate of the line.
// <Pos2_b> is the ending column screen coordinate of the line.
// <BROKEN> causes the line to be dotted.
//    
// Example:
// DRAW LINE FROM 05,02 TO 20,77 [<BROKEN>] 
//
//          Purpose: Draw a line
//  Mapped Function: __DrawLine() contained in GLLIBR.PRG.
//    dGE functions: drawline()
//    Other GL UDFs: __DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW LINE FROM ;                     // Complete 12-26-90
                  <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b> ;
                  [<bro: BROKEN>] ;
               => __DrawLine(<Pos1_a>,<Pos1_b>,<Pos2_a>,<Pos2_b>, ;
                  if(<.bro.>,1,0) ;
                  )


// SET CHARACTER SET ---------------------------------------------------------
// TecGuide-> {Language Ref::String Commands::UDC}
// 
// Description:
// This command lets you easily switch character fonts. Since superfonts are
// usually desired, there is no command control of the dGE font buffers 0 and
// 1.  The font file that corresponds to the selected font type and size must
// be available in the current path or in the path specified by the DGE en-
// vironment variable or in the SET DGE RESOURCES command.
//
// Syntax:
// SET CHARACTER SET TO <type> <size>
//
// Arguments:
// <type> is either SYSTEM, ROMAN, or SWISS.
// <size> is either SMALL, STANDARD, or the four digit character font number.
//    
// Example:
// SET CHARACTER SET TO SYSTEM SMALL         // select small system chr set
//
//          Purpose: Select a character set and size
//  Mapped Function: __SetCSet() contained in GLLIBR.PRG.
//    dGE functions: loadcset()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET CHARACTER SET TO ;               // Completed 12-24-90
                  <type> ;
                  [<size>] ;
               => __SetCSet(<"type">,<"size">)


// DRAW <string> AT ----------------------------------------------------------
// TecGuide-> {Language Ref::String Commands::UDC}
// 
// Description:
// This command will draw text at a specified row and column position using
// the current character set unless specified following the USING clause.
// Additionally, text can be diplayed in a vertical format by simply adding
// the VERTICAL option, or horizontally cenetered with the CENTER option.
//
// Syntax:
// DRAW <string> AT <Pos1>,<Pos2> USING <type> <size>
//
// Arguments:
// <string> is the text to be drawn in graphics mode.
// <Pos1> is the row coordinate 0 to 24.
// <Pos2> is the column coordinate 0 to 79.
// <type> is the character font system, roman, or swiss.
// <size> is the character font size specified as small, standard, or the
//   character font number.
// <VERTICAL> is stated to display the text in a vertical mode.  Horizontal
//   is the default mode.
// <CENTER> is used to display the text in centered mode at the point of
//   origin.
// <RIGHT> is used to display the text in right justified mode at the point
//   of origin.
//    
// Example:
// DRAW "The Graphics Language" AT 02,30 USING system 1609
//
//          Purpose: Draw a text string
//  Mapped Function: __DrawText() contained in GLLIBR.PRG.
//    dGE functions: saystring()
//    Other GL UDFs: __SetCSet(),__XdGE(),__YdGE(),__DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW <string> AT <Pos1>,<Pos2> ;     // Completed 12-24-90
                  [USING <type> <size>] ;
                  [<ver: VERTICAL>] ;
                  [<cen: CENTER,CENTRE>] ;
                  [LEFT] ;                       // no-op command
                  [<rig: RIGHT>] ;
               => __DrawText(<string>, ;
                  <Pos1>, ;
                  <Pos2>, ;
                  <"type">, ;
                  <"size">, ;
                  if(<.ver.>,1,0), ;
                  if(<.cen.>,8,0), ;
                  if(<.rig.>,16,0) ;
                  )


// @ <pos1>,<pos2> DRAW <string> ---------------------------------------------
// TecGuide-> {Language Ref::String Commands::UDC}
// 
// Description:
// This command will draw text at a specified row and column position using
// the current character set unless specified following the USING clause.
// Additionally, text can be diplayed in a vertical format by simply adding
// the VERTICAL option, or horizontally cenetered with the CENTER option.
//
// Syntax:
// @ <pos1>,<pos2> DRAW <string> USING <type> <size>
// 
//
// Arguments:
// <string> is the text to be drawn in graphics mode.
// <Pos1> is the row coordinate 0 to 24.
// <Pos2> is the column coordinate 0 to 79.
// <type> is the character font system, roman, or swiss.
// <size> is the character font size specified as small, standard, or the
//   character font number.
// <VERTICAL> is stated to display the text in a vertical mode.  Horizontal
//   is the default mode.
// <CENTER> is used to display the text in centered mode at the point of
//   origin.
// <RIGHT> is used to display the text in right justified mode at the point
//   of origin.
//    
// Example:
// @ 02,30 DRAW "The Graphics Language" USING system 1609
//
//          Purpose: Draw a text string
//  Mapped Function: __DrawText() contained in GLLIBR.PRG.
//    dGE functions: saystring()
//    Other GL UDFs: __SetCSet(),__XdGE(),__YdGE(),__DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    @ <Pos1>,<Pos2> DRAW <string> ;      // Completed 12-24-90
                  [USING <type> <size>] ;
                  [<ver: VERTICAL>] ;
                  [<cen: CENTER,CENTRE>] ;
                  [LEFT] ;                       // no-op command
                  [<rig: RIGHT>] ;
               => __DrawText(<string>, ;
                  <Pos1>, ;
                  <Pos2>, ;
                  <"type">, ;
                  <"size">, ;
                  if(<.ver.>,1,0), ;
                  if(<.cen.>,8,0), ;
                  if(<.rig.>,16,0) ;
                  )


// CLEAR PREVIOUS STRING -----------------------------------------------------
// TecGuide-> {Language Ref::String Commands::UDC}
// 
// Description:
// This command will erase the most recent string display accomplished with
// dGE's saystring() function or the DRAW <string> command.  The cleared area
// will not disturb the background color established by SET PALETTE.
//
// Syntax:
// CLEAR PREVIOUS STRING
//
// Arguments:
// None.
//    
// Example:
// CLEAR PREVIOUS STRING                  // clear the most recent text draw
//
//          Purpose: Clear the previous text draw
//  Mapped Function: 
//    dGE functions: clrstring()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    CLEAR PREVIOUS STRING ;              // Completed 12-24-90
               => clrstring()


// SET PROMPT DELIMITER ------------------------------------------------------
// TecGuide-> {Language Ref::String Commands::UDC}
// 
// Description:
// This command establishes the delimiter character for use with the dGE
// getstring() and edstring() functions.
//
// Syntax:
// SET PROMPT DELIMITER TO <character>
//
// Arguments:
// <character> is the character to be used as the prompt delimiter.
//    
// Example:
// SET PROMPT DELIMITER TO ":"               // set the dGE prompt delimiter
//
//          Purpose: Set the prompt delimiter character
//  Mapped Function: __SetDelimiter() contained in GLLIBR.PRG.
//    dGE functions: setdelim()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET PROMPT DELIMITER TO ;            // Completed 12-24-90
                  <character> ;
               => __SetDelimiter(<"character">)


// SET ICON ------------------------------------------------------------------
// TecGuide-> {Language Ref::Icon Commands::UDC}
// 
// Description:
// This command establishes the current super icon file that is used for all
// subsequent icon drawings.  The icon files included with the Graphics
// Language are named ICONS000.ICO through ICONS010.ICO and include various
// icons for use in menu design and development.  Each ICO file contains 8
// icons and can be modified with dGE's GFONT font editor. 
//
// Syntax:
// SET ICON TO <iconfile>
//
// Arguments:
// <iconfile> is the name of an icon file that is loaded into the current
//   icon buffer.
//    
// Example:
// SET ICON TO SAMPLE.ICO                    // select an icon file for use
//
//          Purpose: Select an icon file for use
//  Mapped Function: __SetIcon() contained in GLLIBR.PRG.
//    dGE functions: loadicon()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET ICON TO ;                        // Complete 12-24-90
                  [<iconfile>] ;
                => __SetIcon(<"iconfile">)


// @ <Pos1>,<Pos2> DRAW STD ICON ----------------------------------------------
// TecGuide-> {Language Ref::Icon Commands::UDC}
// 
// Description:
// This command displays internal dGE icons in graphical mode.  Standard
// icons are resident in dGE and can be displayed at any time by simply 
// specifying the internal icon number.
//
// Syntax:
// @ <Pos1>,<Pos2> DRAW [STD] [STANDARD] ICON <icon>
//    [VECTOR] [XOR]
//
// Arguments:
// [STANDARD] or [STD] is specified to indicate that icons are to be
//   selected from the standard resident dGE icons.
// <icon> is the icon number to be drawn from 0 to 7.
// <Pos1> is the x screen coordinate from 0 to 24.
// <Pos2> is the y screen coordinate from 0 to 79.
// [<VECTOR>] sets the origin in length/angle format or "vector" mode.
//   The default origin is cartesion or "x/y" mode.
// [<XOR>] sets the xor mode.
//    
// Example:
// @ 10,20 DRAW STD ICON 7                   // display current icon # 7
//
//          Purpose: Display one of eight standard dGE icons
//  Mapped Function: __DrawStdIcon() contained in GLLIBR.PRG.
//    dGE functions: drawicon()
//    Other GL UDFs: __DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    @ <Pos1>,<Pos2> DRAW [STANDARD] [STD] ICON <icon> ;  // Complete 12-24-90
                  [<vec: VECTOR>] ;
                  [<xor: XOR>] ;
               => __DrawStdIcon(<icon>, ;
                  <Pos1>, ;
                  <Pos2>, ;
                  <.vec.>, ;
                  <.xor.> ;
                  )


// DRAW STD ICON <icon> -------------------------------------------------------
// TecGuide-> {Language Ref::Icon Commands::UDC}
// 
// Description:
// This command displays internal dGE icons in graphical mode.  Standard
// icons are resident in dGE and can be displayed at any time by simply 
// specifying the internal icon number.
//
// Syntax:
// DRAW [STD] [STANDARD] ICON <icon> AT <Pos1>,<Pos2>
//    [VECTOR] [XOR]
//
// Arguments:
// [STANDARD] or [STD] is specified to indicate that icons are to be
//   selected from the standard resident dGE icons.
// <icon> is the icon number to be drawn from 0 to 7.
// <Pos1> is the x screen coordinate from 0 to 24.
// <Pos2> is the y screen coordinate from 0 to 79.
// [<VECTOR>] sets the origin in length/angle format or "vector" mode.
//   The default origin is cartesion or "x/y" mode.
// [<XOR>] sets the xor mode.
//    
// Syntax:
// DRAW [STANDARD] [STD] ICON <icon> AT <Pos1>,<Pos2> 
//   [<VECTOR>]
//   [<XOR>]
//
// Example:
// DRAW STD ICON 7 AT 10,20                  // display current icon # 7
//
//          Purpose: Display one of eight standard dGE icons
//  Mapped Function: __DrawStdIcon() contained in GLLIBR.PRG.
//    dGE functions: drawicon()
//    Other GL UDFs: __DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW [STANDARD] [STD] ICON <icon> AT ;  // Complete 12-24-90
                  <Pos1>,<Pos2> ;
                  [<vec: VECTOR>] ;
                  [<xor: XOR>] ;
               => __DrawStdIcon(<icon>, ;
                  <Pos1>, ;
                  <Pos2>, ;
                  <.vec.>, ;
                  <.xor.> ;
                  )


// @ <Pos1>,<Pos2> DRAW SUPER ICON --------------------------------------------
// TecGuide-> {Language Ref::Icon Commands::UDC}
// 
// Description:
// This command displays a selection from the current super icon file loaded
// with the most recent SET ICON TO <iconfile> command.  Super icons can be
// created and modified using dGE's GFONT font editor.
//
// Syntax:
// @ <Pos1>,<Pos2> DRAW SUPER ICON <icon>
//   [VECTOR]
//   [REPLACE] 
//   [OR] 
//   [BLACK] 
//   [INVERSE] 
//   [COMPOSITE]
//   [OVERLAY <color1> <color2> <color3> <color4>]
//
// Arguments:
// <icon> is the icon number to be displayed from 0 to 7.
// <Pos1> is the row screen coordinate from 0 to 24.
// <Pos2> is the column screen coordinate from 0 to 79.
// [VECTOR] sets the origin in length/angle format or "vector" mode.  The 
//   default origin is Cartesion or "x/y" mode.
// [REPLACE] sets the replace mode.
// [OR] sets the or mode.
// [BLACK] sets the black mode.
// [INVERSE] sets the inverse mode.
// [COMPOSITE] draws 4 icons at the centerpoint <Pos1>,<Pos2> without
//   overlaying the images.
// [OVERLAY <color1> <color2> <color3> <color4>] displays an overlay of
//   icons in positions 0 through 3 or 4 through 7 using the colors speci-
//   fied in the tokens 1 through 4.
//    
// Example:
// @ 10,20 DRAW SUPER ICON 7                 // display super icon # 7
//
//          Purpose: Display one or more of eight current super icons
//  Mapped Function: __DrawSuperIcon() contained in GLLIBR.PRG.
//    dGE functions: drawicon()
//    Other GL UDFs: __DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    @ <Pos1>,<Pos2> DRAW SUPER ICON <icon> ;  // Complete 12-28-90
                  [<vec: VECTOR>] ;
                  [<rep: REPLACE>] ;
                  [<orr: OR>] ;
                  [<bla: BLACK>] ;
                  [<inv: INVERSE>] ;
                  [<com: COMPOSITE>] ;
                  [OVERLAY <p1> <p2> <p3> <p4>] ;
               => __DrawSuperIcon(<icon>, ;
                  <Pos1>, ;
                  <Pos2>, ;
                  <.vec.>, ;
                  <.rep.>, ;
                  <.orr.>, ;
                  <.bla.>, ;
                  <.inv.>, ;
                  <.com.>, ;
                  <p1>, ;
                  <p2>, ;
                  <p3>, ;
                  <p4>  ;
                  )


// DRAW SUPER ICON <icon> -----------------------------------------------------
// TecGuide-> {Language Ref::Icon Commands::UDC}
// 
// Description:
// This command displays a selection from the current super icon file loaded
// with the most recent SET ICON TO <iconfile> command.  Super icons can be
// created and modified using dGE's GFONT font editor.
//
// Syntax:
// @ <Pos1>,<Pos2> DRAW SUPER ICON <icon>
//   [VECTOR]
//   [REPLACE] 
//   [OR] 
//   [BLACK] 
//   [INVERSE] 
//   [COMPOSITE]
//   [OVERLAY <color1> <color2> <color3> <color4>]
//
// Arguments:
// <icon> is the icon number to be displayed from 0 to 7.
// <Pos1> is the row screen coordinate from 0 to 24.
// <Pos2> is the column screen coordinate from 0 to 79.
// [VECTOR] sets the origin in length/angle format or "vector" mode.  The 
//   default origin is Cartesion or "x/y" mode.
// [REPLACE] sets the replace mode.
// [OR] sets the or mode.
// [BLACK] sets the black mode.
// [INVERSE] sets the inverse mode.
// [COMPOSITE] draws 4 icons at the centerpoint <Pos1>,<Pos2> without
//   overlaying the images.
// [OVERLAY <color1> <color2> <color3> <color4>] displays an overlay of
//   icons in positions 0 through 3 or 4 through 7 using the colors speci-
//   fied in the tokens 1 through 4.
//    
// Example:
// DRAW SUPER ICON 7 AT 10,20                // display super icon # 7
//
//          Purpose: Display one of eight current super icons
//  Mapped Function: __DrawSuperIcon() contained in GLLIBR.PRG.
//    dGE functions: drawicon()
//    Other GL UDFs: __DgeColor()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW SUPER ICON <icon> ;             // Complete 12-24-90
                  AT <Pos1>,<Pos2> ;
                  [<vec: VECTOR>] ;
                  [<rep: REPLACE>] ;
                  [<orr: OR>] ;
                  [<bla: BLACK>] ;
                  [<inv: INVERSE>] ;
                  [<com: COMPOSITE>] ;
                  [OVERLAY <p1> <p2> <p3> <p4>] ;
               => __DrawSuperIcon(<icon>, ;
                  <Pos1>, ;
                  <Pos2>, ;
                  <.vec.>, ;
                  <.rep.>, ;
                  <.orr.>, ;
                  <.bla.>, ;
                  <.inv.>, ;
                  <.com.>, ;
                  <p1>, ;
                  <p2>, ;
                  <p3>, ;
                  <p4>  ;
                  )


// SET GRAPHICS PRINT ---------------------------------------------------------
// TecGuide-> {Language Ref::Printer Commands::UDC}
// 
// Description:
// This command will establish a printer device and channel for all printer
// output.
//
// Syntax:
// SET GRAPHICS PRINT TO <device>
//
// Arguments:
// LPT1, LPT2, LPT3, COM1, or COM2.
//
// Example:
// SET GRAPHICS PRINT TO com1             // send output to serial, com1
//    
//          Purpose: Establish the print device and channel
//  Mapped Function: __SetPrintDevice() contained in GLLIBR.PRG.
//    dGE functions: prndev()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET GRAPHICS PRINT TO ;              // Complete 12-28-90
                  [<lpt1: LPT1>] ;
                  [<lpt2: LPT2>] ;
                  [<lpt3: LPT3>] ;
                  [<com1: COM1>] ;
                  [<com2: COM2>] ;
               => __SetPrintDevice( ;
                  <.lpt1.>, ;
                  <.lpt2.>, ;
                  <.lpt3.>, ;
                  <.com1.>, ;
                  <.com2.> ;
                  )


// PRINT IMAGE TO MATRIX -----------------------------------------------------
// TecGuide-> {Language Ref::Printer Commands::UDC}
// 
// Description:
// This command prints the current graphical screen image to a dot matrix 
// printer.
//
// Syntax:
// PRINT IMAGE TO MATRIX 
//
// Arguments:
// None.
//    
// Example:
// PRINT IMAGE TO MATRIX 
//
//          Purpose: Print the screen to a matrix printer
//  Mapped Function: __PrintMatrix() contained in GLLIBR.PRG.
//    dGE functions: printscr()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    PRINT IMAGE TO MATRIX ;              // Complete 12-27-90
               => __PrintMatrix()


// PRINT IMAGE TO LASER ------------------------------------------------------
// TecGuide-> {Language Ref::Printer Commands::UDC}
// 
// Description:
// This command prints the current graphical screen to a laser printer.
//
// Syntax:
// PRINT IMAGE TO LASER 
//    [<RESET>] 
//    [<FORMFEED>] 
//    [<ASPECT>] 
//    [<PAINTJET>]
//    [<BWPAINTJET>]
//    [<LANDSCAPE>]
//    [<REVERSE>]
//    [HORIZONTAL OFFSET <hoffset>]
//    [VERTICAL OFFSET <voffset>]
//    [DENSITY <density>]
//
// Arguments:
// <RESET>
// <FORMFEED>
// <ASPECT>
// <PAINTJET>
// <BWPAINTJET>
// <LANDSCAPE>
// <REVERSE>
// <hoffset>
// <voffset>
// <density>
//    
// Example:
// PRINT IMAGE TO LASER FORMFEED
//
//          Purpose: Print the screen to a laser printer
//  Mapped Function: __PrintLaser() contained in GLLIBR.PRG.
//    dGE functions: printpcl()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    PRINT IMAGE TO LASER ;               // Incomplete
                  [<res: RESET>] ;
                  [<ffd: FORMFEED>] ;
                  [<asp: ASPECT>] ;
                  [<pai: PAINTJET>];
                  [<bwp: BWPAINTJET>];
                  [<lan: LANDSCAPE>];
                  [<rev: REVERSE>];
                  [HORIZONTAL OFFSET <hoffset>];
                  [VERTICAL OFFSET <voffset>];
                  [DENSITY <density>];
               => __PrintLaser( ;
                  if(<.res.>,1,0), ;
                  if(<.ffd.>,2,0), ;
                  if(<.asp.>,4,0), ;
                  if(<.pai.>,8,0), ;
                  if(<.bwp.>,16,0), ;
                  if(<.lan.>,32,0) ;
                  if(<.rev.>,64,0) ;
                  <hoffset>, ;
                  <voffset>, ;
                  <density>)


// PRINT IMAGE TO POSTSCRIPT -------------------------------------------------
// TecGuide-> {Language Ref::Printer Commands::UDC}
// 
// Description:
// This command prints the current graphical screen to a postscript
// printer.
//
// Syntax:
// PRINT IMAGE TO POSTSCRIPT 
//    [LANDSCAPE]
//    [REVERSE]
//    [HORIZONTAL OFFSET <hoffset>]
//    [VERTICAL OFFSET <voffset>]
//    [HORIZONTAL SCALE <hscale>]
//    [VERTICAL SCALE <vscale>]
//    [DENSITY <density>]
//
// Arguments:
// [LANDSCAPE] will print the image in a landscape mode.
// [REVERSE] will print the image in reverse mode.
// <hoffset> is the horizontal offset from the left of the page.
// <voffset> is the vertical offset from the base of the page.
// <hlength> is the base length of the image on the page.
// <vscale> is the specifies the Cartesian Y axis scale factor percent.
// <density>
//    
// Example:
// PRINT IMAGE TO POSTSCRIPT LANDSCAPE
//
//          Purpose: Print the screen to a Post Script printer
//  Mapped Function: __PrintPostScript() contained in GLLIBR.PRG.
//    dGE functions: printps()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    PRINT IMAGE TO POSTSCRIPT ;          // Incomplete
                  [<lan: LANDSCAPE>];
                  [<rev: REVERSE>];
                  [HORIZONTAL OFFSET <hoffset>];
                  [VERTICAL OFFSET <voffset>];
                  [HORIZONTAL SCALE <hscale>];
                  [VERTICAL SCALE <vscale>];
                  [DENSITY <density>];
               => __PrintPostScript( ;
                  if(<.lan.>,32,0), ;
                  if(<.rev.>,64,0), ;
                  <hoffset>, ;
                  <voffset>, ;
                  <hscale>, ;
                  <vscale>, ;
                  <density>)


// SET VECTOR PRINT ------------------------------------------------------
// TecGuide-> {Language Ref::Printer Commands::UDC}
// 
// Description:
// This command toggles vector printing to an ON or OFF state and accepts
// commands to control page eject, color, and other aspects of vector
// printing.  This command, without any arguments will toggle vector
// printing off and eject the current page.
//
// Syntax:
// SET VECTOR PRINT [ON] [OFF]
//    [HORIZONTAL OFFSET <hoffset>]
//    [VERTICAL OFFSET <voffset>]
//    [HORIZONTAL LENGTH <hlength>]
//    [UNITS <units>]
//    [VERTICAL SCALE <vscale>]
//    [PORTRAIT]
//    [PCL5]
//    [LASERJET]
//    [POSTSCRIPT]
//    [WINDOW]
//    [COLOR]
//    [PATTERN]
//    [EJECT]
//    [NOEJECT]
//
// Arguments:
// <hoffset> is the horizontal offset from the left of the page.
// <voffset> is the vertical offset from the base of the page.
// <hlength> is the base length of the image on the page.
// <units> is the specifies either "MMS", points "1/72" nd of an inch, or
//   "1/100" th of an inch.
// <vscale> is the specifies the Cartesian Y axis scale factor percent.
// [PORTRAIT] is the invokes an orientation angle on page of 90 degrees.
// [PCL5] invokes a printing mode that supports HPGL, LaserJet III and above,
//   and any printer that supports HPGL plotter emulation.
// [LASERJET] is synonomous with PCL5.
// [POSTSCRIPT] invokes a Postscript printing mode.
// [WINDOW] prints within the current clipping window.
// [COLOR] is the invokes postscript color printing mode.
// [PATTERN] is the invokes postscript pattern priority.
// [NOEJECT] is the suppresses page ejecting when toggling postscript 
//   printing to the OFF state.
//    
// Example:
// SET VECTOR PRINT ON LASERJET              // toggle vector print on
// * drawing commands *
// SET VECTOR PRINT OFF EJECT                // toggle vector off, eject
//
//          Purpose: Set the vector print feature ON or OFF
//  Mapped Function: __SetVectorPrint() contained in GLLIBR.PRG.
//    dGE functions: printps(),vpon(),vpoff()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET VECTOR PRINT ;                   // Complete 12-29-90
                  [<pon: ON>];
                  [HORIZONTAL OFFSET <hoffset>];
                  [VERTICAL OFFSET <voffset>];
                  [HORIZONTAL LENGTH <hlength>];
                  [UNITS <units>];
                  [VERTICAL SCALE <vscale>];
                  [<por: PORTRAIT>];
                  [PCL5];                        // this is a no-op default
                  [LASERJET];                    // this is a no-op default
                  [<pos: POSTSCRIPT>];
                  [<win: WINDOW>];
                  [<col: COLOR,COLOUR>];
                  [<pat: PATTERN>];
                  [OFF];                         // this is a no-op default
                  [EJECT];                       // this is a no-op default
                  [<noe: NOEJECT>];
               => __SetVectorPrint( ;
                  if(<.pon.>,1,2), ;             // command (on or off)
                  <hoffset>, ;                   // horizontal offset
                  <voffset>, ;                   // vertical offset
                  <hlength>, ;                   // base length
                  <"units">, ;                   // units (mms, points, inch)
                  <vscale>, ;                    // Y axis scale factor
                  if(<.por.>,90,0), ;            // orientation (default to 0)
                  if(<.pos.>,-1,0), ;            // Postscript
                  if(<.win.>,8,0), ;             // clipping window
                  if(<.col.>,16,0), ;            // color printing
                  if(<.pat.>,32,0), ;            // pattern priority
                  if(<.noe.>,1,0) ;              // no eject
                  )


// SET MOUSE ------------------------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command hides or displays the mouse cursor.
//
// Syntax:
// SET MOUSE <status>
//
// Arguments:
// <status> is either ON or OFF.
//    
// Example:
// SET MOUSE ON                              // display the mouse cursor
//
//          Purpose: Hide or display the mouse cursor
//  Mapped Function: __SetGMouse() contained in GLLIBR.PRG.
//    dGE functions: mreset(),mcuron(),mcuroff(),mcuron()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET MOUSE ;                          // Complete 12-27-90
                  [<on: ON>] ;
                  [OFF] ;                        // no-op
               => __SetGMouse(<.on.>,NIL)


// SET MOUSE CURSOR TO -------------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command establishes the mouse cursor type and initializes the dGE
//   mouse support.  The default cursor type, if unspecified is an ARROW.
//
// Syntax:
// SET MOUSE CURSOR TO <type>
//
// Arguments:
// <type> is the cursor type desired, either CROSS or ARROW.
//    
// Example:
// SET MOUSE CURSOR TO CROSS                 // init cross mouse cursor
//
//          Purpose: Select the mouse cursor type
//  Mapped Function: __SetGMouse() contained in GLLIBR.PRG.
//    dGE functions: mreset(),mcuron(),mcuroff(),mcuron()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    SET MOUSE CURSOR TO ;                // Complete 12-27-90
                  [<cro: CROSS>] ;
                  [ARROW] ;                      // no-op
               => __SetGMouse(NIL,if(<.cro.>,1,0))


// DEFINE MOUSE WINDOW FROM --------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command defines the boundaries of free movement of the mouse cursor.
// The default mouse window area is from 0.0 to 24,79.
//
// Syntax:
// DEFINE MOUSE WINDOW FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>
//
// Arguments:
//   <Pos1_a> is the upper left x screen coordinate from 0 to 24.
//   <Pos1_b> is the upper left y screen coordinate from 0 to 79.
//   <Pos2_a> is the lower right x screen coordinate from 0 to 24.
//   <Pos2_b> is the lower right y screen coordinate from 0 to 79.
//    
// Example:
// DEFINE MOUSE WINDOW FROM ;                // set the mouse movement area
//   05,02 TO 10,57
//
//          Purpose: Define the free movement of the mouse
//  Mapped Function: __DefineMouseWindow() contained in GLLIBR.PRG.
//    dGE functions: msetwin()
//    Other GL UDFs: __XdGE(),__YdGE(),__XdGE(),__YdGE()
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DEFINE MOUSE WINDOW FROM ;           // Complete 12-27-90
                  <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>;
               => __DefineMouseWindow(<Pos1_a>,<Pos1_b>,<Pos2_a>,<Pos2_b>)


// FIX MOUSE POSITION AT -----------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command positions the mouse cursor at the specified row/column
// screen coordinates.  It is useful in moving the mouse for the operator 
// and in the design of mouse supported tutorials.
//
// Syntax:
// FIX MOUSE POSITION AT <Pos1>,<Pos2>
//
// Arguments:
//   <Pos1> is the row screen coordinate of the position from 0 to 24.
//   <Pos2> is the col screen coordinate of the position from 0 to 79.
//    
// Example:
// FIX MOUSE POSITION AT 10,20               // move the mouse cursor
//
//          Purpose: Set the mouse cursor position
//  Mapped Function: __FixMousePosition() contained in GLLIBR.PRG.
//    dGE functions: mfixpos()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    FIX MOUSE POSITION AT ;              // Complete 12-24-90
                  <Pos1>,<Pos2> ;
               => __FixMousePosition(<Pos1>,<Pos2>)


// SET EVENT SHADOW TO <color> ------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command sets the current color for all subsequent button shadows when
// using the DEFINE EVENT command with the SHADOW option.
//
// Syntax:
// SET EVENT SHADOW TO <color>
//
// Arguments:
// <color> is the color to be used for all subsequent event region shadows.
//   This argument uses standard Clipper color formats.
//    
// Example:
// SET EVENT SHADOW TO "n+/b"                // set shadow color to grey
//
//          Purpose: Establish the color of button shadows
//  Mapped Function: __SetEventShadow() contained in GLLIBR.PRG.
//    dGE functions: None.
//    Other GL UDFs: None.
// System variables: _eshadow_
// System constants: None.
//
// See Also:
// 
#command    SET EVENT SHADOW TO <color> ;        // Complete 12-24-90
               => __SetEventShadow(<"color">)


// DEFINE EVENT <label> FROM --------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command creates an event region on the screen without a visible 
// button or graphical object.  It creates a "click" region that is 
// invisible.  However, the click region can be superimposed over other 
// objects such as icons, bars in a bar chart, and other graphical objects.
// Event regions are automatically created when icon buttons are defined.
//
// Syntax:
// DEFINE EVENT <label> FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b>
//    [ACTIVATE]
//
// Arguments:
// <label> is a label name assciated with a region in the event array.
//    
// Example:
// DRAW BOX FROM 21,26 TO 22,56              // display a box
// @ 21.5,28 DRAW "CLICK HERE..."            // display message in box
// DEFINE EVENT "PAUSE" ;                    // define the event area
//    FROM 21,26 TO 22,56 ;                  // specify the area
//    ACTIVATE                               // activate the region 
// WAIT EVENT "PAUSE" RELEASE                // wait for a mouse press
//
//          Purpose: Create a mouse click region
//  Mapped Function: __DefEventRegion() contained in GLLIBR.PRG.
//    dGE functions: __ScanObjects(),__FindUnusedHandle(),__HandleInRange()
//                   __ActEventRegion(),__HandleError()
//    Other GL UDFs: None.
// System variables: _handles_[]
// System constants: NoHandlesLeft
//
// See Also:
// ACTIVATE EVENT, DEACTIVATE EVENT, RELEASE EVENT
// 
#command    DEFINE EVENT <label> ;               // Incomplete
                  FROM <Pos1_a>,<Pos1_b> TO <Pos2_a>,<Pos2_b> ;
                  [<act: ACTIVATE>] ;
               => __DefEventRegion(<label>, ;
                  <Pos1_a>, ;
                  <Pos1_b>, ;
                  <Pos2_a>, ;
                  <Pos2_b>, ;
                  <.act.>)


// DEFINE EVENT <label> AT -----------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command creates a super icon as a mouse click button and adds it to
// the GET list for processing with WAIT EVENT TO.  An optional ACTIVATE
// clause is used to display it immediately.  The SHADOW clause will draw a
// shadow box behing the icon.
//
// Syntax:
// DEFINE EVENT <label> AT <Pos1>,<Pos2> USING SUPER ICON <icon> ;
//   [SHADOW] [ACTIVATE]
//
// Arguments:
// <Pos1> is the center point row screen coordinate of the super icon button.
// <Pos2> is the center point column screen coordinate of the super icon
//   button.
// <label> is the button name.
// <icon> is the icon number from the current super icon file.
// <ACTIVATE> is an optional specification that activates and displays the
//   button once it's defined.
// <SHADOW> is an optional specification that draws a shadow behind the 
//   button.
//    
// Example:
// DEFINE EVENT "one" AT 03,08 ;             // define/disp icon button
//   USING SUPER ICON 2 SHADOW ACTIVATE
//
//          Purpose: Define a super icon button
//  Mapped Function: __DefIconButton() contained in GLLIBR.PRG.
//    dGE functions: None.
//    Other GL UDFs: __ScanObjects,__ActIconButton(),__HandleError()
// System variables: _eshadow_,_handles_[]
// System constants: None.
//
// See Also:
// ACTIVATE EVENT, DEACTIVATE EVENT, RELEASE EVENT
// 
#command    DEFINE EVENT <label> AT ;            // Complete 12-24-90
                  <Pos1>,<Pos2> USING SUPER ICON <icon> ;
                  [<act: ACTIVATE>] ;
                  [<sha: SHADOW>] ;
               => __DefIconButton(<label>, ;
                  <Pos1>,<Pos2>,<icon>, ;
                  if(<.act.>,ActiveObject,InactiveObject), ;
                  if(<.sha.>,ShadowOn,ShadowOff))


// ACTIVATE EVENT <label> -----------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command changes the status of an event region to active.
//
// Syntax:
// ACTIVATE EVENT <label>
//
// Arguments:
// <label> is a label name assciated with a region in the event array.
//
// Example:
// ACTIVATE EVENT "pause"                    // activate event "pause"
//
//          Purpose: Activate a mouse click region
//  Mapped Function: __ActEventRegion() contained in GLLIBR.PRG.
//    dGE functions: msethot()
//    Other GL UDFs: __ScanObjects(),__XdGE(),__YdGE(),__XdGE_(),__YdGE_()
//                   __HandleError()
// System variables: _handles_[]
// System constants: NoSuchLabel
//
// See Also:
// DEFINE EVENT, DEACTIVATE EVENT, RELEASE EVENT, WAIT EVENT
//
#command    ACTIVATE EVENT <label> ;             // Complete 12-27-90
               => __ActEventRegion(<label>)


// MOVE EVENT <label> TO <Pos1>,<Pos2> ----------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command is useful when moving an icon button from one location to 
// another.  The move will not change the status of the button unless the
// optional ACTIVATE or DEACTIVATE clauses are used.
//
// Syntax:
// MOVE EVENT <label> TO <Pos1>,<Pos2> [ACTIVATE] [DEACTIVATE]
//
// Arguments:
// <Pos1> is the new row screen coordinate of the event object.
// <Pos2> is the new column screen coordinate of the event object.
// <label> is the event object name.
// <ACTIVATE> is an optional specification that activates the event object
//   in its new location.
// <DEACTIVATE> is an optional specification that deactivates the event 
//   object in its new location.
//    
// Example:
// MOVE EVENT "button one" TO 20,20          // move event object
// 
//          Purpose: Move a previously defined event object
//  Mapped Function: __MovEventRegion() contained in GLLIBR.PRG.
//    dGE functions: msethot(),loadicon()
//    Other GL UDFs: __ScanObjects,__DrawSuperIcon(),__HandleError()
// System variables: _handles_[],_eshadow_,_icnfile_,_dgepath_
// System constants: None.
//
// See Also:
// 
#command    MOVE EVENT <label> TO ;              // Complete 12-24-90
                  <Pos1>,<Pos2> ;
                  [<act: ACTIVATE>] ;
                  [<dea: DEACTIVATE>] ;
               => __MovEventRegion(<label>, ;
                  <Pos1>, ;
                  <Pos2>, ;
                  if(<.act.>,ActiveObject,NIL), ;
                  if(<.dea.>,InactiveObject,NIL) ;
                  )


// FLASH EVENT <label> --------------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command simply redraws the specified event giving it a selected
// or picked look.  Note that this command has the effect of activating the
// event region being redrawn.  Note that this command has no effect on
// event regions that lack a physical object.
//
// Syntax:
// FLASH EVENT <label>
//
// Arguments:
// <label> is a label name assciated with a region in the event array.
//    
// Example:
// FLASH EVENT "button one"                  // flash the button
//
//          Purpose: Redraw a button
//  Mapped Function: __FlaEventRegion() contained in GLLIBR.PRG.
//    dGE functions: None.
//    Other GL UDFs: __ScanObjects,__ActIconButton(),__ClrIconButton()
//                   __HandleError()
// System variables: _handles_[]
// System constants: None.
//
// See Also:
// 
#command    FLASH EVENT <label>;                 // Completed 12-24-90
               => __FlaEventRegion(<label>)


// DEACTIVATE EVENT <label> ---------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command changes the status of an event object to inactive and 
// optionally clears the screen of the object.
//
// Syntax:
// DEACTIVATE EVENT <label> [CLEAR]
//
// Arguments:
// <label> is a label name assciated with a region in the event array.
//
// Example:
// DEACTIVATE EVENT "pause"                  // suspend event "pause"
//
//          Purpose: Deactivate a mouse click region
//  Mapped Function: __DeaEventRegion() contained in GLLIBR.PRG.
//    dGE functions: msethot()
//    Other GL UDFs: __ScanObjects(),__RelEventRegion(),__HandleError()
// System variables: _handles_[]
// System constants: NoSuchLabel
//
// See Also:
// DEFINE EVENT, ACTIVATE EVENT, RELEASE EVENT, WAIT EVENT
//
#command    DEACTIVATE EVENT <label> ;           // Complete 12-27-90
                  [<clr: CLEAR>] ;               // clear a physical object
               => __DeaEventRegion(<label>,<.clr.>)


// RELEASE EVENT <label> ------------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command eliminates the specified label from the event array, freeing
// the space it occupied in the array.
//
// Syntax:
// RELEASE EVENT <label>
//
// Arguments:
// <label> is a label name assciated with a region in the event array.
//    
// Example:
// RELEASE EVENT "pause"                     // kill the "pause" region
//
//          Purpose: Kill an event region
//  Mapped Function: __RelEventRegion() contained in GLLIBR.PRG.
//    dGE functions: msethot()
//    Other GL UDFs: __ScanObjects(),__HandleError()
// System variables: _handles_[]
// System constants: NoSuchLabel
//
// See Also:
// DEFINE EVENT, ACTIVATE EVENT, DEACTIVATE EVENT, WAIT EVENT
// 
#command    RELEASE EVENT <label> ;              // Complete 12-27-90
               => __RelEventRegion(<label>)


// WAIT EVENT <label> --------------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command processes a mouse event and deterimines if a click has 
// occured in the region specified for the region label.  If the click is
// not in that region, nothing happens.  If a click does occur in the 
// active and specified region, the program continues.  See the Technical 
// Reference section for more details about the button GET list array.
//
// Syntax:
// WAIT EVENT <label> [RELEASE]
//
// Arguments:
// <label> is an object name assciated with a region to prompt for.
//    
// Example:
// DRAW BOX FROM 21,26 TO 22,56              // display a box
// @ 21.5,28 DRAW "CLICK HERE..."            // display message in box
// DEFINE EVENT "PAUSE" ;                    // define the event area
//    FROM 21,26 TO 22,56 ;                  // specify the area
//    ACTIVATE                               // activate the region 
// WAIT EVENT "PAUSE" RELEASE                // wait for a mouse press
//
//          Purpose: Wait for a mouse click in a specific region
//  Mapped Function: __WaitForClick() contained in GLLIBR.PRG.
//    dGE functions: mstatus(),mgethot()
//    Other GL UDFs: __ScanObjects(),__DeaEventRegion(),__RelEventRegion()
// System variables: _handles_[]
// System constants: 
//
// See Also:
// DEFINE EVENT, ACTIVATE EVENT, DEACTIVATE EVENT, RELEASE EVENT
// 
#command    WAIT EVENT <label> ;                 // Incomplete
                  [<dea: DEACTIVATE>] ;
                  [<rel: RELEASE>] ;             // release the array
                  [<nof: NOFLASH>] ;
               => __WaitForClick(<label>, ;
                  <.dea.>, ;
                  <.rel.>, ;
                  <.nof.> ;
                  )


// WAIT EVENT TO -------------------------------------------------------------
// TecGuide-> {Language Ref::Event Commands::UDC}
// 
// Description:
// This command waits for a mouse click in any of the currently active GET
// regions and returns the event label into the specified memory variable.
// NOFLASH is an optional command that suppresses the flashing or redrawing
// of the button that was clicked.  See the Technical Reference section for
// more details about the event region GET list array.
//
// Syntax:
// WAIT EVENT TO <memvar>
// 
// Arguments:
// <memvar> is a memory variable to store the region clicked by the mouse.
// [NOFLASH] is an optional command that suppresses the redrawing of the
//   button object.
//    
// Example:
// DEFINE EVENT "1" AT 03,08 USING SUPER ICON 2 SHADOW ACTIVATE
// DEFINE EVENT "2" AT 09,08 USING SUPER ICON 4 SHADOW ACTIVATE
// DEFINE EVENT "3" AT 15,08 USING SUPER ICON 6 SHADOW ACTIVATE
// DEFINE EVENT "4" AT 21,08 USING SUPER ICON 7 SHADOW ACTIVATE
// DEFINE EVENT "5" AT 21,70 USING SUPER ICON 1 SHADOW ACTIVATE
// WAIT EVENT TO CHOICE_                     // wait for a mouse press
//
//          Purpose: Wait for a mouse click, return the event label
//  Mapped Function: __WaitForEvent() contained in GLLIBR.PRG.
//    dGE functions: mstatus(),mgethot()
//    Other GL UDFs: __FindObject(),__FlaEventRegion()
// System variables: _handles_[]
// System constants: None.
//
// See Also:
// DEFINE EVENT, ACTIVATE EVENT, DEACTIVATE EVENT, RELEASE EVENT
// 
#command    WAIT EVENT TO ;                      // Incomplete
                  <memvar> ;
                  [<nof: NOFLASH>] ;
               => <memvar> := __WaitForEvent(<.nof.>)


// DRAW BAR CHART AT ---------------------------------------------------------
// TecGuide-> {Language Ref::Business Commands::UDC}
// 
// Description:
// This command displays a bar chart at the specified row/column coordinates.  
// The chart is based on a database file that can be optionally filtered. 
// For alternating bar patterns and colors, enter the PATTERN and COLOR
// options respectively. 
//
// Syntax:
// DRAW BAR CHART AT <Pos1>,<Pos2> USING <dbf> PLOT <field> 
//    [LABEL <field>]
//    [WIDTH <width>]
//    [HEIGHT <height>]
//    [DIVISION <value>]
//    [FILTER <filter>]
//    [SOLID]
//    [DOTTED]
//    [DASHED]
//    [BOX]
//    [PATTERN] 
//    [COLOR <color>] 
//    [3D] 
//    [HORIZONTAL] 
//
// Arguments:
// <Pos1> is the row screen coordinate for the lower left corner of the 
//   chart.
// <Pos2> is the column screen coordinate for the lower left corner of the 
//   chart.
// <dbf> is the database file to be used as the source of data.
// [PLOT <field>] is the field to plot.
// [LABEL <field>] is the field to display on the X axes.
// [WIDTH <width>] is the width of the chart.  The default is established as
//   a preprocessor constant in GLLIBR.CH with a value of ???.
// [HEIGHT <height>] is the height of the chart.  The default is established 
//   as a preprocessor constant in GLLIBR.CH with a value of ???.
// [DIVISION <value>] is the Y axes value for determining where labels and
//   grid lines will be placed.
// [SOLID] invokes solid Y axes grid lines at the division marks.
// [DOTTED] invokes dotted Y axes grid lines at the division marks.
// [DASHED] invokes dashed Y axes grid lines at the division marks.
// [BOX] draws a box around the chart area.
// <filter> is the filter statement that isolates the data for the chart.
// [PATTERN] alternates bar patterns.
// [COLOR <color>]  establishes the bar colors.
// [3D] displays the bars in three dimensional mode.
// [HORIZONTAL] displays the bars in horizontal format.
//    
// Example:
// DRAW BAR CHART AT 14,23 USING SAMPLE.DBF; // display a bar chart
//    PLOT DIV_INCOME/100 ;                  // select the field to plot
//    LABLE DIVISION                         // select field for X axes
//    FILTER RECNO()<=16 ;                   // set the filter
//    COLOR BLUE;                            // display blue color bars
//    3D ;                                   // display in 3d mode
//    HEIGHT 8 ;                             // height of 8 rows
//    WIDTH 40 ;                             // width of 40 chrs
//    DIVISION 5000 ;                        // Y axes divisions
//    DOTTED ;                               // dotted Y grid lines
//    BOX                                    // box the chart
//
//          Purpose: Display a bar chart
//  Mapped Function: __DrawBarChart() contained in GLLIBR.PRG.
//    dGE functions: datastore(),bargraph(),datareset()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW BAR CHART AT ;                  // Incomplete
                  <Pos1>,<Pos2> ;
                  USING <dbf> ;
                  PLOT <field> ;
                  [LABEL <label>] ;
                  [WIDTH <width>] ;
                  [HEIGHT <height>] ;
                  [DIVISION <division>] ;
                  [FILTER <filter>] ;
                  [<sol: SOLID>] ;
                  [<dot: DOTTED>] ;
                  [<das: DASHED>] ;
                  [<box: BOX>] ;
                  [<pat: PATTERN>] ;
                  [COLOR <*color*>] ;
                  [COLOUR <*color*>] ;
                  [<thr: 3D>] ;
                  [<hor: HORIZONTAL>] ;
               => __DrawBarChart(<Pos1>,<Pos2>, ;
                  <"dbf">, ;
                  <"field">, ;
                  <"label">, ;
                  <width>, ;
                  <height>, ;
                  <division>, ;
                  #<filter>,;
                  if(<.sol.>,4,0), ;
                  if(<.dot.>,8,0), ;
                  if(<.das.>,12,0), ;
                  if(<.box.>,64,0), ;
                  <.pat.>, ;
                  #<color>, ;
                  if(<.thr.>,16,0), ;
                  if(<.hor.>,4,0) ;
                  )


// DRAW XY CHART AT -----------------------------------------------------------
// TecGuide-> {Language Ref::Business Commands::UDC}
// 
// Description:
// This command displays an XY chart at the specified row/column coordinates.  
// The chart is based on a database file that can be optionally filtered. 
//
// Syntax:
// DRAW XY CHART AT <Pos1>,<Pos2> USING <dbf> PLOT <field> 
//    [LABEL <field>]
//    [WIDTH <width>]
//    [HEIGHT <height>]
//    [DIVISION <value>]
//    [FILTER <filter>]
//    [SOLID]
//    [DOTTED]
//    [DASHED]
//    [BOX]
//
// Arguments:
// <Pos1> is the row screen coordinate for the lower left corner of the 
//   chart.
// <Pos2> is the column screen coordinate for the lower left corner of the 
//   chart.
// <dbf> is the database file to be used as the source of data.
// [PLOT <field>] is the field to plot.
// [LABEL <field>] is the field to display on the X axes labels.
// [WIDTH <width>] is the width of the chart.  The default is established as
//   a preprocessor constant in GLLIBR.CH with a value of ???.
// [HEIGHT <height>] is the height of the chart.  The default is established 
//   as a preprocessor constant in GLLIBR.CH with a value of ???.
// [DIVISION <value>] is the Y axes value for determining where labels and
//   grid lines will be placed.
// [SOLID] invokes solid Y axes grid lines at the division marks.
// [DOTTED] invokes dotted Y axes grid lines at the division marks.
// [DASHED] invokes dashed Y axes grid lines at the division marks.
// [BOX] draws a box around the chart area.
// <filter> is the filter statement that isolates the data for the chart.
//    
// Example:
// DRAW XY CHART AT 14,23 USING SAMPLE.DBF;  // display an xy chart
//    PLOT DIV_INCOME/100 ;                  // select the field to plot
//    LABLE DIVISION                         // select field for X axes
//    FILTER RECNO()<=16 ;                   // set the filter
//    HEIGHT 8 ;                             // height of 8 rows
//    WIDTH 40 ;                             // width of 40 chrs
//    DIVISION 5000 ;                        // Y axes divisions
//    DOTTED ;                               // dotted Y grid lines
//    BOX                                    // box the chart
//
//          Purpose: Display an XY chart
//  Mapped Function: __DrawXYChart() contained in GLLIBR.PRG.
//    dGE functions: datastore(),xygraph(),datareset()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW XY CHART AT ;                   // Complete 12-9-90
                  <Pos1>,<Pos2> ;
                  USING <dbf> ;
                  PLOT <field> ;
                  [LABEL <label>] ;
                  [WIDTH <width>] ;
                  [HEIGHT <height>] ;
                  [DIVISION <division>] ;
                  [FILTER <filter>] ;
                  [<sol: SOLID>] ;
                  [<dot: DOTTED>] ;
                  [<das: DASHED>] ;
                  [<box: BOX>] ;
                  [<col: COLOR,COLOUR>] ;
               => __DrawXYChart(<Pos1>,<Pos2>, ;
                  <"dbf">, ;
                  <"field">, ;
                  <"label">, ;
                  <width>, ;
                  <height>, ;
                  <division>, ;
                  <"filter">,;
                  if(<.sol.>,4,0), ;
                  if(<.dot.>,8,0), ;
                  if(<.das.>,12,0), ;
                  if(<.box.>,64,0), ;
                  <.col.> ;
                  )


// DRAW PIE CHART AT ---------------------------------------------------------
// TecGuide-> {Language Ref::Business Commands::UDC}
// 
// Description:
// This command displays a pie chart centered at the specified row/column
// location.  Restrictions placed on dGE such as the datastore() values must
// be in the range 0 to 32768 apply equally to Graphics Library commands.
//
// Syntax:
// DRAW PIE CHART AT <Pos1>,<Pos2> USING <dbf> PLOT <field> 
//    [FILTER <filter>] 
//    [PATTERN] 
//    [COLOR] 
//    [LABEL <label>] 
//    [OFFSET <value>]
//    [EXPLODE <slice>] 
//    [RADIUS <radius>] 
//    [PERCENT] 
//    [NOCONNECT] 
//
// Arguments:
// <Pos1> is the row screen coordinate of the center of the pie.
// <Pos2> is the column screen coordinate of the center of the pie.
// <dbf> is the database file that contains the data to be charted.
// <field> is the field to be charted.
// <filter> is a filter statement that isolates the records to be charted.
// [PATTERN] alternates the fill patterns for the pie slices.
// [COLOR] alternates the color for the pie slices.
// <label> is a field denoting the pie slice labels.
// [OFFSET <value>] is the pie chart label offset.  This value must be 
//   expressed in Cartesian values.  The default offset is 50 and is defined
//   as a preprocessor constant in GLLIBR.CH.
// <slice> is a slice number to be exploded from the rest of the pie.
// <radius> is the width in characters from the center point to the outer 
//   rim of the pie.
// [PERCENT] displays percentage values of each pie slice.
// [NOCONNECT] suppresses the radius connecting lines.
//    
// Example:
// DRAW PIE CHART AT 08.5,46 ;               // draw a pie chart
//    USING SAMPLE.DBF ;                     // select the database
//    PLOT DIV_INCOME ;                      // select the field to plot
//    LABEL DIVISION ;                       // select the lable
//    PATTERN ;                              // select alternatine patterns
//    RADIUS 12 ;                            // select the radius (in chrs)
//    EXPLODE 3 ;                            // select the slice to explode
//    FILTER YEAR="1990" ;                   // only plot 1990 data
//    COLOR                                  // select alternating colors
//
//          Purpose: Display pie chart
//  Mapped Function: __DrawPieChart() contained in GLLIBR.PRG.
//    dGE functions: datastore(),piechart(),datareset()
//    Other GL UDFs: None.
// System variables: None.
// System constants: None.
//
// See Also:
// 
#command    DRAW PIE CHART AT ;                  // Complete 12-29-90
                  <Pos1>,<Pos2> ;
                  USING <dbf> ;
                  PLOT <field> ;
                  [FILTER <filter>] ;
                  [<pat: PATTERN>] ;
                  [<col: COLOR,COLOUR>] ;
                  [LABEL <label>] ;
                  [OFFSET <offset>] ;
                  [EXPLODE <slice>] ;
                  [RADIUS <radius>] ;
                  [<per: PERCENT>] ;
                  [<noc: NOCONNECT>] ;
               => __DrawPieChart(<Pos1>,<Pos2>, ;
                  <"dbf">, ;
                  <"field">, ;
                  <"filter">, ;
                  <.pat.>, ;
                  <.col.>, ;
                  <"label">, ;
                  <offset>, ;
                  <slice>, ;
                  <radius>, ;
                  if(<.per.>,4,0),;
                  if(<.noc.>,8,0);
                  )


