**********
*
*        Example and functions used to format numbers and do calculations
*   on gets.  The example is spacific to a geologic data system were a
*   wide range of values must occupy a fixed area on a map.  This same
*   formating is also nessery if one does calculations in the field, were
*   the calculated values may not normaly fit in the field width.
*
*         input           output
*         100,000 Bo  --> 100.0 Mbo
*          50,125 Bo  --> 50.13 Mbo
*             345 Bo  --> 0.345 Mbo
*
*          Bo = barrls of oil
*
*   Author : David M. Baker, Cheyenne Petroleum Company
*   Date   : 4/30/90
*

PROCEDURE CUMOIL  && as an example

PRIVATE pic_width, get_len, pic, rptoil, r, c

pic_width = 5
pic       = "@!@S" + LTRIM(STR(pic_width,2,0))
get_len   = 50
rptoil    = PAD(rptoil, get_len)
r         = 2
c         = 2

CLEAR

DO WHILE LASTKEY() <> 27
   @  r, c      SAY  "Reported Cumulitive Oil"
   @  r, c + 28 GET  M->rptoil;
                     PICTURE &pic; && enter different values and see what happens
                     VALID SET_DECI(@rptoil, 1000, pic_width, get_len)
   @  r, c + 34 SAY  "MBO"
   READ
ENDDO

QUIT

**** SET_DECI **
*
*       <expL> = SET_DECI(@<expC>, <expN>, <expN>, <expN>)
*
*       set decimal place for input data
*
*       note: - if the data is alpha, the function returns .t.
*                       leaving it unchanged.
*             - if the data is an integer value, the function
*                       will fill the whole field with a floating
*                       point number representation
*
****

FUNCTION SET_DECI

PARAMETERS get_var, scale, pic_width, get_len

PRIVATE calc_get
calc_get = ISCALC(get_var)

IF (ISNUM(get_var) .AND. EMPTY(AT(".", get_var))) .OR. calc_get
   get_var = IIF(calc_get, STR(&get_var), get_var)
   get_var = PAD(LEAST_SIG(VAL(get_var)/scale, pic_width), get_len)
   KEYBOARD CHR(LASTKEY())
   RETURN .F.
ELSEIF ISNUM(get_var) .AND. !EMPTY(AT(".", get_var));
                      .AND. LEN(ALLTRIM(get_var)) <> pic_width
   get_var = PAD(LEAST_SIG(VAL(get_var), pic_width), get_len)
   KEYBOARD CHR(LASTKEY())
   RETURN .F.
ENDIF
RETURN .T.

**** ISCALC **
*
*       <expL> = ISCALC(<expC>)
*
*       test if a character field represents a numeric calculation
*
****


FUNCTION ISCALC

PARAMETERS get_var

PRIVATE check_it, get_len, i, iscalc

get_var = ALLTRIM(get_var)
get_len = LEN(get_var)
check_it = '"' + get_var + '"'
iscalc = .F.

IF TYPE(&check_it) == "N"
   FOR i = 1 TO get_len
       IF IIF(i=1,;
                   SUBSTR(get_var,1,1) $ "(",;
                   SUBSTR(get_var,i,1) $ "-+/^*%()")
          iscalc = .T.
          EXIT
       ENDIF
   NEXT
ENDIF
RETURN iscalc

**** ISNUM **
*
*       <expL> = ISNUM(<exp>)
*
*       test any data type as numeric
*
****

FUNCTION ISNUM

PARAMETERS data

RETURN IIF(TYPE("data") == "C", SUBSTR(data, IIF(SUBSTR(data,1,1) = "-", 2, 1), 1) $ "0123456789", TYPE("data") == "N")

**** LEAST_SIG **
*
*       <expC> = <expN>, <expN>, [<expL>]
*
*       force a number to fit in a fixed lengh character field by
*           triming off the least significant digits of the number
*
*       note: - the character string returned will fill the whole
*                       field and will be a charater representaion
*                       of a floating point number
*
*            -  for consistent formating of positive and negative
*                       numbers, the sign flag should be set
*
****

FUNCTION LEAST_SIG

PARAMETERS expN, field_len, sign

** make room for the decimal point and optional sign
temp_len = (field_len - 1) - IIF(expN < 0 .OR. IIF(PCOUNT() < 3, .F., sign), 1, 0)
num_dec_pl = temp_len - LEN(LTRIM(STR(INT(expN), temp_len,0)))
RETURN STR(expN, field_len, num_dec_pl)

**** PAD **
*
*       <expC> = PAD(<expC>, <expN>)
*
*       force a string to a specified length
*
*       note: - if the string is longer than the specified
*                       length it will be truncated
*             - if the string is shorter than the specified length
*                       it will be padded with spaces on the right
****

FUNCTION pad

PARAMETERS s, n
RETURN SUBSTR(M->s + SPACE(M->n), 1, M->n)
