*****************************************************************************
*
* Program Name : samplibr
*
* Written By   : David L. Collison
* Written On   : December 07, 1989
*
* Updated By   : David L. Collison
* Updated On   : December 07, 1989
*
* Copyright    : Copyright (c), 1989 - Executive Assist
*
* Description  : This procedure file contains sample code from the library
*                created by Executive Assist.
*
* Files Used   :
*
* Prg's Called :
*
* Parameters   :
*
*****************************************************************************

******************************************************************************
*
* Function Name : ml_envst.prg
*
* Written By    : David L. Collison
* Written On    : October 20, 1989
*
* Updated By    : David L. Collison
* Updated On    : October 20, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will be used to initialize the runtime
*                 environment for Clipper programs.
*
* Files Used    : 
*
* Prg's Called  :
*
* Parameters    :
*
******************************************************************************

FUNCTION MM_ENVST

   PUBLIC PUB_NCLR, PUB_ECLR, PUB_MCLR, PUB_WCLR, PUB_FCLR, PUB_RCLR
   PUBLIC PUB_GCLR, PUB_UCLR, PUB_SCRN, PUB_COMP, PUB_USER, PUB_MEDT
   PUBLIC PUB_CURS

   PUB_COMP = 'Executive Assist'

   PUB_SCRN = .T.
   PUB_MEDT = .F.
   PUB_CURS = .T.

   PUB_USER = GETE ( 'USERNAME' )

   SET ESCAPE OFF
   SET EXCLUSIVE OFF
   SET SCOREBOARD OFF

   SET WRAP ON
   SET EXACT ON
   SET DELETED ON

   SELECT 0
   MM_DFOPN ( 'MM_SYCFG', .F. )

   IF .NOT. ISCOLOR()
      GOTO 2
   ENDIF

   PUB_NCLR = SYCLRNOR
   PUB_ECLR = SYCLRERR
   PUB_MCLR = SYCLRMSG
   PUB_WCLR = SYCLRWIN
   PUB_FCLR = SYCLRSFT
   PUB_RCLR = SYCLRRVS
   PUB_GCLR = SYCLRGTS
   PUB_UCLR = SYCLRUNS
   PUB_COMP = SYCONAME

   CLOSE DATABASES

   MM_SCCLR ( 'NO' )

RETURN ( SPACE ( 0 ) )

******************************************************************************
*
* Function Name : ml_scclr.prg
*
* Written By    : David L. Collison
* Written On    : October 20, 1989
*
* Updated By    : David L. Collison
* Updated On    : October 20, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will change screen colors.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : p_scolor - character - determines new screen color.
*                    'NO' - Normal text screen colors
*                    'RV' - Reverse screen colors
*                    'SF' - Footer screen colors
*                    'ME' - Message screen colors
*                    'WN' - Windows screen colors
*                    'ER' - Error screen colors
*                    'BL' - Blank screen colors
*
******************************************************************************

FUNCTION MM_SCCLR

   PARAMETERS P_SCOLOR

   DO CASE
      CASE P_SCOLOR = "BL"
         SET COLOR TO &PUB_GCLR, X, , , &PUB_UCLR

      CASE P_SCOLOR = "ER"
         SET COLOR TO &PUB_ECLR, &PUB_GCLR, , , &PUB_UCLR

      CASE P_SCOLOR = "ME"
         SET COLOR TO &PUB_MCLR, &PUB_GCLR, , , &PUB_UCLR

      CASE P_SCOLOR = "NO"
         SET COLOR TO &PUB_NCLR, &PUB_GCLR, , , &PUB_UCLR

      CASE P_SCOLOR = "RV"
         SET COLOR TO &PUB_UCLR, &PUB_NCLR, , , &PUB_UCLR

      CASE P_SCOLOR = "SF"
         SET COLOR TO &PUB_FCLR, &PUB_GCLR, , , &PUB_UCLR

      CASE P_SCOLOR = "WN"
         SET COLOR TO &PUB_WCLR, &PUB_GCLR, , , &PUB_UCLR

   ENDCASE

RETURN ( SPACE ( 0 ) )

******************************************************************************
*
* Function Name : mm_schdr
*
* Written By    : David L. Collison
* Written On    : 01/24/89
*
* Updated By    : Danny Higgins
* Updated On    : 10/18/89
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Explanation   : Draws the screen header.
*
* Files Used    :
*
* Prgs Called   :
*
* Parameters    : p_callpr - character - calling program name
*     	         p_scname - character - screen name to display
*
******************************************************************************

FUNCTION MM_SCHDR

   PARAMETERS P_CALLPR, P_SCNAME

   PRIVATE M_LENGTH

   @ 00, 00 CLEAR

   @ 01, 00 TO 21, 79 DOUBLE

   @ 00, 00 SAY "PROC : " + P_CALLPR

   MM_UTCTR ( P_SCNAME, 00, 00, 79 )

   MM_UTRGT ( "USER : " + PUB_USER, 00, 79 )

   MM_SCCLR ( "SF" )

   @ 22, 0 SAY "ESC-EXIT"
   @ 22, 12 SAY "F1-HELP"
   @ 22, 24 SAY "F2-LOOKUP"
   @ 22, 38 SAY "F3-TABLES"

   MM_SCCLR ( "NO" )

RETURN SPACE ( 0 )

******************************************************************************
*
* Function Name : mm_utmsc
*
* Written By    : David L. Collison
* Written On    : 06/19/89
*
* Updated By    : David Melby
* Updated On    : 10/16/89
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Explanation   : Display message based on code passed to program.
*
* Files Used    :
*
* Prgs Called   :
*
* Parameters    : p_msgcod - character - code for message to be displayed.
*
******************************************************************************

FUNCTION MM_UTMSC

   PARAMETERS P_MSGCOD

   DO CASE
      CASE P_MSGCOD = "OF"
         MM_SCCLR ( "ME" )
         @ 24, 0 SAY "OPENING FILES - PLEASE WAIT "
         MM_SCCLR ( "NO" )

      CASE P_MSGCOD = "SF"
         MM_SCCLR ( "ME" )
         @ 24, 0 SAY "SORTING - PLEASE WAIT "
         MM_SCCLR ( "NO" )

      CASE P_MSGCOD = "UP"
         MM_SCCLR ( "ME" )
         @ 24, 0 SAY "UPDATING FILES - PLEASE WAIT "
         MM_SCCLR ( "NO" )

      CASE P_MSGCOD = "VL"
         MM_SCCLR ( "VL" )
         @ 24, 00 SAY "VALIDATING USER ENTRIES - PLEASE WAIT "
         MM_SCCLR ( "NO" )

   ENDCASE

RETURN SPACE ( 0 )

******************************************************************************
*
* Function Name : ml_dfopn.prg
*
* Written By    : David L. Collison
* Written On    : October 20, 1989
*
* Updated By    : David L. Collison
* Updated On    : October 20, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will open all dbf datafiles to be used
*                 within a given system.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : p_filenm - character - name of datafile to use
*                 p_exclsv - logical   - open exclusively or shared
*                 p_falias - character - name of alias to assign file
*
******************************************************************************

FUNCTION MM_DFOPN

   PARAMETER P_FILENM, P_EXCLSV, P_FALIAS

   PRIVATE M_COUNTR

   M_COUNTR = 00

   DO WHILE .T.


      IF PCOUNT() < 3

         IF P_EXCLSV
            USE (P_FILENM) EXCLUSIVE
         ELSE
            USE (P_FILENM)
         ENDIF

      ELSE

         IF P_EXCLSV
            USE (P_FILENM) EXCLUSIVE ALIAS &P_FALIAS
         ELSE
            USE (P_FILENM) ALIAS &P_FALIAS
         ENDIF

      ENDIF

      IF NETERR()
         M_COUNTR = M_COUNTR + 1
      ELSE
         EXIT
      ENDIF

      IF M_COUNTR >= 15

         MM_UTMSG ( 'SYSTEM CAN NOT OPEN : ' + P_FILENM + ' . . . NOTIFY SYSTEM ADMINISTRATOR ', 'PRESS ANY KEY TO HAVE SYSTEM RETRY FILE USE . . . ' )
         M_COUNTR = 00

      ENDIF

   ENDDO

RETURN ( SPACE ( 0 ) )

******************************************************************************
*
* Function Name : mm_lkfil
*
* Written By    : David L. Collison
* Written On    : October 20, 1989
*
* Updated By    : David L. Collison
* Updated On    : October 24, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function allows the user to lock a given file.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    :
*
******************************************************************************

FUNCTION MM_LKFIL

   PRIVATE M_COUNTR

   M_COUNTR = 00

   DO WHILE .T.

      IF .NOT. FLOCK()
         M_COUNTR = M_COUNTR + 1
      ELSE
         EXIT
      ENDIF

      IF M_COUNTR >= 15

         MM_UTMSG ( 'SYSTEM CAN NOT LOCK : ' + P_FILENM + ' . . . NOTIFY SYSTEM ADMINISTRATOR ', 'PRESS ANY KEY TO HAVE SYSTEM RETRY FILE USE . . . ' )
         M_COUNTR = 00

      ENDIF

   ENDDO

RETU ( SPACE ( 0 ) )

******************************************************************************
*
* Function Name : mm_lkfun
*
* Written By    : David L. Collison
* Written On    : October 20, 1989
*
* Updated By    : David L. Collison
* Updated On    : October 24, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will allow programs to unlock a given file.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    :
*
******************************************************************************

FUNCTION MM_LKFUN
   UNLOCK
RETURN ( SPACE ( 0 ) )

******************************************************************************
*
* Function Name : mm_lkrec
*
* Written By    : David L. Collison
* Written On    : October 20, 1989
*
* Updated By    : David L. Collison
* Updated On    : October 24, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function allows the user to lock a given record.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    :
*
******************************************************************************

FUNCTION MM_LKREC

   PRIVATE M_COUNTR

   M_COUNTR = 00

   DO WHILE .T.

      IF .NOT. RLOCK()
         M_COUNTR = M_COUNTR + 1
      ELSE
         EXIT
      ENDIF

      IF M_COUNTR >= 15

         MM_UTMSG ( 'SYSTEM CAN NOT RECORD LOCK : ' + P_FILENM + ' . . . NOTIFY SYSTEM ADMINISTRATOR ', 'PRESS ANY KEY TO HAVE SYSTEM RETRY FILE USE . . . ' )
         M_COUNTR = 00

      ENDIF

   ENDDO

RETU ( SPACE ( 0 ) )

******************************************************************************
*
* Function Name : mm_lkrun
*
* Written By    : David L. Collison
* Written On    : October 20, 1989
*
* Updated By    : David L. Collison
* Updated On    : October 24, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will allow programs to unlock a given record.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    :
*
******************************************************************************

FUNCTION MM_LKRUN
   UNLOCK
RETURN ( SPACE ( 0 ) )

******************************************************************************
*
* Function Name : mm_utget
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Explanation   : Simulates a get statement to enter one character.
*
* Files Used    :
*
* Prgs Called   :
*
* Parameters    : p_rownum - numeric   - starting row for message
*                 p_column - numeric   - starting column for message
*                 p_messag - character - message to preceed statement
*                 p_valans - character - string of valid responses
*
******************************************************************************

FUNCTION MM_UTGET

   PARAMETERS P_ROWNUM, P_COLUMN, P_MESSAG, P_VALANS

   PRIVATE M_ASCIIV, M_GETPOS, M_VALUES, M_SVSCRN

   M_VALUES = SPACE ( 1 )
   M_GETPOS = LEN ( P_MESSAG ) + 1

   M_SVSCRN = SAVESCREEN ( P_ROWNUM, P_COLUMN, P_ROWNUM, M_GETPOS )

   @ P_ROWNUM, P_COLUMN SAY P_MESSAG

   MM_SCCLR ( "RV" )

   @ P_ROWNUM, P_COLUMN + M_GETPOS SAY " "
   @ P_ROWNUM, P_COLUMN + M_GETPOS SAY SPACE ( 0 )

   DO WHILE .T.
      M_ASCIIV = INKEY ( 0 )
      M_VALUES = UPPER ( CHR ( M_ASCIIV ) )

      IF M_ASCIIV > 32 .AND. M_ASCIIV < 127
         @ P_ROWNUM, P_COLUMN + M_GETPOS SAY M_VALUES
         @ P_ROWNUM, P_COLUMN + M_GETPOS SAY SPACE ( 0 )
      ENDIF

      IF M_VALUES $ P_VALANS
         EXIT
      ENDIF

   ENDDO

   MM_SCCLR ( "NO" )

   RESTSCREEN ( P_ROWNUM, P_COLUMN, P_ROWNUM, M_GETPOS, M_SVSCRN )

RETURN ( M_VALUES )

******************************************************************************
*
* Function Name : mm_utmsg
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Explanation   : Display message on line 23 and 24 (may have 1 or 2 line
*                 message).  Message is erased after any key is pressed.
*
* Files Used    :
*
* Prgs Called   :
*
* Parameters    : p_msgln1 - character - line 1 of message
*                 p_msgln2 - character - line 2 of message
*
******************************************************************************

FUNCTION MM_UTMSG

   PARAMETERS P_MSGLN1, P_MSGLN2

   IF PCOUNT() < 2
      P_MSGLN2 = SPACE ( 1 )
   ENDIF

   PRIVATE M_SCREEN, M_ORGCLR

   M_ORGCLR = SETCOLOR()

   IF EMPTY ( P_MSGLN2 )
      MM_SCCLR ( "ME" )
      @ 24, 00 SAY P_MSGLN1
   ELSE

      M_SCREEN = SAVESCREEN ( 23, 0, 24, 79 )

      MM_SCCLR ( "NO" )

      @ 23, 00 CLEAR

      MM_SCCLR ( "ME" )

      @ 23, 00 SAY P_MSGLN1
      @ 24, 00 SAY P_MSGLN2

   ENDIF

   MM_SCCLR ( "NO" )

   INKEY ( 0 )

   IF EMPTY ( P_MSGLN2 )
      @ 24, 00
   ELSE
      RESTSCREEN ( 23, 0, 24, 79, M_SCREEN )
   ENDIF

   SETCOLOR ( M_ORGCLR )

RETURN SPACE ( 0 )

******************************************************************************
*
* Function Name : ml_utctr
*
* Written By    : David L. Collison
* Written On    : October 20, 1989
*
* Updated By    : David L. Collison
* Updated On    : October 20, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will center text and display it on the given
*                line.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : p_currow - numeric - row to display text on
*                 p_stcolm - numeric - starting colomn to center text
*                 p_encolm - numeric - ending column to display text
*                 p_cntext - character - string to center
*
******************************************************************************

FUNCTION MM_UTCTR

   PARAMETER P_CNTEXT, P_CURROW, P_STCOLM, P_ENCOLM

   PRIVATE M_POSITN

   IF LEN ( ALLTRIM ( P_CNTEXT ) ) < ( P_ENCOLM - P_STCOLM )
      M_POSITN = P_STCOLM + ( INT ( ( P_ENCOLM - P_STCOLM ) / 2 ) )
      M_POSITN = M_POSITN - ( INT ( LEN ( ALLTRIM ( P_CNTEXT ) ) / 2 ) )

   ELSE
      M_POSITN = P_STCOLM
      P_CNTEXT = SUBSTR ( P_CNTEXT, 1, ( P_ENCOLM - P_STCOLM - 2 ) )

   ENDIF

   @ P_CURROW, M_POSITN SAY ALLTRIM ( P_CNTEXT )

RETURN ( SPACE ( 0 ) )

*****************************************************************************
*
* Function Name : mm_utrgt
*
* Written By    : David L. Collison
* Written On    : December 09, 1989
*
* Updated By    : David L. Collison
* Updated On    : December 09, 1989
*
* Copyright     : Copyright (c), 1989 - Executive Assist
*
* Description   : This function will be used to right justify a piece of
*                 text.
*
* Files Used    :
*
* Prg's Called  :
*
* Parameters    : P_DSPTXT - Character - Text to display
*                 P_ROWNUM - Numeric   - Row number to display text
*                 P_NUMCOL - Numeric   - Number of columns on row.
*
*****************************************************************************

FUNCTION MM_UTRGT

   PARAMETERS P_DSPTXT, P_ROWNUM, P_NUMCOL

   @ P_ROWNUM, ( P_NUMCOL - LEN ( P_DSPTXT ) ) SAY P_DSPTXT

RETURN ( SPACE ( 0 ) )




