******************************************************************************
*
* Program Name : ml_utvld.prg
*
* Written By   : David L. Collison
* Written On   : October 24, 1989
*
* Updated By   : David L. Collison
* Updated On   : October 24, 1989
*
* Copyright    : Copyright (c), 1989 - Executive Assist
*
* Description  : Used to perform full screen validation.
*
* Files Used   :
*
* Prg's Called :
*
* Parameters   : p_arvald - character - name of array containing validation
*                                       function names and the parameters
*                                       to pass to those functions.
*                p_curget - numeric   - number of the current get.
*                p_maxget - numeric   - maximum number of gets to process in
*                                       current read.
*
******************************************************************************

FUNCTION MM_UTVLD

   PARAMETER P_ARVALD, P_CURGET, P_MAXGET

   *
   * Declare all private variables for this function.
   *

   PRIVATE M_FRLOOP, M_VALFNC

   *
   * Extract the validation routine and parameters from the array.
   *

   M_VALFNC = P_ARVALD [ P_CURGET ]

   *
   * If the array validation element equals VALDTRUE, do not check this
   *    get.
   *

   IF P_ARVALD [ P_CURGET ] <> 'VALDTRUE'

      *
      * Execute the validation function, if a false return value is recieved
      *    return a .f. to the pending get and force user to enter another
      *    value to check.
      *

      IF .F. = &M_VALFNC
         RETU ( .F. )
      ENDIF

   ENDIF

   *
   * If the user has pressed page down or ctrl-end validate all remaining
   *    gets on the screen.
   *

   IF LASTKEY() = 3 .OR. LASTKEY() = 23

      *
      * Set loop up to validate all pending gets.
      *

      FOR M_FRLOOP = ( P_CURGET + 1 ) TO P_MAXGET

         *
         * Extract the validation routine and parameters from the array.
         *

         M_VALFNC = P_ARVALD [ M_FRLOOP ]

         *
         * If the array validation element equals VALDTRUE, do not 
         *    check this get.
         *

         IF M_VALFNC <> 'VALDTRUE'

            *
            * Execute the validation function, if a false return value is 
            *    received return a .f. to the pending get and force the 
            *    to the pending get in error by stuffing the keyboard with 
            *    carriage returns.
            *

            IF .F. = &M_VALFNC
               KEYBOARD REPLICATE ( CHR ( 13 ), M_FRLOOP - P_CURGET )
               RETU ( .F. )
            ENDIF

         ENDIF

      NEXT

   ENDIF

RETURN ( .T. )

