/*

   'getlist' jumping in Clipper 5.2 without modifying GETSYS.PRG.
   in the example below, GET 1 jumps to GET 3 ; GET 5 to GET 2.

   also included is READ AT POSITION.  you'll note that the READ begins
   at GET 4.

   remember, this is to be used with Clipper's GETSYS.PRG, and not with
   GETSYSSK.PRG included in the .ZIP.

   Contact:
   Steve Kolterman  [76320,37]

*/

// in your source code:
#include "inkey.ch"
#include "getexit.ch"
#include "common.ch"

#xcomm READ [<sv: SAVE>] [AT POSITION <pos>]  =>  ;
       ReadNJump( getlist,[<pos>] )  ;
       [; IIF( !<.sv.>, getlist:= {}, ) ]

#define ORDPOS     cargo[1]
#define JUMP2POS   cargo[2]

FUNCTION Test
LOCAL getlist:= {},nX,aGets[5],nRow:= 5

FOR nX:= 1 TO Len(aGets)
   aGets[nX]:= nX
   @ ++nRow,5 GET aGets[nX]
   getlist[nX]:cargo:= {nX,0}
   IIF( nX==1 .or. nX==5,getlist[nX]:postblock:= {|g| GetJump(g)}, )
NEXT

READ AT POSITION 4

RETURN NIL

FUNCTION GetJump(oGet)
LOCAL nPos:= IIF( oGet:ORDPOS==1,3,2 )
oGet:JUMP2POS:= nPos
oGet:exitstate:= GE_WRITE
RETURN .T.

FUNCTION ReadNJump( getlist,nReadPos )
LOCAL nKey:= 0,lUpdated:= .F.,nGetPos
DEFAULT nReadPos TO 1

WHILE nReadPos > 0 .and. nKey <> K_ESC
    lUpdated:= ReadModal( getlist,nReadPos )
    nKey:= Lastkey()
    // if we had a jump, do it.
    IF (nGetPos:= Ascan( getlist,{|e| e:JUMP2POS > 0} )) > 0
       // reset for another entry.
       nReadPos:= getlist[nGetPos]:JUMP2POS
       getlist[nGetPos]:JUMP2POS:= 0
    ENDIF
ENDDO
RETURN lUpdated

/***
*
*  GetPreValidate()
*
*  Test entry condition (WHEN clause) for a GET
*
*/
FUNCTION GetPreValidate( oGet )

   LOCAL lSavUpdated
   LOCAL lWhen := .T.

   IF !( oGet:preBlock == NIL )

      lSavUpdated := ReadUpdated()  //slUpdated

      lWhen := EVAL( oGet:preBlock, oGet )

      oGet:display()

      // ShowScoreBoard()

      ReadUpdated( lSavUpdated )

      //slUpdated := lSavUpdated

   ENDIF

   IF ( ReadKill() )  //slKillRead )
      
      lWhen := .F.
      oGet:exitState := GE_ESCAPE       // Provokes ReadModal() exit

   //added by SK.
   ELSEIF ( !lWhen .and. oGet:exitstate==GE_WRITE )
      // nothing else to do, except prevent following ELSEIF from
      // resetting the exitstate to GE_WHEN.

   ELSEIF ( !lWhen )
      
      oGet:exitState := GE_WHEN         // Indicates failure

   ELSE
      
      oGet:exitState := GE_NOEXIT       // Prepares for editing

   END

   RETURN ( lWhen )
