/***
*  torment.prg
*  Demonstration of routines in getstuff.prg
*
*  Copyright (c) 1990 Nantucket Corp.  All rights reserved.
*  Craig Ogg
*
*/

MEMVAR GetList

FUNCTION DataEntryTormentor

   LOCAL v := REPLICATE("x",5)
   LOCAL w := "Kilroy was here"
   LOCAL x := "B"
   LOCAL y := 9999
   LOCAL z := 9000

   LOCAL lMoved := .F.

   CLEAR SCREEN

   @ 0,0 SAY "Data Entry Tormentor v1.0"
   @ 2,0 SAY "First make them think there eyes are 'unstable'..."
   
   @  4,10 SAY "First  " GET v WHEN MagicMove(GetList, @lMoved)
   @  6,10 SAY "Second " GET w WHEN MagicMove(GetList, @lMoved)
   @  8,10 SAY "Third  " GET x WHEN MagicMove(GetList, @lMoved)
   @ 10,10 SAY "Fourth " GET y WHEN MagicMove(GetList, @lMoved)
   @ 12,10 SAY "Fifth  " GET z WHEN MagicMove(GetList, @lMoved)
   READ

   @ 14,0 SAY "Then mess with the color control..."
   @ 16,10 SAY "First  " GET v WHEN MagicColor(GetList, "W/R,W+/R")
   @ 18,10 SAY "Second " GET w WHEN MagicColor(GetList, "W/B,W+/B")
   @ 20,10 SAY "Third  " GET x WHEN MagicColor(GetList, "GR/W,GR+/W")
   @ 22,10 SAY "Fourth " GET y WHEN MagicColor(GetList, "B/W,BG/W")
   READ

   RETURN(NIL)

FUNCTION MagicMove( GetList, lMoved )
   LOCAL nMoveBy
   LOCAL lHasFocus
   LOCAL nLen, nIndex, nBuffLen
   
   nMoveBy := IIF( lMoved, -1, 1 )
   nLen    := LEN(GetList)

   lMoved := (!lMoved)

   // Erase current gets
   FOR nIndex := 1 TO nLen
      // Save focus
      lHasFocus := GetList[nIndex]:hasFocus 

      // Set focus so I can find out buffer length (get width)
      GetList[nIndex]:setFocus()
      nBuffLen := LEN(GetList[nIndex]:buffer)

      // Restore focus
      IF !lHasFocus
         GetList[nIndex]:killFocus()
      ENDIF

      // Blank out current get (assumes current color is background color)
      @ GetList[nIndex]:row,GetList[nIndex]:col SAY SPACE(nBuffLen)
   NEXT

   MoveGets( GetList, 0, nMoveBy )

   RETURN (.T.)


FUNCTION MagicColor( GetList, cColor )
   
   ColorGets( GetList, cColor )

   RETURN (.T.)
