;getdir.asm
;gets the current directory from dos
;This represents an interesting problem in assembly language programming
;for two reasons. First, DOS returns the directory name in SI, and second
;it returns it as an ASCIIZ string. This presents two interesting ways
;to severely clobber DBASE memory space. First, If the MOV SI,6000d statement
;is omitted in the code below, DOS return the value for the current directory
;RIGHT ON TOP OF BX -- which just happens to be where Dbase is storing its
;memory variable stack. The result is a clobbering of whatever memvar was
;there before the routine was called.
;Secondly, Since DOS returns the directory name with an ASCII terminator.
;If you don't remove it, you will not return the same length string as you
;started with. A definite no-no for Dbase. The code below illustrates
;the appropriate way to handle the problem. Needless to say, it took
;a while to figure this one out. Hope it helps someone.
;
;Gary Gruber
;Data Base Designs
;17 Lorca Drive East.
;Rancho Mirage, Calif. 92270
;619-568-4338
;
; SYNTAX: i=space(64)
;         call getdir with i
; TRIM() the string and you're all set.
;
_prog   segment byte    public  'prog'
getdir  proc    far
assume  cs:_prog,ds:_prog,es:_prog
start:          
        push    ds
        push    es
        cld
        mov     dl,0            ;get directory on logged drive
        mov     si,6000d        ;get WAY past dbase's memory stack
        mov     ah,47h
        int     21h
        xor     cx,cx
        mov     di,offset dirspec
        push    di
transfer:
        lodsb
        cmp     al,0            ;Did we get to the ASCIIZ yet?
        je      done
        stosb                   ;store it in DI
        inc     cx
        jmp     transfer
done:
        pop     di              ;get back starting address
        push    bx
put_it:
        mov     al, byte ptr es:[di]
        mov     byte ptr [bx],al
        inc     bx
        inc     di
        loop    put_it          ;CX has count of chars to move
        pop     bx
        pop     es
        pop     ds
        ret
        dirspec         db      64 dup (32)
getdir  endp
_prog   ends
        end     start









