*                      FOR THE CLIPPER DEVELOPER...
*
*The awareness of the needs of users has resulted in a change in the
*complexion of Clipper programs.  Point-and-shoot menus, pop-up windows, and
*database browse features are now standards that most of us include in every
*application.  Several 3rd party libraries provide functions that make it
*possible to include features like these with as little as one line of code
*and should be part of every Clipper developers' arsenal. This is not,
*however, the limit of what you may wish to include in the finished
*application.
*
*A feature that should be a standard in most applications is the facility
*for the application to create the database files used by the application if
*those database files do not already exist.  With this feature, it is
*possible to distribute the .EXE file alone, without the added burden of the
*empty database files.  Installation (or re-installation) becomes a greatly
*simplified process for everyone.
*
*Many of us have spent considerable time writing procedures that will create
*database files if the program can't find them.  Typical code for this
*process might look something like this:
*
*PROCEDURE FILECHECK
*IF !FILE('CUSTOMER.DBF')
*  DO MAKECUST
*  USE CUSTOMER
*  INDEX ON CUSTNUM TO CUSTOMER
*ENDIF
*
*The content of the MAKECUST procedure is the bottleneck.  In this procedure
*you would CREATE a structure extended database, APPEND a series of blanks,
*and code a number of REPLACE statements for each field. For example:
*
*PROCEDURE MAKECUST
*CREATE ___temp
*APPEND BLANK
*REPLACE FIELD_NAME WITH 'FCUSTNUM'
*REPLACE FIELD_TYPE WITH 'C'
*REPLACE FIELD_LEN WITH '8'
*REPLACE FIELD_DEC WITH '0'
*APPEND BLANK
*REPLACE FIELD_NAME WITH 'FCOMPANY'
*REPLACE FIELD_TYPE WITH 'C'
*REPLACE FIELD_LEN WITH '50'
*REPLACE FIELD_DEC WITH '0'
***
*** Continue appending blanks until all fields are specified **
***
*CREATE CUSTOMER FROM ___temp
*ERASE ___temp
*RETURN
*
*
*The potential for tedium and for error is one I've actualized with some
*frequency using this method, particulary when the number of fields exceeds
*a dozen or so.
*
*It occurred to me that when applications are being developed, the .DBF
*files are ALWAYS in the development directory.  My guess is that we all
*create the .DBF's as an early part of the development process.  So if they
*exist, why couldn't a code generator be written to create the CODE
*that would create the database file?  GENSTRU.PRG is the response to that
*question.
*
*'CLIPPER GENSTRU' will compile the program.  Use your favorite linker, but
*'PLINK86 FI GENSTRU LIB CLIPPER,EXTEND' will do the linking just fine.
*This assumes that everything is taking place in the Clipper directory, or
*that the LIB and OBJ environment variables have been correctly set to point
*to the Clipper directory. Written for 'S87, it should run fine under 5.0
*with few modifications, but those of you with a trustworthy copy of 5.0 may
*be able to come up with less code to do the same thing.
*
*Running GENSTRU requires two parameters: the name of the .DBF file (with or
*without the '.DBF' extension) and the name of the program file you wish to
*create. If you do not add the .PRG extension to the filename, GENSTRU will
*add it for you.
*
*'GENSTRU CUSTOMER MAKECUST.PRG' is the command syntax that will create
*MAKECUST.PRG from the information that already exists in CUSTOMER.DBF.
*Indexes can be created with a single line of code for each index once the
*database file has been created.  Modify the FILECHECK procedure, above, to
*create the indexes that would be appropriate for your application.
*
*Source code for GENSTRU is provided below:
*******************************************************************************
*       Program....:  Generate .PRG to create .DBF file
*       Filename...:  GENSTRU.PRG
*       Author.....:  David A. Greene, MA   Productive Solutions 213/479-7021
*       Date.......:  06/24/90
*       Compile....:  Clipper genstru
*       Link.......:  Tlink genstru,,,clipper extend
*                  :  Plink86 fi genstru lib clipper,extend
*                  :  Blinker fi genstru lib clipper,extend
*       GENSTRU.PRG is released to the Public Domain.
*******************************************************************************
PARAMETERS _dbfile, _progname

IF PCOUNT()<2                        && Ensure both parameters have been passed
  CLEAR
  @ 22,0 SAY 'Syntax for the command is:'
  @ 23,0 SAY 'GENSTRU <.dbf filename> <output progname>'
  @ 24,0
  QUIT
ENDIF

_dbfile=UPPER(_dbfile)
_progname=UPPER(_progname)

IF RIGHT(_dbfile,4)!='.DBF'          && Append extension if necessary
  _dbfile=_dbfile+'.DBF'
ENDIF

IF RIGHT(_progname,4)!='.PRG';
 .AND. !('.'$_progname)               && Append extension if necessary
  _progname=_progname+'.PRG'          && and if no extension was provided
ENDIF

IF ! FILE(_dbfile)
  CLEAR
  @ 20,0 SAY 'Cannot find file '+_dbfile
  @ 22,0 SAY 'Syntax for the command is:'
  @ 23,0 SAY 'GENSTRU <.dbf filename> <output progname>'
  @ 24,0
  QUIT
ENDIF

IF FILE(_progname)
  @ 23,0 SAY UPPER(_progname)+' already exists. Overwrite (Y/N)?'
  SET CONSOLE OFF
  mow='X'
  DO WHILE !(UPPER(mow)$'YN')
    WAIT "" TO mow
  ENDDO
  IF UPPER(mow)='N'
    @ 24,0
    QUIT
  ENDIF
  @ 23,0
ENDIF

SET EXCLUSIVE OFF

USE (_dbfile)
IF NETERR()                          && Error trap for network use
  CLEAR
  @ 23,0 SAY _dbfile+' is not available in exclusive mode at this time.'
  @ 24,0
  QUIT
ENDIF

COPY STRUCTURE EXTENDED TO ___temp

USE ___temp
GO TOP

SET CONSOLE OFF
SET ALTERNATE TO &_progname
SET ALTERNATE ON
? '****** CREATE DATABASE PROCEDURE  **********************************************'
? "*..... Clipper Summer '87 Version "
? '*..... This code was generated by GENSTRU.EXE, a product of Productive Solutions '
? '*..... David A. Greene, MA  PO Box 25943 Los Angeles, CA 90025  213/479-7021'
? '*'
? '*..... This procedure creates '+_dbfile
? '*'
? '*..... Insert the following code in the calling program: '
? '*'
? '*      SELECT 0 '
? '*      IF !FILE("'+_dbfile+'")'
? '*         DO '+IIF('.PRG'$_progname,SUBSTR(_progname,1,AT('.PRG',_progname)-1),_progname)
? '*         USE '+_dbfile
? '*         INDEX ON <key> TO <filename>'
? '*      ENDIF'
? '********************************************************************************'
? 'PRIVATE cstring,mlast,x,y,mtime,mtempname'
? ' '
? 'cstring=+;'
mlast=LASTREC()
DO WHILE !EOF()
 ?'"'+FIELD_NAME+'*'+FIELD_TYPE+'*'+STR(FIELD_LEN,3,0)+'*'+;
  STR(FIELD_DEC,3,0)+IIF(RECNO()=mlast,'"','"+;')
 SKIP
ENDDO
? ''
? '** Create unique temporary filename'
? 'mtime=TIME()'
? 'mtempname=SUBSTR(DTOC(DATE()),4,2)+;'
? 'SUBSTR(mtime,1,2)+SUBSTR(mtime,4,2)+SUBSTR(mtime,7,2)'
? 'DO WHILE FILE(mtempname+".*")'
? '   INKEY(1)'
? '   mtime=TIME()'
? '   mtempname=SUBSTR(DTOC(DATE()),4,2)+;'
? '   SUBSTR(mtime,1,2)+SUBSTR(mtime,4,2)+SUBSTR(mtime,7,2)'
? 'ENDDO'
? '** Build database structure'
? 'y=LEN(cstring)'
? 'CREATE &mtempname'
? 'FOR x=1 TO y STEP 20'
? '  APPEND BLANK'
? '  REPLACE field_name WITH SUBSTR(cstring,x,10)'
? '  REPLACE field_type WITH SUBSTR(cstring,x+11,1)'
? '  REPLACE field_len WITH VAL(SUBSTR(cstring,x+13,3))'
? '  REPLACE field_dec WITH VAL(SUBSTR(cstring,x+17))'
? 'NEXT'
? 'CREATE '+_dbfile+' FROM &mtempname'
? 'USE'
? 'mtempname=mtempname+".dbf"'
? 'ERASE &mtempname'
? 'RETURN'

SET ALTERNATE TO
USE
ERASE ___TEMP.DBF
CLEAR
@ 23,0 SAY _progname+' successfully created.'
QUIT
***** EOF GENSTRU.PRG *****************************************************
*
*
*David Greene is a Business Applications designer/developer who uses
*Clipper as the dBase dialect of choice for business, accounting, and touch
*screen applications. He can be reached at Productive Solutions
*213/479-7021 or on CIS: 73257,1324.

