/*
 Programa Ŀ
   Aplication: Generatex index automaticaly (CDX and NSX)                 
      Fichero: GENSIX.PRG                                                 
        Autor: Ignacio Ortiz de Ziga Echeverra                         
        Fecha: 22/10/94                                                   
         Hora: 18:02:12                                                   
    Make File: GENSIX.RMK                                                 
    Exec File: GENSIX.EXE                                                 
    Copyright: 1994 by Ortiz de Zuiga, S.L.                              

*/

#include "sixcdx.ch"
#include "directry.ch"
#include "inkey.ch"
#include "dbstruct.ch"

STATIC aTree := {} ,;
       aSpec := {}

STATIC lTest := .F. ,;
       lPack := .F.

REQUEST sixnsx
REQUEST _upper                                   // FUNCky
REQUEST descend
REQUEST alltrim
REQUEST left
REQUEST right
REQUEST strtran
REQUEST transform
REQUEST padr
REQUEST padl
REQUEST padc

/*
NOTES:

     If you use for your index expressions functions from other libraries
     or functions not defined in the above list (clipper internal are
     allready included) include them.

     If a function is not available do not worry the program wont brake,
     and it will give you a report indicating wich DBF's could not be
     indexed.

     You need the library SIX 2.x and FUNCky II to create de EXE file.

     The compile and link should be something like this:

     CLIPPER GENSIX /m/n/w/a
     BLINKER FI GENSIX @SIX2 @FUNCKYVM

     I am using 9 functions of FUNCky II that can be easily created with
     Clipper 5 wich are documented on the file funcky.txt. By the way
     I highly recommend that library.

     All the comments of the source code are in spanish but I think it is
     enough clear to understand it.

     I will apreciate any comment or sugestion.

     CIS: 10042,3051
*/

//--------------------------------------------------------------------------//

Function Main(cDirectory,cflag1,cFlag2,cFlag3)

     LOCAL cFile      ,;
           cFlag      ,;
           aFiles     ,;
           aTags

     LOCAL nFor       ,;
           nRow

     if pcount() < 1
          scroll()
          @ 00,0 SAY "****************************"
          @ 01,0 SAY "* INDEX GENERATOR FOR SIX2 *"
          @ 02,0 SAY "****************************"
          @ 04,0 SAY "Developed by Ignacio Ortiz de Ziga (1994)"
          @ 06,0 SAY "Syntax Error:"
          @ 07,0 SAY "GENSIX <Directory> [/S][/T][/P]"
          @ 09,0 SAY "/S:Includes subdirectories"
          @ 10,0 SAY "/T:Performs only a test"
          @ 11,0 SAY "/P:Pack DBF files before the index process"
          @ 15,0 SAY "Remember: The information of the index file has"
          @ 16,0 SAY "          precendence over the .INF file"
          QUIT
     endif

     SET COLOR TO "W+/B"
     scroll()

     @ 0,0 SAY "****************************"
     @ 1,0 SAY "* INDEX GENERATOR FOR SIX2 *"
     @ 2,0 SAY "****************************"
     @ 4,0 SAY "Developed by Ignacio Ortiz de Ziga (1994)" COLOR "G+/B"

     cFlag1      := iif(cFlag1==NIL,"" ,cFlag1 )
     cFlag2      := iif(cFlag2==NIL,"" ,cFlag2 )
     cFlag3      := iif(cFlag3==NIL,"" ,cFlag3 )
     cFlag       := cFlag1+cFlag2+cFlag3
     cDirectory  := alltrim(upper(cDirectory))

     /*
     Comprobar que existe el directorio
     */

     if !isdir(cDirectory)                       // FUNCky
          @ 6,0 SAY "Directory does not exist"
          QUIT
     endif

     /*
     Si es test indicarlo
     */

     IF "/T"$upper(cFlag)
          lTest := .T.
          @ 0,68 SAY "*** TEST ***" COLOR "B/W*"
     ENDIF
     IF "/P"$upper(cFlag)
          lPack := .T.
     ENDIF

     /*
     Quitar el cursor
     */

     Set Cursor off

     /*
     Carga en una matriz de todos los directorios
     */

     Aadd(aTree,cDirectory)
     Aadd(aSpec,cDirectory)

     IF "/S"$upper(cFlag)
          @ 20, 0 SAY "Current directory:"
          MakeTree(cDirectory)
     ENDIF

     /*
     Dibujar cajas y datos indice
     */

     @ 5,0 CLEAR TO 24,79
     SET COLOR TO "GR+/B"
     @ 5,0 TO 20,40
     @ 5,41 TO 20,79
     @ 21,0 TO 24,79
     SET COLOR TO "W+/B"

     @ 22,1 SAY "N of Tag..:"
     @ 23,1 SAY "Name of Tag:"
     @ 22,28 SAY "Ĵ"
     @ 23,28 SAY "0        20        40        60        80      100"

     /*
     Mostrar Arbol (hasta lo posible)
     */

     SET COLOR TO "W/B"

     nRow := 6

     FOR nFor := 1 TO len(aTree)
          @ nRow++,1 SAY padr(aTree[nFor],39)
          IF nRow > 19
               EXIT
          ENDIF
     NEXT

     /*
     Bucle de manejo de directorios
     */

     nRow := 6

     FOR nFor := 1 TO len(aTree)
          @ nRow,1 SAY padr(aTree[nFor],39) COLOR "B/W"

          /*
          Procesa el directorio
          */

          ProcFiles(aSpec[nFor])

          /*
          Ver si pulso Escape
          */

          IF inkey() == K_ESC
               EXIT
          ENDIF

          /*
          Ir al siguiente directorio
          */

          @ nRow++,1 SAY padr(aTree[nFor],39)

          IF nRow > 19
               Scroll(6,1,19,39,1)
               nRow--
          ENDIF

     NEXT

     M_squeak()                                  // FUNCky

     Scroll(22,1,23,78,0)
     IF lastkey() == K_ESC
          @ 23,1 SAY padc("*** Process Aborted ***",77) COLOR "W+/B"
     ELSE
          @ 23,1 SAY padc("*** Process Finished ***",77) COLOR "W+/B"
     ENDIF
     keyboard("")
     inkey(0)

     GenError("",.T.)

     Set Cursor on

RETURN NIL

//--------------------------------------------------------------------------//

STATIC FUNCTION ProcFiles(cBaseDir)

     LOCAL aFiles

     LOCAL nFor, nLen, nRow

     aFiles  := DIRECTORY( cBaseDir + "\*.DBF" )
     nLen    := len(aFiles)

     /*
     Mostrar el mximo de ficheros posibles
     */

     nRow := 6

     FOR nFor := 1 TO len(aFiles)
          @ nRow++,42 SAY padr(aFiles[nFor,F_NAME],37)
          IF nRow > 19
               EXIT
          ENDIF
     NEXT

     /*
     Procesar fichero a fichero
     */

     nRow := 6

     FOR nFor := 1 TO len(aFiles)
          @ nRow,42 SAY padr(aFiles[nFor,F_NAME],37) COLOR "B/W"

          /*
          Procesa el fichero
          */

          ProcDbf(cBaseDir,aFiles[nFor,F_NAME],nRow)

          /*
          Ver si pulso Escape
          */

          IF inkey() == K_ESC
               EXIT
          ENDIF

          /*
          Ir al siguiente fichero
          */

          @ nRow++,42 SAY padr(aFiles[nFor,F_NAME],37)

          IF nRow > 19
               Scroll(6,42,19,78,1)
               nRow--
          ENDIF

     NEXT

     Scroll(6,42,19,78,0)

RETURN NIL

//--------------------------------------------------------------------------//

STATIC FUNCTION ProcDbf(cBaseDir,cFile,nRow)

     LOCAL oGenError
     LOCAL bNewError, bOldError
     LOCAL aIdxStr
     LOCAL cMessage, cFor, cExtension
     LOCAL nFor
     LOCAL lUnique, lDescend

     PRIVATE xIndexExp, xFilterExp

     /*
     Crear un nuevo error block
     */

     bNewError := {|oError| ErrorHandler(oError,.T.) }
     bOldError := Errorblock(bNewError)

	BEGIN SEQUENCE

          /*
          Ver que RDD utilizar
          */

          DO CASE
          CASE File(cBaseDir+"\"+fparsefn(cFile)+".CDX")
               cExtension := "CDX"
          CASE File(cBaseDir+"\"+fparsefn(cFile)+".NSX")
               cExtension := "NSX"
          CASE File(cBaseDir+"\"+fparsefn(cFile)+".INF")
               cExtension := GetIdxType(cFile)
          OTHERWISE
               GenError(cBaseDir+"\"+cFile+": No CDX, NSX or INF file")
               BREAK NIL
          ENDCASE

          /*
          Abrir base de datos
          */

          USE (cBaseDir+"\"+cFile) EXCLUSIVE VIA "SIX"+cExtension

          /*
          Si hay indice recuperar informacin del fichero indice,
          sino del fichero INF (FUNCky for fParseFn())
          */

          IF File(cBaseDir+"\"+fparsefn(cFile)+".CDX") .OR. ;
             File(cBaseDir+"\"+fparsefn(cFile)+".NSX")
               SET INDEX TO (cBaseDir+"\"+fparsefn(cFile)+"."+cExtension)
               aIdxStr := Sx_TagInfo()
               SET INDEX TO
          ELSE
               aIdxStr := GetInfFile(cBaseDir+"\"+fparsefn(cFile)+".INF")
          ENDIF

          /*
          Crear el fichero INF (FUNCky for fParseFn())
          */

          IF !lTest
               SetInfFile(cBaseDir+"\"+fparsefn(cFile)+".INF",;
                          aIdxStr,;
                          cExtension)
          ENDIF

          /*
          Borramos indice temporal por si ya existe (FUNCky for fParseFn())
          */

          ferase(cBaseDir+"\"+fparsefn(cFile)+".$$$")

          /*
          Pack si se ha pedido
          */

          IF lPack .AND. !lTest
               @ 0,68 SAY "*** PACK ***" COLOR "B/W*"
               PACK
               @ 0,68 SAY "            "
          ENDIF

          /*
          Reindexar
          */

          FOR nFor := 1 TO len(aIdxStr)

               @ 22,15 SAY padr("("+ltrim(str(nFor))+"/"+ltrim(str(len(aIdxStr)))+")",10)
               @ 23,15 SAY padr(aIdxStr[nFor,1],12)

               /*
               Si es RYO no reindexar
               */

               IF aIdxStr[nFor,6]
                    nFor++
                    LOOP
               ENDIF

               /*
               Inicializar variables
               */

               IF !empty(aIdxStr[nFor,3])
                    cFor       := aIdxStr[nFor,3]
                    xFilterExp := &("{||" + cFor + "}")
               ELSE
                    cFor       := NIL
                    xFilterExp := NIL
               ENDIF

               lUnique   := aIdxStr[nFor,4]
               lDescend  := aIdxStr[nFor,5]
               xIndexExp := &("{||" + (aIdxStr[nFor,2]) + "}")

               /*
               Reindexacin (FUNCky for fParseFn())
               */

               ordCondSet(cFor                                   ,;
                          xFilterExp                             ,;
                          NIL                                    ,;
                          NIL                                    ,;
                          {|| Meter() }                          ,;
                          max(Int(lastrec()/20),1)               ,;
                          Recno()                                ,;
                          NIL                                    ,;
                          NIL                                    ,;
                          NIL                                    ,;
                          iif(lDescend,.T. ,NIL )                ,;
                          .T.                                    ,;
                          (cBaseDir+"\"+fparsefn(cFile)+".$$$")  ,;
                          .F.                                    ,;
                          .F.                                    ,;
                          .F.                                    ,;
                          .T.                                    ,;
                          .F.                                    ,;
                          .F.                                    ,;
                          )

            ordCreate(cBaseDir+"\"+fparsefn(cFile)+".$$$"        ,;
                      aIdxStr[nFor,1]                            ,;
                      aIdxStr[nFor,2]                            ,;
                      xIndexExp                                  ,;
                      iif(lUnique,.T., NIL)                      ,;
                      )

          NEXT

          /*
          Cerrar base de datos
          */

          DbCloseAll()
          DbCommitAll()

          /*
          Borrar indice original y sustituirlo por el recien creado
          (FUNCky for fParseFn() and Fcopy())
          */

          IF !lTest
               IF file(cBaseDir+"\"+fparsefn(cFile)+".$$$")
                    FCopy(cBaseDir+"\"+fparsefn(cFile)+".$$$",;
                          cBaseDir+"\"+fparsefn(cFile)+"."+cExtension)
                    FErase(cBaseDir+"\"+fparsefn(cFile)+".$$$")
               ELSE
                    GenError(cBaseDir+"\"+fparsefn(cFile)+".$$$: Creation Error")
               ENDIF
          ELSE
               IF file(cBaseDir+"\"+fparsefn(cFile)+".$$$")
                    FErase(cBaseDir+"\"+fparsefn(cFile)+".$$$")
               ELSE
                    GenError(cBaseDir+"\"+fparsefn(cFile)+".$$$: Creation Error")
               ENDIF
          ENDIF

          /*
          Poner la barra de estado a cero y limpiar pantalla
          */

          @ 22,15 SAY space(12)
          @ 23,15 SAY space(12)
          @ 22,28 SAY "Ĵ" COLOR "W+/B"

     RECOVER USING oGenError

          /*
          Comprobar si es un error forzado
          */

          IF oGenError == NIL
               Errorblock(bOldError)
               RETU (NIL)
          ENDIF

          /*
          Generacin del mensaje de error
          */

          cMessage := cBaseDir+"\"+cFile+": "

          IF Valtype(oGenError) == "O"
               cMessage += oGenError:subsystem+" "+;
                           ltrim(str(oGenError:subcode))
               IF valtype(oGenError:description) == "C"
                    cMessage += " "+oGenError:description
               ENDIF
          ELSE
               cMessage := oGenError
          ENDIF

          IF !empty(oGenError:operation)
               cMessage += ": "+oGenError:operation
		ENDIF

          GenError(cMessage)

     END SEQUENCE

     /*
     Restablecer error block original
     */

     Errorblock(bOldError)

RETURN NIL

//--------------------------------------------------------------------------//

STATIC FUNCTION ErrorHandler(oError,lLocalError)

	IF lLocalError
		BREAK oError
	ENDIF

RETURN NIL

//--------------------------------------------------------------------------//

STATIC FUNCTION MakeTree( cBaseDir, cPrefix )

     LOCAL aDir, ;
           aDirs := {}

     LOCAL i, ;
          nLen

     iif( cBaseDir == NIL, cBaseDir := "", )
     iif( cPrefix == NIL, cPrefix := "", )

     cBaseDir += iif(!right(cBaseDir,1)="\","\" ,"" )

     aDir  := directory( cBaseDir + "*.*", "DHS" )
     nLen  := len( aDir )

     FOR i := 1 TO nLen
          IF ( ( "D" $ aDir[i, F_ATTR] ) .AND. ;
               ( .NOT. ( left( aDir[i, F_NAME], 1 ) == "." ) ) )
               AADD( aDirs, aDir[i] )
          ENDIF
     NEXT i

     nLen  := len( aDirs )
     FOR i := 1 TO nLen
          @ 20, 22 SAY PADR(aDirs[i, F_NAME], 12) COLOR "W/B"
          AADD( aTree, cPrefix + IIF( i == nLen, "", "" ) + aDirs[i, ;
               F_NAME] )
          AADD( aSpec, cBaseDir + aDirs[i,F_NAME] )
          MakeTree( cBaseDir + aDirs[i, F_NAME] + "\", cPrefix + ;
          iif( i == nLen, "  " , " " ) )
     NEXT i

RETURN( NIL )

//--------------------------------------------------------------------------//

STATIC FUNCTION GenError(cExpr,lPrint)

     STATIC cError := ""

     lPrint := iif(lPrint==NIL,.F. ,lPrint )

     cError += cExpr+chr(13)+chr(10)

     IF lPrint
          SET COLOR TO
          scroll()
          stdoutline("")                                  // FUNCky
          stdoutline("****************************")
          stdoutline("* INDEX GENERATOR FOR SIX2 *")
          stdoutline("****************************")
          stdoutline("")
          stdoutline("Developed by Ignacio Ortiz de Ziga (1994)")
          stdoutline("")
          Stdout(cError)                                  // FUNCky
     ENDIF

RETURN NIL

//--------------------------------------------------------------------------//

STATIC FUNCTION GetIdxType(cFile)

     LOCAL cLine, cType
     LOCAL nHandle

     nHandle := FOpen(cFile,32)
     cType   := ""

     IF FError() > 0
          GenError(cFile+": Read Error")
          BREAK NIL
     ENDIF

     DO WHILE !feof(nHandle)                     // FUNCky
          cLine := FReadLine(nHandle)            // FUNCky
          IF cLine = "INDEX TYPE"
               cType := upper(ExtraeValor(cLine))
               EXIT
          ENDIF
     ENDDO

     Fclose(nHandle)

     IF cType == ""
          GenError(cFile+": No Index information")
          BREAK NIL
     ENDIF

     IF cType != "CDX" .AND. cType !="NSX"
          GenError(cFile+": Index extension error")
          BREAK NIL
     ENDIF

RETURN cType

//--------------------------------------------------------------------------//

STATIC FUNCTION GetInfFile(cFile)

     LOCAL aData, aStruc
     LOCAL cLine
     LOCAL nHandle, nFor, nElem

     nHandle := FOpen(cFile,32)
     aData   := {}
     aStruc  := {}

     IF FError() > 0
          GenError(cFile+": Read Error")
          BREAK NIL
     ENDIF

     DO WHILE !feof(nHandle)                     // FUNCky
          cLine := FReadLine(nHandle)            // FUNCky
          IF !empty(cLine)
               Aadd(aData,cLine)
          ENDIF
     ENDDO

     Fclose(nHandle)

     IF len(aData) == 0
          GenError(cFile+": Empty File")
          BREAK NIL
     ENDIF

    DO WHILE (nElem := ascan(aData,{|x| upper(x) = "TAG NAME"  },nElem)) > 0

          aadd(aStruc,array(6))

          aStruc[len(aStruc)][1] := ExtraeValor(aData[nElem++])
          aStruc[len(aStruc)][2] := ExtraeValor(aData[nElem++])
          aStruc[len(aStruc)][3] := ExtraeValor(aData[nElem++])
          aStruc[len(aStruc)][4] := iif(upper(ExtraeValor(aData[nElem++]))="YES",.T.,.F.)
          aStruc[len(aStruc)][5] := iif(upper(ExtraeValor(aData[nElem++]))="YES",.T.,.F.)
          aStruc[len(aStruc)][6] := iif(upper(ExtraeValor(aData[nElem++]))="YES",.T.,.F.)

	ENDDO

     IF len(aStruc) == 0
          GenError(cFile+": No index information")
          BREAK NIL
     ENDIF

RETURN aStruc

//--------------------------------------------------------------------------//

STATIC FUNCTION ExtraeValor(cValor)

	cValor := alltrim(cValor)

	IF "//"$cValor
		cValor := substr(cValor,1,at("//",cValor)-1)
	ENDIF

	cValor := iif(at("=",cValor)>0,;
			    alltrim(substr(cValor,at("=",cValor)+1)) ,"" )

	cValor := strtran(cValor,"#"," ")

RETURN (cValor)

//--------------------------------------------------------------------------//

STATIC FUNCTION SetInfFile(cFile,aData,cExtension)

	LOCAL aDbStruct
	LOCAL nHandle, nFor

     nHandle := FCreate(cFile,0)

     IF FError() > 0
          GenError(cFile+": Creation Error")
          BREAK NIL
     ENDIF

	aDbStruct := DbStruct()

     FwriteLine(nHandle,"FILE NAME  = "+cFile)
     FwriteLine(nHandle,"INDEX TYPE = "+cExtension)
     FwriteLine(nHandle,"")

     FwriteLine(nHandle,"NAME       TYPE LEN DEC") // FUNCky
     FwriteLine(nHandle,"---------- ---- --- ---") // FUNCky

     FOR nFor := 1 TO len(aDbStruct)               // FUNCky
          FwriteLine(nHandle,padr(aDbStruct[nFor,DBS_NAME],10)+"    "+;
				 aDbStruct[nFor,DBS_TYPE]+" "+;
				 str(aDbStruct[nFor,DBS_LEN],3)+"  "+;
				 str(aDbStruct[nFor,DBS_DEC],2))
	NEXT

     FwriteLine(nHandle,replicate("-",70))         // FUNCky

     FOR nFor := 1 TO len(aData)                   // FUNCky
		FwriteLine(nHandle,"Tag Name         = "+aData[nFor,1])
          FwriteLine(nHandle,"Index Expression = "+aData[nFor,2])
          FwriteLine(nHandle,"Index Filter     = "+aData[nFor,3])
          FwriteLine(nHandle,"Unique           = "+iif(aData[nFor,4],"Yes","No"))
          FwriteLine(nHandle,"Descending       = "+iif(aData[nFor,5],"Yes","No"))
          FwriteLine(nHandle,"RYO index        = "+iif(aData[nFor,6],"Yes","No"))
          FwriteLine(nHandle,replicate("-",70))
     NEXT

     Fclose(nHandle)

     IF FError() > 0
          GenError(cFile+": Creation Error")
          BREAK NIL
     ENDIF

RETURN NIL

//--------------------------------------------------------------------------//

STATIC FUNCTION Meter()

     STATIC nRecCount,;                           // total registros
            nRecActual                            // registro actual

     /*
     Primera llamada a la funcin
     */

	IF bof()

          nReccount  := Lastrec()
		nRecActual := 0

          @ 22,28 SAY "Ĵ" COLOR "W+/B"

     ELSEIF eof()

          @ 22,28 SAY replicate(chr(219),50) COLOR "R+/B"

	ELSE

   		nRecActual += Sx_Step()
          @ 22,28 SAY replicate(chr(219),int(((nRecActual/nRecCount)*100/2))) COLOR "R+/B"

	ENDIF

RETURN .T.
