*    This test program demonstrates the use of GENFUNC.  Call GENFUNC
*    from dBEDIT.  GENFUNC has an entry string box that allows the user
*    to perform index searches in any indexed column in dBEDIT.  GENFUNC
*    needs certain variables defined beforehand... see the comments below.
*    This program uses TEST.DBF, which is included.  If you don't have it,
*    the structure is:
*         NAME     CHAR    20
*         COMPANY  CHAR    20
*         PHONE    CHAR    13
*
*    This file also contains several other functions that are used by the
*    driver program to make the test program function nicely.  They are not
*    needed by GENFUNC.  They are:
*    shadbox:  A function that draws shaded boxes.  P/D by Robert Kohut.
*    err:      A function that displays an error message on line 24.
*    bline23   A proc that displays what keystrokes are active during dBEDIT
*              on line 23.
*    After running this program, please strip GENFUNC out and tailor to your
*    needs.
*         COMPILE THIS PROGRAM USING CLIPPER BY TYPING:
*               CLIPPER test
*         LINK THIS PROGRAM BY TYPING:
*               PLINK86 FI test LIB clipper,extend   Or if you have BLINKER,
*               BLINKER FI test LIB clipper,extend
*    IF YOU DON'T OWN BLINKER, YOU OWE YOURSELF TO BUY IT!  BLINKER is 
*    available from BLINK, Inc at (804) 353-0137.
*

SET DELETED ON
SET FUNCTION 10 TO CHR(23)         && Ctrl-W.
SET SCOREBOARD OFF

IF ISCOLOR()
     xbrowse    = "N/BG,W+/B"
     xerror     = "GR+/R,N/R"
     xinfo      = "GR+/B"
     xnormal    = "W+/B,W+/R,,,N/W"
ELSE
     xbrowse    = ""
     xerror     = ""
     xinfo      = ""
     xnormal    = ""
ENDIF

SET COLOR TO (xnormal)
CLEAR

IF ! FILE("test.dbf")
     err("Cannot open TEST.DBF!  Aborting Program!")
     QUIT
ENDIF
USE test
INDEX ON UPPER(test->name)    TO testname
INDEX ON UPPER(test->company) TO testco
SET INDEX TO testname,testco

DECLARE fnames[3],titles[3],indexes[3],pics[3]
fnames[1] = "test->name"
fnames[2] = "test->company"
fnames[3] = "test->phone"
titles[1] = "Name"
titles[2] = "Organization"
titles[3] = "Phone"
pics[1] = "@X"
pics[2] = "@X"
pics[3] = "(999)999-9999"
indexes[1] = 1
indexes[2] = 2
indexes[3] = 0

SET COLOR TO (xbrowse)
shadbox(4,3,19,77)
DO bline23
TopRow = 5
BottRow = 19
NewField = .F.
EntryStr = ''
Boxname = "PHONEBOX"
BottomScrn = SAVESCREEN(21,27,24,52)

DBEDIT(TopRow,5,Bottrow,75,fnames,"genfunc",pics,titles,.T.,.T.,"")

SET COLOR TO
CLEAR
QUIT
*
*    End Test.prg
*


*********************************************
FUNCTION phonebox
*********************************************
PARA keystroke

IF keystroke = "2"            && F2 was Pressed.
     ?? CHR(7)                && This particular Prog. doesn't use F2,
     RETURN 1                 && so return to DBEDIT.
ENDIF

SAVE SCREEN TO pscreen

IF keystroke = '.'            && Delete was pressed
     ans = .F.
     SET COLOR to (xerror)
     @ ROW(),0 SAY " "
     SHADBOX(21,27,23,52)
     @ 22,29 SAY "Delete this Record? " GET ans PICTURE "Y"
     READ
     KEYBOARD ''             && Kludgy way of making sure that the next time
     INKEY()                  && LASTKEY() is used, it doesn't see whatever key 
     SET COLOR to (xbrowse)   && was used to exit this read.
     IF ans
         DELETE
         SKIP                 && Makes sure that SET DELETED ON sees
         SKIP -1              && that this record is deleted.
     ENDIF
     RESTORE SCREEN FROM pscreen
     RETURN 2
ENDIF

IF keystroke = "E"                 && Enter was pressed
     _name       = test->name
     _company    = test->company
     _phone      = test->phone
ELSE                               && INSert was pressed
     _name       = SPACE(20)
     _company    = SPACE(20)
     _phone      = SPACE(13)
ENDIF

SET COLOR TO (xinfo)
@ 23,00 CLEAR
@ 23,00 SAY "<Esc>"
@ 23,55 SAY "<F10>"
SET COLOR TO (xnormal)
@ 23,06 SAY "Cancel without save"
@ 23,61 SAY "Complete with save"
SET CURSOR ON

SHADBOX(9,22,15,57)                && Put a box here with your GETS.
@ 11,25 SAY "Name   :" GET _name
@ 12,25 SAY "Company:" GET _company
@ 13,25 SAY "Phone  :" GET _phone PICTURE "(999)999-9999" 
READ

REST SCREEN FROM pscreen
SET COLOR TO (xbrowse)
DO bline23

IF LASTKEY() = 27
     KEYBOARD ''
     INKEY()
     RETURN 1
ENDIF

KEYBOARD ''
INKEY()
IF keystroke = "A"
     APPEND BLANK
ENDIF

REPLACE test->name       WITH _name
REPLACE test->company    WITH _company
REPLACE test->phone      WITH _phone

RETURN 2
*
*    End phonebox
*






***********************************************************************
FUNCTION genfunc
***********************************************************************
*      by Galen Mulrooney, based on code written by Robert Kohut.
*      Released to Public Domain for the furtherment of the Clipper 
*      Language and its devotees.  12/9/1990.

*    Generic Function to use for DBEDITS.
*    The following Keys are active:
*         ESC = Exit
*         INS, F2, Del, Enter call &Boxname
*    The following PUBLIC Variables are REQUIRED:
*         Boxname (name of function to call when INS, Del, Enter, or F2 
*              key is pressed.  Boxname will called with PARAMETER "A", ".",
*              "E", or "2", respectively.
*              Function must return DBEDIT Return Value.
*         Indexes is an array with the same number of elements as there are
*              fields being dBEDITed.  Each element must contain the Index number
*              that must be active for seeks on that field; or 0 if not indexed.
*         fnames[] must be the name of the array hoding the field names.
*         The bottom portion of the screen MUST be saved into BottomScrn (21,27,24,52)
*         EntryStr MUST be initialized to ""
*         TopRow is the top row coordinate of dBEDIT.
*         BottRow is the bottom row coordinate of dBEDIT.
*         NewField MUST = .F.
*         DELETED SHOULD BE SET ON
***********************************************************************

PARA Mode, FldPtr

LKey = LASTKEY()
CurFld = fnames[FldPtr]
EntryLen = Len(EntryStr)
RetVal = 1

IF LKey = 27 .OR. LKey = 23       && ESCape. or Ctrl-W
     RETURN 0
ENDIF

IF INDEXORD() != indexes[FldPtr]                                 && Proper index not active
     IF indexes[FldPtr] # 0                                      && This field is indexed
          SET ORDER TO indexes[FldPtr]                           && Set index order to proper index
          NewField = .T.                                         && NewField is used to re-paint the screen when passing the top or bott of screen.
     ENDIF
     EntryStr = ""                                               && Reset Entry String
     EntryLen = 0
     RESTSCREEN(21,27,24,52,BottomScrn)                          && Erase Box
ENDIF

IF Mode = 1
     err(" Top-of-file ... no more Records in this direction ")
     RETURN 1
ENDIF

IF Mode = 2
     err(" Bottom-of-file ... no more Records in this direction ")
     RETURN 1
ENDIF

IF Mode = 3
     err(" No records were found.  If this is incorrect, try re-indexing. ")
     RETURN 1
ENDIF

IF Mode = 0
     IF (LKey=5 .OR. LKey=24 .OR. LKey=18 .OR. LKey=3 .OR. LKey = 30 .OR. LKey = 31) .AND. EntryLen > 0    && ,,PgUp,PgDn,Ctrl-PgUp,Ctrl-PgDn
          EntryStr = ""                                && Reset Entry String
          EntryLen = 0
          RESTSCREEN(21,27,24,52,BottomScrn)           && Erase Box
     ENDIF
     IF LKey = 5 .AND. ROW() = TopRow+2 .AND. NewField
          NewField = .F.
          RetVal = 2
     ELSEIF LKey = 24 .AND. ROW() = BottRow-1 .AND. NewField
          NewField = .F.
          RetVal = 2
     ENDIF
ENDIF

IF Mode = 4                                            && Exception
     IF LKey = 7                                       && Delete
          EntryStr = ""                                && Reset Entry String
          RESTSCREEN(21,27,24,52,BottomScrn)           && Erase Box
          func = Boxname + "('.')"
          RETURN &func
     ENDIF
     IF LKey = -1                                      && F2
          EntryStr = ""                                && Reset Entry String
          RESTSCREEN(21,27,24,52,BottomScrn)           && Erase Box
          func = Boxname + "('2')"
          RETURN &func
     ENDIF
     IF LKey = 13                                      && Enter
          EntryStr = ""                                && Reset Entry String
          RESTSCREEN(21,27,24,52,BottomScrn)           && Erase Box
          func = Boxname + "('E')"
          RETURN &func
     ENDIF
     IF LKey = 22                                      && Insert
          EntryStr = ""                                && Reset Entry String
          RESTSCREEN(21,27,24,52,BottomScrn)           && Erase Box
          func = Boxname + "('A')"
          RETURN &func
     ENDIF
     *
     *    EntryString Processing
     *
     IF LKey = 8  .AND. INDEXORD() = indexes[FldPtr]        && Backspace
          EntryStr = LEFT(EntryStr,EntryLen-1)
     ELSEIF ((LKey>32 .AND. LKey<127) .OR. (LKey=32 .AND. EntryLen>0)) .AND. INDEXORD() = indexes[FldPtr]
     *    (Search Characters AND this field is indexed)
          EntryStr = EntryStr + UPPER(CHR(LASTKEY()))
          PresRec = RECNO()
          SEEK EntryStr
          IF ! FOUND()
               TONE(125,0)
               EntryStr = LEFT(EntryStr,EntryLen)
               GOTO PresRec
          ELSE
               IF LEN(EntryStr) = 1
                    RetVal = 2
                    shadbox(21,27,23,51,"","S")
               ENDIF
          ENDIF
     ELSE
          TONE(125,0)
     ENDIF
ENDIF
IF LEN(EntryStr) > 0
     @ 22,30 SAY SPACE(20)
     @ 22,30 SAY EntryStr
ELSE
     RESTSCREEN(21,27,24,52,BottomScrn)
ENDIF
RETURN RetVal
*
*    End GenFunc
*




**********************************************************************
FUNC shadbox
**********************************************************************
*    Produces Shadow Box.  Placed in Public Domain by Robert Kohut.
*
PARA t,l,b,r,ParaColor,OutLine

PRIVATE OldColor, Mask
OldColor = SETCOLOR()
Mask = REPL("X",79)

* ---   Shade the area below the box
Shadow = SAVESCREEN(b+1,l+1,b+1,r+1)
Shadow = TRAN(Shadow,LEFT(Mask,LEN(Shadow)))
RESTSCREEN(b+1,l+1,b+1,r+1,Shadow)

* ---   Shade the area to the right of the box
Shadow = SAVESCREEN(t+1,r+1,b+1,r+1)
Shadow = TRAN(Shadow,LEFT(Mask,LEN(Shadow)))
RESTSCREEN(t+1,r+1,b+1,r+1,Shadow)

* ---  do the box
IF PCOUNT() > 4
     IF LEN(ParaColor) > 0
          SETCOLOR(ParaColor)
     ENDIF
ENDIF
SCROLL(t,l,b,r,0)
IF PCOUNT() = 6
     IF OutLine = "D"
          @ t,l+1 TO b,r-1 double
     ELSEIF OutLine = " "
          @ t,l+1 clea to b,r-1
     ELSE
          @ t,l+1 TO b,r-1
     ENDIF
ELSE
     @ t,l+1 TO b,r-1
ENDIF
SETCOLOR(OldColor)
RETURN .T.
*
*    End shadbox
*




***********************************************************************
FUNC err       &&  Prints error message
***********************************************************************
PARA msg
PRIVATE rw, OldLine24, OldColor
rw = (80-LEN(msg))/2
OldColor = SETCOLOR()
OldLine24 = SAVESCREEN(24,00,24,79)
TONE(125,4)
SET COLOR TO (xerror)
@ 24,rw SAY msg
INKEY(0)
KEYBOARD ""        && This is kludgy way of making sure that LASTKEY() isn't
INKEY(0)            && affected by whatever key the user hits to exit this message.
SET COLOR TO (OldColor)
RESTSCREEN(24,00,24,79,OldLine24)
RETURN .F.
*
*    end err
*


***********************************************************************
PROC bline23
***********************************************************************

PRIVATE OldColor
OldColor = SETCOLOR()
SET COLOR TO (xinfo)
@ 23,00 CLEAR TO 23,79
@ 23,04 SAY "<F10>"
@ 23,25 SAY "<Ins>"
@ 23,38 SAY "<Del>"
@ 23,56 SAY "<Enter>"
*
SET COLOR TO (xnormal)
@ 23,10 SAY "Save & Exit"
@ 23,31 SAY "Add"
@ 23,44 SAY "Delete"
@ 23,64 SAY "Edit field"
*
SET COLOR TO (OldColor)
RETURN
*
*    end bline23
*


